/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HandlerManager;
import hprose.common.HproseContext;
import hprose.common.HproseException;
import hprose.common.HproseFilter;
import hprose.common.HproseMethod;
import hprose.common.HproseMethods;
import hprose.common.HproseResultMode;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.Reader;
import hprose.server.HproseClients;
import hprose.server.HproseServiceEvent;
import hprose.server.Message;
import hprose.server.PushEvent;
import hprose.server.ServiceContext;
import hprose.server.Topic;
import hprose.util.StrUtil;
import hprose.util.concurrent.Action;
import hprose.util.concurrent.AsyncFunc;
import hprose.util.concurrent.Call;
import hprose.util.concurrent.Func;
import hprose.util.concurrent.Promise;
import hprose.util.concurrent.Reducer;
import hprose.util.concurrent.Threads;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class HproseService
extends HandlerManager
implements HproseClients {
    private static final ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
    private static final InvalidRequestException invalidRequestException;
    private final ArrayList<HproseFilter> filters = new ArrayList();
    private HproseMode mode = HproseMode.MemberMode;
    private boolean debugEnabled = false;
    private int errorDelay = 10000;
    protected HproseServiceEvent event = null;
    protected HproseMethods globalMethods = null;
    private static final ThreadLocal<ServiceContext> currentContext;
    private int timeout = 120000;
    private int heartbeat = 3000;
    private PushEvent pushEvent = null;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Topic>> allTopics = new ConcurrentHashMap();

    public HproseService() {
        this.add("call", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return UUID.randomUUID().toString();
            }
        }, "#", true);
    }

    public static ServiceContext getCurrentContext() {
        return currentContext.get();
    }

    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseMethods();
        }
        return this.globalMethods;
    }

    public void setGlobalMethods(HproseMethods methods) {
        this.globalMethods = methods;
    }

    public final HproseMode getMode() {
        return this.mode;
    }

    public final void setMode(HproseMode mode) {
        this.mode = mode;
    }

    public final boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public final void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    public int getErrorDelay() {
        return this.errorDelay;
    }

    public void setErrorDelay(int errorDelay) {
        this.errorDelay = errorDelay;
    }

    public final HproseServiceEvent getEvent() {
        return this.event;
    }

    public final void setEvent(HproseServiceEvent event) {
        this.event = event;
    }

    public final HproseFilter getFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        return this.filters.get(0);
    }

    public final void setFilter(HproseFilter filter) {
        if (!this.filters.isEmpty()) {
            this.filters.clear();
        }
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public final HproseService addFilter(HproseFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public final boolean removeFilter(HproseFilter filter) {
        return this.filters.remove(filter);
    }

    public final HproseService add(Method method, Object obj, String aliasName) {
        this.getGlobalMethods().addMethod(method, obj, aliasName);
        return this;
    }

    public final HproseService add(Method method, Object obj, String aliasName, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, mode);
        return this;
    }

    public final HproseService add(Method method, Object obj, String aliasName, boolean simple) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, simple);
        return this;
    }

    public final HproseService add(Method method, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, mode, simple);
        return this;
    }

    public final HproseService add(Method method, Object obj, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Method method, Object obj) {
        this.getGlobalMethods().addMethod(method, obj);
        return this;
    }

    public final HproseService add(Method method, Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(method, obj, mode);
        return this;
    }

    public final HproseService add(Method method, Object obj, boolean simple) {
        this.getGlobalMethods().addMethod(method, obj, simple);
        return this;
    }

    public final HproseService add(Method method, Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(method, obj, mode, simple);
        return this;
    }

    public final HproseService add(Method method, Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethod(method, obj, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, mode);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, mode);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, mode);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, mode);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Object obj, String aliasName) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName);
        return this;
    }

    public final HproseService add(String methodName, Object obj, String aliasName, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, mode);
        return this;
    }

    public final HproseService add(String methodName, Object obj, String aliasName, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, String aliasName) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, String aliasName, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, mode);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, String aliasName, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, String aliasName, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Object obj) {
        this.getGlobalMethods().addMethod(methodName, obj);
        return this;
    }

    public final HproseService add(String methodName, Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, obj, mode);
        return this;
    }

    public final HproseService add(String methodName, Object obj, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethod(methodName, obj, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type) {
        this.getGlobalMethods().addMethod(methodName, type);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, type, mode);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, mode, simple);
        return this;
    }

    public final HproseService add(String methodName, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethod(methodName, type, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String[] aliasNames) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, mode);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String[] aliasNames, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, mode, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String aliasPrefix) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, mode);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, mode, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj) {
        this.getGlobalMethods().addMethods(methodNames, obj);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, obj, mode);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, mode, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethods(methodNames, obj, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String[] aliasNames) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, mode);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String[] aliasNames, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, mode, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String aliasPrefix) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, mode);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, mode, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, mode, simple, oneway);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type) {
        this.getGlobalMethods().addMethods(methodNames, type);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, type, mode);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, mode, simple);
        return this;
    }

    public final HproseService add(String[] methodNames, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addMethods(methodNames, type, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, String aliasPrefix) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, mode);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, simple);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, mode, simple);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type) {
        this.getGlobalMethods().addInstanceMethods(obj, type);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, type, mode);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, simple);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, mode, simple);
        return this;
    }

    public final HproseService add(Object obj, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addInstanceMethods(obj, type, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Object obj, String aliasPrefix) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix);
        return this;
    }

    public final HproseService add(Object obj, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, mode);
        return this;
    }

    public final HproseService add(Object obj, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, simple);
        return this;
    }

    public final HproseService add(Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, mode, simple);
        return this;
    }

    public final HproseService add(Object obj, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Object obj) {
        this.getGlobalMethods().addInstanceMethods(obj);
        return this;
    }

    public final HproseService add(Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, mode);
        return this;
    }

    public final HproseService add(Object obj, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, simple);
        return this;
    }

    public final HproseService add(Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, mode, simple);
        return this;
    }

    public final HproseService add(Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addInstanceMethods(obj, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Class<?> type, String aliasPrefix) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix);
        return this;
    }

    public final HproseService add(Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, mode);
        return this;
    }

    public final HproseService add(Class<?> type, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, simple);
        return this;
    }

    public final HproseService add(Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, mode, simple);
        return this;
    }

    public final HproseService add(Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, mode, simple, oneway);
        return this;
    }

    public final HproseService add(Class<?> type) {
        this.getGlobalMethods().addStaticMethods(type);
        return this;
    }

    public final HproseService add(Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addStaticMethods(type, mode);
        return this;
    }

    public final HproseService add(Class<?> type, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, simple);
        return this;
    }

    public final HproseService add(Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, mode, simple);
        return this;
    }

    public final HproseService add(Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) {
        this.getGlobalMethods().addStaticMethods(type, mode, simple, oneway);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Object obj) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Object obj, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, mode);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Object obj, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, simple);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Object obj, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, mode, simple);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Object obj, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, mode, simple, oneway);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Class<?> type) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Class<?> type, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, mode);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Class<?> type, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, simple);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, mode, simple);
        return this;
    }

    public final HproseService addMissingMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, mode, simple, oneway);
        return this;
    }

    public final HproseService remove(String alias) {
        this.getGlobalMethods().remove(alias);
        return this;
    }

    private ByteBuffer outputFilter(ByteBuffer response, ServiceContext context) {
        if (response.position() != 0) {
            response.flip();
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            response = this.filters.get(i).outputFilter(response, context);
            if (response.position() == 0) continue;
            response.flip();
        }
        return response;
    }

    private ByteBuffer inputFilter(ByteBuffer request, ServiceContext context) {
        if (request.position() != 0) {
            request.flip();
        }
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            request = this.filters.get(i).inputFilter(request, context);
            if (request.position() == 0) continue;
            request.flip();
        }
        return request;
    }

    private String getErrorMessage(Throwable e) {
        if (this.debugEnabled) {
            StackTraceElement[] st = e.getStackTrace();
            StringBuffer es = new StringBuffer(e.toString()).append("\r\n");
            int n = st.length;
            for (int i = 0; i < n; ++i) {
                es.append(st[i].toString()).append("\r\n");
            }
            return es.toString();
        }
        return e.toString();
    }

    private ByteBuffer sendError(Throwable e, ServiceContext context) {
        try {
            Throwable ex;
            if (this.event != null && (ex = this.event.onSendError(e, context)) != null) {
                e = ex;
            }
        }
        catch (Throwable ex) {
            e = ex;
        }
        try {
            ByteBufferStream data = new ByteBufferStream();
            Writer writer = new Writer(data.getOutputStream(), this.mode, true);
            data.write(69);
            writer.writeString(this.getErrorMessage(e));
            data.flip();
            return data.buffer;
        }
        catch (IOException ex) {
            this.fireErrorEvent(ex, context);
            return null;
        }
    }

    private ByteBuffer endError(Throwable e, ServiceContext context) {
        ByteBufferStream data = new ByteBufferStream();
        data.write(this.sendError(e, context));
        data.write(122);
        data.flip();
        return data.buffer;
    }

    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, ServiceContext context) {
        int count = arguments.length;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class) || argType.equals(ServiceContext.class)) {
                args[count] = context;
            }
            return args;
        }
        return arguments;
    }

    private ByteBuffer doOutput(Object[] args, Object result, ServiceContext context) throws IOException, InterruptedException, ExecutionException {
        ByteBufferStream data = new ByteBufferStream();
        HproseMethod remoteMethod = context.getRemoteMethod();
        if (result instanceof Future) {
            result = ((Future)result).get();
        }
        switch (remoteMethod.mode) {
            case RawWithEndTag: {
                data.write((byte[])result);
                data.flip();
                return data.buffer;
            }
            case Raw: {
                data.write((byte[])result);
                break;
            }
            default: {
                data.write(82);
                boolean simple = remoteMethod.simple;
                Writer writer = new Writer(data.getOutputStream(), this.mode, simple);
                if (remoteMethod.mode == HproseResultMode.Serialized) {
                    data.write((byte[])result);
                } else {
                    writer.serialize(result);
                }
                if (!context.isByref()) break;
                data.write(65);
                writer.reset();
                writer.writeArray(args);
                break;
            }
        }
        data.flip();
        return data.buffer;
    }

    private Object beforeInvoke(final String name, final Object[] args, final ServiceContext context) {
        try {
            if (this.event != null) {
                this.event.onBeforeInvoke(name, args, context.isByref(), context);
            }
            return this.invokeHandler.handle(name, args, context).then(new Func<ByteBuffer, Object>(){

                @Override
                public ByteBuffer call(Object result) throws Throwable {
                    if (result instanceof Throwable) {
                        throw (Throwable)result;
                    }
                    if (HproseService.this.event != null) {
                        HproseService.this.event.onAfterInvoke(name, args, context.isByref(), result, context);
                    }
                    return HproseService.this.doOutput(args, result, context);
                }
            }).catchError(new Func<ByteBuffer, Throwable>(){

                @Override
                public ByteBuffer call(Throwable e) throws Throwable {
                    return HproseService.this.sendError(e, context);
                }
            });
        }
        catch (Throwable e) {
            return this.sendError(e, context);
        }
    }

    private Object callService(String name, Object[] args, ServiceContext context) throws Throwable {
        HproseMethod remoteMethod = context.getRemoteMethod();
        try {
            if (context.isMissingMethod()) {
                return remoteMethod.method.invoke(remoteMethod.obj, name, args);
            }
            Object[] arguments = this.fixArguments(remoteMethod.paramTypes, args, context);
            Object result = remoteMethod.method.invoke(remoteMethod.obj, arguments);
            if (context.isByref()) {
                System.arraycopy(arguments, 0, args, 0, args.length);
            }
            return result;
        }
        catch (Throwable ex) {
            Throwable e = ex.getCause();
            if (e != null) {
                throw e;
            }
            throw ex;
        }
    }

    @Override
    protected Promise<Object> invokeHandler(String name, Object[] args, HproseContext context) {
        return this.invokeHandler(name, args, (ServiceContext)context);
    }

    @Override
    protected Promise<ByteBuffer> beforeFilterHandler(ByteBuffer request, HproseContext context) {
        return this.beforeFilter(request, (ServiceContext)context);
    }

    @Override
    protected Promise<ByteBuffer> afterFilterHandler(ByteBuffer request, HproseContext context) {
        return this.afterFilter(request, (ServiceContext)context);
    }

    private Promise<Object> invokeHandler(final String name, final Object[] args, final ServiceContext context) {
        boolean oneway = context.getRemoteMethod().oneway;
        if (oneway) {
            timerService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HproseService.this.callService(name, args, context);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return Promise.value(null);
        }
        return Promise.sync(new Call<Object>(){

            @Override
            public Object call() throws Throwable {
                return HproseService.this.callService(name, args, context);
            }
        });
    }

    protected Promise<ByteBuffer> doInvoke(ByteBufferStream stream, ServiceContext context) throws IOException {
        int tag;
        HproseMethods methods = context.getMethods();
        Reader reader = new Reader(stream.getInputStream(), this.mode);
        ArrayList<Object> results = new ArrayList<Object>();
        do {
            Object[] args;
            reader.reset();
            String name = reader.readString();
            String aliasname = name.toLowerCase();
            HproseMethod remoteMethod = null;
            tag = reader.checkTags("azC");
            if (tag == 97) {
                reader.reset();
                int count = reader.readInt(123);
                if (methods != null) {
                    remoteMethod = methods.get(aliasname, count);
                }
                if (remoteMethod == null) {
                    remoteMethod = this.getGlobalMethods().get(aliasname, count);
                }
                if (remoteMethod == null) {
                    args = reader.readArray(count);
                } else {
                    args = new Object[count];
                    reader.readArray(remoteMethod.paramTypes, args, count);
                }
                tag = reader.checkTags("tzC");
                if (tag == 116) {
                    context.setByref(true);
                    tag = reader.checkTags("zC");
                }
            } else {
                if (methods != null) {
                    remoteMethod = methods.get(aliasname, 0);
                }
                if (remoteMethod == null) {
                    remoteMethod = this.getGlobalMethods().get(aliasname, 0);
                }
                args = new Object[]{};
            }
            if (remoteMethod == null) {
                if (methods != null) {
                    remoteMethod = methods.get("*", 2);
                }
                if (remoteMethod == null) {
                    remoteMethod = this.getGlobalMethods().get("*", 2);
                }
                context.setMissingMethod(true);
            } else {
                context.setMissingMethod(false);
            }
            if (remoteMethod == null) {
                results.add(this.sendError(new NoSuchMethodError("Can't find this method " + name), context));
                continue;
            }
            context.setRemoteMethod(remoteMethod);
            results.add(this.beforeInvoke(name, args, context));
        } while (tag == 67);
        return Promise.reduce(results.toArray(), new Reducer<ByteBufferStream, ByteBuffer>(){

            @Override
            public ByteBufferStream call(ByteBufferStream output, ByteBuffer result, int index) throws Throwable {
                output.write(result);
                return output;
            }
        }, new ByteBufferStream()).then(new Func<ByteBuffer, ByteBufferStream>(){

            @Override
            public ByteBuffer call(ByteBufferStream data) throws Throwable {
                data.write(122);
                return data.buffer;
            }
        });
    }

    protected ByteBufferStream doFunctionList(ServiceContext context) throws IOException {
        HproseMethods methods = context.getMethods();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.getGlobalMethods().getAllNames());
        if (methods != null) {
            names.addAll(methods.getAllNames());
        }
        ByteBufferStream data = new ByteBufferStream();
        Writer writer = new Writer(data.getOutputStream(), this.mode, true);
        data.write(70);
        writer.writeList(names);
        data.write(122);
        return data;
    }

    private Promise<ByteBuffer> afterFilter(ByteBuffer request, ServiceContext context) {
        try {
            ByteBufferStream stream = new ByteBufferStream(request);
            switch (stream.read()) {
                case 67: {
                    return this.doInvoke(stream, context);
                }
                case 122: {
                    return Promise.value(this.doFunctionList((ServiceContext)context).buffer);
                }
            }
            throw new HproseException("Wrong Request: \r\n" + StrUtil.toString(stream));
        }
        catch (IOException e) {
            return Promise.error(e);
        }
    }

    private Promise<ByteBuffer> delayError(Throwable e, ServiceContext context) {
        ByteBuffer error = this.endError(e, context);
        if (this.errorDelay > 0) {
            return Promise.delayed((long)this.errorDelay, error);
        }
        return Promise.value(error);
    }

    private Promise<ByteBuffer> beforeFilter(ByteBuffer request, final ServiceContext context) {
        Promise<ByteBuffer> response;
        try {
            request = this.inputFilter(request, context);
            response = this.afterFilterHandler.handle(request, context).catchError(new AsyncFunc<ByteBuffer, Throwable>(){

                @Override
                public Promise<ByteBuffer> call(Throwable e) throws Throwable {
                    return HproseService.this.delayError(e, context);
                }
            });
        }
        catch (Throwable e) {
            response = this.delayError(e, context);
        }
        return response.then(new Func<ByteBuffer, ByteBuffer>(){

            @Override
            public ByteBuffer call(ByteBuffer value) throws Throwable {
                return HproseService.this.outputFilter(value, context);
            }
        });
    }

    protected void fireErrorEvent(Throwable e, ServiceContext context) {
        if (this.event != null) {
            this.event.onServerError(e, context);
        }
    }

    protected Promise<ByteBuffer> handle(ByteBuffer buffer, ServiceContext context) {
        currentContext.set(context);
        return this.beforeFilterHandler.handle(buffer, context).whenComplete(new Runnable(){

            @Override
            public void run() {
                currentContext.remove();
            }
        });
    }

    protected Promise<ByteBuffer> handle(ByteBuffer buffer, HproseMethods methods, ServiceContext context) {
        context.setMethods(methods);
        return this.handle(buffer, context);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public PushEvent getPushEvent() {
        return this.pushEvent;
    }

    public void setPushEvent(PushEvent pushEvent) {
        this.pushEvent = pushEvent;
    }

    private ConcurrentHashMap<String, Topic> getTopics(String topic) {
        ConcurrentHashMap<String, Topic> topics = this.allTopics.get(topic);
        if (topics == null) {
            throw new RuntimeException("topic \"" + topic + "\" is not published.");
        }
        return topics;
    }

    private void delTimer(ConcurrentHashMap<String, Topic> topics, String id) {
        Topic t = topics.get(id);
        if (t != null && t.timer != null) {
            t.timer.cancel(false);
            t.timer = null;
        }
    }

    private void offline(ConcurrentHashMap<String, Topic> topics, String topic, String id) {
        this.delTimer(topics, id);
        ConcurrentLinkedQueue<Message> messages = topics.remove((Object)id).messages;
        for (Message message : messages) {
            message.detector.resolve((Object)false);
        }
        if (this.pushEvent != null) {
            this.pushEvent.unsubscribe(topic, id, this);
        }
    }

    private void setTimer(final ConcurrentHashMap<String, Topic> topics, final String topic, final String id) {
        Topic t = topics.get(id);
        if (t != null && t.timer == null) {
            t.timer = timerService.schedule(new Runnable(){

                @Override
                public void run() {
                    HproseService.this.offline(topics, topic, id);
                }
            }, (long)t.heartbeat, TimeUnit.MILLISECONDS);
        }
    }

    private void resetTimer(ConcurrentHashMap<String, Topic> topics, String topic, String id) {
        this.delTimer(topics, id);
        this.setTimer(topics, topic, id);
    }

    private Promise<?> setRequestTimer(final String topic, final String id, Promise<?> request, int timeout) {
        final ConcurrentHashMap<String, Topic> topics = this.getTopics(topic);
        if (timeout > 0) {
            return request.timeout(timeout).catchError(new AsyncFunc<Object, Throwable>(){

                @Override
                public Promise<Object> call(Throwable e) throws Throwable {
                    final Topic t = (Topic)topics.get(id);
                    if (e instanceof TimeoutException) {
                        new Runnable(){

                            @Override
                            public void run() {
                                t.timer = timerService.schedule(this, (long)t.heartbeat, TimeUnit.MILLISECONDS);
                                if (t.count.get() < 0) {
                                    HproseService.this.offline(topics, topic, id);
                                } else {
                                    t.count.decrementAndGet();
                                }
                            }
                        }.run();
                    } else {
                        if (e instanceof InvalidRequestException) {
                            return new Promise<Object>();
                        }
                        t.count.decrementAndGet();
                    }
                    return null;
                }
            });
        }
        return request;
    }

    public final HproseService publish(String topic) {
        return this.publish(topic, -1, -1);
    }

    public final HproseService publish(String topic, int timeout) {
        return this.publish(topic, timeout, -1);
    }

    public final HproseService publish(final String topic, final int timeout, final int heartbeat) {
        final ConcurrentHashMap topics = new ConcurrentHashMap();
        this.allTopics.put(topic, topics);
        return this.add("call", (Object)new Func<Object, String>(){

            @Override
            public Object call(String id) throws Throwable {
                Topic t = (Topic)topics.get(id);
                if (t != null) {
                    ConcurrentLinkedQueue<Message> messages;
                    if (t.count.get() < 0) {
                        t.count.set(0);
                    }
                    if ((messages = t.messages).size() > 0) {
                        Message message = messages.poll();
                        message.detector.resolve((Object)true);
                        HproseService.this.resetTimer(topics, topic, id);
                        return message.result;
                    }
                    HproseService.this.delTimer(topics, id);
                    t.count.incrementAndGet();
                    this.newRequest(t, id);
                } else {
                    t = new Topic(heartbeat < 0 ? HproseService.this.heartbeat : heartbeat);
                    topics.put(id, t);
                    this.newRequest(t, id);
                    if (HproseService.this.pushEvent != null) {
                        HproseService.this.pushEvent.subscribe(topic, id, HproseService.this);
                    }
                }
                return HproseService.this.setRequestTimer(topic, id, t.request, timeout < 0 ? HproseService.this.timeout : timeout);
            }

            private void newRequest(Topic t, final String id) {
                if (t.request != null) {
                    t.request.reject(invalidRequestException);
                }
                Promise request = new Promise();
                request.complete(new Action<Object>(){

                    @Override
                    public void call(Object result) throws Throwable {
                        Topic t = (Topic)topics.get(id);
                        t.count.decrementAndGet();
                    }
                });
                t.request = request;
            }
        }, topic);
    }

    public final HproseService publish(String[] topics) {
        return this.publish(topics, -1, -1);
    }

    public final HproseService publish(String[] topics, int timeout) {
        return this.publish(topics, timeout, -1);
    }

    public final HproseService publish(String[] topics, int timeout, int heartbeat) {
        int n = topics.length;
        for (int i = 0; i < n; ++i) {
            this.publish(topics[i], timeout, heartbeat);
        }
        return this;
    }

    @Override
    public final String[] idlist(String topic) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.getTopics(topic).keySet())).toArray(new String[0]);
    }

    @Override
    public final boolean exist(String topic, String id) {
        return this.getTopics(topic).containsKey(id);
    }

    @Override
    public final void broadcast(String topic, Object result) {
        this.multicast(topic, this.idlist(topic), result);
    }

    @Override
    public final void broadcast(String topic, Object result, Action<String[]> callback) {
        this.multicast(topic, this.idlist(topic), result, callback);
    }

    @Override
    public final void multicast(String topic, String[] ids, Object result) {
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            this.push(topic, ids[i], result);
        }
    }

    @Override
    public final void multicast(String topic, String[] ids, Object result, Action<String[]> callback) {
        if (callback == null) {
            this.multicast(topic, ids, result);
            return;
        }
        int n = ids.length;
        List<String> sent = Collections.synchronizedList(new ArrayList(n));
        AtomicInteger count = new AtomicInteger(n);
        for (int i = 0; i < n; ++i) {
            String id = ids[i];
            if (id != null) {
                this.push(topic, id, result).then(this.check(sent, id, count, callback));
                continue;
            }
            count.decrementAndGet();
        }
    }

    private Action<Boolean> check(final List<String> sent, final String id, final AtomicInteger count, final Action<String[]> callback) {
        return new Action<Boolean>(){

            @Override
            public void call(Boolean success) throws Throwable {
                if (success.booleanValue()) {
                    sent.add(id);
                }
                if (count.decrementAndGet() == 0) {
                    callback.call(sent.toArray(new String[sent.size()]));
                }
            }
        };
    }

    @Override
    public final void unicast(String topic, String id, Object result) {
        this.push(topic, id, result);
    }

    @Override
    public final void unicast(String topic, String id, Object result, Action<Boolean> callback) {
        Promise<Boolean> detector = this.push(topic, id, result);
        if (callback != null) {
            detector.then(callback);
        }
    }

    @Override
    public final Promise<String[]> push(String topic, Object result) {
        return this.push(topic, this.idlist(topic), result);
    }

    @Override
    public final Promise<String[]> push(String topic, String[] ids, Object result) {
        final Promise<String[]> detector = new Promise<String[]>();
        this.multicast(topic, ids, result, new Action<String[]>(){

            @Override
            public void call(String[] value) throws Throwable {
                detector.resolve(value);
            }
        });
        return detector;
    }

    @Override
    public final Promise<Boolean> push(String topic, String id, Object result) {
        ConcurrentHashMap<String, Topic> topics = this.getTopics(topic);
        Topic t = topics.get(id);
        if (t == null) {
            return Promise.value(false);
        }
        if (t.request != null) {
            try {
                t.request.resolve(result);
                t.request = null;
                this.setTimer(topics, topic, id);
                return Promise.value(true);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        Promise<Boolean> detector = new Promise<Boolean>();
        t.messages.add(new Message(detector, result));
        this.setTimer(topics, topic, id);
        return detector;
    }

    static {
        Threads.registerShutdownHandler(new Runnable(){

            @Override
            public void run() {
                timerService.shutdownNow();
            }
        });
        invalidRequestException = new InvalidRequestException();
        currentContext = new ThreadLocal();
    }

    private static class InvalidRequestException
    extends Exception {
        private InvalidRequestException() {
        }
    }
}

