/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.io.ByteBufferStream;
import hprose.net.ConnectionHandler;
import hprose.net.OutPacket;
import hprose.net.Reactor;
import hprose.net.TimeoutType;
import hprose.util.concurrent.Timer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class Connection {
    private final SocketChannel channel;
    private final ConnectionHandler handler;
    private volatile SelectionKey key;
    private volatile TimeoutType timeoutType;
    private final Timer timer = new Timer(new Runnable(){

        @Override
        public void run() {
            try {
                Connection.this.handler.onTimeout(Connection.this, Connection.this.timeoutType);
            }
            finally {
                Connection.this.close();
            }
        }
    });
    private ByteBuffer inbuf = ByteBufferStream.allocate(1024);
    private int headerLength = 4;
    private int dataLength = -1;
    private Integer id = null;
    private OutPacket packet = null;
    private final Queue<OutPacket> outqueue = new ConcurrentLinkedQueue<OutPacket>();
    private Reactor reactor = null;

    public Connection(SocketChannel channel, ConnectionHandler handler) {
        this.channel = channel;
        this.handler = handler;
    }

    public final void connect(Selector selector) throws ClosedChannelException {
        this.key = this.channel.register(selector, 8, this);
        this.setTimeout(this.handler.getConnectTimeout(), TimeoutType.CONNECT_TIMEOUT);
    }

    public final void connected(Reactor reactor, Selector selector) throws ClosedChannelException {
        this.clearTimeout();
        this.reactor = reactor;
        this.key = this.channel.register(selector, 1, this);
        this.handler.onConnected(this);
    }

    public final boolean isConnected() {
        return this.channel.isOpen() && this.channel.isConnected();
    }

    public final SocketChannel socketChannel() {
        return this.channel;
    }

    public final void close() {
        try {
            this.clearTimeout();
            this.handler.onClose(this);
            this.channel.close();
            this.key.cancel();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean receive() {
        try {
            this.setTimeout(this.handler.getReadTimeout(), TimeoutType.READ_TIMEOUT);
            int n = this.channel.read(this.inbuf);
            if (n < 0) {
                this.close();
                return false;
            }
            if (n == 0) {
                return true;
            }
            while (true) {
                if (this.dataLength < 0 && this.inbuf.position() >= this.headerLength) {
                    this.dataLength = this.inbuf.getInt(0);
                    if (this.dataLength < 0) {
                        this.dataLength &= Integer.MAX_VALUE;
                        this.headerLength = 8;
                    }
                    if (this.headerLength + this.dataLength > this.inbuf.capacity()) {
                        ByteBuffer buf = ByteBufferStream.allocate(this.headerLength + this.dataLength);
                        this.inbuf.flip();
                        buf.put(this.inbuf);
                        ByteBufferStream.free(this.inbuf);
                        this.inbuf = buf;
                    }
                    this.setTimeout(this.handler.getReadTimeout(), TimeoutType.READ_TIMEOUT);
                    if (this.channel.read(this.inbuf) < 0) {
                        this.close();
                        return false;
                    }
                }
                if (this.headerLength == 8 && this.id == null && this.inbuf.position() >= this.headerLength) {
                    this.id = this.inbuf.getInt(4);
                }
                if (this.dataLength >= 0 && this.inbuf.position() - this.headerLength >= this.dataLength) {
                    ByteBuffer data = ByteBufferStream.allocate(this.dataLength);
                    this.inbuf.flip();
                    this.inbuf.position(this.headerLength);
                    int bufLen = this.inbuf.limit();
                    this.inbuf.limit(this.headerLength + this.dataLength);
                    data.put(this.inbuf);
                    this.inbuf.limit(bufLen);
                    this.inbuf.compact();
                    this.clearTimeout();
                    this.handler.onReceived(this, data, this.id);
                    this.headerLength = 4;
                    this.dataLength = -1;
                    this.id = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.handler.onError(this, e);
            this.close();
            return false;
        }
        return true;
    }

    public final void send(ByteBuffer buffer, Integer id) {
        this.outqueue.offer(new OutPacket(buffer, id));
        this.key.interestOps(5);
        this.reactor.write(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void send() {
        if (this.packet == null) {
            this.packet = this.outqueue.poll();
            if (this.packet == null) {
                return;
            }
        }
        try {
            while (true) {
                if (this.packet.writeLength < this.packet.totalLength) {
                    this.setTimeout(this.handler.getWriteTimeout(), TimeoutType.WRITE_TIMEOUT);
                    long n = this.channel.write(this.packet.buffers);
                    if (n < 0L) {
                        this.close();
                        return;
                    }
                    if (n == 0L) {
                        this.key.interestOps(5);
                        return;
                    }
                    this.packet.writeLength = (int)((long)this.packet.writeLength + n);
                    continue;
                }
                ByteBufferStream.free(this.packet.buffers[1]);
                this.clearTimeout();
                this.handler.onSended(this, this.packet.id);
                Queue<OutPacket> n = this.outqueue;
                synchronized (n) {
                    this.packet = this.outqueue.poll();
                    if (this.packet == null) {
                        this.key.interestOps(1);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            this.close();
            return;
        }
    }

    public final void setTimeout(int timeout, TimeoutType type) {
        this.timeoutType = type;
        if (type == TimeoutType.IDLE_TIMEOUT) {
            this.timer.setTimeout(timeout);
        } else {
            this.timer.setTimeout(timeout, true);
        }
    }

    public final void clearTimeout() {
        this.timer.clear();
    }
}

