/*
 * Decompiled with CFR 0.152.
 */
package hprose.util.concurrent;

import hprose.util.concurrent.Action;
import hprose.util.concurrent.AsyncCall;
import hprose.util.concurrent.AsyncFunc;
import hprose.util.concurrent.Call;
import hprose.util.concurrent.Callback;
import hprose.util.concurrent.Executor;
import hprose.util.concurrent.Func;
import hprose.util.concurrent.Handler;
import hprose.util.concurrent.PromiseFuture;
import hprose.util.concurrent.Reducer;
import hprose.util.concurrent.Rejector;
import hprose.util.concurrent.Resolver;
import hprose.util.concurrent.State;
import hprose.util.concurrent.Subscriber;
import hprose.util.concurrent.Thenable;
import hprose.util.concurrent.Threads;
import hprose.util.concurrent.TypeException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class Promise<V>
implements Resolver<V>,
Rejector,
Thenable<V> {
    private static volatile ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentLinkedQueue<Subscriber<?, V>> subscribers = new ConcurrentLinkedQueue();
    private volatile AtomicReference<State> state = new AtomicReference<State>(State.PENDING);
    private volatile V value;
    private volatile Throwable reason;

    public Promise() {
    }

    public Promise(final Call<V> computation) {
        timer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Promise.this.resolve(computation.call());
                }
                catch (Throwable e) {
                    Promise.this.reject(e);
                }
            }
        });
    }

    public Promise(final AsyncCall<V> computation) {
        timer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Promise.this.resolve(computation.call());
                }
                catch (Throwable e) {
                    Promise.this.reject(e);
                }
            }
        });
    }

    public Promise(Executor<V> executor) {
        executor.exec(this, this);
    }

    public static final <T> Promise<T> value(T value) {
        Promise promise = new Promise();
        promise.resolve(value);
        return promise;
    }

    public static final <T> Promise<T> value(Promise<T> value) {
        Promise<T> promise = new Promise<T>();
        promise.resolve(value);
        return promise;
    }

    public static final <T> Promise<T> value(Thenable<T> value) {
        Promise<T> promise = new Promise<T>();
        promise.resolve(value);
        return promise;
    }

    public static final <T> Promise<T> error(Throwable reason) {
        Promise promise = new Promise();
        promise.reject(reason);
        return promise;
    }

    public static final <T> Promise<T> delayed(long duration, TimeUnit timeunit, final Call<T> computation) {
        final Promise promise = new Promise();
        timer.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    promise.resolve(computation.call());
                }
                catch (Throwable e) {
                    promise.reject(e);
                }
            }
        }, duration, timeunit);
        return promise;
    }

    public static final <T> Promise<T> delayed(long duration, TimeUnit timeunit, final AsyncCall<T> computation) {
        final Promise promise = new Promise();
        timer.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    promise.resolve(computation.call());
                }
                catch (Throwable e) {
                    promise.reject(e);
                }
            }
        }, duration, timeunit);
        return promise;
    }

    public static final <T> Promise<T> delayed(long duration, TimeUnit timeunit, final T value) {
        final Promise promise = new Promise();
        timer.schedule(new Runnable(){

            @Override
            public void run() {
                promise.resolve(value);
            }
        }, duration, timeunit);
        return promise;
    }

    public static final <T> Promise<T> delayed(long duration, TimeUnit timeunit, final Promise<T> value) {
        final Promise promise = new Promise();
        timer.schedule(new Runnable(){

            @Override
            public void run() {
                promise.resolve(value);
            }
        }, duration, timeunit);
        return promise;
    }

    public static final <T> Promise<T> delayed(long duration, Call<T> computation) {
        return Promise.delayed(duration, TimeUnit.MILLISECONDS, computation);
    }

    public static final <T> Promise<T> delayed(long duration, AsyncCall<T> computation) {
        return Promise.delayed(duration, TimeUnit.MILLISECONDS, computation);
    }

    public static final <T> Promise<T> delayed(long duration, T value) {
        return Promise.delayed(duration, TimeUnit.MILLISECONDS, value);
    }

    public static final <T> Promise<T> delayed(long duration, Promise<T> value) {
        return Promise.delayed(duration, TimeUnit.MILLISECONDS, value);
    }

    public static final <T> Promise<T> sync(Call<T> computation) {
        try {
            return Promise.value(computation.call());
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
    }

    public static final <T> Promise<T> sync(AsyncCall<T> computation) {
        try {
            return Promise.value(computation.call());
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
    }

    public static final boolean isThenable(Object value) {
        return value instanceof Thenable;
    }

    public static final boolean isPromise(Object value) {
        return value instanceof Promise;
    }

    public static final Promise<?> toPromise(Object value) {
        return Promise.isPromise(value) ? (Promise<Object>)value : Promise.value(value);
    }

    private static <T> void allHandler(final Promise<T[]> promise, final AtomicInteger count, final T[] result, Object element, final int i) {
        Promise.toPromise(element).then(new Action<T>(){

            @Override
            public void call(T value) throws Throwable {
                result[i] = value;
                if (count.decrementAndGet() == 0) {
                    promise.resolve(result);
                }
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                promise.reject(e);
            }
        });
    }

    public static final <T> Promise<T[]> all(Object[] array, Class<T> type) {
        Object[] result;
        if (array == null) {
            return Promise.value((Object[])null);
        }
        int n = array.length;
        Object[] objectArray = result = type == Object.class ? new Object[n] : (Object[])Array.newInstance(type, n);
        if (n == 0) {
            return Promise.value(result);
        }
        AtomicInteger count = new AtomicInteger(n);
        Promise<T[]> promise = new Promise<T[]>();
        for (int i = 0; i < n; ++i) {
            Promise.allHandler(promise, count, result, array[i], i);
        }
        return promise;
    }

    public static final Promise<Object[]> all(Object[] array) {
        return Promise.all(array, Object.class);
    }

    public static final <T> Promise<T[]> all(Promise<Object[]> promise, final Class<T> type) {
        return promise.then(new AsyncFunc<T[], Object[]>(){

            @Override
            public Promise<T[]> call(Object[] array) throws Throwable {
                return Promise.all(array, type);
            }
        });
    }

    public static final Promise<Object[]> all(Promise<Object[]> promise) {
        return Promise.all(promise, Object.class);
    }

    public final <T> Promise<T[]> all(Class<T> type) {
        return Promise.all(this, type);
    }

    public final Promise<Object[]> all() {
        return Promise.all(this);
    }

    public static final Promise<Object[]> join(Object ... args) {
        return Promise.all(args);
    }

    public static final <T> Promise<T> race(Object[] array, Class<T> type) {
        Promise promise = new Promise();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Promise.toPromise(array[i]).fill(promise);
        }
        return promise;
    }

    public static final Promise<?> race(Object[] array) {
        return Promise.race(array, Object.class);
    }

    public static final <T> Promise<T> race(Promise<Object[]> promise, final Class<T> type) {
        return promise.then(new AsyncFunc<T, Object[]>(){

            @Override
            public Promise<T> call(Object[] array) throws Throwable {
                return Promise.race(array, type);
            }
        });
    }

    public static final Promise<?> race(Promise<Object[]> promise) {
        return Promise.race(promise, Object.class);
    }

    public final <T> Promise<T> race(Class<T> type) {
        return Promise.race(this, type);
    }

    public final Promise<?> race() {
        return Promise.race(this);
    }

    public static final <T> Promise<T> any(Object[] array, Class<T> type) {
        int n = array.length;
        if (n == 0) {
            return Promise.error(new IllegalArgumentException("any(): array must not be empty"));
        }
        final RuntimeException reason = new RuntimeException("any(): all promises failed");
        final Promise promise = new Promise();
        final AtomicInteger count = new AtomicInteger(n);
        for (int i = 0; i < n; ++i) {
            Promise.toPromise(array[i]).then(new Action<T>(){

                @Override
                public void call(T value) throws Throwable {
                    promise.resolve(value);
                }
            }, new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    if (count.decrementAndGet() == 0) {
                        promise.reject(reason);
                    }
                }
            });
        }
        return promise;
    }

    public static final Promise<?> any(Object[] array) {
        return Promise.any(array, Object.class);
    }

    public static final <T> Promise<T> any(Promise<Object[]> promise, final Class<T> type) {
        return promise.then(new AsyncFunc<T, Object[]>(){

            @Override
            public Promise<T> call(Object[] array) throws Throwable {
                return Promise.any(array, type);
            }
        });
    }

    public static final Promise<?> any(Promise<Object[]> promise) {
        return Promise.any(promise, Object.class);
    }

    public final <T> Promise<T> any(Class<T> type) {
        return Promise.any(this, type);
    }

    public final Promise<?> any() {
        return Promise.any(this);
    }

    public static final Promise<?> run(Action<Object[]> handler, Object ... args) {
        return Promise.all(args).then(handler);
    }

    public static final <V> Promise<V> run(Func<V, Object[]> handler, Object ... args) {
        return Promise.all(args).then(handler);
    }

    public static final <V> Promise<V> run(AsyncFunc<V, Object[]> handler, Object ... args) {
        return Promise.all(args).then(handler);
    }

    public static final <T> Promise<?> run(Class<T> type, Action<T[]> handler, Object ... args) {
        return Promise.all(args, type).then(handler);
    }

    public static final <V, T> Promise<V> run(Class<T> type, Func<V, T[]> handler, Object ... args) {
        return Promise.all(args, type).then(handler);
    }

    public static final <V, T> Promise<V> run(Class<T> type, AsyncFunc<V, T[]> handler, Object ... args) {
        return Promise.all(args, type).then(handler);
    }

    public static final <V> Promise<?> forEach(final Action<V> callback, Object ... args) {
        return Promise.all(args).then(new Action<Object[]>(){

            @Override
            public void call(Object[] array) throws Throwable {
                if (array == null) {
                    return;
                }
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    callback.call(array[i]);
                }
            }
        });
    }

    private static <V> Action<Object[]> getForEachHandler(final Handler<?, V> callback) {
        return new Action<Object[]>(){

            @Override
            public void call(Object[] array) throws Throwable {
                if (array == null) {
                    return;
                }
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    callback.call(array[i], i);
                }
            }
        };
    }

    public static final <V> Promise<?> forEach(Object[] array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getForEachHandler(callback));
    }

    public static final <V> Promise<?> forEach(Promise<Object[]> array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getForEachHandler(callback));
    }

    public final Promise<?> forEach(Handler<?, V> callback) {
        return this.all().then(Promise.getForEachHandler(callback));
    }

    public static final <V> Promise<Boolean> every(final Func<Boolean, V> callback, Object ... args) {
        return Promise.all(args).then(new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (((Boolean)callback.call(array[i])).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private static <V> Func<Boolean, Object[]> getEveryHandler(final Handler<Boolean, V> callback) {
        return new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (((Boolean)callback.call(array[i], i)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static final <V> Promise<Boolean> every(Object[] array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getEveryHandler(callback));
    }

    public static final <V> Promise<Boolean> every(Promise<Object[]> array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getEveryHandler(callback));
    }

    public final <V> Promise<Boolean> every(Handler<Boolean, V> callback) {
        return this.all().then(Promise.getEveryHandler(callback));
    }

    public static final <V> Promise<Boolean> some(final Func<Boolean, V> callback, Object ... args) {
        return Promise.all(args).then(new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                if (array == null) {
                    return false;
                }
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i])).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private static <V> Func<Boolean, Object[]> getSomeHandler(final Handler<Boolean, V> callback) {
        return new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                if (array == null) {
                    return false;
                }
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i], i)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final <V> Promise<Boolean> some(Object[] array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getSomeHandler(callback));
    }

    public static final <V> Promise<Boolean> some(Promise<Object[]> array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getSomeHandler(callback));
    }

    public final <V> Promise<Boolean> some(Handler<Boolean, V> callback) {
        return this.all().then(Promise.getSomeHandler(callback));
    }

    public static final <V> Promise<Object[]> filter(final Func<Boolean, V> callback, Object ... args) {
        return Promise.all(args).then(new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                ArrayList<Object> result = new ArrayList<Object>(n);
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i])).booleanValue()) continue;
                    result.add(array[i]);
                }
                return result.toArray();
            }
        });
    }

    private static <V, T> Func<T[], T[]> getFilterHandler(final Handler<Boolean, V> callback, final Class<T> type) {
        return new Func<T[], T[]>(){

            @Override
            public T[] call(T[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                ArrayList result = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i], i)).booleanValue()) continue;
                    result.add(array[i]);
                }
                return result.toArray(type == Object.class ? new Object[result.size()] : (Object[])Array.newInstance(type, result.size()));
            }
        };
    }

    public static final <V, T> Promise<T[]> filter(Object[] array, Handler<Boolean, V> callback, Class<T> type) {
        return Promise.all(array, type).then(Promise.getFilterHandler(callback, type));
    }

    public static final <V> Promise<Object[]> filter(Object[] array, Handler<Boolean, V> callback) {
        return Promise.filter(array, callback, Object.class);
    }

    public static final <V, T> Promise<T[]> filter(Promise<Object[]> array, Handler<Boolean, V> callback, Class<T> type) {
        return Promise.all(array, type).then(Promise.getFilterHandler(callback, type));
    }

    public static final <V> Promise<Object[]> filter(Promise<Object[]> array, Handler<Boolean, V> callback) {
        return Promise.filter(array, callback, Object.class);
    }

    public final <V, T> Promise<T[]> filter(Handler<Boolean, V> callback, Class<T> type) {
        return this.all(type).then(Promise.getFilterHandler(callback, type));
    }

    public final <V> Promise<Object[]> filter(Handler<Boolean, V> callback) {
        return this.filter(callback, Object.class);
    }

    public static final <V> Promise<Object[]> map(final Func<?, V> callback, Object ... args) {
        return Promise.all(args).then(new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                Object[] result = new Object[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = callback.call(array[i]);
                }
                return result;
            }
        });
    }

    private static <V, T> Func<T[], Object[]> getMapHandler(final Handler<T, V> callback, final Class<T> type) {
        return new Func<T[], Object[]>(){

            @Override
            public T[] call(Object[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                Object[] result = type == Object.class ? new Object[n] : (Object[])Array.newInstance(type, n);
                for (int i = 0; i < n; ++i) {
                    result[i] = callback.call(array[i], i);
                }
                return result;
            }
        };
    }

    private static <V> Func<Object[], Object[]> getMapHandler(final Handler<?, V> callback) {
        return new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                Object[] result = new Object[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = callback.call(array[i], i);
                }
                return result;
            }
        };
    }

    public static final <V, T> Promise<T[]> map(Object[] array, Handler<T, V> callback, Class<T> type) {
        return Promise.all(array).then(Promise.getMapHandler(callback, type));
    }

    public static final <V> Promise<Object[]> map(Object[] array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getMapHandler(callback));
    }

    public static final <V, T> Promise<T[]> map(Promise<Object[]> array, Handler<T, V> callback, Class<T> type) {
        return Promise.all(array).then(Promise.getMapHandler(callback, type));
    }

    public static final <V> Promise<Object[]> map(Promise<Object[]> array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getMapHandler(callback));
    }

    public final <V, T> Promise<T[]> map(Handler<T, V> callback, Class<T> type) {
        return this.all().then(Promise.getMapHandler(callback, type));
    }

    public final <V> Promise<Object[]> map(Handler<?, V> callback) {
        return this.all().then(Promise.getMapHandler(callback));
    }

    private static <V> Func<V, Object[]> getReduceHandler(final Reducer<V, V> callback) {
        return new Func<V, Object[]>(){

            @Override
            public V call(Object[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                if (n == 0) {
                    return null;
                }
                Object result = array[0];
                for (int i = 1; i < n; ++i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <V> Promise<V> reduce(Object[] array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceHandler(callback));
    }

    public static final <V> Promise<V> reduce(Promise<Object[]> array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceHandler(callback));
    }

    public final <V> Promise<V> reduce(Reducer<V, V> callback) {
        return this.all().then(Promise.getReduceHandler(callback));
    }

    private static <R, V> Func<R, Object[]> getReduceHandler(final Reducer<R, V> callback, final R initialValue) {
        return new Func<R, Object[]>(){

            @Override
            public R call(Object[] array) throws Throwable {
                if (array == null) {
                    return initialValue;
                }
                int n = array.length;
                if (n == 0) {
                    return initialValue;
                }
                Object result = initialValue;
                for (int i = 0; i < n; ++i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <R, V> Promise<R> reduce(Object[] array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceHandler(callback, initialValue));
    }

    public static final <R, V> Promise<R> reduce(Promise<Object[]> array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceHandler(callback, initialValue));
    }

    public final <R, V> Promise<R> reduce(Reducer<R, V> callback, R initialValue) {
        return this.all().then(Promise.getReduceHandler(callback, initialValue));
    }

    private static <V> Func<V, Object[]> getReduceRightHandler(final Reducer<V, V> callback) {
        return new Func<V, Object[]>(){

            @Override
            public V call(Object[] array) throws Throwable {
                if (array == null) {
                    return null;
                }
                int n = array.length;
                if (n == 0) {
                    return null;
                }
                Object result = array[n - 1];
                for (int i = n - 2; i >= 0; --i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <V> Promise<V> reduceRight(Object[] array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback));
    }

    public static final <V> Promise<V> reduceRight(Promise<Object[]> array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback));
    }

    public final <V> Promise<V> reduceRight(Reducer<V, V> callback) {
        return this.all().then(Promise.getReduceRightHandler(callback));
    }

    private static <R, V> Func<R, Object[]> getReduceRightHandler(final Reducer<R, V> callback, final R initialValue) {
        return new Func<R, Object[]>(){

            @Override
            public R call(Object[] array) throws Throwable {
                if (array == null) {
                    return initialValue;
                }
                int n = array.length;
                if (n == 0) {
                    return initialValue;
                }
                Object result = initialValue;
                for (int i = n - 1; i >= 0; --i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <R, V> Promise<R> reduceRight(Object[] array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback, initialValue));
    }

    public static final <R, V> Promise<R> reduceRight(Promise<Object[]> array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback, initialValue));
    }

    public final <R, V> Promise<R> reduceRight(Reducer<R, V> callback, R initialValue) {
        return this.all().then(Promise.getReduceRightHandler(callback, initialValue));
    }

    private <R, V> void call(Callback<R, V> callback, Promise<R> next, V x) {
        try {
            if (callback instanceof Action) {
                ((Action)callback).call(x);
                next.resolve((Object)null);
            } else if (callback instanceof Func) {
                next.resolve(((Func)callback).call(x));
            } else if (callback instanceof AsyncFunc) {
                next.resolve(((AsyncFunc)callback).call(x));
            }
        }
        catch (Throwable e) {
            next.reject(e);
        }
    }

    private <R, V> void resolve(Callback<R, V> onfulfill, Promise<R> next, V x) {
        if (onfulfill != null) {
            this.call(onfulfill, next, x);
        } else {
            next.resolve(x);
        }
    }

    private <R> void reject(Callback<R, Throwable> onreject, Promise<R> next, Throwable e) {
        if (onreject != null) {
            this.call(onreject, next, e);
        } else {
            next.reject(e);
        }
    }

    private <R> void _resolve(V value) {
        if (this.state.compareAndSet(State.PENDING, State.FULFILLED)) {
            this.value = value;
            while (!this.subscribers.isEmpty()) {
                Subscriber<?, V> subscriber = this.subscribers.poll();
                this.resolve(subscriber.onfulfill, subscriber.next, value);
            }
        }
    }

    @Override
    public final void resolve(Object value) {
        if (Promise.isPromise(value)) {
            this.resolve((Promise)value);
        } else if (Promise.isThenable(value)) {
            this.resolve((Thenable)value);
        } else {
            this._resolve(value);
        }
    }

    @Override
    public final void resolve(Thenable<V> value) {
        block2: {
            final AtomicBoolean notrun = new AtomicBoolean(true);
            Action resolveFunction = new Action<V>(){

                @Override
                public void call(V y) throws Throwable {
                    if (notrun.compareAndSet(true, false)) {
                        Promise.this.resolve(y);
                    }
                }
            };
            Action<Throwable> rejectFunction = new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    if (notrun.compareAndSet(true, false)) {
                        Promise.this.reject(e);
                    }
                }
            };
            try {
                value.then(resolveFunction, rejectFunction);
            }
            catch (Throwable e) {
                if (!notrun.compareAndSet(true, false)) break block2;
                this.reject(e);
            }
        }
    }

    @Override
    public final void resolve(Promise<V> value) {
        if (value == null) {
            this._resolve(null);
        } else if (value == this) {
            this.reject(new TypeException("Self resolution"));
        } else {
            value.fill(this);
        }
    }

    private <R> void _reject(Throwable e) {
        if (this.state.compareAndSet(State.PENDING, State.REJECTED)) {
            this.reason = e;
            while (!this.subscribers.isEmpty()) {
                Subscriber<?, V> subscriber = this.subscribers.poll();
                this.reject(subscriber.onreject, subscriber.next, e);
            }
        }
    }

    @Override
    public final void reject(Throwable e) {
        this._reject(e);
    }

    public final Promise<?> then(Action<V> onfulfill) {
        return this.then(onfulfill, (Action<Throwable>)null);
    }

    public final <R> Promise<R> then(Func<R, V> onfulfill) {
        return this.then((Callback<R, V>)onfulfill, null);
    }

    public final <R> Promise<R> then(AsyncFunc<R, V> onfulfill) {
        return this.then((Callback<R, V>)onfulfill, null);
    }

    @Override
    public final Promise<?> then(Action<V> onfulfill, Action<Throwable> onreject) {
        return this.then((Callback)onfulfill, (Callback)onreject);
    }

    @Override
    public final <R> Promise<R> then(Func<R, V> onfulfill, Func<R, Throwable> onreject) {
        return this.then((Callback<R, V>)onfulfill, (Callback<R, Throwable>)onreject);
    }

    @Override
    public final <R> Promise<R> then(AsyncFunc<R, V> onfulfill, Func<R, Throwable> onreject) {
        return this.then((Callback<R, V>)onfulfill, (Callback<R, Throwable>)onreject);
    }

    @Override
    public final <R> Promise<R> then(AsyncFunc<R, V> onfulfill, AsyncFunc<R, Throwable> onreject) {
        return this.then((Callback<R, V>)onfulfill, (Callback<R, Throwable>)onreject);
    }

    @Override
    public final <R> Promise<R> then(Func<R, V> onfulfill, AsyncFunc<R, Throwable> onreject) {
        return this.then((Callback<R, V>)onfulfill, (Callback<R, Throwable>)onreject);
    }

    @Override
    private <R> Promise<R> then(Callback<R, V> onfulfill, Callback<R, Throwable> onreject) {
        Promise<V> next = new Promise<V>();
        switch (this.state.get()) {
            case FULFILLED: {
                this.resolve(onfulfill, next, this.value);
                break;
            }
            case REJECTED: {
                this.reject(onreject, next, this.reason);
                break;
            }
            default: {
                this.subscribers.offer(new Subscriber<R, V>(onfulfill, onreject, next));
            }
        }
        return next;
    }

    public final void done(Action<V> onfulfill) {
        this.done(onfulfill, null);
    }

    public final void done(Action<V> onfulfill, Action<Throwable> onreject) {
        this.then(onfulfill, onreject).then((Action<?>)null, new Action<Throwable>(){

            @Override
            public void call(final Throwable e) {
                timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
    }

    public final State getState() {
        return this.state.get();
    }

    public final V getValue() {
        return this.value;
    }

    public final Throwable getReason() {
        return this.reason;
    }

    public final Promise<?> catchError(Action<Throwable> onreject) {
        return this.then((Action<V>)null, onreject);
    }

    public final <R> Promise<R> catchError(Func<R, Throwable> onreject) {
        return this.then((Callback)null, onreject);
    }

    public final <R> Promise<R> catchError(AsyncFunc<R, Throwable> onreject) {
        return this.then((Callback)null, onreject);
    }

    public final Promise<?> catchError(Action<Throwable> onreject, Func<Boolean, Throwable> test) {
        return this.catchError((Callback)onreject, test);
    }

    public final <R> Promise<R> catchError(Func<R, Throwable> onreject, Func<Boolean, Throwable> test) {
        return this.catchError((Callback<R, Throwable>)onreject, test);
    }

    public final <R> Promise<R> catchError(AsyncFunc<R, Throwable> onreject, Func<Boolean, Throwable> test) {
        return this.catchError((Callback<R, Throwable>)onreject, test);
    }

    public final Promise<?> catchError(Action<Throwable> onreject, AsyncFunc<Boolean, Throwable> test) {
        return this.catchError((Callback)onreject, test);
    }

    public final <R> Promise<R> catchError(Func<R, Throwable> onreject, AsyncFunc<Boolean, Throwable> test) {
        return this.catchError((Callback<R, Throwable>)onreject, test);
    }

    public final <R> Promise<R> catchError(AsyncFunc<R, Throwable> onreject, AsyncFunc<Boolean, Throwable> test) {
        return this.catchError((Callback<R, Throwable>)onreject, test);
    }

    private <R> Promise<R> catchError(final Callback<R, Throwable> onreject, final Func<Boolean, Throwable> test) {
        if (test != null) {
            return this.then((Callback)null, new AsyncFunc<R, Throwable>(){

                @Override
                public Promise<R> call(Throwable e) throws Throwable {
                    if (((Boolean)test.call(e)).booleanValue()) {
                        return Promise.this.then(null, onreject);
                    }
                    throw e;
                }
            });
        }
        return this.then(null, onreject);
    }

    private <R> Promise<R> catchError(final Callback<R, Throwable> onreject, final AsyncFunc<Boolean, Throwable> test) {
        if (test != null) {
            return this.then((Callback)null, new AsyncFunc<R, Throwable>(){

                @Override
                public Promise<R> call(final Throwable e) throws Throwable {
                    return test.call(e).then(new AsyncFunc<R, Boolean>(){

                        @Override
                        public Promise<R> call(Boolean value) throws Throwable {
                            if (value.booleanValue()) {
                                return Promise.this.then(null, onreject);
                            }
                            throw e;
                        }
                    });
                }
            });
        }
        return this.then(null, onreject);
    }

    public final void fail(Action<Throwable> onreject) {
        this.done(null, onreject);
    }

    public final Promise<V> whenComplete(final Runnable action) {
        return this.then(new Func<V, V>(){

            @Override
            public V call(V value) throws Throwable {
                action.run();
                return value;
            }
        }, new Func<V, Throwable>(){

            @Override
            public V call(Throwable e) throws Throwable {
                action.run();
                throw e;
            }
        });
    }

    public final Promise<V> whenComplete(final Action<?> action) {
        return this.then(new Func<V, V>(){

            @Override
            public V call(V value) throws Throwable {
                action.call(value);
                return value;
            }
        }, new Func<V, Throwable>(){

            @Override
            public V call(Throwable e) throws Throwable {
                action.call(e);
                throw e;
            }
        });
    }

    public final Promise<?> complete(Action<?> oncomplete) {
        return this.then(oncomplete, oncomplete);
    }

    public final <R> Promise<R> complete(Func<R, ?> oncomplete) {
        return this.then(oncomplete, oncomplete);
    }

    public final <R> Promise<R> complete(AsyncFunc<R, ?> oncomplete) {
        return this.then(oncomplete, oncomplete);
    }

    public final void always(Action<?> oncomplete) {
        this.done(oncomplete, oncomplete);
    }

    public final void fill(final Promise<V> promise) {
        this.then(new Action<V>(){

            @Override
            public void call(V value) throws Throwable {
                promise.resolve(value);
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                promise.reject(e);
            }
        });
    }

    public final Promise<V> timeout(long duration, TimeUnit timeunit, final Throwable reason) {
        final Promise<V> promise = new Promise<V>();
        final ScheduledFuture<?> timeoutID = timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (reason == null) {
                    promise.reject(new TimeoutException("timeout"));
                } else {
                    promise.reject(reason);
                }
            }
        }, duration, timeunit);
        this.whenComplete(new Runnable(){

            @Override
            public void run() {
                timeoutID.cancel(true);
            }
        }).fill(promise);
        return promise;
    }

    public final Promise<V> timeout(long duration, Throwable reason) {
        return this.timeout(duration, TimeUnit.MILLISECONDS, reason);
    }

    public final Promise<V> timeout(long duration) {
        return this.timeout(duration, TimeUnit.MILLISECONDS, null);
    }

    public final Promise<V> delay(final long duration, final TimeUnit timeunit) {
        final Promise<V> promise = new Promise<V>();
        this.then(new Action<V>(){

            @Override
            public void call(final V value) throws Throwable {
                timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        promise.resolve(value);
                    }
                }, duration, timeunit);
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                promise.reject(e);
            }
        });
        return promise;
    }

    public final Promise<V> delay(long duration) {
        return this.delay(duration, TimeUnit.MILLISECONDS);
    }

    public final Promise<V> tap(final Action<V> onfulfilledSideEffect) {
        return this.then(new Func<V, V>(){

            @Override
            public V call(V value) throws Throwable {
                onfulfilledSideEffect.call(value);
                return value;
            }
        });
    }

    public final Future<V> toFuture() {
        return new PromiseFuture(this);
    }

    static {
        Threads.registerShutdownHandler(new Runnable(){

            @Override
            public void run() {
                ScheduledExecutorService t = timer;
                timer = Executors.newSingleThreadScheduledExecutor();
                t.shutdownNow();
            }
        });
    }
}

