/*
 * Decompiled with CFR 0.152.
 */
package hprose.util;

import hprose.io.HproseClassManager;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Iterator;

public final class ClassUtil {
    private static Class<?> getInnerClass(StringBuilder className, int[] pos, int i, char c) {
        if (i < pos.length) {
            int p = pos[i];
            className.setCharAt(p, c);
            Class<?> type = ClassUtil.getInnerClass(className, pos, i + 1, '_');
            if (i + 1 < pos.length && type == null) {
                type = ClassUtil.getInnerClass(className, pos, i + 1, '$');
            }
            return type;
        }
        try {
            return Class.forName(className.toString());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static final String getClassAlias(Class<?> type) {
        String className = HproseClassManager.getClassAlias(type);
        if (className == null) {
            className = type.getName().replace('.', '_').replace('$', '_');
            HproseClassManager.register(type, className);
        }
        return className;
    }

    private static Class<?> getClass(StringBuilder className, int[] pos, int i, char c) {
        if (i < pos.length) {
            int p = pos[i];
            className.setCharAt(p, c);
            Class<?> type = ClassUtil.getClass(className, pos, i + 1, '.');
            if (i + 1 < pos.length) {
                if (type == null) {
                    type = ClassUtil.getClass(className, pos, i + 1, '_');
                }
                if (type == null) {
                    type = ClassUtil.getInnerClass(className, pos, i + 1, '$');
                }
            }
            return type;
        }
        try {
            return Class.forName(className.toString());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static final Class<?> getClass(String className) {
        Class<Object> type = HproseClassManager.getClass(className);
        if (type == null) {
            StringBuilder cn = new StringBuilder(className);
            ArrayList<Integer> al = new ArrayList<Integer>();
            int p = cn.indexOf("_");
            while (p > -1) {
                al.add(p);
                p = cn.indexOf("_", p + 1);
            }
            if (al.size() > 0) {
                try {
                    int size = al.size();
                    int[] pos = new int[size];
                    int i = -1;
                    Iterator iterator = al.iterator();
                    while (iterator.hasNext()) {
                        int x = (Integer)iterator.next();
                        pos[++i] = x;
                    }
                    type = ClassUtil.getClass(cn, pos, 0, '.');
                    if (type == null) {
                        type = ClassUtil.getClass(cn, pos, 0, '_');
                    }
                    if (type == null) {
                        type = ClassUtil.getInnerClass(cn, pos, 0, '$');
                    }
                }
                catch (Exception e) {}
            } else {
                try {
                    type = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (type == null) {
                type = Void.TYPE;
            }
            HproseClassManager.register(type, className);
        }
        return type;
    }

    private static Class<?> toClass(Type[] bounds) {
        Type boundType;
        if (bounds.length == 1 && (boundType = bounds[0]) instanceof Class) {
            return (Class)boundType;
        }
        return Object.class;
    }

    public static final Class<?> toClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType) {
            return ClassUtil.toClass(((WildcardType)type).getUpperBounds());
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.toClass(((TypeVariable)type).getBounds());
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ClassUtil.toClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return Object.class;
    }

    public static final Type getComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (((Class)type).isArray() ? ((Class)type).getComponentType() : Object.class));
    }

    public static final Type getKeyType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
    }

    public static final Type getValueType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[1] : Object.class;
    }

    public static final Type getActualType(Type type, Type paramType) {
        if (type instanceof ParameterizedType && paramType instanceof TypeVariable) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<?>[] typeParameters = ((TypeVariable)paramType).getGenericDeclaration().getTypeParameters();
            int n = typeParameters.length;
            for (int i = 0; i < n; ++i) {
                if (!typeParameters[i].equals(paramType)) continue;
                return actualTypeArguments[i];
            }
        }
        return paramType;
    }
}

