/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.ClientContext;
import hprose.client.HproseHttpClient;
import hprose.client.HproseInvocationHandler;
import hprose.client.HproseTcpClient;
import hprose.common.HandlerManager;
import hprose.common.HproseCallback;
import hprose.common.HproseCallback1;
import hprose.common.HproseContext;
import hprose.common.HproseErrorEvent;
import hprose.common.HproseException;
import hprose.common.HproseFilter;
import hprose.common.HproseResultMode;
import hprose.common.InvokeSettings;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.Reader;
import hprose.util.ClassUtil;
import hprose.util.StrUtil;
import hprose.util.concurrent.Action;
import hprose.util.concurrent.AsyncCall;
import hprose.util.concurrent.AsyncFunc;
import hprose.util.concurrent.Func;
import hprose.util.concurrent.Promise;
import hprose.util.concurrent.Threads;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class HproseClient
extends HandlerManager {
    private static final Object[] nullArgs = new Object[0];
    private final ArrayList<HproseFilter> filters;
    private final ArrayList<String> uriList;
    private final AtomicInteger index;
    private volatile HproseMode mode;
    private volatile int timeout;
    private volatile int retry;
    private volatile boolean idempotent;
    private volatile boolean failswitch;
    private volatile int failround;
    private volatile boolean byref;
    private volatile boolean simple;
    protected String uri;
    public HproseErrorEvent onError;
    public Action<HproseClient> onFailswitch;
    private static final HashMap<String, Class<? extends HproseClient>> clientFactories = new HashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Topic<?>>> allTopics;
    private static final InvokeSettings autoIdSettings;
    private volatile String autoId;

    protected HproseClient() {
        this((String[])null, HproseMode.MemberMode);
    }

    protected HproseClient(HproseMode mode) {
        this((String[])null, mode);
    }

    protected HproseClient(String uri) {
        this(uri, HproseMode.MemberMode);
    }

    protected HproseClient(String uri, HproseMode mode) {
        String[] stringArray;
        if (uri == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = uri;
        }
        this(stringArray, mode);
    }

    protected HproseClient(String[] uriList) {
        this(uriList, HproseMode.MemberMode);
    }

    protected HproseClient(String[] uriList, HproseMode mode) {
        this.filters = new ArrayList();
        this.uriList = new ArrayList();
        this.index = new AtomicInteger(-1);
        this.timeout = 30000;
        this.retry = 10;
        this.idempotent = false;
        this.failswitch = false;
        this.failround = 0;
        this.byref = false;
        this.simple = false;
        this.onError = null;
        this.onFailswitch = null;
        this.allTopics = new ConcurrentHashMap();
        this.autoId = null;
        this.mode = mode;
        if (uriList != null) {
            this.setUriList(uriList);
        }
        Threads.registerShutdownHandler(new Runnable(){

            @Override
            public void run() {
                HproseClient.this.close();
            }
        });
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientFactory(String scheme, Class<? extends HproseClient> clientClass) {
        HashMap<String, Class<? extends HproseClient>> hashMap = clientFactories;
        synchronized (hashMap) {
            clientFactories.put(scheme, clientClass);
        }
    }

    public static HproseClient create(String uri) throws IOException, URISyntaxException {
        return HproseClient.create(new String[]{uri}, HproseMode.MemberMode);
    }

    public static HproseClient create(String uri, HproseMode mode) throws IOException, URISyntaxException {
        return HproseClient.create(new String[]{uri}, mode);
    }

    public static HproseClient create(String[] uriList, HproseMode mode) throws IOException, URISyntaxException {
        String scheme = new URI(uriList[0]).getScheme().toLowerCase();
        int n = uriList.length;
        for (int i = 1; i < n; ++i) {
            if (new URI(uriList[i]).getScheme().toLowerCase().equalsIgnoreCase(scheme)) continue;
            throw new HproseException("Not support multiple protocol.");
        }
        Class<? extends HproseClient> clientClass = clientFactories.get(scheme);
        if (clientClass != null) {
            try {
                HproseClient client = clientClass.newInstance();
                client.mode = mode;
                client.useService(uriList);
                return client;
            }
            catch (Exception ex) {
                throw new HproseException("This client doesn't support " + scheme + " scheme.");
            }
        }
        throw new HproseException("This client doesn't support " + scheme + " scheme.");
    }

    public final List<String> getUriList() {
        return this.uriList;
    }

    private void initUriList() {
        Collections.shuffle(this.uriList);
        this.index.set(0);
        this.failround = 0;
        this.uri = this.uriList.get(0);
    }

    public final void setUriList(List<String> uriList) {
        this.uriList.clear();
        int n = uriList.size();
        for (int i = 0; i < n; ++i) {
            this.uriList.add(uriList.get(i));
        }
        this.initUriList();
    }

    public final void setUriList(String[] uriList) {
        this.uriList.clear();
        int n = uriList.length;
        for (int i = 0; i < n; ++i) {
            this.uriList.add(uriList[i]);
        }
        this.initUriList();
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("timeout must be great than 0");
        }
        this.timeout = timeout;
    }

    public final int getRetry() {
        return this.retry;
    }

    public final void setRetry(int retry) {
        this.retry = retry;
    }

    public final boolean isIdempotent() {
        return this.idempotent;
    }

    public final void setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
    }

    public final boolean isFailswitch() {
        return this.failswitch;
    }

    public final void setFailswitch(boolean failswitch) {
        this.failswitch = failswitch;
    }

    public final int getFailround() {
        return this.failround;
    }

    public final boolean isByref() {
        return this.byref;
    }

    public final void setByref(boolean byref) {
        this.byref = byref;
    }

    public final boolean isSimple() {
        return this.simple;
    }

    public final void setSimple(boolean simple) {
        this.simple = simple;
    }

    public final HproseFilter getFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        return this.filters.get(0);
    }

    public final void setFilter(HproseFilter filter) {
        if (!this.filters.isEmpty()) {
            this.filters.clear();
        }
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public final void addFilter(HproseFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public final boolean removeFilter(HproseFilter filter) {
        return this.filters.remove(filter);
    }

    public final void useService(String uri) {
        this.setUriList(new String[]{uri});
    }

    public final void useService(String[] uriList) {
        this.setUriList(uriList);
    }

    public final <T> T useService(Class<T> type) {
        return this.useService(type, null);
    }

    public final <T> T useService(String uri, Class<T> type) {
        return this.useService(uri, type, null);
    }

    public final <T> T useService(String[] uriList, Class<T> type) {
        return this.useService(uriList, type, null);
    }

    public final <T> T useService(Class<T> type, String ns) {
        HproseInvocationHandler handler = new HproseInvocationHandler(this, ns);
        if (type.isInterface()) {
            return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        }
        return (T)Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)handler);
    }

    public final <T> T useService(String uri, Class<T> type, String ns) {
        this.useService(uri);
        return this.useService(type, ns);
    }

    public final <T> T useService(String[] uriList, Class<T> type, String ns) {
        this.setUriList(uriList);
        return this.useService(type, ns);
    }

    private ByteBuffer outputFilter(ByteBuffer request, ClientContext context) {
        if (request.position() != 0) {
            request.flip();
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            request = this.filters.get(i).outputFilter(request, context);
            if (request.position() == 0) continue;
            request.flip();
        }
        return request;
    }

    private ByteBuffer inputFilter(ByteBuffer response, ClientContext context) {
        if (response.position() != 0) {
            response.flip();
        }
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            response = this.filters.get(i).inputFilter(response, context);
            if (response.position() == 0) continue;
            response.flip();
        }
        return response;
    }

    private Promise<ByteBuffer> beforeFilterHandler(ByteBuffer request, final ClientContext context) {
        request = this.outputFilter(request, context);
        if (context.getSettings().isOneway()) {
            this.afterFilterHandler.handle(request, context);
            return Promise.value(null);
        }
        return this.afterFilterHandler.handle(request, context).then(new Func<ByteBuffer, ByteBuffer>(){

            @Override
            public ByteBuffer call(ByteBuffer response) throws Throwable {
                response = HproseClient.this.inputFilter(response, context);
                return response;
            }
        });
    }

    private Promise<ByteBuffer> afterFilterHandler(ByteBuffer request, ClientContext context) {
        return this.sendAndReceive(request, context);
    }

    private Promise<ByteBuffer> sendRequest(final ByteBuffer request, final ClientContext context) {
        return this.beforeFilterHandler.handle(request, context).catchError(new AsyncFunc<ByteBuffer, Throwable>(){

            @Override
            public Promise<ByteBuffer> call(Throwable e) throws Throwable {
                Promise response = HproseClient.this.retry(request, context);
                if (response != null) {
                    return response;
                }
                throw e;
            }
        });
    }

    private Promise<ByteBuffer> retry(final ByteBuffer request, final ClientContext context) throws Throwable {
        InvokeSettings settings = context.getSettings();
        if (settings.isFailswitch()) {
            this.failswitch();
        }
        if (settings.isIdempotent() && context.retried < settings.getRetry()) {
            int interval = ++context.retried * 500;
            if (settings.isFailswitch()) {
                interval -= (this.uriList.size() - 1) * 500;
            }
            if (interval > 5000) {
                interval = 5000;
            }
            if (interval > 0) {
                return Promise.delayed((long)interval, new AsyncCall<ByteBuffer>(){

                    @Override
                    public Promise<ByteBuffer> call() throws Throwable {
                        return HproseClient.this.sendRequest(request, context);
                    }
                });
            }
            return this.sendRequest(request, context);
        }
        return null;
    }

    private void failswitch() throws Throwable {
        int n = this.uriList.size();
        if (n > 1) {
            if (this.index.compareAndSet(n - 1, 0)) {
                this.uri = this.uriList.get(0);
                ++this.failround;
            } else {
                this.uri = this.uriList.get(this.index.incrementAndGet());
            }
        } else {
            ++this.failround;
        }
        if (this.onFailswitch != null) {
            this.onFailswitch.call(this);
        }
    }

    private ClientContext getContext(InvokeSettings settings) {
        ClientContext context = new ClientContext(this);
        context.getSettings().copyFrom(settings);
        if (settings.getUserData() != null) {
            context.getUserData().putAll(settings.getUserData());
        }
        return context;
    }

    private ByteBufferStream encode(String name, Object[] args, ClientContext context) throws Throwable {
        ByteBufferStream stream = new ByteBufferStream();
        InvokeSettings settings = context.getSettings();
        Writer writer = new Writer(stream.getOutputStream(), this.mode, settings.isSimple());
        stream.write(67);
        writer.writeString(name);
        if (args != null && (args.length > 0 || settings.isByref())) {
            writer.reset();
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                if (!(args[i] instanceof Future)) continue;
                args[i] = ((Future)args[i]).get(settings.getTimeout(), TimeUnit.MILLISECONDS);
            }
            writer.writeArray(args);
            if (settings.isByref()) {
                writer.writeBoolean(true);
            }
        }
        stream.write(122);
        return stream;
    }

    private Object getRaw(ByteBufferStream stream, Type returnType) throws HproseException {
        stream.flip();
        if (returnType == null || returnType == Object.class || returnType == ByteBuffer.class || returnType == Buffer.class) {
            return stream.buffer;
        }
        if (returnType == ByteBufferStream.class) {
            return stream;
        }
        if (returnType == byte[].class) {
            byte[] bytes = stream.toArray();
            stream.close();
            return bytes;
        }
        throw new HproseException("Can't Convert ByteBuffer to Type: " + returnType.toString());
    }

    private Object decode(ByteBufferStream stream, Object[] args, ClientContext context) throws IOException, HproseException {
        InvokeSettings settings = context.getSettings();
        if (settings.isOneway()) {
            return null;
        }
        if (stream.available() == 0) {
            throw new HproseException("EOF");
        }
        int tag = stream.buffer.get(stream.buffer.limit() - 1);
        if (tag != 122) {
            throw new HproseException("Wrong Response: \r\n" + StrUtil.toString(stream));
        }
        HproseResultMode resultMode = settings.getMode();
        Type returnType = settings.getReturnType();
        if (resultMode == HproseResultMode.RawWithEndTag) {
            return this.getRaw(stream, returnType);
        }
        if (resultMode == HproseResultMode.Raw) {
            stream.buffer.limit(stream.buffer.limit() - 1);
            return this.getRaw(stream, returnType);
        }
        Object result = null;
        Reader reader = new Reader(stream.getInputStream(), this.mode);
        tag = stream.read();
        if (tag == 82) {
            if (resultMode == HproseResultMode.Normal) {
                result = reader.unserialize(returnType);
            } else if (resultMode == HproseResultMode.Serialized) {
                result = this.getRaw(reader.readRaw(), returnType);
            }
            tag = stream.read();
            if (tag == 65) {
                reader.reset();
                Object[] arguments = reader.readObjectArray();
                int length = args.length;
                if (length > arguments.length) {
                    length = arguments.length;
                }
                System.arraycopy(arguments, 0, args, 0, length);
                tag = stream.read();
            }
        } else if (tag == 69) {
            throw new HproseException(reader.readString());
        }
        if (tag != 122) {
            stream.rewind();
            throw new HproseException("Wrong Response: \r\n" + StrUtil.toString(stream));
        }
        return result;
    }

    @Override
    protected Promise<Object> invokeHandler(String name, Object[] args, HproseContext context) {
        return this.invokeHandler(name, args, (ClientContext)context);
    }

    @Override
    protected Promise<ByteBuffer> beforeFilterHandler(ByteBuffer request, HproseContext context) {
        return this.beforeFilterHandler(request, (ClientContext)context);
    }

    @Override
    protected Promise<ByteBuffer> afterFilterHandler(ByteBuffer request, HproseContext context) {
        return this.afterFilterHandler(request, (ClientContext)context);
    }

    private Promise<Object> invokeHandler(String name, final Object[] args, final ClientContext context) {
        ByteBufferStream stream;
        try {
            stream = this.encode(name, args, context);
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
        final InvokeSettings settings = context.getSettings();
        return this.sendRequest(stream.buffer, context).then(new Func<Object, ByteBuffer>(){

            @Override
            public Object call(ByteBuffer value) throws Throwable {
                stream.buffer = value;
                try {
                    Object object = HproseClient.this.decode(stream, args, context);
                    return object;
                }
                finally {
                    if (settings.getMode() == HproseResultMode.Normal || settings.getMode() == HproseResultMode.Serialized || settings.getReturnType() == byte[].class) {
                        stream.close();
                    }
                }
            }
        });
    }

    protected abstract Promise<ByteBuffer> sendAndReceive(ByteBuffer var1, ClientContext var2);

    public final void invoke(String name, HproseCallback1<?> callback) {
        this.invoke(name, nullArgs, callback, null, null, null);
    }

    public final void invoke(String name, HproseCallback1<?> callback, HproseErrorEvent errorEvent) {
        this.invoke(name, nullArgs, callback, errorEvent, null, null);
    }

    public final void invoke(String name, HproseCallback1<?> callback, InvokeSettings settings) {
        this.invoke(name, nullArgs, callback, null, null, settings);
    }

    public final void invoke(String name, HproseCallback1<?> callback, HproseErrorEvent errorEvent, InvokeSettings settings) {
        this.invoke(name, nullArgs, callback, errorEvent, null, settings);
    }

    public final void invoke(String name, Object[] args, HproseCallback1<?> callback) {
        this.invoke(name, args, callback, null, null, null);
    }

    public final void invoke(String name, Object[] args, HproseCallback1<?> callback, HproseErrorEvent errorEvent) {
        this.invoke(name, args, callback, errorEvent, null, null);
    }

    public final void invoke(String name, Object[] args, HproseCallback1<?> callback, InvokeSettings settings) {
        this.invoke(name, args, callback, null, null, settings);
    }

    public final void invoke(String name, Object[] args, HproseCallback1<?> callback, HproseErrorEvent errorEvent, InvokeSettings settings) {
        this.invoke(name, args, callback, errorEvent, null, settings);
    }

    public final <T> void invoke(String name, HproseCallback1<T> callback, Class<T> returnType) {
        this.invoke(name, nullArgs, callback, null, returnType, null);
    }

    public final <T> void invoke(String name, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType) {
        this.invoke(name, nullArgs, callback, errorEvent, returnType, null);
    }

    public final <T> void invoke(String name, HproseCallback1<T> callback, Class<T> returnType, InvokeSettings settings) {
        this.invoke(name, nullArgs, callback, null, returnType, settings);
    }

    public final <T> void invoke(String name, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, InvokeSettings settings) {
        this.invoke(name, nullArgs, callback, errorEvent, returnType, settings);
    }

    public final <T> void invoke(String name, Object[] args, HproseCallback1<T> callback, Class<T> returnType) {
        this.invoke(name, args, callback, null, returnType, null);
    }

    public final <T> void invoke(String name, Object[] args, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType) {
        this.invoke(name, args, callback, errorEvent, returnType, null);
    }

    public final <T> void invoke(String name, Object[] args, HproseCallback1<T> callback, Class<T> returnType, InvokeSettings settings) {
        this.invoke(name, args, callback, null, returnType, settings);
    }

    public final <T> void invoke(final String name, Object[] args, final HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, InvokeSettings settings) {
        if (settings == null) {
            settings = new InvokeSettings();
        }
        if (returnType != null) {
            settings.setReturnType(returnType);
        }
        final HproseErrorEvent errEvent = errorEvent == null ? this.onError : errorEvent;
        settings.setAsync(true);
        final ClientContext context = this.getContext(settings);
        Promise.all(args).then(new Action<Object[]>(){

            @Override
            public void call(Object[] args) throws Throwable {
                HproseClient.this.invokeHandler.handle(name, args, context).then(new Action<Object>(){

                    @Override
                    public void call(Object value) throws Throwable {
                        callback.handler(value);
                    }
                }, new Action<Throwable>(){

                    @Override
                    public void call(Throwable e) throws Throwable {
                        if (errEvent != null) {
                            errEvent.handler(name, e);
                        }
                    }
                });
            }
        });
    }

    public final void invoke(String name, Object[] args, HproseCallback<?> callback) {
        this.invoke(name, args, callback, null, null, null);
    }

    public final void invoke(String name, Object[] args, HproseCallback<?> callback, HproseErrorEvent errorEvent) {
        this.invoke(name, args, callback, errorEvent, null, null);
    }

    public final void invoke(String name, Object[] args, HproseCallback<?> callback, InvokeSettings settings) {
        this.invoke(name, args, callback, null, null, settings);
    }

    public final void invoke(String name, Object[] args, HproseCallback<?> callback, HproseErrorEvent errorEvent, InvokeSettings settings) {
        this.invoke(name, args, callback, errorEvent, null, settings);
    }

    public final <T> void invoke(String name, Object[] args, HproseCallback<T> callback, Class<T> returnType) {
        this.invoke(name, args, callback, null, returnType, null);
    }

    public final <T> void invoke(String name, Object[] args, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType) {
        this.invoke(name, args, callback, errorEvent, returnType, null);
    }

    public final <T> void invoke(String name, Object[] args, HproseCallback<T> callback, Class<T> returnType, InvokeSettings settings) {
        this.invoke(name, args, callback, null, returnType, settings);
    }

    public final <T> void invoke(final String name, Object[] args, final HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, InvokeSettings settings) {
        if (settings == null) {
            settings = new InvokeSettings();
        }
        if (returnType != null) {
            settings.setReturnType(returnType);
        }
        final HproseErrorEvent errEvent = errorEvent == null ? this.onError : errorEvent;
        settings.setAsync(true);
        final ClientContext context = this.getContext(settings);
        Promise.all(args).then(new Action<Object[]>(){

            @Override
            public void call(final Object[] args) throws Throwable {
                HproseClient.this.invokeHandler.handle(name, args, context).then(new Action<Object>(){

                    @Override
                    public void call(Object value) throws Throwable {
                        callback.handler(value, args);
                    }
                }, new Action<Throwable>(){

                    @Override
                    public void call(Throwable e) throws Throwable {
                        if (errEvent != null) {
                            errEvent.handler(name, e);
                        }
                    }
                });
            }
        });
    }

    public final Object invoke(String name) throws Throwable {
        return this.invoke(name, nullArgs, (Class)null, null);
    }

    public final Object invoke(String name, InvokeSettings settings) throws Throwable {
        return this.invoke(name, nullArgs, (Class)null, settings);
    }

    public final Object invoke(String name, Object[] args) throws Throwable {
        return this.invoke(name, args, (Class)null, null);
    }

    public final Object invoke(String name, Object[] args, InvokeSettings settings) throws Throwable {
        return this.invoke(name, args, (Class)null, settings);
    }

    public final <T> T invoke(String name, Class<T> returnType) throws Throwable {
        return this.invoke(name, nullArgs, returnType, null);
    }

    public final <T> T invoke(String name, Class<T> returnType, InvokeSettings settings) throws Throwable {
        return this.invoke(name, nullArgs, returnType, settings);
    }

    public final <T> T invoke(String name, Object[] args, Class<T> returnType) throws Throwable {
        return this.invoke(name, args, returnType, null);
    }

    public final <T> T invoke(String name, Object[] args, Class<T> returnType, InvokeSettings settings) throws Throwable {
        Type type;
        Class<?> cls;
        if (settings == null) {
            settings = new InvokeSettings();
        }
        if (returnType != null) {
            settings.setReturnType(returnType);
        }
        if (Promise.class.equals(cls = ClassUtil.toClass(type = settings.getReturnType()))) {
            return (T)this.asyncInvoke(name, args, type, settings);
        }
        if (Future.class.equals(cls)) {
            return (T)this.asyncInvoke(name, args, type, settings).toFuture();
        }
        if (settings.isAsync()) {
            return (T)this.asyncInvoke(name, args, type, settings);
        }
        if (args != null) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                if (!(args[i] instanceof Promise)) continue;
                args[i] = ((Promise)args[i]).toFuture();
            }
        }
        ClientContext context = this.getContext(settings);
        return (T)this.invokeHandler.handle(name, args, context).toFuture().get(context.getSettings().getTimeout(), TimeUnit.MILLISECONDS);
    }

    private Promise<?> asyncInvoke(final String name, Object[] args, Type type, InvokeSettings settings) {
        settings.setAsync(true);
        if (type instanceof ParameterizedType) {
            if (Void.TYPE.equals(type = ((ParameterizedType)type).getActualTypeArguments()[0]) || Void.class.equals((Object)type)) {
                type = null;
            }
        } else {
            Class<?> cls = ClassUtil.toClass(type);
            if (Promise.class.equals(cls) || Future.class.equals(cls)) {
                type = null;
            }
        }
        settings.setReturnType(type);
        final ClientContext context = this.getContext(settings);
        return Promise.all(args).then(new AsyncFunc<Object, Object[]>(){

            @Override
            public Promise<Object> call(Object[] args) throws Throwable {
                return HproseClient.this.invokeHandler.handle(name, args, context);
            }
        });
    }

    private Topic<?> getTopic(String name, String id) {
        ConcurrentHashMap<String, Topic<?>> topics = this.allTopics.get(name);
        if (topics != null) {
            return topics.get(id);
        }
        return null;
    }

    public synchronized String autoId() {
        block3: {
            if (this.autoId == null) {
                try {
                    this.autoId = (String)this.invoke("#", autoIdSettings);
                }
                catch (Throwable e) {
                    if (this.onError == null) break block3;
                    this.onError.handler("autoId", e);
                }
            }
        }
        return this.autoId;
    }

    public final void subscribe(String name, Action<Object> callback) {
        this.subscribe(name, (Action)callback, (Type)((Object)Object.class), this.timeout);
    }

    public final void subscribe(String name, Action<Object> callback, int timeout) {
        this.subscribe(name, (Action)callback, (Type)((Object)Object.class), timeout);
    }

    public final void subscribe(String name, String id, Action<Object> callback) {
        this.subscribe(name, id, (Action)callback, (Type)((Object)Object.class), this.timeout);
    }

    public final void subscribe(String name, String id, Action<Object> callback, int timeout) {
        this.subscribe(name, id, (Action)callback, (Type)((Object)Object.class), timeout);
    }

    public final <T> void subscribe(String name, Action<T> callback, Type type) {
        this.subscribe(name, callback, type, this.timeout);
    }

    public final <T> void subscribe(String name, Action<T> callback, Type type, int timeout) {
        this.subscribe(name, this.autoId(), callback, type, timeout);
    }

    public final <T> void subscribe(String name, String id, Action<T> callback, Type type) {
        this.subscribe(name, id, callback, type, this.timeout);
    }

    public final <T> void subscribe(String name, String id, Action<T> callback, Type type, int timeout) {
        this.subscribe(name, id, callback, type, timeout, false);
    }

    public final void subscribe(String name, Action<Object> callback, boolean failswitch) {
        this.subscribe(name, (Action)callback, (Type)((Object)Object.class), this.timeout, failswitch);
    }

    public final void subscribe(String name, Action<Object> callback, int timeout, boolean failswitch) {
        this.subscribe(name, (Action)callback, (Type)((Object)Object.class), timeout, failswitch);
    }

    public final void subscribe(String name, String id, Action<Object> callback, boolean failswitch) {
        this.subscribe(name, id, (Action)callback, (Type)((Object)Object.class), this.timeout, failswitch);
    }

    public final void subscribe(String name, String id, Action<Object> callback, int timeout, boolean failswitch) {
        this.subscribe(name, id, (Action)callback, (Type)((Object)Object.class), timeout, failswitch);
    }

    public final <T> void subscribe(String name, Action<T> callback, Type type, boolean failswitch) {
        this.subscribe(name, callback, type, this.timeout, failswitch);
    }

    public final <T> void subscribe(String name, Action<T> callback, Type type, int timeout, boolean failswitch) {
        this.subscribe(name, this.autoId(), callback, type, timeout, failswitch);
    }

    public final <T> void subscribe(String name, String id, Action<T> callback, Type type, boolean failswitch) {
        this.subscribe(name, id, callback, type, this.timeout, failswitch);
    }

    public final <T> void subscribe(final String name, final String id, Action<T> callback, final Type type, final int timeout, final boolean failswitch) {
        this.allTopics.putIfAbsent(name, new ConcurrentHashMap());
        Topic<Object> topic = this.getTopic(name, id);
        if (topic == null) {
            final Action<Throwable> cb = new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    Topic topic = HproseClient.this.getTopic(name, id);
                    if (topic != null) {
                        InvokeSettings settings = new InvokeSettings();
                        settings.setIdempotent(true);
                        settings.setFailswitch(failswitch);
                        settings.setReturnType(type);
                        settings.setTimeout(timeout);
                        settings.setAsync(true);
                        Promise<Object> result = HproseClient.this.invokeHandler.handle(name, new Object[]{id}, HproseClient.this.getContext(settings));
                        result.then(topic.handler, this);
                    }
                }
            };
            topic = new Topic();
            topic.handler = new Action<T>(){

                @Override
                public void call(T result) throws Throwable {
                    Topic topic = HproseClient.this.getTopic(name, id);
                    if (topic != null) {
                        if (result != null) {
                            ConcurrentLinkedQueue callbacks = topic.callbacks;
                            for (Action callback : callbacks) {
                                try {
                                    callback.call(result);
                                }
                                catch (Throwable e) {}
                            }
                        }
                        cb.call(null);
                    }
                }
            };
            topic.callbacks.offer(callback);
            this.allTopics.get(name).put(id, topic);
            try {
                cb.call(null);
            }
            catch (Throwable e) {
                if (this.onError != null) {
                    this.onError.handler(name, e);
                }
            }
        } else if (!topic.callbacks.contains(callback)) {
            topic.callbacks.offer(callback);
        }
    }

    private <T> void delTopic(ConcurrentHashMap<String, Topic<?>> topics, String id, Action<T> callback) {
        if (topics != null && topics.size() > 0) {
            if (callback != null) {
                Topic<?> topic = topics.get(id);
                if (topic != null) {
                    ConcurrentLinkedQueue callbacks = topic.callbacks;
                    callbacks.remove(callback);
                    if (callbacks.isEmpty()) {
                        topics.remove(id);
                    }
                }
            } else {
                topics.remove(id);
            }
        }
    }

    public void unsubscribe(String name) {
        this.unsubscribe(name, null, null);
    }

    public <T> void unsubscribe(String name, Action<T> callback) {
        this.unsubscribe(name, null, callback);
    }

    public void unsubscribe(String name, String id) {
        this.unsubscribe(name, id, null);
    }

    public <T> void unsubscribe(String name, String id, Action<T> callback) {
        ConcurrentHashMap<String, Topic<?>> topics = this.allTopics.get(name);
        if (topics != null) {
            if (id == null) {
                if (this.autoId == null) {
                    for (String i : topics.keySet()) {
                        this.delTopic(topics, i, callback);
                    }
                } else {
                    this.delTopic(topics, this.autoId, callback);
                }
            } else {
                this.delTopic(topics, id, callback);
            }
            if (topics.isEmpty()) {
                this.allTopics.remove(name, topics);
            }
        }
    }

    public String getId() {
        return this.autoId;
    }

    public boolean isSubscribed(String name) {
        return this.allTopics.containsKey(name);
    }

    public String[] subscribedList() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.allTopics.keySet())).toArray(new String[0]);
    }

    static {
        HproseClient.registerClientFactory("tcp", HproseTcpClient.class);
        HproseClient.registerClientFactory("tcp4", HproseTcpClient.class);
        HproseClient.registerClientFactory("tcp6", HproseTcpClient.class);
        HproseClient.registerClientFactory("http", HproseHttpClient.class);
        HproseClient.registerClientFactory("https", HproseHttpClient.class);
        autoIdSettings = new InvokeSettings();
        autoIdSettings.setReturnType((Type)((Object)String.class));
        autoIdSettings.setSimple(true);
        autoIdSettings.setIdempotent(true);
        autoIdSettings.setFailswitch(true);
    }

    private static class Topic<T> {
        Action<T> handler;
        final ConcurrentLinkedQueue<Action<T>> callbacks = new ConcurrentLinkedQueue();

        private Topic() {
        }
    }
}

