/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.net.Connection;
import hprose.net.Reactor;
import java.io.IOException;

public class ReactorGroup {
    private final Reactor[] reactors;
    private int index;

    public ReactorGroup(int count) throws IOException {
        this.reactors = new Reactor[count];
        for (int i = 0; i < count; ++i) {
            this.reactors[i] = new Reactor();
        }
    }

    public void start() {
        int n = this.reactors.length;
        for (int i = 0; i < n; ++i) {
            this.reactors[i].start();
        }
    }

    public void register(Connection conn) {
        int n = this.reactors.length;
        this.index = (this.index + 1) % n;
        this.reactors[this.index].register(conn);
    }

    public void close() {
        for (int i = this.reactors.length - 1; i >= 0; --i) {
            this.reactors[i].close();
        }
    }
}

