/*
 * Decompiled with CFR 0.152.
 */
package hprose.util;

import hprose.util.TimeZoneUtil;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTime {
    public int year = 1970;
    public int month = 1;
    public int day = 1;
    public int hour = 0;
    public int minute = 0;
    public int second = 0;
    public int nanosecond = 0;
    public boolean utc = false;

    public static final Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZoneUtil.DefaultTZ);
        calendar.setTime(date);
        return calendar;
    }

    private void init(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        if (!tz.hasSameRules(TimeZoneUtil.DefaultTZ) && !tz.hasSameRules(TimeZoneUtil.UTC)) {
            tz = TimeZoneUtil.UTC;
            Calendar c = (Calendar)calendar.clone();
            c.setTimeZone(tz);
            calendar = c;
        }
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.nanosecond = calendar.get(14) * 1000000;
        this.utc = tz.hasSameRules(TimeZoneUtil.UTC);
    }

    public DateTime() {
    }

    public DateTime(Calendar calendar) {
        this.init(calendar);
    }

    public DateTime(Date date) {
        this.init(DateTime.toCalendar(date));
    }

    public DateTime(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DateTime(int year, int month, int day, boolean utc) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.utc = utc;
    }

    public DateTime(int hour, int minute, int second, int nanosecond) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.nanosecond = nanosecond;
    }

    public DateTime(int hour, int minute, int second, int nanosecond, boolean utc) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.nanosecond = nanosecond;
        this.utc = utc;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, boolean utc) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.utc = utc;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int nanosecond) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.nanosecond = nanosecond;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int nanosecond, boolean utc) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.nanosecond = nanosecond;
        this.utc = utc;
    }

    public String toString() {
        String s;
        if (this.year == 1970 && this.month == 1 && this.day == 1) {
            s = String.format("%02d:%02d:%02d", this.hour, this.minute, this.second);
            if (this.nanosecond != 0) {
                s = s + String.format(".%09d", this.nanosecond);
            }
        } else if (this.hour == 0 && this.minute == 0 && this.second == 0 && this.nanosecond == 0) {
            s = String.format("%04d-%02d-%02d", this.year, this.month, this.day);
        } else {
            s = String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.year, this.month, this.day, this.hour, this.minute, this.second);
            if (this.nanosecond != 0) {
                s = s + String.format(".%09d", this.nanosecond);
            }
        }
        if (this.utc) {
            s = s + 'Z';
        }
        return s;
    }

    public StringBuilder toStringBuilder() {
        StringBuilder s = new StringBuilder();
        if (this.year == 1970 && this.month == 1 && this.day == 1) {
            s.append(String.format("%02d:%02d:%02d", this.hour, this.minute, this.second));
            if (this.nanosecond != 0) {
                s.append(String.format(".%09d", this.nanosecond));
            }
        } else if (this.hour == 0 && this.minute == 0 && this.second == 0 && this.nanosecond == 0) {
            s.append(String.format("%04d-%02d-%02d", this.year, this.month, this.day));
        } else {
            s.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.year, this.month, this.day, this.hour, this.minute, this.second));
            if (this.nanosecond != 0) {
                s.append(String.format(".%09d", this.nanosecond));
            }
        }
        if (this.utc) {
            s.append('Z');
        }
        return s;
    }

    public StringBuffer toStringBuffer() {
        StringBuffer s = new StringBuffer();
        if (this.year == 1970 && this.month == 1 && this.day == 1) {
            s.append(String.format("%02d:%02d:%02d", this.hour, this.minute, this.second));
            if (this.nanosecond != 0) {
                s.append(String.format(".%09d", this.nanosecond));
            }
        } else if (this.hour == 0 && this.minute == 0 && this.second == 0 && this.nanosecond == 0) {
            s.append(String.format("%04d-%02d-%02d", this.year, this.month, this.day));
        } else {
            s.append(String.format("%04d-%02d-%02dT%02d:%02d:%02d", this.year, this.month, this.day, this.hour, this.minute, this.second));
            if (this.nanosecond != 0) {
                s.append(String.format(".%09d", this.nanosecond));
            }
        }
        if (this.utc) {
            s.append('Z');
        }
        return s;
    }

    public Calendar toCalendar() {
        Calendar calendar = Calendar.getInstance(this.utc ? TimeZoneUtil.UTC : TimeZoneUtil.DefaultTZ);
        calendar.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        calendar.set(14, this.nanosecond / 1000000);
        return calendar;
    }

    public Timestamp toTimestamp() {
        Timestamp timestamp = new Timestamp(this.toCalendar().getTimeInMillis());
        timestamp.setNanos(this.nanosecond);
        return timestamp;
    }

    public java.sql.Date toDate() {
        return new java.sql.Date(this.toCalendar().getTimeInMillis());
    }

    public Time toTime() {
        return new Time(this.toCalendar().getTimeInMillis());
    }

    public Date toDateTime() {
        return new Date(this.toCalendar().getTimeInMillis());
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.toCalendar().getTimeInMillis());
    }

    public long toLong() {
        return this.toCalendar().getTimeInMillis();
    }
}

