/*
 * Decompiled with CFR 0.152.
 */
package hprose.common;

import hprose.common.FilterHandler;
import hprose.common.FilterHandlerManager;
import hprose.common.HproseContext;
import hprose.common.InvokeHandler;
import hprose.common.NextFilterHandler;
import hprose.common.NextInvokeHandler;
import hprose.util.concurrent.Func;
import hprose.util.concurrent.Promise;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class HandlerManager {
    private final ArrayList<InvokeHandler> invokeHandlers = new ArrayList();
    private final ArrayList<FilterHandler> beforeFilterHandlers = new ArrayList();
    private final ArrayList<FilterHandler> afterFilterHandlers = new ArrayList();
    private final NextInvokeHandler defaultInvokeHandler = new NextInvokeHandler(){

        @Override
        public Promise<Object> handle(String name, Object[] args, HproseContext context) {
            return HandlerManager.this.invokeHandler(name, args, context);
        }
    };
    private final NextFilterHandler defaultBeforeFilterHandler = new NextFilterHandler(){

        @Override
        public Promise<ByteBuffer> handle(ByteBuffer request, HproseContext context) {
            if (request.position() != 0) {
                request.flip();
            }
            return HandlerManager.this.beforeFilterHandler(request, context).then(new Func<ByteBuffer, ByteBuffer>(){

                @Override
                public ByteBuffer call(ByteBuffer response) throws Throwable {
                    if (response == null) {
                        return null;
                    }
                    if (response.position() != 0) {
                        response.flip();
                    }
                    return response;
                }
            });
        }
    };
    private final NextFilterHandler defaultAfterFilterHandler = new NextFilterHandler(){

        @Override
        public Promise<ByteBuffer> handle(ByteBuffer request, HproseContext context) {
            if (request.position() != 0) {
                request.flip();
            }
            return HandlerManager.this.afterFilterHandler(request, context).then(new Func<ByteBuffer, ByteBuffer>(){

                @Override
                public ByteBuffer call(ByteBuffer response) throws Throwable {
                    if (response == null) {
                        return null;
                    }
                    if (response.position() != 0) {
                        response.flip();
                    }
                    return response;
                }
            });
        }
    };
    protected NextInvokeHandler invokeHandler = this.defaultInvokeHandler;
    protected NextFilterHandler beforeFilterHandler = this.defaultBeforeFilterHandler;
    protected NextFilterHandler afterFilterHandler = this.defaultAfterFilterHandler;
    public final FilterHandlerManager beforeFilter = new FilterHandlerManager(){

        @Override
        public final FilterHandlerManager use(FilterHandler handler) {
            HandlerManager.this.addBeforeFilterHandler(handler);
            return this;
        }
    };
    public final FilterHandlerManager afterFilter = new FilterHandlerManager(){

        @Override
        public final FilterHandlerManager use(FilterHandler handler) {
            HandlerManager.this.addAfterFilterHandler(handler);
            return this;
        }
    };

    protected abstract Promise<Object> invokeHandler(String var1, Object[] var2, HproseContext var3);

    protected abstract Promise<ByteBuffer> beforeFilterHandler(ByteBuffer var1, HproseContext var2);

    protected abstract Promise<ByteBuffer> afterFilterHandler(ByteBuffer var1, HproseContext var2);

    private NextInvokeHandler getNextInvokeHandler(final NextInvokeHandler next, final InvokeHandler handler) {
        return new NextInvokeHandler(){

            @Override
            public Promise<Object> handle(String name, Object[] args, HproseContext context) {
                try {
                    return handler.handle(name, args, context, next);
                }
                catch (Throwable e) {
                    return Promise.error(e);
                }
            }
        };
    }

    private NextFilterHandler getNextFilterHandler(final NextFilterHandler next, final FilterHandler handler) {
        return new NextFilterHandler(){

            @Override
            public Promise<ByteBuffer> handle(ByteBuffer request, HproseContext context) {
                try {
                    if (request.position() != 0) {
                        request.flip();
                    }
                    return handler.handle(request, context, next).then(new Func<ByteBuffer, ByteBuffer>(){

                        @Override
                        public ByteBuffer call(ByteBuffer response) throws Throwable {
                            if (response == null) {
                                return null;
                            }
                            if (response.position() != 0) {
                                response.flip();
                            }
                            return response;
                        }
                    });
                }
                catch (Throwable e) {
                    return Promise.error(e);
                }
            }
        };
    }

    public final void addInvokeHandler(InvokeHandler handler) {
        if (handler == null) {
            return;
        }
        this.invokeHandlers.add(handler);
        NextInvokeHandler next = this.defaultInvokeHandler;
        for (int i = this.invokeHandlers.size() - 1; i >= 0; --i) {
            next = this.getNextInvokeHandler(next, this.invokeHandlers.get(i));
        }
        this.invokeHandler = next;
    }

    public final void addBeforeFilterHandler(FilterHandler handler) {
        if (handler == null) {
            return;
        }
        this.beforeFilterHandlers.add(handler);
        NextFilterHandler next = this.defaultBeforeFilterHandler;
        for (int i = this.beforeFilterHandlers.size() - 1; i >= 0; --i) {
            next = this.getNextFilterHandler(next, this.beforeFilterHandlers.get(i));
        }
        this.beforeFilterHandler = next;
    }

    public final void addAfterFilterHandler(FilterHandler handler) {
        if (handler == null) {
            return;
        }
        this.afterFilterHandlers.add(handler);
        NextFilterHandler next = this.defaultAfterFilterHandler;
        for (int i = this.afterFilterHandlers.size() - 1; i >= 0; --i) {
            next = this.getNextFilterHandler(next, this.afterFilterHandlers.get(i));
        }
        this.afterFilterHandler = next;
    }

    public final HandlerManager use(InvokeHandler handler) {
        this.addInvokeHandler(handler);
        return this;
    }
}

