/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HproseContext;
import hprose.common.HproseMethods;
import hprose.io.ByteBufferStream;
import hprose.server.HproseHttpMethods;
import hprose.server.HproseHttpServiceEvent;
import hprose.server.HproseService;
import hprose.server.HttpContext;
import hprose.server.ServiceContext;
import hprose.util.concurrent.Action;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HproseHttpService
extends HproseService {
    private boolean crossDomainEnabled = false;
    private boolean p3pEnabled = false;
    private boolean getEnabled = true;
    private int asyncTimeout = 300000;
    private final HashMap<String, Boolean> origins = new HashMap();
    private static final ThreadLocal<HttpContext> currentContext = new ThreadLocal();

    public static HttpContext getCurrentContext() {
        return currentContext.get();
    }

    @Override
    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseHttpMethods();
        }
        return this.globalMethods;
    }

    @Override
    public void setGlobalMethods(HproseMethods methods) {
        if (!(methods instanceof HproseHttpMethods)) {
            throw new ClassCastException("methods must be a HproseHttpMethods instance");
        }
        this.globalMethods = methods;
    }

    public boolean isCrossDomainEnabled() {
        return this.crossDomainEnabled;
    }

    public void setCrossDomainEnabled(boolean enabled) {
        this.crossDomainEnabled = enabled;
    }

    public boolean isP3pEnabled() {
        return this.p3pEnabled;
    }

    public void setP3pEnabled(boolean enabled) {
        this.p3pEnabled = enabled;
    }

    public boolean isGetEnabled() {
        return this.getEnabled;
    }

    public void setGetEnabled(boolean enabled) {
        this.getEnabled = enabled;
    }

    public int getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(int asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    public void addAccessControlAllowOrigin(String origin) {
        this.origins.put(origin, true);
    }

    public void removeAccessControlAllowOrigin(String origin) {
        this.origins.remove(origin);
    }

    @Override
    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, ServiceContext context) {
        int count = arguments.length;
        HttpContext httpContext = (HttpContext)context;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class) || argType.equals(ServiceContext.class)) {
                args[count] = context;
            } else if (argType.equals(HttpContext.class)) {
                args[count] = httpContext;
            } else if (argType.equals(HttpServletRequest.class)) {
                args[count] = httpContext.getRequest();
            } else if (argType.equals(HttpServletResponse.class)) {
                args[count] = httpContext.getResponse();
            } else if (argType.equals(HttpSession.class)) {
                args[count] = httpContext.getSession();
            } else if (argType.equals(ServletContext.class)) {
                args[count] = httpContext.getApplication();
            } else if (argType.equals(ServletConfig.class)) {
                args[count] = httpContext.getConfig();
            }
            return args;
        }
        return arguments;
    }

    protected void sendHeader(HttpContext httpContext) {
        if (this.event != null && HproseHttpServiceEvent.class.isInstance(this.event)) {
            ((HproseHttpServiceEvent)this.event).onSendHeader(httpContext);
        }
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        response.setContentType("text/plain");
        if (this.p3pEnabled) {
            response.setHeader("P3P", "CP=\"CAO DSP COR CUR ADM DEV TAI PSA PSD IVAi IVDi CONi TELo OTPi OUR DELi SAMi OTRi UNRi PUBi IND PHY ONL UNI PUR FIN COM NAV INT DEM CNT STA POL HEA PRE GOV\"");
        }
        if (this.crossDomainEnabled) {
            String origin = request.getHeader("Origin");
            if (origin != null && !origin.equals("null")) {
                if (this.origins.isEmpty() || this.origins.containsKey(origin)) {
                    response.setHeader("Access-Control-Allow-Origin", origin);
                    response.setHeader("Access-Control-Allow-Credentials", "true");
                }
            } else {
                response.setHeader("Access-Control-Allow-Origin", "*");
            }
        }
    }

    public void handle(HttpContext httpContext) {
        this.handle(httpContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpContext httpContext, HproseHttpMethods methods) {
        this.sendHeader(httpContext);
        String method = httpContext.getRequest().getMethod();
        if (method.equals("GET")) {
            if (this.getEnabled) {
                try (ByteBufferStream ostream = null;){
                    httpContext.setMethods(methods);
                    ostream = this.doFunctionList(httpContext);
                    httpContext.getResponse().setContentLength(ostream.available());
                    ostream.writeTo((OutputStream)httpContext.getResponse().getOutputStream());
                }
            } else {
                try {
                    httpContext.getResponse().sendError(403);
                }
                catch (IOException ex) {
                    this.fireErrorEvent(ex, httpContext);
                }
            }
        } else if (method.equals("POST")) {
            if (httpContext.getRequest().isAsyncSupported()) {
                this.asyncHandle(httpContext, methods);
            } else {
                this.syncHandle(httpContext, methods);
            }
        }
    }

    private void asyncHandle(final HttpContext httpContext, final HproseHttpMethods methods) {
        final AsyncContext async = httpContext.getRequest().startAsync();
        async.setTimeout((long)this.asyncTimeout);
        async.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent ae) throws IOException {
            }

            public void onTimeout(AsyncEvent ae) throws IOException {
                ((HttpServletResponse)ae.getSuppliedResponse()).sendError(408);
            }

            public void onError(AsyncEvent ae) throws IOException {
            }

            public void onStartAsync(AsyncEvent ae) throws IOException {
            }
        });
        async.start(new Runnable(){

            @Override
            public void run() {
                final ByteBufferStream istream = new ByteBufferStream();
                try {
                    istream.readFrom((InputStream)async.getRequest().getInputStream());
                }
                catch (Throwable e) {
                    HproseHttpService.this.fireErrorEvent(e, httpContext);
                    istream.close();
                    async.complete();
                    return;
                }
                currentContext.set(httpContext);
                HproseHttpService.this.handle(istream.buffer, methods, httpContext).then(new Action<ByteBuffer>(){

                    @Override
                    public void call(ByteBuffer value) throws Throwable {
                        try (ByteBufferStream ostream = new ByteBufferStream(value);){
                            async.getResponse().setContentLength(ostream.available());
                            ostream.writeTo((OutputStream)async.getResponse().getOutputStream());
                        }
                    }
                }).catchError(new Action<Throwable>(){

                    @Override
                    public void call(Throwable e) throws Throwable {
                        HproseHttpService.this.fireErrorEvent(e, httpContext);
                    }
                }).whenComplete(new Runnable(){

                    @Override
                    public void run() {
                        currentContext.remove();
                        istream.close();
                        async.complete();
                    }
                });
            }
        });
    }

    private void syncHandle(final HttpContext httpContext, HproseHttpMethods methods) {
        final ByteBufferStream istream = new ByteBufferStream();
        try {
            istream.readFrom((InputStream)httpContext.getRequest().getInputStream());
        }
        catch (Throwable e) {
            this.fireErrorEvent(e, httpContext);
            istream.close();
            return;
        }
        currentContext.set(httpContext);
        this.handle(istream.buffer, methods, httpContext).then(new Action<ByteBuffer>(){

            @Override
            public void call(ByteBuffer value) throws Throwable {
                try (ByteBufferStream ostream = new ByteBufferStream(value);){
                    httpContext.getResponse().setContentLength(ostream.available());
                    ostream.writeTo((OutputStream)httpContext.getResponse().getOutputStream());
                }
            }
        }).catchError(new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                HproseHttpService.this.fireErrorEvent(e, httpContext);
            }
        }).whenComplete(new Runnable(){

            @Override
            public void run() {
                currentContext.remove();
                istream.close();
            }
        });
    }
}

