/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0007\u001b\t)\")\u001f;f\u0005V4g-\u001a:J]B,Ho\u0015;sK\u0006l'BA\u0002\u0005\u0003\u0015AG\u000f\u001e93\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003\u0015\u0011G.\u0019>f\u0015\tI!\"\u0001\u0004iiR\u0004Hg\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\t!![8\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u0019\u0011WO\u001a4feB\u0011\u0011\u0004H\u0007\u00025)\u00111DE\u0001\u0004]&|\u0017BA\u000f\u001b\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001a\u0003C\u0001\u0012\u0001\u001b\u0005\u0011\u0001\"B\f\u001f\u0001\u0004A\u0002BB\u0013\u0001A\u0003&a%\u0001\u0005nCJ\\7+\u001b>f!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\rIe\u000e\u001e\u0005\u0006[\u0001!\tEL\u0001\u0005e\u0016\fG\rF\u0001'\u0011\u0015i\u0003\u0001\"\u00111)\u00111\u0013'O\u001e\t\u000bIz\u0003\u0019A\u001a\u0002\u0003\t\u00042a\n\u001b7\u0013\t)\u0004FA\u0003BeJ\f\u0017\u0010\u0005\u0002(o%\u0011\u0001\b\u000b\u0002\u0005\u0005f$X\rC\u0003;_\u0001\u0007a%A\u0002pM\u001aDQ\u0001P\u0018A\u0002\u0019\n1\u0001\\3o\u0011\u0015q\u0004\u0001\"\u0011/\u0003%\tg/Y5mC\ndW\rC\u0003A\u0001\u0011\u0005\u0013)\u0001\u0003nCJ\\GC\u0001\"F!\t93)\u0003\u0002EQ\t!QK\\5u\u0011\u00151u\b1\u0001'\u0003%\u0011X-\u00193mS6LG\u000fC\u0003I\u0001\u0011\u0005\u0013*A\u0003sKN,G\u000fF\u0001C\u0011\u0015Y\u0005\u0001\"\u0011M\u00035i\u0017M]6TkB\u0004xN\u001d;fIR\tQ\n\u0005\u0002(\u001d&\u0011q\n\u000b\u0002\b\u0005>|G.Z1o\u0001")
public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private int markSize;

    @Override
    public int read() {
        int n;
        if (this.buffer.hasRemaining()) {
            --this.markSize;
            n = this.buffer.get() & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int n;
        if (this.buffer.hasRemaining()) {
            int readSize = package$.MODULE$.min(len, this.buffer.remaining());
            this.markSize -= readSize;
            this.buffer.get(b, off, readSize);
            n = readSize;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this.markSize = readlimit;
        this.buffer.mark();
    }

    @Override
    public void reset() {
        if (this.markSize >= 0) {
            this.markSize = -1;
            this.buffer.reset();
            return;
        }
        throw new IOException("Invalid mark");
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.markSize = -1;
    }
}

