/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.HeaderEncoder;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.util.BufferTools$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\r5\u0011AB\u0012:b[\u0016,enY8eKJT!a\u0001\u0003\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000b\td\u0017M_3\u000b\u0005%Q\u0011A\u00025uiB$4OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005q!/Z7pi\u0016\u001cV\r\u001e;j]\u001e\u001c\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00055AE\u000f\u001e93'\u0016$H/\u001b8hg\"A1\u0004\u0001B\u0001B\u0003%A$A\u0007iK\u0006$WM]#oG>$WM\u001d\t\u0003/uI!A\b\u0002\u0003\u001b!+\u0017\rZ3s\u000b:\u001cw\u000eZ3s\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\u0019!e\t\u0013\u0011\u0005]\u0001\u0001\"B\u000b \u0001\u00041\u0002\"B\u000e \u0001\u0004a\u0002B\u0002\u0014\u0001A\u0013%q%\u0001\u0007nCb4%/Y7f'&TX-F\u0001)!\ty\u0011&\u0003\u0002+!\t\u0019\u0011J\u001c;\t\u000b1\u0002A\u0011A\u0017\u0002\u001fM,G/T1y)\u0006\u0014G.Z*ju\u0016$\"AL\u0019\u0011\u0005=y\u0013B\u0001\u0019\u0011\u0005\u0011)f.\u001b;\t\u000bIZ\u0003\u0019\u0001\u0015\u0002\tML'0\u001a\u0005\u0006i\u0001!\t!N\u0001\u0014g\u0016\u001c8/[8o/&tGm\\<Va\u0012\fG/\u001a\u000b\u0003my\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u00079LwNC\u0001<\u0003\u0011Q\u0017M^1\n\u0005uB$A\u0003\"zi\u0016\u0014UO\u001a4fe\")!g\ra\u0001Q!)\u0001\t\u0001C\u0001\u0003\u0006\u00112\u000f\u001e:fC6<\u0016N\u001c3poV\u0003H-\u0019;f)\r1$\t\u0012\u0005\u0006\u0007~\u0002\r\u0001K\u0001\tgR\u0014X-Y7JI\")!g\u0010a\u0001Q!)a\t\u0001C\u0001\u000f\u0006I\u0001/\u001b8h\rJ\fW.\u001a\u000b\u0003m!CQ!S#A\u0002)\u000bA\u0001Z1uCB\u0019qbS'\n\u00051\u0003\"!B!se\u0006L\bCA\bO\u0013\ty\u0005C\u0001\u0003CsR,\u0007\"B)\u0001\t\u0003\u0011\u0016a\u00029j]\u001e\f5m\u001b\u000b\u0003mMCQ!\u0013)A\u0002)CQ!\u0016\u0001\u0005\u0002Y\u000b\u0001B]:u\rJ\fW.\u001a\u000b\u0004m]C\u0006\"B\"U\u0001\u0004A\u0003\"B-U\u0001\u0004Q\u0016!C3se>\u00148i\u001c3f!\ty1,\u0003\u0002]!\t!Aj\u001c8h\u0011\u0015q\u0006\u0001\"\u0001`\u0003%!\u0017\r^1Ge\u0006lW\r\u0006\u0003aM\u001ed\u0007cA1em5\t!M\u0003\u0002d!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0014'aA*fc\")1)\u0018a\u0001Q!)\u0001.\u0018a\u0001S\u0006IQM\u001c3TiJ,\u0017-\u001c\t\u0003\u001f)L!a\u001b\t\u0003\u000f\t{w\u000e\\3b]\")\u0011*\u0018a\u0001m!)a\u000e\u0001C\u0001_\u0006Y\u0001.Z1eKJ4%/Y7f)\u0015\u0001\u0007/\u001d<x\u0011\u0015\u0019U\u000e1\u0001)\u0011\u0015\u0011X\u000e1\u0001t\u0003!\u0001(/[8sSRL\bCA\fu\u0013\t)(A\u0001\u0005Qe&|'/\u001b;z\u0011\u0015AW\u000e1\u0001j\u0011\u0015AX\u000e1\u0001z\u0003\u001dAW-\u00193feN\u0004\"A\u001f@\u000f\u0005mdX\"\u0001\u0003\n\u0005u$\u0011a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!a\u0002%fC\u0012,'o\u001d\u0006\u0003{\u0012\u0001")
public final class FrameEncoder {
    private final Http2Settings remoteSettings;
    private final HeaderEncoder headerEncoder;

    private int maxFrameSize() {
        return this.remoteSettings.maxFrameSize();
    }

    public void setMaxTableSize(int size) {
        this.headerEncoder.maxTableSize(size);
    }

    public ByteBuffer sessionWindowUpdate(int size) {
        return this.streamWindowUpdate(0, size);
    }

    public ByteBuffer streamWindowUpdate(int streamId, int size) {
        return FrameSerializer$.MODULE$.mkWindowUpdateFrame(streamId, size);
    }

    public ByteBuffer pingFrame(byte[] data) {
        return FrameSerializer$.MODULE$.mkPingFrame(false, data);
    }

    public ByteBuffer pingAck(byte[] data) {
        return FrameSerializer$.MODULE$.mkPingFrame(true, data);
    }

    public ByteBuffer rstFrame(int streamId, long errorCode) {
        return FrameSerializer$.MODULE$.mkRstStreamFrame(streamId, errorCode);
    }

    public Seq<ByteBuffer> dataFrame(int streamId, boolean endStream, ByteBuffer data) {
        ArrayBuffer arrayBuffer;
        int limit = this.maxFrameSize();
        if (data.remaining() <= limit) {
            arrayBuffer = FrameSerializer$.MODULE$.mkDataFrame(streamId, endStream, 0, data);
        } else {
            ArrayBuffer acc = new ArrayBuffer();
            while (data.hasRemaining()) {
                ByteBuffer thisData = BufferTools$.MODULE$.takeSlice(data, package$.MODULE$.min(data.remaining(), limit));
                boolean eos = endStream && !data.hasRemaining();
                acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkDataFrame(streamId, eos, 0, thisData));
            }
            arrayBuffer = acc;
        }
        return arrayBuffer;
    }

    public Seq<ByteBuffer> headerFrame(int streamId, Priority priority, boolean endStream, Seq<Tuple2<String, String>> headers) {
        ArrayBuffer arrayBuffer;
        int headersPrioritySize;
        ByteBuffer rawHeaders = this.headerEncoder.encodeHeaders(headers);
        int limit = this.maxFrameSize();
        int n = headersPrioritySize = priority.isDefined() ? 5 : 0;
        if (rawHeaders.remaining() + headersPrioritySize <= limit) {
            arrayBuffer = FrameSerializer$.MODULE$.mkHeaderFrame(streamId, priority, true, endStream, 0, rawHeaders);
        } else {
            ArrayBuffer acc = new ArrayBuffer();
            ByteBuffer headersBuf = BufferTools$.MODULE$.takeSlice(rawHeaders, limit - headersPrioritySize);
            acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkHeaderFrame(streamId, priority, false, endStream, 0, headersBuf));
            while (rawHeaders.hasRemaining()) {
                int size = package$.MODULE$.min(limit, rawHeaders.remaining());
                ByteBuffer continueBuf = BufferTools$.MODULE$.takeSlice(rawHeaders, size);
                boolean endHeaders = !rawHeaders.hasRemaining();
                acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkContinuationFrame(streamId, endHeaders, continueBuf));
            }
            arrayBuffer = acc;
        }
        return arrayBuffer;
    }

    public FrameEncoder(Http2Settings remoteSettings, HeaderEncoder headerEncoder) {
        this.remoteSettings = remoteSettings;
        this.headerEncoder = headerEncoder;
    }
}

