/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings$;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;
import scala.util.Right$;

public final class SettingsDecoder$ {
    public static final SettingsDecoder$ MODULE$;

    static {
        new SettingsDecoder$();
    }

    public Either<Http2Exception, SettingsDecoder.SettingsFrame> decodeSettingsFrame(ByteBuffer buffer) {
        Either<Http2Exception, SettingsDecoder.SettingsFrame> either;
        int len = FrameDecoder$.MODULE$.getLengthField(buffer);
        Predef$.MODULE$.assert(len + bits$.MODULE$.HeaderSize() - bits$.MODULE$.LengthFieldSize() == buffer.remaining());
        byte tpe = buffer.get();
        if (tpe != bits$FrameTypes$.MODULE$.SETTINGS()) {
            either = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Expected SETTINGS frame"));
        } else {
            byte flags = buffer.get();
            int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
            either = this.decodeSettingsFrame(buffer, streamId, flags);
        }
        return either;
    }

    public Either<Http2Exception, SettingsDecoder.SettingsFrame> decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        Right right;
        int len = buffer.remaining();
        boolean isAck = bits$Flags$.MODULE$.ACK(flags);
        if (len % 6 != 0) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS frame payload must be multiple of 6 bytes, size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)len)}));
            right = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else if (isAck && len != 0) {
            int settingsCount = len / 6;
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS ACK frame with settings payload (", " settings)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)settingsCount)}));
            right = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else if (streamId != 0) {
            right = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS frame with invalid stream id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)streamId)}))));
        } else {
            SettingsDecoder.SettingsFrame settingsFrame;
            Right$ right$ = package$.MODULE$.Right();
            if (isAck) {
                settingsFrame = new SettingsDecoder.SettingsFrame((Option<Seq<Http2Settings.Setting>>)None$.MODULE$);
            } else {
                Builder settings = package$.MODULE$.Vector().newBuilder();
                while (buffer.hasRemaining()) {
                    int id = buffer.getShort() & 0xFFFF;
                    int value = buffer.getInt();
                    settings.$plus$eq((Object)new Http2Settings.Setting(id, value));
                }
                settingsFrame = new SettingsDecoder.SettingsFrame((Option<Seq<Http2Settings.Setting>>)new Some(settings.result()));
            }
            right = right$.apply((Object)settingsFrame);
        }
        return right;
    }

    public Either<Http2Exception, MutableHttp2Settings> settingsFromFrame(Seq<Http2Settings.Setting> settings) {
        Option<Http2Exception> option;
        block4: {
            Right right;
            block3: {
                block2: {
                    MutableHttp2Settings next = MutableHttp2Settings$.MODULE$.default();
                    option = next.updateSettings(settings);
                    if (!None$.MODULE$.equals(option)) break block2;
                    right = package$.MODULE$.Right().apply((Object)next);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Http2Exception ex = (Http2Exception)some.x();
                right = package$.MODULE$.Left().apply((Object)ex);
            }
            return right;
        }
        throw new MatchError(option);
    }

    private SettingsDecoder$() {
        MODULE$ = this;
    }
}

