/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.syntax.GenTemporalOps_$;
import cats.effect.std.Dispatcher;
import cats.effect.syntax.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers$;
import org.http4s.HttpVersion$;
import org.http4s.InvalidBodyException;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.http2.DataFrame;
import org.http4s.blaze.http.http2.HeadersFrame;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.PseudoHeaders$;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.util.Http2Writer;
import org.http4s.headers.Connection$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.package$;
import org.slf4j.Logger;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\r\u001a\t\tB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AQ\t\u0001BC\u0002\u0013-a\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0013\u0005\r\u0001A!A!\u0002\u0013i\u0004BCA\u0003\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u00111\u0003\u0001\u0003\u0002\u0003\u0006I!!\u0006\t\u0015\u0005%\u0002A!A!\u0002\u0017\tY\u0003C\u0004\u0002@\u0001!\t!!\u0011\t\u0011\u0005}\u0003\u0001)A\u0005\u0003CBq!!\u001e\u0001\t\u0003\n9\bC\u0004\u0002\n\u0002!\t&a#\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\f\"9\u0011Q\u0013\u0001\u0005\n\u0005-\u0005\u0002CAL\u0001\u0001\u0006I!!'\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBAn\u0001\u0011%\u0011Q\u001c\u0005\t\u0003G\u0004\u0001\u0015!\u0003\u0002b\tq\u0001\n\u001e;qe9{G-Z*uC\u001e,'B\u0001\u000e\u001c\u0003\u0019\u0019XM\u001d<fe*\u0011A$H\u0001\u0006E2\f'0\u001a\u0006\u0003=}\ta\u0001\u001b;uaR\u001a(\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005\r\u001a7c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u00042a\u000b\u00181\u001b\u0005a#BA\u0017\u001c\u0003!\u0001\u0018\u000e]3mS:,\u0017BA\u0018-\u0005%!\u0016-\u001b7Ti\u0006<W\r\u0005\u00022m5\t!G\u0003\u00024i\u0005)\u0001\u000e\u001e;qe)\u0011QgG\u0001\u0005QR$\b/\u0003\u00028e\tY1\u000b\u001e:fC64%/Y7f\u0003!\u0019HO]3b[&#\u0007CA\u0013;\u0013\tYdEA\u0002J]R\fq\u0001^5nK>,H\u000f\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006AA-\u001e:bi&|gN\u0003\u0002CM\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0011{$\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A$\u0011\u0005!KU\"A!\n\u0005)\u000b%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000fI\u0001\u000bCR$(/\u001b2vi\u0016\u001c\bcA\u0013O!&\u0011qJ\n\u0002\n\rVt7\r^5p]B\u0002\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u000bY\fW\u000f\u001c;\u000b\u0005U{\u0012!\u0003;za\u0016dWM^3m\u0013\t9&KA\u0003WCVdG/A\u0004iiR\u0004\u0018\t\u001d9\u0011\u0007is\u0016M\u0004\u0002\\96\tQ$\u0003\u0002^;\u00059\u0001/Y2lC\u001e,\u0017BA0a\u0005\u001dAE\u000f\u001e9BaBT!!X\u000f\u0011\u0005\t\u001cG\u0002\u0001\u0003\u0006I\u0002\u0011\r!\u001a\u0002\u0002\rV\u0011a-\\\t\u0003O*\u0004\"!\n5\n\u0005%4#a\u0002(pi\"Lgn\u001a\t\u0003K-L!\u0001\u001c\u0014\u0003\u0007\u0005s\u0017\u0010B\u0003oG\n\u0007aM\u0001\u0003`I\u0011\n\u0014aE:feZL7-Z#se>\u0014\b*\u00198eY\u0016\u0014\bcA9~C:\u0011!o\u001f\b\u0003gjt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]\f\u0013A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u001b;%\u0011Q\f \u0006\u00035uI!A`@\u0003'M+'O^5dK\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\u0005uc\u0018!\u0006:fgB|gn]3IK\u0006$WM\u001d+j[\u0016|W\u000f^\u0001\fS\u0012dW\rV5nK>,H/A\u0005tG\",G-\u001e7feB!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000em\tA!\u001e;jY&!\u0011\u0011CA\u0006\u0005E!\u0016nY6XQ\u0016,G.\u0012=fGV$xN]\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014\b#BA\f\u0003K\tWBAA\r\u0015\u0011\tY\"!\b\u0002\u0007M$HM\u0003\u0003\u0002 \u0005\u0005\u0012AB3gM\u0016\u001cGO\u0003\u0002\u0002$\u0005!1-\u0019;t\u0013\u0011\t9#!\u0007\u0003\u0015\u0011K7\u000f]1uG\",'/A\u0001G!\u0015\ti#!\u000fb\u001d\u0011\ty#a\u000e\u000f\t\u0005E\u0012Q\u0007\b\u0004k\u0006M\u0012BAA\u0012\u0013\u0011\ty\"!\t\n\u0007u\u000bi\"\u0003\u0003\u0002<\u0005u\"!B!ts:\u001c'bA/\u0002\u001e\u00051A(\u001b8jiz\"b#a\u0011\u0002L\u00055\u0013qJA)\u0003'\n)&a\u0016\u0002Z\u0005m\u0013Q\f\u000b\u0005\u0003\u000b\nI\u0005\u0005\u0003\u0002H\u0001\tW\"A\r\t\u000f\u0005%R\u0002q\u0001\u0002,!)\u0001(\u0004a\u0001s!)A(\u0004a\u0001{!)Q)\u0004a\u0002\u000f\")A*\u0004a\u0001\u001b\")\u0001,\u0004a\u00013\")q.\u0004a\u0001a\"1\u0011\u0011A\u0007A\u0002uBa!a\u0001\u000e\u0001\u0004i\u0004bBA\u0003\u001b\u0001\u0007\u0011q\u0001\u0005\b\u0003'i\u0001\u0019AA\u000b\u0003\u0019\u0011XO\\!qaB9Q%a\u0019\u0002h\u00055\u0014bAA3M\tIa)\u001e8di&|g.\r\t\u00057\u0006%\u0014-C\u0002\u0002lu\u0011qAU3rk\u0016\u001cH\u000f\u0005\u0003cG\u0006=\u0004\u0003B.\u0002r\u0005L1!a\u001d\u001e\u0005!\u0011Vm\u001d9p]N,\u0017\u0001\u00028b[\u0016,\"!!\u001f\u0011\t\u0005m\u00141\u0011\b\u0005\u0003{\ny\b\u0005\u0002vM%\u0019\u0011\u0011\u0011\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\t))a\"\u0003\rM#(/\u001b8h\u0015\r\t\tIJ\u0001\rgR\fw-Z*uCJ$X\u000f\u001d\u000b\u0003\u0003\u001b\u00032!JAH\u0013\r\t\tJ\n\u0002\u0005+:LG/A\bj]&$\u0018\n\u001a7f)&lWm\\;u\u0003-\u0011X-\u00193IK\u0006$WM]:\u0002%MDW\u000f\u001e3po:\u001cF/Y4f)>\\WM\u001c\t\u0006K\u0005m\u0015qT\u0005\u0004\u0003;3#\u0001B*p[\u0016\u0004BAY2\u0002\u000e\u00069q-\u001a;C_\u0012LH\u0003BAS\u0003W\u0003BAWATC&\u0019\u0011\u0011\u00161\u0003\u0015\u0015sG/\u001b;z\u0005>$\u0017\u0010C\u0004\u0002.R\u0001\r!a,\u0002\r5\f\u0007\u0010\\3o!\r)\u0013\u0011W\u0005\u0004\u0003g3#\u0001\u0002'p]\u001e\f!c\u00195fG.\fe\u000e\u001a*v]J+\u0017/^3tiR1\u0011QRA]\u0003#Dq!a/\u0016\u0001\u0004\ti,\u0001\u0002igB!\u0011qXAf\u001d\u0011\t\t-!3\u000f\t\u0005\r\u0017q\u0019\b\u0004g\u0006\u0015\u0017B\u0001\u000f\u001e\u0013\t)4$\u0003\u0002^i%!\u0011QZAh\u0005\u001dAU-\u00193feNT!!\u0018\u001b\t\u000f\u0005MW\u00031\u0001\u0002V\u0006IQM\u001c3TiJ,\u0017-\u001c\t\u0004K\u0005]\u0017bAAmM\t9!i\\8mK\u0006t\u0017A\u0004:f]\u0012,'OU3ta>t7/\u001a\u000b\u0005\u0003?\u000by\u000eC\u0004\u0002bZ\u0001\r!a\u001c\u0002\tI,7\u000f]\u0001\fe\u0006\u001cW\rV5nK>,H\u000f")
public class Http2NodeStage<F>
implements TailStage<StreamFrame> {
    private final int streamId;
    private final Duration timeout;
    private final ExecutionContext executionContext;
    private final Function0<Vault> attributes;
    public final Function1<Request<F>, PartialFunction<Throwable, F>> org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler;
    private final Duration idleTimeout;
    private final TickWheelExecutor scheduler;
    public final Dispatcher<F> org$http4s$blaze$server$Http2NodeStage$$dispatcher;
    public final Async<F> org$http4s$blaze$server$Http2NodeStage$$F;
    private final Function1<Request<F>, F> runApp;
    private final Some<F> shutdownStageToken;
    public final Function1<Request<F>, F> org$http4s$blaze$server$Http2NodeStage$$raceTimeout;
    private Head<StreamFrame> _prevStage;
    private Logger logger;

    public final void closePipeline(Option<Throwable> cause) {
        Tail.closePipeline$((Tail)this, cause);
    }

    public Future<StreamFrame> channelRead(int size, Duration timeout) {
        return Tail.channelRead$((Tail)this, (int)size, (Duration)timeout);
    }

    public int channelRead$default$1() {
        return Tail.channelRead$default$1$((Tail)this);
    }

    public Duration channelRead$default$2() {
        return Tail.channelRead$default$2$((Tail)this);
    }

    public Future channelWrite(Object data) {
        return Tail.channelWrite$((Tail)this, (Object)data);
    }

    public final Future channelWrite(Object data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, (Object)data, (Duration)timeout);
    }

    public Future<BoxedUnit> channelWrite(Seq<StreamFrame> data) {
        return Tail.channelWrite$((Tail)this, data);
    }

    public final Future<BoxedUnit> channelWrite(Seq<StreamFrame> data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, data, (Duration)timeout);
    }

    public final void spliceBefore(MidStage<StreamFrame, StreamFrame> stage) {
        Tail.spliceBefore$((Tail)this, stage);
    }

    public final Option<Stage> findOutboundStage(String name) {
        return Tail.findOutboundStage$((Tail)this, (String)name);
    }

    public final <C extends Stage> Option<C> findOutboundStage(Class<C> clazz) {
        return Tail.findOutboundStage$((Tail)this, clazz);
    }

    public final Tail<StreamFrame> replaceTail(LeafBuilder<StreamFrame> leafBuilder, boolean startup) {
        return Tail.replaceTail$((Tail)this, leafBuilder, (boolean)startup);
    }

    public void stageShutdown() {
        Stage.stageShutdown$((Stage)this);
    }

    public void inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$((Stage)this, (Command.InboundCommand)cmd);
    }

    public Head<StreamFrame> _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head<StreamFrame> x$1) {
        this._prevStage = x$1;
    }

    public final Logger logger() {
        return this.logger;
    }

    public final void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    public String name() {
        return "Http2NodeStage";
    }

    public void stageStartup() {
        Stage.stageStartup$((Stage)this);
        this.initIdleTimeout();
        this.readHeaders();
    }

    private void initIdleTimeout() {
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            Function1 & Serializable cb = (Function1 & Serializable)x0$1 -> {
                Http2NodeStage.$anonfun$initIdleTimeout$1(this, x0$1);
                return BoxedUnit.UNIT;
            };
            IdleTimeoutStage stage = new IdleTimeoutStage(finiteDuration, this.scheduler, this.executionContext());
            this.spliceBefore((MidStage<StreamFrame, StreamFrame>)stage);
            stage.init((Function1)cb);
            return;
        }
    }

    private void readHeaders() {
        Duration x$1 = this.timeout;
        int x$2 = this.channelRead$default$1();
        this.channelRead(x$2, x$1).onComplete((Function1 & Serializable)x0$1 -> {
            Http2NodeStage.$anonfun$readHeaders$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
    }

    private Stream<F, Object> getBody(long maxlen) {
        BooleanRef complete = BooleanRef.create((boolean)false);
        LongRef bytesRead = LongRef.create((long)0L);
        Object t = this.org$http4s$blaze$server$Http2NodeStage$$F.async((Function1 & Serializable)cb -> $this.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0 & Serializable)() -> {
            Object object;
            if (complete$1.elem) {
                object = cb.apply((Object)org.http4s.blazecore.util.package$.MODULE$.End());
            } else {
                Duration x$1 = $this.timeout;
                int x$2 = this.channelRead$default$1();
                this.channelRead(x$2, x$1).onComplete((Function1 & Serializable)x0$1 -> {
                    Http2NodeStage.$anonfun$getBody$3(this, complete, bytesRead, maxlen, cb, x0$1);
                    return BoxedUnit.UNIT;
                }, this.executionContext());
                object = BoxedUnit.UNIT;
            }
            return $this.shutdownStageToken;
        }));
        return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.repeatEval(t))).flatMap((Function1 & Serializable)x$1 -> Stream$.MODULE$.chunk(x$1), NotGiven$.MODULE$.default());
    }

    private void checkAndRunRequest(Seq<Tuple2<String, String>> hs, boolean endStream) {
        ListBuffer headers = new ListBuffer();
        ObjectRef method = ObjectRef.create(null);
        ObjectRef scheme = ObjectRef.create(null);
        ObjectRef path = ObjectRef.create(null);
        LongRef contentLength = LongRef.create((long)-1L);
        ObjectRef error = ObjectRef.create((Object)"");
        BooleanRef pseudoDone = BooleanRef.create((boolean)false);
        hs.foreach((Function1 & Serializable)x0$1 -> {
            String k;
            String k2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string2 = PseudoHeaders$.MODULE$.Method();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    if ((Method)method$1.elem == null) {
                        Either either = Method$.MODULE$.fromString(v);
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            Method m = (Method)right.value();
                            method$1.elem = m;
                        } else if (either instanceof Left) {
                            Left left = (Left)either;
                            ParseFailure e = (ParseFailure)left.value();
                            error$1.elem = new StringBuilder(18).append((String)error$1.elem).append(" Invalid method: ").append(e).append(" ").toString();
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return BoxedUnit.UNIT;
                    }
                    error$1.elem = new StringBuilder(36).append((String)error$1.elem).append("Multiple ':method' headers defined. ").toString();
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string4 = PseudoHeaders$.MODULE$.Scheme();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    if ((String)scheme$1.elem == null) {
                        scheme$1.elem = v;
                        return BoxedUnit.UNIT;
                    }
                    error$1.elem = new StringBuilder(36).append((String)error$1.elem).append("Multiple ':scheme' headers defined. ").toString();
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string6 = PseudoHeaders$.MODULE$.Path();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    if ((Uri)path$1.elem == null) {
                        Either either = Uri$.MODULE$.requestTarget(v);
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            Uri p = (Uri)right.value();
                            path$1.elem = p;
                        } else if (either instanceof Left) {
                            Left left = (Left)either;
                            ParseFailure e = (ParseFailure)left.value();
                            error$1.elem = new StringBuilder(15).append((String)error$1.elem).append(" Invalid path: ").append(e).toString();
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return BoxedUnit.UNIT;
                    }
                    error$1.elem = new StringBuilder(34).append((String)error$1.elem).append("Multiple ':path' headers defined. ").toString();
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string8 = PseudoHeaders$.MODULE$.Authority();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null && (k2 = (String)tuple2._1()).startsWith(":")) {
                error$1.elem = new StringBuilder(25).append((String)error$1.elem).append("Invalid pseudo header: ").append(tuple2).append(". ").toString();
                return BoxedUnit.UNIT;
            }
            if (tuple2 != null && !HeaderNames$.MODULE$.validH2HeaderKey(k = (String)tuple2._1())) {
                error$1.elem = new StringBuilder(22).append((String)error$1.elem).append("Invalid header key: ").append(k).append(". ").toString();
                return BoxedUnit.UNIT;
            }
            pseudoDone$1.elem = true;
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                String string = (String)tuple22._1();
                String string10 = HeaderNames$.MODULE$.Connection();
                String string11 = string;
                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                    error$1.elem = new StringBuilder(46).append((String)error$1.elem).append("HTTP/2 forbids connection specific headers: ").append(tuple22).append(". ").toString();
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple22 != null) {
                String string = (String)tuple22._1();
                String v = (String)tuple22._2();
                String string12 = HeaderNames$.MODULE$.ContentLength();
                String string13 = string;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    if (contentLength$1.elem < 0L) {
                        BoxedUnit boxedUnit;
                        try {
                            long sz = Long.parseLong(v);
                            if (sz != 0L && endStream) {
                                error$1.elem = new StringBuilder(44).append((String)error$1.elem).append("Nonzero content length (").append(sz).append(") for end of stream.").toString();
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (sz < 0L) {
                                error$1.elem = new StringBuilder(25).append((String)error$1.elem).append("Negative content length: ").append(sz).toString();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                contentLength$1.elem = sz;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            error$1.elem = new StringBuilder(26).append((String)error$1.elem).append("Invalid content-length: ").append(v).append(". ").toString();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    error$1.elem = new StringBuilder(40).append((String)error$1.elem).append("Received multiple content-length headers").toString();
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple22 != null) {
                String string = (String)tuple22._1();
                String v = (String)tuple22._2();
                String string14 = HeaderNames$.MODULE$.TE();
                String string15 = string;
                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                    if (!v.equalsIgnoreCase("trailers")) {
                        error$1.elem = new StringBuilder(55).append((String)error$1.elem).append("HTTP/2 forbids TE header values other than 'trailers'. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple22 != null) {
                String k3 = (String)tuple22._1();
                String v = (String)tuple22._2();
                return headers.$plus$eq((Object)Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k3), (Object)v)));
            }
            throw new MatchError((Object)tuple22);
        });
        if ((Method)method.elem == null || (String)scheme.elem == null || (Uri)path.elem == null) {
            error.elem = new StringBuilder(69).append((String)error.elem).append("Invalid request: missing pseudo headers. Method: ").append((Method)method.elem).append(", Scheme: ").append((String)scheme.elem).append(", path: ").append((Uri)path.elem).append(". ").toString();
        }
        if (((String)error.elem).length() > 0) {
            this.closePipeline((Option<Throwable>)new Some((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, (String)error.elem)));
            return;
        }
        Stream<F, Object> body = endStream ? package$.MODULE$.EmptyBody() : this.getBody(contentLength.elem);
        List hs2 = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers.result(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.identityToRaw(h))}));
        Request req = Request$.MODULE$.apply((Method)method.elem, (Uri)path.elem, HttpVersion$.MODULE$.HTTP$div2(), hs2, body, (Vault)this.attributes.apply());
        this.executionContext().execute(new Runnable(this, req){
            private final /* synthetic */ Http2NodeStage $outer;
            private final Request req$1;

            public void run() {
                Object action = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.defer((Function0 & Serializable)() -> $this.$outer.org$http4s$blaze$server$Http2NodeStage$$raceTimeout.apply((Object)$this.req$1)), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), (PartialFunction)this.$outer.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler.apply((Object)this.req$1), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)x$2 -> $this.$outer.org$http4s$blaze$server$Http2NodeStage$$renderResponse(x$2));
                Object fa = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(action, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Right) {
                        return $this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.unit();
                    }
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable t = (Throwable)left.value();
                        return ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError($this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                            if ($this.$outer.logger().isErrorEnabled()) {
                                $this.$outer.logger().error(new StringBuilder(23).append("Error running request: ").append($this.req$1).toString(), t);
                                return;
                            }
                        }), $this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), $this.$outer.org$http4s$blaze$server$Http2NodeStage$$F)), $this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.$outer.closePipeline((Option<Throwable>)None$.MODULE$)), $this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                    }
                    throw new MatchError((Object)either);
                });
                this.$outer.org$http4s$blaze$server$Http2NodeStage$$dispatcher.unsafeRunSync(fa);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.req$1 = req$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.http4s.blaze.server.Http2NodeStage$$anon$1 ), $anonfun$run$2(org.http4s.blaze.server.Http2NodeStage$$anon$1 org.http4s.Response ), $anonfun$run$3(org.http4s.blaze.server.Http2NodeStage$$anon$1 scala.util.Either ), $anonfun$run$4(org.http4s.blaze.server.Http2NodeStage$$anon$1 java.lang.Throwable ), $anonfun$run$5(org.http4s.blaze.server.Http2NodeStage$$anon$1 )}, serializedLambda);
            }
        });
    }

    public F org$http4s$blaze$server$Http2NodeStage$$renderResponse(Response<F> resp) {
        ArrayBuffer hs = new ArrayBuffer(16);
        hs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PseudoHeaders$.MODULE$.Status()), (Object)Integer.toString(resp.status().code())));
        Headers$.MODULE$.foreach$extension(resp.headers(), (Function1 & Serializable)h -> {
            Http2NodeStage.$anonfun$renderResponse$1(hs, h);
            return BoxedUnit.UNIT;
        });
        return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(new Http2Writer((TailStage)this, (Seq)hs, this.org$http4s$blaze$server$Http2NodeStage$$F).writeEntityBody(resp.body()), this.org$http4s$blaze$server$Http2NodeStage$$F), this.org$http4s$blaze$server$Http2NodeStage$$F), this.org$http4s$blaze$server$Http2NodeStage$$F).map((Function1 & Serializable)x0$1 -> {
            Http2NodeStage.$anonfun$renderResponse$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$initIdleTimeout$1(Http2NodeStage $this, Either x0$1) {
        Either either = x0$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            $this.logger().error("Error in idle timeout callback", t);
            $this.closePipeline((Option<Throwable>)new Some((Object)t));
            return;
        }
        if (either instanceof Right) {
            $this.logger().debug("Shutting down due to idle timeout");
            $this.closePipeline((Option<Throwable>)None$.MODULE$);
            return;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$readHeaders$1(Http2NodeStage $this, Try x0$1) {
        boolean bl = false;
        Success success = null;
        boolean bl2 = false;
        Failure failure = null;
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            StreamFrame streamFrame = (StreamFrame)success.value();
            if (streamFrame instanceof HeadersFrame) {
                HeadersFrame headersFrame = (HeadersFrame)streamFrame;
                boolean endStream = headersFrame.endStream();
                Seq hs = headersFrame.headers();
                $this.checkAndRunRequest((Seq<Tuple2<String, String>>)hs, endStream);
                return;
            }
        }
        if (bl) {
            StreamFrame frame = (StreamFrame)success.value();
            Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst($this.streamId, new StringBuilder(24).append("Received invalid frame: ").append(frame).toString());
            $this.closePipeline((Option<Throwable>)new Some((Object)e));
            return;
        }
        if (try_ instanceof Failure) {
            bl2 = true;
            failure = (Failure)try_;
            Throwable throwable = failure.exception();
            if (Command.EOF$.MODULE$.equals(throwable)) {
                $this.closePipeline((Option<Throwable>)None$.MODULE$);
                return;
            }
        }
        if (bl2) {
            Throwable t = failure.exception();
            $this.logger().error("Unknown error in readHeaders", t);
            Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst($this.streamId, "Unknown error");
            $this.closePipeline((Option<Throwable>)new Some((Object)e));
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$getBody$3(Http2NodeStage $this, BooleanRef complete$1, LongRef bytesRead$1, long maxlen$1, Function1 cb$1, Try x0$1) {
        StreamFrame streamFrame;
        boolean bl = false;
        Success success = null;
        boolean bl2 = false;
        Failure failure = null;
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            StreamFrame streamFrame2 = (StreamFrame)success.value();
            if (streamFrame2 instanceof DataFrame) {
                DataFrame dataFrame = (DataFrame)streamFrame2;
                boolean last = dataFrame.endStream();
                ByteBuffer bytes = dataFrame.data();
                complete$1.elem = last;
                bytesRead$1.elem += (long)bytes.remaining();
                if (complete$1.elem && maxlen$1 > 0L && bytesRead$1.elem != maxlen$1) {
                    String msg = new StringBuilder(38).append("Entity too small. Expected ").append(maxlen$1).append(", received ").append(bytesRead$1.elem).toString();
                    Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst($this.streamId, msg);
                    $this.closePipeline((Option<Throwable>)new Some((Object)e));
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)new InvalidBodyException(msg)));
                    return;
                }
                if (maxlen$1 > 0L && bytesRead$1.elem > maxlen$1) {
                    String msg = new StringBuilder(47).append("Entity too large. Expected ").append(maxlen$1).append(", received bytesRead").toString();
                    Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst($this.streamId, msg);
                    $this.closePipeline((Option<Throwable>)new Some((Object)e));
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)new InvalidBodyException(msg)));
                    return;
                }
                BoxedUnit cfr_ignored_2 = (BoxedUnit)cb$1.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)new Some((Object)Chunk$.MODULE$.array((Object)bytes.array(), (ClassTag)ClassTag$.MODULE$.Byte()))));
                return;
            }
        }
        if (bl && (streamFrame = (StreamFrame)success.value()) instanceof HeadersFrame) {
            HeadersFrame headersFrame = (HeadersFrame)streamFrame;
            boolean bl3 = headersFrame.endStream();
            Seq ts = headersFrame.headers();
            if (bl3) {
                if ($this.logger().isWarnEnabled()) {
                    $this.logger().warn(new StringBuilder(21).append("Discarding trailers: ").append(ts).toString());
                }
                BoxedUnit cfr_ignored_3 = (BoxedUnit)cb$1.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)new Some((Object)Chunk$.MODULE$.empty())));
                return;
            }
        }
        if (bl) {
            StreamFrame other = (StreamFrame)success.value();
            String msg = new StringBuilder(48).append("Received invalid frame while accumulating body: ").append(other).toString();
            if ($this.logger().isInfoEnabled()) {
                $this.logger().info(msg);
            }
            Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst($this.streamId, msg);
            $this.closePipeline((Option<Throwable>)new Some((Object)e));
            BoxedUnit cfr_ignored_4 = (BoxedUnit)cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)new InvalidBodyException(msg)));
            return;
        }
        if (try_ instanceof Failure) {
            bl2 = true;
            failure = (Failure)try_;
            Throwable throwable = failure.exception();
            if (Command.EOF$.MODULE$.equals(throwable)) {
                $this.logger().debug("EOF while accumulating body");
                cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)new InvalidBodyException("Received premature EOF.")));
                $this.closePipeline((Option<Throwable>)None$.MODULE$);
                return;
            }
        }
        if (bl2) {
            Throwable t = failure.exception();
            $this.logger().error("Error in getBody().", t);
            Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst($this.streamId, "Failed to read body");
            cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)e));
            $this.closePipeline((Option<Throwable>)new Some((Object)e));
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$renderResponse$1(ArrayBuffer hs$1, Header.Raw h) {
        CIString cIString = h.name();
        CIString cIString2 = Transfer$minusEncoding$.MODULE$.name();
        if (cIString == null ? cIString2 != null : !cIString.equals(cIString2)) {
            CIString cIString3 = h.name();
            CIString cIString4 = Header$.MODULE$.apply(Connection$.MODULE$.headerInstance()).name();
            if (cIString3 == null ? cIString4 != null : !cIString3.equals(cIString4)) {
                hs$1.$plus$eq((Object)new Tuple2((Object)h.name().toString().toLowerCase(Locale.ROOT), (Object)h.value()));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$renderResponse$2(Http2NodeStage $this, Either x0$1) {
        boolean bl = false;
        Left left = null;
        Either either = x0$1;
        if (either instanceof Right) {
            $this.closePipeline((Option<Throwable>)None$.MODULE$);
            return;
        }
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Throwable throwable = (Throwable)left.value();
            if (Command.EOF$.MODULE$.equals(throwable)) {
                $this.stageShutdown();
                return;
            }
        }
        if (bl) {
            Throwable t = (Throwable)left.value();
            $this.closePipeline((Option<Throwable>)new Some((Object)t));
            return;
        }
        throw new MatchError((Object)either);
    }

    public Http2NodeStage(int streamId, Duration timeout, ExecutionContext executionContext, Function0<Vault> attributes, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, Duration responseHeaderTimeout, Duration idleTimeout, TickWheelExecutor scheduler, Dispatcher<F> dispatcher, Async<F> F) {
        Function1 & Serializable intersect;
        this.streamId = streamId;
        this.timeout = timeout;
        this.executionContext = executionContext;
        this.attributes = attributes;
        this.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler = serviceErrorHandler;
        this.idleTimeout = idleTimeout;
        this.scheduler = scheduler;
        this.org$http4s$blaze$server$Http2NodeStage$$dispatcher = dispatcher;
        this.org$http4s$blaze$server$Http2NodeStage$$F = F;
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        this.runApp = httpApp.run();
        this.shutdownStageToken = new Some(F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stageShutdown()));
        Duration duration = responseHeaderTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            intersect = (Function1 & Serializable)req -> GenTemporalOps_$.MODULE$.timeoutTo$extension(package.temporal$.MODULE$.genTemporalOps_($this.runApp.apply(req)), finiteDuration, $this.org$http4s$blaze$server$Http2NodeStage$$F.pure((Object)Response$.MODULE$.timeout()), $this.org$http4s$blaze$server$Http2NodeStage$$F);
        } else {
            intersect = this.runApp;
        }
        this.org$http4s$blaze$server$Http2NodeStage$$raceTimeout = intersect;
        Statics.releaseFence();
    }
}

