/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.List;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJETx
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJETx.class);
    private volatile Transaction tx;
    private final List<Cursor> openCursors = new ArrayList<Cursor>();
    private final LockMode lm;

    public BerkeleyJETx(Transaction t, LockMode lockMode, BaseTransactionConfig config) {
        super(config);
        this.tx = t;
        this.lm = lockMode;
        Preconditions.checkNotNull((Object)this.lm);
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    private void closeOpenIterators() {
        this.openCursors.forEach(Cursor::close);
    }

    LockMode getLockMode() {
        return this.lm;
    }

    public synchronized void rollback() throws BackendException {
        super.rollback();
        if (this.tx == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("{} rolled back", (Object)this.toString(), (Object)new TransactionClose(this.toString()));
        }
        try {
            this.closeOpenIterators();
            this.tx.abort();
            this.tx = null;
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public synchronized void commit() throws BackendException {
        super.commit();
        if (this.tx == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("{} committed", (Object)this.toString(), (Object)new TransactionClose(this.toString()));
        }
        try {
            this.closeOpenIterators();
            this.tx.commit();
            this.tx = null;
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + (null == this.tx ? "nulltx" : this.tx.toString());
    }

    private static class TransactionClose
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TransactionClose(String msg) {
            super(msg);
        }
    }
}

