/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.SimonFilter;
import org.javasimon.SimonPattern;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonTypeFactory;
import org.javasimon.console.SimonVisitor;

public class SimonVisitors {
    private SimonVisitors() {
    }

    public static void visitList(Manager manager, String pattern, Set<SimonType> types, SimonVisitor visitor) throws IOException {
        ArrayList simons = new ArrayList(manager.getSimons((SimonFilter)SimonPattern.create((String)pattern)));
        Collections.sort(simons, new Comparator<Simon>(){

            @Override
            public int compare(Simon s1, Simon s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        for (Simon simon : simons) {
            SimonType lType = SimonTypeFactory.getValueFromInstance(simon);
            if (types != null && !types.contains((Object)lType)) continue;
            visitor.visit(simon);
        }
    }

    public static void visitTree(Simon simon, SimonVisitor visitor) throws IOException {
        visitor.visit(simon);
        for (Simon childSimon : simon.getChildren()) {
            SimonVisitors.visitTree(childSimon, visitor);
        }
    }
}

