/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kie.api.definition.process.Node;

public class Signal
implements Serializable {
    private static final long serialVersionUID = 510L;
    private String id;
    private String name;
    private String structureRef;
    private Collection<Node> incomingNodes = new ArrayList<Node>();
    private Collection<Node> outgoingNodes = new ArrayList<Node>();

    public Signal(String id, String structureRef) {
        this.id = id;
        this.structureRef = structureRef;
    }

    public Signal(String id, String name, String structureRef) {
        this(id, structureRef);
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getStructureRef() {
        return this.structureRef;
    }

    public String getName() {
        return this.name;
    }

    public void addIncomingNode(Node node) {
        this.incomingNodes.add(node);
    }

    public void addOutgoingNode(Node node) {
        this.outgoingNodes.add(node);
    }

    public Collection<Node> getIncomingNodes() {
        return Collections.unmodifiableCollection(this.incomingNodes);
    }

    public Collection<Node> getOutgoingNodes() {
        return Collections.unmodifiableCollection(this.outgoingNodes);
    }
}

