/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.jdbi.v3.stringtemplate4.StringTemplateSqlLocator;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class UseStringTemplateSqlLocatorImpl
implements Configurer {
    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        SqlLocator locator = (type, method, config) -> {
            String templateName = SqlAnnotations.getAnnotationValue((Method)method, sql -> sql).orElseGet(method::getName);
            STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(type);
            if (!group.isDefined(templateName)) {
                throw new IllegalStateException("No StringTemplate group " + templateName + " for class " + sqlObjectType);
            }
            return templateName;
        };
        TemplateEngine templateEngine = (templateName, ctx) -> {
            STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(sqlObjectType);
            ST template = group.getInstanceOf(templateName);
            ctx.getAttributes().forEach((arg_0, arg_1) -> ((ST)template).add(arg_0, arg_1));
            return template.render();
        };
        ((SqlObjects)registry.get(SqlObjects.class)).setSqlLocator(locator);
        ((SqlStatements)registry.get(SqlStatements.class)).setTemplateEngine(templateEngine);
    }

    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
        this.configureForType(registry, annotation, sqlObjectType);
    }
}

