/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VElement;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.VParent;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.content.ContentLineStrategy;
import jfxtras.icalendarfx.content.Orderer;
import jfxtras.icalendarfx.content.OrdererBase;
import jfxtras.icalendarfx.content.UnfoldingStringIterator;
import jfxtras.icalendarfx.parameters.VParameter;
import jfxtras.icalendarfx.properties.VProperty;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRulePart;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;

public abstract class VParentBase<T>
extends VElementBase
implements VParent {
    private static final Map<Class<? extends VParent>, Map<Class<? extends VChild>, Method>> SETTERS = new HashMap<Class<? extends VParent>, Map<Class<? extends VChild>, Method>>();
    private static final Map<Class<? extends VParent>, Map<Class<? extends VChild>, Method>> GETTERS = new HashMap<Class<? extends VParent>, Map<Class<? extends VChild>, Method>>();
    protected Orderer orderer = new OrdererBase(this, this.getGetters());
    protected ContentLineStrategy contentLineGenerator;

    @Override
    public void orderChild(VChild addedChild) {
        this.orderer.orderChild(addedChild);
    }

    @Override
    public void orderChild(VChild oldChild, VChild newChild) {
        this.orderer.replaceChild(oldChild, newChild);
    }

    @Override
    public void orderChild(int index, VChild addedChild) {
        this.orderer.orderChild(index, addedChild);
    }

    @Override
    public void addChild(VChild child) {
        Method setter = this.getSetter(child);
        boolean isList = Collection.class.isAssignableFrom(setter.getParameters()[0].getType());
        try {
            if (isList) {
                Method getter = this.getGetter(child);
                ArrayList<VChild> list = (ArrayList<VChild>)getter.invoke((Object)this, new Object[0]);
                if (list == null) {
                    list = getter.getReturnType() == List.class ? new ArrayList<VChild>() : (getter.getReturnType() == Set.class ? new LinkedHashSet() : new ArrayList());
                    list.add(child);
                    setter.invoke((Object)this, list);
                } else {
                    list.add(child);
                    this.orderChild(child);
                }
            } else {
                setter.invoke((Object)this, child);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addChild(int index, VChild child) {
        this.addChild(child);
        this.orderChild(index, child);
    }

    @Override
    public void addChild(String childContent) {
        this.parseContent(childContent);
    }

    @Override
    public boolean removeChild(VChild child) {
        Method setter = this.getSetter(child);
        boolean isList = List.class.isAssignableFrom(setter.getParameters()[0].getType());
        try {
            if (isList) {
                Method getter = this.getGetter(child);
                List list = (List)getter.invoke((Object)this, new Object[0]);
                if (list == null) {
                    return false;
                }
                boolean result = list.remove(child);
                this.orderChild(child, null);
                return result;
            }
            setter.invoke((Object)this, new Object[]{null});
            this.orderChild(child, null);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeChild(int index) {
        return this.removeChild(this.childrenUnmodifiable().get(index));
    }

    @Override
    public boolean replaceChild(int index, VChild child) {
        this.removeChild(index);
        this.addChild(index, child);
        return true;
    }

    @Override
    public boolean replaceChild(VChild oldChild, VChild newChild) {
        return this.orderer.replaceChild(oldChild, newChild);
    }

    public T withChild(VChild child) {
        this.addChild(child);
        return (T)this;
    }

    protected Map<Class<? extends VChild>, Method> getSetters() {
        if (SETTERS.get(this.getClass()) == null) {
            Map<Class<? extends VChild>, Method> setterMap = VParentBase.collectSetterMap(this.getClass());
            SETTERS.put(this.getClass(), setterMap);
            return setterMap;
        }
        return SETTERS.get(this.getClass());
    }

    protected Map<Class<? extends VChild>, Method> getGetters() {
        if (GETTERS.get(this.getClass()) == null) {
            Map<Class<? extends VChild>, Method> getterMap = VParentBase.collectGetterMap(this.getClass());
            GETTERS.put(this.getClass(), getterMap);
            return getterMap;
        }
        return GETTERS.get(this.getClass());
    }

    protected Method getSetter(VChild child) {
        return this.getSetters().get(child.getClass());
    }

    protected Method getGetter(VChild child) {
        return this.getGetters().get(child.getClass());
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        Iterator<String> i = Arrays.asList(content.split(System.lineSeparator())).iterator();
        return this.parseContent(new UnfoldingStringIterator(i));
    }

    protected List<VElementBase.Message> parseContent(Iterator<String> unfoldedLineIterator) {
        Class singlelineChildClass;
        Class<VComponent> multilineChildClass;
        if (VCalendar.class.isAssignableFrom(this.getClass())) {
            multilineChildClass = VComponent.class;
            singlelineChildClass = VProperty.class;
        } else if (VComponent.class.isAssignableFrom(this.getClass())) {
            multilineChildClass = VComponent.class;
            singlelineChildClass = VProperty.class;
        } else if (VProperty.class.isAssignableFrom(this.getClass())) {
            multilineChildClass = null;
            singlelineChildClass = VParameter.class;
        } else if (RecurrenceRuleValue.class.isAssignableFrom(this.getClass())) {
            multilineChildClass = null;
            singlelineChildClass = RRulePart.class;
        } else {
            throw new RuntimeException("Not supported parent class:" + this.getClass());
        }
        ArrayList<VElementBase.Message> messages = new ArrayList<VElementBase.Message>();
        while (unfoldedLineIterator.hasNext()) {
            List<VElementBase.Message> myMessages;
            VElementBase child;
            String unfoldedLine = unfoldedLineIterator.next();
            if (unfoldedLine.startsWith("END:")) {
                return messages;
            }
            String childName = VParentBase.elementName(unfoldedLine);
            if (childName != null) {
                childName = childName.startsWith("X-") ? "X-" : childName;
            }
            boolean isMultiLineElement = unfoldedLine.startsWith("BEGIN:");
            boolean isMainComponent = this.name().equals(childName);
            if (isMultiLineElement) {
                if (isMainComponent) continue;
                child = (VElementBase)((Object)VElementBase.newEmptyVElement(multilineChildClass, childName));
                myMessages = ((VParentBase)child).parseContent(unfoldedLineIterator);
                messages.addAll(myMessages);
                this.addChildInternal(messages, unfoldedLine, childName, (VChild)((Object)child));
                continue;
            }
            child = isMainComponent ? this : (VElementBase)((Object)VElementBase.newEmptyVElement(singlelineChildClass, childName));
            if (child != null) {
                myMessages = ((VParentBase)child).parseContent(unfoldedLine);
                if (myMessages.isEmpty()) {
                    this.addChildInternal(messages, unfoldedLine, childName, (VChild)((Object)child));
                    continue;
                }
                messages.addAll(myMessages);
                continue;
            }
            messages.add(new VElementBase.Message(this, "Unknown element:" + unfoldedLine, VElementBase.MessageEffect.MESSAGE_ONLY));
        }
        return messages;
    }

    protected void processInLineChild(List<VElementBase.Message> messages, String childName, String content, Class<? extends VElement> singleLineChildClass) {
        VChild newChild = VElementBase.newEmptyVElement(singleLineChildClass, childName);
        if (newChild != null) {
            List<VElementBase.Message> myMessages = ((VElementBase)((Object)newChild)).parseContent(childName + "=" + content);
            messages.addAll(myMessages);
            this.addChildInternal(messages, content, childName, newChild);
        } else {
            messages.add(new VElementBase.Message(this, "Unknown element:" + content, VElementBase.MessageEffect.MESSAGE_ONLY));
        }
    }

    protected boolean checkChild(List<VElementBase.Message> messages, String content, String elementName, VChild newChild) {
        boolean isChildAlreadyPresent;
        Method getter;
        boolean isChildAllowed;
        int initialMessageSize = messages.size();
        if (newChild == null) {
            VElementBase.Message message = new VElementBase.Message(this, "Ignored invalid element:" + content, VElementBase.MessageEffect.MESSAGE_ONLY);
            messages.add(message);
        }
        boolean bl = isChildAllowed = (getter = this.getGetter(newChild)) != null;
        if (!isChildAllowed) {
            VElementBase.Message message = new VElementBase.Message(this, elementName + " not allowed in " + this.name(), VElementBase.MessageEffect.THROW_EXCEPTION);
            messages.add(message);
        }
        Object currentParameter = null;
        try {
            currentParameter = getter.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (currentParameter instanceof Collection) {
            isChildAlreadyPresent = ((Collection)currentParameter).contains(newChild);
        } else {
            boolean bl2 = isChildAlreadyPresent = currentParameter != null;
        }
        if (isChildAlreadyPresent) {
            VElementBase.Message message = new VElementBase.Message(this, newChild.getClass().getSimpleName() + " can only occur once in a calendar component.  Ignoring instances beyond first.", VElementBase.MessageEffect.MESSAGE_ONLY);
            messages.add(message);
        }
        return messages.size() == initialMessageSize;
    }

    protected void addChildInternal(List<VElementBase.Message> messages, String content, String elementName, VChild newChild) {
        boolean isOK = this.checkChild(messages, content, elementName, newChild);
        if (isOK) {
            this.addChild(newChild);
        }
    }

    @Override
    public List<VChild> childrenUnmodifiable() {
        return this.orderer.childrenUnmodifiable();
    }

    public void copyChildrenInto(VParent destination) {
        this.childrenUnmodifiable().forEach(childSource -> {
            try {
                VChild newChild = (VChild)childSource.getClass().getConstructor(childSource.getClass()).newInstance(childSource);
                destination.addChild(newChild);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    public VParentBase() {
    }

    public VParentBase(VParentBase<T> source) {
        this();
        source.copyChildrenInto(this);
    }

    @Override
    public List<String> errors() {
        return this.childrenUnmodifiable().stream().flatMap(c -> c.errors().stream()).collect(Collectors.toList());
    }

    public String toString() {
        if (this.contentLineGenerator == null) {
            throw new RuntimeException("Can't produce content lines because contentLineGenerator isn't set");
        }
        return this.contentLineGenerator.execute();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VParent testObj = (VParent)obj;
        Map<Class<VChild>, Method> getters = this.getGetters();
        return getters.entrySet().stream().map(e -> (Method)e.getValue()).allMatch(m -> {
            try {
                Object v1 = m.invoke((Object)this, new Object[0]);
                Object v2 = m.invoke((Object)testObj, new Object[0]);
                return Objects.equals(v1, v2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                e1.printStackTrace();
                return false;
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (VChild child : this.childrenUnmodifiable()) {
            result = 31 * result + child.hashCode();
        }
        return result;
    }

    public static Map<Class<? extends VChild>, Method> collectGetterMap(Class<?> class1) {
        HashMap<Class<? extends VChild>, Method> getters = new HashMap<Class<? extends VChild>, Method>();
        Iterator methodIterator = Arrays.stream(class1.getMethods()).filter(m -> m.getParameters().length == 0).filter(m -> m.getName().startsWith("get")).iterator();
        while (methodIterator.hasNext()) {
            Method m2 = (Method)methodIterator.next();
            Class<?> returnType = m2.getReturnType();
            if (VChild.class.isAssignableFrom(returnType)) {
                getters.put(returnType, m2);
                continue;
            }
            if (!Collection.class.isAssignableFrom(returnType)) continue;
            ParameterizedType pt = (ParameterizedType)m2.getGenericReturnType();
            Type t = pt.getActualTypeArguments()[0];
            if (ParameterizedType.class.isAssignableFrom(t.getClass())) {
                ParameterizedType t2 = (ParameterizedType)t;
                t = t2.getRawType();
            }
            Class listType = (Class)t;
            getters.put(listType, m2);
        }
        return getters;
    }

    public static Map<Class<? extends VChild>, Method> collectSetterMap(Class<?> class1) {
        HashMap<Class<? extends VChild>, Method> setters = new HashMap<Class<? extends VChild>, Method>();
        Iterator methodIterator = Arrays.stream(class1.getMethods()).filter(m -> m.getParameters().length == 1).filter(m -> m.getName().startsWith("set")).iterator();
        while (methodIterator.hasNext()) {
            Class clazz2;
            boolean isListOfChildren;
            Method m2 = (Method)methodIterator.next();
            Parameter p = m2.getParameters()[0];
            Class<?> parameterType = p.getType();
            if (VChild.class.isAssignableFrom(parameterType)) {
                setters.put(parameterType, m2);
                continue;
            }
            if (!Collection.class.isAssignableFrom(parameterType)) continue;
            ParameterizedType pt = (ParameterizedType)p.getParameterizedType();
            Type t = pt.getActualTypeArguments()[0];
            if (ParameterizedType.class.isAssignableFrom(t.getClass())) {
                ParameterizedType t2 = (ParameterizedType)t;
                t = t2.getRawType();
            }
            if (!(isListOfChildren = VChild.class.isAssignableFrom(clazz2 = (Class)t))) continue;
            setters.put(clazz2, m2);
        }
        return setters;
    }
}

