/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VRepeatableBase;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRuleCache;
import jfxtras.icalendarfx.properties.component.timezone.TimeZoneName;
import jfxtras.icalendarfx.properties.component.timezone.TimeZoneOffsetFrom;
import jfxtras.icalendarfx.properties.component.timezone.TimeZoneOffsetTo;

public abstract class StandardOrDaylight<T extends StandardOrDaylight<T>>
extends VRepeatableBase<T> {
    private List<TimeZoneName> timeZoneNames;
    private TimeZoneOffsetFrom timeZoneOffsetFrom;
    private TimeZoneOffsetTo timeZoneOffsetTo;
    private RecurrenceRuleCache streamer = new RecurrenceRuleCache(this);

    public List<TimeZoneName> getTimeZoneNames() {
        return this.timeZoneNames;
    }

    public void setTimeZoneNames(List<TimeZoneName> timeZoneNames) {
        if (this.timeZoneNames != null) {
            this.timeZoneNames.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.timeZoneNames = timeZoneNames;
        if (timeZoneNames != null) {
            timeZoneNames.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public T withTimeZoneNames(List<TimeZoneName> timeZoneNames) {
        if (this.getTimeZoneNames() == null) {
            this.setTimeZoneNames(new ArrayList<TimeZoneName>());
        }
        this.getTimeZoneNames().addAll(timeZoneNames);
        if (timeZoneNames != null) {
            timeZoneNames.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    public T withTimeZoneNames(String ... timeZoneNames) {
        List<TimeZoneName> newElements = Arrays.stream(timeZoneNames).map(c -> TimeZoneName.parse(c)).collect(Collectors.toList());
        return this.withTimeZoneNames(newElements);
    }

    public T withTimeZoneNames(TimeZoneName ... timeZoneNames) {
        return this.withTimeZoneNames(Arrays.asList(timeZoneNames));
    }

    public TimeZoneOffsetFrom getTimeZoneOffsetFrom() {
        return this.timeZoneOffsetFrom;
    }

    public void setTimeZoneOffsetFrom(TimeZoneOffsetFrom timeZoneOffsetFrom) {
        this.orderChild(this.timeZoneOffsetFrom, (VChild)timeZoneOffsetFrom);
        this.timeZoneOffsetFrom = timeZoneOffsetFrom;
    }

    public void setTimeZoneOffsetFrom(ZoneOffset zoneOffset) {
        this.setTimeZoneOffsetFrom(new TimeZoneOffsetFrom(zoneOffset));
    }

    public void setTimeZoneOffsetFrom(String timeZoneOffsetFrom) {
        this.setTimeZoneOffsetFrom(TimeZoneOffsetFrom.parse(timeZoneOffsetFrom));
    }

    public T withTimeZoneOffsetFrom(TimeZoneOffsetFrom timeZoneOffsetFrom) {
        this.setTimeZoneOffsetFrom(timeZoneOffsetFrom);
        return (T)this;
    }

    public T withTimeZoneOffsetFrom(ZoneOffset zoneOffset) {
        this.setTimeZoneOffsetFrom(zoneOffset);
        return (T)this;
    }

    public T withTimeZoneOffsetFrom(String timeZoneOffsetFrom) {
        this.setTimeZoneOffsetFrom(timeZoneOffsetFrom);
        return (T)this;
    }

    public TimeZoneOffsetTo getTimeZoneOffsetTo() {
        return this.timeZoneOffsetTo;
    }

    public void setTimeZoneOffsetTo(TimeZoneOffsetTo timeZoneOffsetTo) {
        this.orderChild(this.timeZoneOffsetTo, (VChild)timeZoneOffsetTo);
        this.timeZoneOffsetTo = timeZoneOffsetTo;
    }

    public void setTimeZoneOffsetTo(ZoneOffset zoneOffset) {
        this.setTimeZoneOffsetTo(new TimeZoneOffsetTo(zoneOffset));
    }

    public void setTimeZoneOffsetTo(String timeZoneOffsetTo) {
        this.setTimeZoneOffsetTo(TimeZoneOffsetTo.parse(timeZoneOffsetTo));
    }

    public T withTimeZoneOffsetTo(TimeZoneOffsetTo timeZoneOffsetTo) {
        this.setTimeZoneOffsetTo(timeZoneOffsetTo);
        return (T)this;
    }

    public T withTimeZoneOffsetTo(ZoneOffset zoneOffset) {
        this.setTimeZoneOffsetTo(zoneOffset);
        return (T)this;
    }

    public T withTimeZoneOffsetTo(String timeZoneOffsetTo) {
        this.setTimeZoneOffsetTo(timeZoneOffsetTo);
        return (T)this;
    }

    @Override
    public List<? extends VComponent> calendarList() {
        throw new RuntimeException("Subcomponent " + this.name() + " is embedded in VTimeZone not VCalendar");
    }

    public StandardOrDaylight() {
    }

    public StandardOrDaylight(StandardOrDaylight<T> source) {
        super(source);
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        if (this.getDateTimeStart() == null) {
            errors.add("DTSTART is not present.  DTSTART is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getTimeZoneOffsetFrom() == null) {
            errors.add("TZOFFSETFROM is not present.  TZOFFSETFROM is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getTimeZoneOffsetTo() == null) {
            errors.add("TZOFFSETTO is not present.  TZOFFSETTO is REQUIRED and MUST NOT occur more than once");
        }
        return Collections.unmodifiableList(errors);
    }

    @Override
    public RecurrenceRuleCache recurrenceCache() {
        return this.streamer;
    }
}

