/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.icalendarfx.components.VRepeatable;
import jfxtras.icalendarfx.properties.component.recurrence.PropertyBaseRecurrence;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceDates;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRule;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRuleCache;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public abstract class VRepeatableBase<T>
extends VPrimary<T>
implements VRepeatable<T> {
    private List<RecurrenceDates> recurrenceDates;
    private RecurrenceRule recurrenceRule;
    private RecurrenceRuleCache streamer = new RecurrenceRuleCache(this);

    @Override
    public List<RecurrenceDates> getRecurrenceDates() {
        return this.recurrenceDates;
    }

    @Override
    public void setRecurrenceDates(List<RecurrenceDates> recurrenceDates) {
        if (this.recurrenceDates != null) {
            this.recurrenceDates.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.recurrenceDates = recurrenceDates;
        if (recurrenceDates != null) {
            recurrenceDates.forEach(c -> this.orderChild((VChild)c));
        }
    }

    @Override
    public RecurrenceRule getRecurrenceRule() {
        return this.recurrenceRule;
    }

    @Override
    public void setRecurrenceRule(RecurrenceRule recurrenceRule) {
        this.orderChild(this.recurrenceRule, (VChild)recurrenceRule);
        this.recurrenceRule = recurrenceRule;
    }

    VRepeatableBase() {
    }

    public VRepeatableBase(VRepeatableBase<T> source) {
        super(source);
    }

    @Override
    public Stream<Temporal> streamRecurrences(Temporal start) {
        Stream<Temporal> inStream = VRepeatable.super.streamRecurrences(start);
        if (this.getRecurrenceRule() == null) {
            return inStream;
        }
        return this.recurrenceCache().makeCache(inStream);
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        errors.addAll(VRepeatableBase.errorsRepeatable(this));
        errors.addAll(VRepeatableBase.errorsRecurrence(this.getRecurrenceDates(), this.getDateTimeStart()));
        return errors;
    }

    protected static List<String> errorsRepeatable(VRepeatable<?> testObj) {
        ArrayList<String> errors = new ArrayList<String>();
        String recurrenceDateError = testObj.checkRecurrencesConsistency(testObj.getRecurrenceDates());
        if (recurrenceDateError != null) {
            errors.add(recurrenceDateError);
        }
        if (testObj.getRecurrenceRule() != null && ((RecurrenceRuleValue)testObj.getRecurrenceRule().getValue()).getUntil() != null) {
            Temporal until = (Temporal)((RecurrenceRuleValue)testObj.getRecurrenceRule().getValue()).getUntil().getValue();
            DateTimeUtilities.DateTimeType untilType = DateTimeUtilities.DateTimeType.of(until);
            DateTimeUtilities.DateTimeType startType = DateTimeUtilities.DateTimeType.of((Temporal)testObj.getDateTimeStart().getValue());
            switch (startType) {
                case DATE: {
                    if (untilType == DateTimeUtilities.DateTimeType.DATE) break;
                    errors.add("If DTSTART specifies a DATE then UNTIL must also specify a DATE value instead of:" + (Object)((Object)untilType));
                    break;
                }
                case DATE_WITH_LOCAL_TIME: 
                case DATE_WITH_LOCAL_TIME_AND_TIME_ZONE: 
                case DATE_WITH_UTC_TIME: {
                    if (untilType == DateTimeUtilities.DateTimeType.DATE_WITH_UTC_TIME) break;
                    errors.add("If DTSTART specifies a DATE_WITH_LOCAL_TIME, DATE_WITH_LOCAL_TIME_AND_TIME_ZONE or DATE_WITH_UTC_TIME then UNTIL must specify a DATE_WITH_UTC_TIME value instead of:" + (Object)((Object)untilType));
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported DateTimeType:" + (Object)((Object)startType));
                }
            }
        }
        return errors;
    }

    protected static List<String> errorsRecurrence(List<? extends PropertyBaseRecurrence<?>> recurrenceDates, DateTimeStart dtstart) {
        ArrayList<String> errors = new ArrayList<String>();
        if (recurrenceDates != null && !recurrenceDates.isEmpty()) {
            DateTimeUtilities.DateTimeType dateTimeStartType;
            PropertyBaseRecurrence<?> sample = recurrenceDates.get(0);
            Temporal sampleTemporal = (Temporal)recurrenceDates.stream().flatMap(r -> ((Set)r.getValue()).stream()).findAny().get();
            DateTimeUtilities.DateTimeType sampleType = DateTimeUtilities.DateTimeType.of(sampleTemporal);
            Optional<String> error1 = recurrenceDates.stream().flatMap(r -> ((Set)r.getValue()).stream()).map(v -> {
                DateTimeUtilities.DateTimeType recurrenceType = DateTimeUtilities.DateTimeType.of(v);
                if (!recurrenceType.equals((Object)sampleType)) {
                    return sample.name() + ": DateTimeType " + (Object)((Object)recurrenceType) + " doesn't match previous recurrence's DateTimeType " + (Object)((Object)sampleType);
                }
                return null;
            }).filter(s -> s != null).findAny();
            if (error1.isPresent()) {
                errors.add(error1.get());
            } else if (sampleTemporal instanceof ZonedDateTime) {
                ZoneId zone = ((ZonedDateTime)sampleTemporal).getZone();
                boolean allZonesIdentical = recurrenceDates.stream().flatMap(r -> ((Set)r.getValue()).stream()).map(t -> ((ZonedDateTime)t).getZone()).allMatch(z -> z.equals(zone));
                if (!allZonesIdentical) {
                    errors.add("ZoneId are not all identical");
                }
            }
            if (dtstart != null && sampleType != (dateTimeStartType = DateTimeUtilities.DateTimeType.of((Temporal)dtstart.getValue()))) {
                errors.add("DTSTART, " + sample.name() + ": The value type of " + sample.name() + " elements MUST be the same as the DTSTART property (DTSTART=" + (Object)((Object)dateTimeStartType) + ", " + sample.name() + "=" + (Object)((Object)sampleType));
            }
        }
        return errors;
    }

    @Override
    public RecurrenceRuleCache recurrenceCache() {
        return this.streamer;
    }
}

