/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.itip;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.itip.Processable;
import jfxtras.icalendarfx.parameters.Range;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RecurrenceRuleValue;
import jfxtras.icalendarfx.properties.component.relationship.RecurrenceId;
import jfxtras.icalendarfx.properties.component.relationship.UniqueIdentifier;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class ProcessCancel
implements Processable {
    @Override
    public List<String> process(VCalendar mainVCalendar, VCalendar iTIPMessage) {
        ArrayList<String> log = new ArrayList<String>();
        iTIPMessage.childrenUnmodifiable().stream().filter(c -> c instanceof VComponent).map(c -> (VComponent)c).forEach(c -> {
            if (!(c instanceof VDisplayable)) throw new RuntimeException("not implemented");
            VDisplayable vDisplayable = (VDisplayable)c;
            int newSequence = vDisplayable.getSequence() == null ? 0 : (Integer)vDisplayable.getSequence().getValue();
            UniqueIdentifier uid = vDisplayable.getUniqueIdentifier();
            List<VDisplayable> relatedVComponents = mainVCalendar.getVComponents(vDisplayable).stream().map(v -> (VDisplayable)v).filter(v -> v.getUniqueIdentifier().equals(uid)).collect(Collectors.toList());
            RecurrenceId recurrenceID = vDisplayable.getRecurrenceId();
            if (relatedVComponents.isEmpty()) return;
            if (recurrenceID == null) {
                relatedVComponents.forEach(v -> mainVCalendar.removeChild((VChild)v));
                log.add("SUCCESS: canceled " + vDisplayable.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue());
                return;
            } else {
                boolean isMatchFound;
                VDisplayable matchingVComponent = relatedVComponents.stream().filter(v -> Objects.equals(recurrenceID, v.getRecurrenceId())).findAny().orElseGet(() -> null);
                boolean bl = isMatchFound = matchingVComponent != null;
                if (isMatchFound) {
                    int oldSequence;
                    int n = oldSequence = matchingVComponent.getSequence() == null ? 0 : (Integer)matchingVComponent.getSequence().getValue();
                    if (newSequence < oldSequence) throw new RuntimeException("Can't cancel because SEQUENCE in cancel message(" + newSequence + ") is lower than sequence of matching component (" + oldSequence + ").");
                    List<? extends VComponent> myVComponents = vDisplayable.calendarList();
                    myVComponents.remove(matchingVComponent);
                    log.add("SUCCESS: canceled " + c.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue());
                    return;
                } else {
                    int oldSequence;
                    VDisplayable parentVComponent = vDisplayable.getRecurrenceRule() == null ? relatedVComponents.stream().filter(v -> v.getRecurrenceRule() != null).findAny().orElseThrow(() -> new RuntimeException("Can't add EXDATE: VComponent with Recurrence Rule can't be found for uid:" + uid)) : vDisplayable;
                    boolean isRecurrence = parentVComponent.isRecurrence((Temporal)recurrenceID.getValue());
                    if (!isRecurrence) return;
                    int n = oldSequence = parentVComponent.getSequence() == null ? 0 : (Integer)parentVComponent.getSequence().getValue();
                    if (newSequence < oldSequence) throw new RuntimeException("Can't cancel because SEQUENCE in cancel message(" + newSequence + ") is lower than sequence of matching component (" + oldSequence + ").");
                    if (recurrenceID.getRange() == null) {
                        if (parentVComponent.getExceptionDates() == null) {
                            parentVComponent.withExceptionDates((Temporal)recurrenceID.getValue());
                        } else {
                            ((Set)parentVComponent.getExceptionDates().get(0).getValue()).add(recurrenceID.getValue());
                            log.add("SUCCESS: canceled " + recurrenceID.getValue() + " for " + parentVComponent.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue());
                        }
                    } else {
                        void var14_18;
                        if (recurrenceID.getRange().getValue() != Range.RangeType.THIS_AND_FUTURE) throw new IllegalArgumentException("Unsupported RangeType:" + recurrenceID.getRange().toString());
                        Temporal previous = parentVComponent.previousStreamValue((Temporal)recurrenceID.getValue());
                        if (previous.isSupported(ChronoUnit.NANOS)) {
                            Temporal temporal = DateTimeUtilities.DateTimeType.DATE_WITH_UTC_TIME.from(previous);
                        } else {
                            LocalDate localDate = LocalDate.from(previous);
                        }
                        ((RecurrenceRuleValue)parentVComponent.getRecurrenceRule().getValue()).setUntil((Temporal)var14_18);
                        log.add("SUCCESS: canceled recurrences after " + var14_18 + " for " + parentVComponent.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue());
                        List<VDisplayable<?>> orphanedChildren = parentVComponent.orphanedRecurrenceChildren();
                        if (!orphanedChildren.isEmpty()) {
                            mainVCalendar.getVComponents(vDisplayable).removeAll(orphanedChildren);
                        }
                    }
                    parentVComponent.incrementSequence();
                }
            }
        });
        return log;
    }
}

