/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties;

import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VElement;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.VParent;
import jfxtras.icalendarfx.VParentBase;
import jfxtras.icalendarfx.content.SingleLineContent;
import jfxtras.icalendarfx.parameters.NonStandardParameter;
import jfxtras.icalendarfx.parameters.VParameter;
import jfxtras.icalendarfx.parameters.ValueParameter;
import jfxtras.icalendarfx.properties.VProperty;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.ValueType;
import jfxtras.icalendarfx.properties.component.misc.NonStandardProperty;
import jfxtras.icalendarfx.utilities.ICalendarUtilities;
import jfxtras.icalendarfx.utilities.StringConverter;

public abstract class VPropertyBase<T, U>
extends VParentBase<U>
implements VProperty<T> {
    private VParent myParent;
    private T value;
    private Class<T> valueClass;
    protected String propertyName;
    private final VPropertyElement propertyType = VPropertyElement.fromClass(this.getClass());
    private String unknownValue;
    protected final ValueType defaultValueType;
    protected final Collection<ValueType> allowedValueTypes = this.propertyType.allowedValueTypes();
    private ValueParameter valueType;
    private List<NonStandardParameter> nonStandardParams;
    protected String actualValueContent = null;
    private StringConverter<T> converter;

    @Override
    public void setParent(VParent parent) {
        this.myParent = parent;
    }

    @Override
    public VParent getParent() {
        return this.myParent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public U withValue(T value) {
        this.setValue(value);
        return (U)this;
    }

    protected String valueContent() {
        String value = null;
        value = this.getValue() == null ? this.getUnknownValue() : (this.getConverter().toString(this.getValue()) == null ? this.getUnknownValue() : this.getConverter().toString(this.getValue()));
        return value == null ? "" : value;
    }

    private Class<?> getValueClass() {
        if (this.valueClass == null) {
            if (this.getValue() != null) {
                if (this.getValue() instanceof Collection) {
                    if (!((Collection)this.getValue()).isEmpty()) {
                        return ((Collection)this.getValue()).iterator().next().getClass();
                    }
                    return null;
                }
                return this.getValue().getClass();
            }
            return null;
        }
        return this.valueClass;
    }

    @Override
    public String name() {
        if (this.propertyName == null) {
            return this.propertyType.toString();
        }
        return this.propertyName;
    }

    protected String getUnknownValue() {
        return this.unknownValue;
    }

    private void setUnknownValue(String value) {
        this.unknownValue = value;
    }

    @Override
    public ValueParameter getValueType() {
        return this.valueType;
    }

    @Override
    public void setValueType(ValueParameter valueType) {
        if (valueType != null && !this.isValueTypeValid((ValueType)((Object)valueType.getValue()))) {
            throw new IllegalArgumentException("Invalid Value Date Type:" + valueType.getValue() + ", allowed = " + this.allowedValueTypes);
        }
        this.orderChild(this.valueType, (VChild)valueType);
        this.valueType = valueType;
        this.valueParamenterConverter(valueType);
    }

    public void setValueType(ValueType value) {
        this.setValueType(new ValueParameter(value));
    }

    public U withValueType(ValueType value) {
        this.setValueType(value);
        return (U)this;
    }

    private void valueParamenterConverter(ValueParameter newValueParameter) {
        boolean isMatch;
        if (!this.isCustomConverter() && this.modifiedValue() != null) {
            String modifiedValue = this.modifiedValue();
            T newPropValue = this.getConverter().fromString(modifiedValue);
            this.value = newPropValue;
        }
        if (newValueParameter != null && this.getValueClass() != null && !(isMatch = ((ValueType)((Object)newValueParameter.getValue())).allowedClasses().stream().map(c -> this.getValueClass().isAssignableFrom((Class<?>)c)).findAny().isPresent())) {
            throw new IllegalArgumentException("Value class " + this.getValueClass().getSimpleName() + " doesn't match allowed value classes: " + ((ValueType)((Object)newValueParameter.getValue())).allowedClasses());
        }
    }

    @Override
    public List<NonStandardParameter> getNonStandard() {
        return this.nonStandardParams;
    }

    @Override
    public void setNonStandard(List<NonStandardParameter> nonStandardParams) {
        if (this.nonStandardParams != null) {
            this.nonStandardParams.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.nonStandardParams = nonStandardParams;
        if (nonStandardParams != null) {
            nonStandardParams.forEach(e -> this.orderChild((VChild)e));
        }
    }

    public U withNonStandard(List<NonStandardParameter> nonStandardParams) {
        if (this.getNonStandard() == null) {
            this.setNonStandard(new ArrayList<NonStandardParameter>());
        }
        this.getNonStandard().addAll(nonStandardParams);
        if (nonStandardParams != null) {
            nonStandardParams.forEach(c -> this.orderChild((VChild)c));
        }
        return (U)this;
    }

    public U withNonStandard(String ... nonStandardParams) {
        List<NonStandardParameter> list = Arrays.stream(nonStandardParams).map(c -> NonStandardParameter.parse(c)).collect(Collectors.toList());
        return this.withNonStandard(list);
    }

    public U withNonStandard(NonStandardParameter ... nonStandardParams) {
        return this.withNonStandard(Arrays.asList(nonStandardParams));
    }

    protected String modifiedValue() {
        if (this.actualValueContent == null) {
            T value2 = this.getValue();
            if (value2 != null) {
                return this.getConverter().toString(this.getValue());
            }
            return null;
        }
        return this.actualValueContent;
    }

    protected StringConverter<T> getConverter() {
        if (this.converter == null) {
            ValueType valueType = this.getValueType() == null ? this.defaultValueType : (ValueType)((Object)this.getValueType().getValue());
            return valueType.getConverter();
        }
        return this.converter;
    }

    protected void setConverter(StringConverter<T> converter) {
        this.converter = converter;
    }

    private boolean isCustomConverter() {
        return this.converter != null;
    }

    protected VPropertyBase() {
        this.defaultValueType = this.propertyType.defaultValueType();
        this.contentLineGenerator = new SingleLineContent(this.orderer, Void2 -> this.name(), 50);
    }

    public VPropertyBase(Class<T> valueClass, String contentLine) {
        this();
        this.valueClass = valueClass;
        this.setConverterByClass(valueClass);
        this.parseContent(contentLine);
    }

    public VPropertyBase(VPropertyBase<T, U> source) {
        this();
        this.setConverter(source.getConverter());
        T valueCopy = this.copyValue(source.getValue());
        this.setValue(valueCopy);
        source.copyChildrenInto(this);
        this.setParent(source.getParent());
    }

    public VPropertyBase(T value) {
        this();
        this.setValue(value);
    }

    protected T copyValue(T source) {
        return source;
    }

    protected void setConverterByClass(Class<T> valueClass) {
    }

    @Override
    protected List<VElementBase.Message> parseContent(String unfoldedContent) {
        boolean isNameless;
        ArrayList<VElementBase.Message> messages = new ArrayList<VElementBase.Message>();
        String propertyName = VPropertyBase.elementName(unfoldedContent);
        boolean bl = isNameless = propertyName == null;
        if (isNameless) {
            unfoldedContent = ":" + unfoldedContent;
        } else if (propertyName.startsWith(VPropertyElement.NON_STANDARD_PROPERTY.toString())) {
            ((NonStandardProperty)this).setPropertyName(propertyName);
        }
        ICalendarUtilities.parseInlineElementsToListPair(unfoldedContent).stream().forEach(entry -> this.processInLineChild(messages, (String)entry.getKey(), (String)entry.getValue(), VParameter.class));
        return messages;
    }

    @Override
    protected void processInLineChild(List<VElementBase.Message> messages, String childName, String content, Class<? extends VElement> singleLineChildClass) {
        if (childName == ":") {
            if (content != null) {
                try {
                    this.actualValueContent = content;
                    T value = this.getConverter().fromString(this.modifiedValue());
                    if (value == null) {
                        this.setUnknownValue(content);
                    } else {
                        this.setValue(value);
                        if (value.toString() == "UNKNOWN") {
                            this.setUnknownValue(content);
                        }
                    }
                }
                catch (IllegalArgumentException | DateTimeException e) {
                    VElementBase.Message message = new VElementBase.Message(this, "Invalid element:" + e.getMessage() + this.modifiedValue(), VElementBase.MessageEffect.MESSAGE_ONLY);
                    messages.add(message);
                }
            }
        } else {
            super.processInLineChild(messages, childName, content, singleLineChildClass);
        }
    }

    @Override
    public List<String> errors() {
        ValueType valueType;
        List<String> errors = super.errors();
        if (this.getValue() == null) {
            // empty if block
        }
        if (this.getValueType() != null) {
            valueType = (ValueType)((Object)this.getValueType().getValue());
            boolean isValueTypeOK = this.isValueTypeValid(valueType);
            if (!isValueTypeOK) {
                errors.add(this.name() + " value type " + this.getValueType().getValue() + " is not supported.  Supported types include:" + this.allowedValueTypes.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
            }
        } else {
            valueType = this.defaultValueType;
        }
        List<String> valueTypeErrorList = valueType.createErrorList(this.getValue());
        if (valueTypeErrorList != null) {
            errors.addAll(valueTypeErrorList);
        }
        return errors;
    }

    private boolean isValueTypeValid(ValueType value) {
        boolean isValueTypeOK = this.allowedValueTypes.contains((Object)value);
        boolean isUnknownType = value.equals((Object)ValueType.UNKNOWN);
        return isValueTypeOK || isUnknownType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(":" + this.valueContent());
        return ICalendarUtilities.foldLine(builder).toString();
    }

    @Override
    public boolean equals(Object obj) {
        boolean valueEquals;
        boolean childrenEquals = super.equals(obj);
        if (!childrenEquals) {
            return false;
        }
        VPropertyBase testObj = (VPropertyBase)obj;
        boolean bl = this.getValue() == null ? testObj.getValue() == null : (valueEquals = this.getValue().equals(testObj.getValue()));
        if (!valueEquals) {
            return false;
        }
        boolean nameEquals = this.name().equals(testObj.name());
        return nameEquals;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int prime = 31;
        hash = 31 * hash + (this.converter == null ? 0 : this.converter.hashCode());
        hash = 31 * hash + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        hash = 31 * hash + (this.actualValueContent == null ? 0 : this.actualValueContent.hashCode());
        hash = 31 * hash + (this.unknownValue == null ? 0 : this.unknownValue.hashCode());
        hash = 31 * hash + (this.value == null ? 0 : this.value.hashCode());
        return hash;
    }
}

