/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleIntegerAbstract;

public class ByHour
extends ByRuleIntegerAbstract<ByHour> {
    public ByHour() {
    }

    public ByHour(Integer ... hours) {
        super(hours);
    }

    public ByHour(ByHour source) {
        super(source);
    }

    @Override
    Predicate<Integer> isValidValue() {
        return value -> value >= 0 && value <= 23;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        if (dateTimeStart.isSupported(ChronoField.HOUR_OF_DAY)) {
            switch (chronoUnit) {
                case HOURS: 
                case MINUTES: 
                case SECONDS: {
                    return inStream.filter(d -> {
                        int myHourOfDay = d.get(ChronoField.HOUR_OF_DAY);
                        Iterator iterator = ((List)this.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int hourOfDay = (Integer)iterator.next();
                            if (hourOfDay <= 0 || hourOfDay != myHourOfDay) continue;
                            return true;
                        }
                        return false;
                    });
                }
                case DAYS: 
                case WEEKS: 
                case MONTHS: 
                case YEARS: {
                    return inStream.flatMap(d -> {
                        ArrayList<Temporal> dates = new ArrayList<Temporal>();
                        Iterator iterator = ((List)this.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int hourOfDay = (Integer)iterator.next();
                            Temporal newTemporal = d.with(ChronoField.HOUR_OF_DAY, hourOfDay);
                            dates.add(newTemporal);
                        }
                        return dates.stream();
                    });
                }
            }
            throw new IllegalArgumentException("Not implemented: " + chronoUnit);
        }
        return inStream;
    }

    public static ByHour parse(String content) {
        return ByHour.parse(new ByHour(), content);
    }
}

