/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.utilities;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.components.VEvent;
import jfxtras.icalendarfx.parameters.VParameterElement;
import jfxtras.icalendarfx.properties.component.time.TimeTransparency;
import jfxtras.icalendarfx.utilities.ICalendarUtilities;
import jfxtras.icalendarfx.utilities.Pair;

public final class DateTimeUtilities {
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    public static final DateTimeType DEFAULT_DATE_TIME_TYPE = DateTimeType.DATE_WITH_UTC_TIME;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(LOCAL_DATE_FORMATTER).appendLiteral('T').append(LOCAL_TIME_FORMATTER).toFormatter();
    public static final DateTimeFormatter ZONED_DATE_TIME_UTC_FORMATTER = new DateTimeFormatterBuilder().append(LOCAL_DATE_TIME_FORMATTER).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ZONED_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().optionalStart().appendLiteral('[').parseCaseInsensitive().appendZoneRegionId().appendLiteral(']').optionalEnd().append(LOCAL_DATE_TIME_FORMATTER).optionalStart().appendOffsetId().optionalEnd().toFormatter();
    static final DateTimeFormatter ZONE_FORMATTER = new DateTimeFormatterBuilder().optionalStart().parseCaseInsensitive().appendLiteral("TZID=").appendZoneRegionId().optionalEnd().toFormatter();
    public static final Comparator<Temporal> TEMPORAL_COMPARATOR = (t1, t2) -> {
        if (t1.getClass().equals(t2.getClass())) {
            return DateTimeUtilities.getTemporalComparator(t1).compare((Temporal)t1, (Temporal)t2);
        }
        throw new DateTimeException("For comparision, Temporal classes must be equal (" + t1.getClass().getSimpleName() + ", " + t2.getClass().getSimpleName() + ")");
    };
    public static final Comparator<Temporal> TEMPORAL_COMPARATOR2 = (t1, t2) -> {
        ZonedDateTime z1 = (ZonedDateTime)DateTimeType.DATE_WITH_UTC_TIME.from((Temporal)t1);
        ZonedDateTime z2 = (ZonedDateTime)DateTimeType.DATE_WITH_UTC_TIME.from((Temporal)t2);
        return z1.compareTo(z2);
    };
    private static final int CONFLICT_CHECK_QUANTITY = 400;

    private DateTimeUtilities() {
    }

    public static final Comparator<Temporal> getTemporalComparator(Temporal t) {
        if (t instanceof LocalDate) {
            return (t1, t2) -> ((LocalDate)t1).compareTo((LocalDate)t2);
        }
        if (t instanceof LocalDateTime) {
            return (t1, t2) -> ((LocalDateTime)t1).compareTo((LocalDateTime)t2);
        }
        if (t instanceof ZonedDateTime) {
            return (t1, t2) -> ((ZonedDateTime)t1).compareTo((ZonedDateTime)t2);
        }
        throw new DateTimeException("Unsupported Temporal type:" + t.getClass().getSimpleName());
    }

    public static boolean isBefore(Temporal t1, Temporal t2) {
        if (t1.getClass().equals(t2.getClass())) {
            if (t1 instanceof LocalDate) {
                return ((LocalDate)t1).isBefore((LocalDate)t2);
            }
            if (t1 instanceof LocalDateTime) {
                return ((LocalDateTime)t1).isBefore((LocalDateTime)t2);
            }
            if (t1 instanceof ZonedDateTime) {
                return ((ZonedDateTime)t1).isBefore((ZonedDateTime)t2);
            }
            throw new DateTimeException("Unsupported Temporal class: " + t1.getClass());
        }
        throw new DateTimeException("For comparision, Temporal classes must be equal (" + t1.getClass().getSimpleName() + ", " + t2.getClass().getSimpleName() + ")");
    }

    public static boolean isAfter(Temporal t1, Temporal t2) {
        if (t1.getClass().equals(t2.getClass())) {
            if (t1 instanceof LocalDate) {
                return ((LocalDate)t1).isAfter((LocalDate)t2);
            }
            if (t1 instanceof LocalDateTime) {
                return ((LocalDateTime)t1).isAfter((LocalDateTime)t2);
            }
            if (t1 instanceof ZonedDateTime) {
                return ((ZonedDateTime)t1).isAfter((ZonedDateTime)t2);
            }
            throw new DateTimeException("Unsupported Temporal class: " + t1.getClass());
        }
        throw new DateTimeException("For comparision, Temporal classes must be equal (" + t1.getClass().getSimpleName() + ", " + t2.getClass().getSimpleName() + ")");
    }

    public static String checkScheduleConflict(VEvent vEvent, List<VEvent> vEvents) {
        return DateTimeUtilities.checkScheduleConflict(vEvent, vEvents, 400);
    }

    public static String checkScheduleConflict(VEvent vEvent, List<VEvent> vEvents, int checkQuantity) {
        TimeTransparency.TimeTransparencyType newTransparency;
        TimeTransparency.TimeTransparencyType timeTransparencyType = newTransparency = vEvent.getTimeTransparency() == null ? TimeTransparency.TimeTransparencyType.OPAQUE : (TimeTransparency.TimeTransparencyType)((Object)vEvent.getTimeTransparency().getValue());
        if (newTransparency == TimeTransparency.TimeTransparencyType.TRANSPARENT) {
            return null;
        }
        LocalDate dtstart = LocalDate.from((TemporalAccessor)vEvent.getDateTimeStart().getValue());
        TemporalAmount duration = vEvent.getActualDuration();
        List newStarts = vEvent.streamRecurrences().limit(checkQuantity).collect(Collectors.toList());
        Temporal lastStart = (Temporal)newStarts.get(newStarts.size() - 1);
        List eventTimes = vEvents.stream().filter(v -> {
            TimeTransparency.TimeTransparencyType myTransparency = v.getTimeTransparency() == null ? TimeTransparency.TimeTransparencyType.OPAQUE : (TimeTransparency.TimeTransparencyType)((Object)((Object)v.getTimeTransparency().getValue()));
            return myTransparency == TimeTransparency.TimeTransparencyType.OPAQUE;
        }).flatMap(v -> {
            TemporalAmount actualDuration = v.getActualDuration();
            Temporal myDTStart = ((Temporal)v.getDateTimeStart().getValue()).with(dtstart);
            return v.streamRecurrences(myDTStart).limit(checkQuantity).filter(t -> !DateTimeUtilities.isAfter(t, lastStart)).map(t -> {
                String uid = v.getUniqueIdentifier() != null ? (String)v.getUniqueIdentifier().getValue() : null;
                return new Triple((Temporal)t, t.plus(actualDuration), uid);
            });
        }).sorted((t1, t2) -> TEMPORAL_COMPARATOR2.compare(t1.start, t2.start)).collect(Collectors.toList());
        for (Temporal newStart : newStarts) {
            Temporal newEnd = newStart.plus(duration);
            Triple firstConflict = eventTimes.stream().filter(triple -> {
                boolean newStartBeforeEnd = DateTimeUtilities.isBefore(newStart, triple.end);
                boolean newEndAfterStart = DateTimeUtilities.isAfter(newEnd, triple.start);
                return newStartBeforeEnd && newEndAfterStart;
            }).findAny().orElseGet(() -> null);
            if (firstConflict == null) continue;
            String uid = firstConflict.uid != null ? firstConflict.uid + ", " : "";
            return firstConflict == null ? null : uid + DateTimeUtilities.temporalToString(firstConflict.start);
        }
        return null;
    }

    public static int weekOrdinalInMonth(Temporal dateBasedTemporal) {
        Temporal start = dateBasedTemporal.with(TemporalAdjusters.firstDayOfMonth());
        int ordinalWeekNumber = 0;
        while (!DateTimeUtilities.isBefore(dateBasedTemporal, start)) {
            ++ordinalWeekNumber;
            start = start.plus(1L, ChronoUnit.WEEKS);
        }
        return ordinalWeekNumber;
    }

    public static TemporalAmount temporalAmountBetween(Temporal startInclusive, Temporal endExclusive) {
        TemporalAmount duration = startInclusive instanceof LocalDate || endExclusive instanceof LocalDate ? Period.between(LocalDate.from(startInclusive), LocalDate.from(endExclusive)) : Duration.between(startInclusive, endExclusive);
        return duration;
    }

    public static String temporalToString(Temporal temporal) {
        if (temporal instanceof ZonedDateTime) {
            ZonedDateTime value = (ZonedDateTime)temporal;
            ZoneId z = value.getZone();
            if (z.normalized().equals(ZoneOffset.UTC)) {
                return ZONED_DATE_TIME_UTC_FORMATTER.format(value);
            }
            return LOCAL_DATE_TIME_FORMATTER.format(value);
        }
        if (temporal instanceof LocalDateTime) {
            LocalDateTime value = (LocalDateTime)temporal;
            return LOCAL_DATE_TIME_FORMATTER.format(value);
        }
        if (temporal instanceof LocalDate) {
            return LOCAL_DATE_FORMATTER.format(temporal);
        }
        if (temporal != null) {
            throw new DateTimeException("Unsuported Date-Time class:" + temporal.getClass().getSimpleName());
        }
        return null;
    }

    public static Temporal temporalFromString(String string) {
        List<Pair<String, String>> list = ICalendarUtilities.parseInlineElementsToListPair(string);
        Map<String, String> map = list.stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue()));
        StringBuilder builder = new StringBuilder(50);
        String value = map.get(":");
        if (map.get(VParameterElement.TIME_ZONE_IDENTIFIER.toString()) != null && value.charAt(value.length() - 1) != 'Z') {
            builder.append("[");
            builder.append(map.get(VParameterElement.TIME_ZONE_IDENTIFIER.toString()));
            builder.append("]");
        }
        builder.append(value);
        String string2 = builder.toString();
        String form0 = "^[0-9]{8}";
        String form1 = "^[0-9]{8}T([0-9]{6})";
        String form2 = "^[0-9]{8}T([0-9]{6})Z";
        String form3 = "^(\\[.*/.*\\])[0-9]{8}T([0-9]{6}Z?)";
        if (string2.matches("^[0-9]{8}")) {
            return LocalDate.parse(string2, LOCAL_DATE_FORMATTER);
        }
        if (string2.matches("^[0-9]{8}T([0-9]{6})")) {
            return LocalDateTime.parse(string2, LOCAL_DATE_TIME_FORMATTER);
        }
        if (string2.matches("^[0-9]{8}T([0-9]{6})Z")) {
            return ZonedDateTime.parse(string2, ZONED_DATE_TIME_UTC_FORMATTER);
        }
        if (string2.matches("^(\\[.*/.*\\])[0-9]{8}T([0-9]{6}Z?)")) {
            return ZonedDateTime.parse(string2, ZONED_DATE_TIME_FORMATTER);
        }
        throw new DateTimeException("Can't parse date-time string:" + string);
    }

    public static DayOfWeek dayOfWeekFromAbbreviation(String dayOfWeekAbbreviation) {
        Optional<DayOfWeek> optional = Arrays.stream(DayOfWeek.values()).filter(d -> d.toString().substring(0, 2).equals(dayOfWeekAbbreviation.toUpperCase())).findAny();
        return optional.isPresent() ? optional.get() : null;
    }

    @Deprecated
    public static LocalDateTime toLocalDateTime(Temporal temporal) {
        return (LocalDateTime)DateTimeType.DATE_WITH_LOCAL_TIME.from(temporal);
    }

    public static enum DateTimeType {
        DATE("^[0-9]{8}"){

            @Override
            public Temporal from(Temporal temporal, ZoneId zone) {
                return this.from(temporal);
            }

            @Override
            public Temporal from(Temporal temporal) {
                switch (DateTimeType.of(temporal)) {
                    case DATE: {
                        return temporal;
                    }
                    case DATE_WITH_LOCAL_TIME: {
                        return LocalDate.from(temporal);
                    }
                    case DATE_WITH_LOCAL_TIME_AND_TIME_ZONE: 
                    case DATE_WITH_UTC_TIME: {
                        return ZonedDateTime.from(temporal).withZoneSameInstant(DEFAULT_ZONE).toLocalDate();
                    }
                }
                throw new DateTimeException("Unsupported Temporal class:" + temporal.getClass().getSimpleName());
            }

            @Override
            boolean is(Temporal temporal) {
                return temporal instanceof LocalDate;
            }

            @Override
            public Temporal parse(String temporalString, ZoneId zone) {
                if (temporalString.matches(this.getPattern())) {
                    return LocalDate.parse(temporalString, LOCAL_DATE_FORMATTER);
                }
                return null;
            }
        }
        ,
        DATE_WITH_LOCAL_TIME("^[0-9]{8}T([0-9]{6})"){

            @Override
            public Temporal from(Temporal temporal, ZoneId zone) {
                return this.from(temporal);
            }

            @Override
            public Temporal from(Temporal temporal) {
                switch (DateTimeType.of(temporal)) {
                    case DATE: {
                        return LocalDate.from(temporal).atStartOfDay();
                    }
                    case DATE_WITH_LOCAL_TIME: {
                        return temporal;
                    }
                    case DATE_WITH_LOCAL_TIME_AND_TIME_ZONE: 
                    case DATE_WITH_UTC_TIME: {
                        return ZonedDateTime.from(temporal).withZoneSameInstant(DEFAULT_ZONE).toLocalDateTime();
                    }
                }
                throw new DateTimeException("Unsupported Temporal class:" + temporal.getClass().getSimpleName());
            }

            @Override
            boolean is(Temporal temporal) {
                return temporal instanceof LocalDateTime;
            }

            @Override
            public Temporal parse(String temporalString, ZoneId zone) {
                boolean isTzidEmpty = zone == null;
                boolean isPatternMatch = temporalString.matches(this.getPattern());
                if (isTzidEmpty && isPatternMatch) {
                    return LocalDateTime.parse(temporalString, LOCAL_DATE_TIME_FORMATTER);
                }
                return null;
            }
        }
        ,
        DATE_WITH_UTC_TIME("^[0-9]{8}T([0-9]{6})Z"){

            @Override
            public Temporal from(Temporal temporal, ZoneId zone) {
                return this.from(temporal);
            }

            @Override
            public Temporal from(Temporal temporal) {
                switch (DateTimeType.of(temporal)) {
                    case DATE: {
                        return LocalDate.from(temporal).atStartOfDay().atZone(ZoneId.of("Z"));
                    }
                    case DATE_WITH_LOCAL_TIME: {
                        return LocalDateTime.from(temporal).atZone(DEFAULT_ZONE).withZoneSameInstant(ZoneId.of("Z"));
                    }
                    case DATE_WITH_LOCAL_TIME_AND_TIME_ZONE: {
                        return ZonedDateTime.from(temporal).withZoneSameInstant(ZoneId.of("Z"));
                    }
                    case DATE_WITH_UTC_TIME: {
                        return temporal;
                    }
                }
                throw new DateTimeException("Unsupported Temporal class:" + temporal.getClass().getSimpleName());
            }

            @Override
            boolean is(Temporal temporal) {
                if (temporal instanceof ZonedDateTime) {
                    ZoneId z = ((ZonedDateTime)temporal).getZone();
                    return z == ZoneId.of("Z");
                }
                return false;
            }

            @Override
            public Temporal parse(String temporalString, ZoneId zone) {
                boolean isPatternMatch = temporalString.matches(this.getPattern());
                if (isPatternMatch) {
                    return ZonedDateTime.parse(temporalString, ZONED_DATE_TIME_UTC_FORMATTER);
                }
                return null;
            }
        }
        ,
        DATE_WITH_LOCAL_TIME_AND_TIME_ZONE("^[0-9]{8}T([0-9]{6})Z?"){

            @Override
            public Temporal from(Temporal temporal, ZoneId zone) {
                switch (DateTimeType.of(temporal)) {
                    case DATE: {
                        return LocalDate.from(temporal).atStartOfDay().atZone(zone);
                    }
                    case DATE_WITH_LOCAL_TIME: {
                        return LocalDateTime.from(temporal).atZone(zone);
                    }
                    case DATE_WITH_LOCAL_TIME_AND_TIME_ZONE: 
                    case DATE_WITH_UTC_TIME: {
                        return ZonedDateTime.from(temporal).withZoneSameInstant(zone);
                    }
                }
                throw new DateTimeException("Unsupported Temporal class:" + temporal.getClass().getSimpleName());
            }

            @Override
            public Temporal from(Temporal temporal) {
                throw new DateTimeException("Can't make DATE_WITH_LOCAL_TIME_AND_TIME_ZONE without time zone.  Use from(Temporal temporal, ZoneId zone) instead");
            }

            @Override
            boolean is(Temporal temporal) {
                return temporal instanceof ZonedDateTime;
            }

            @Override
            public Temporal parse(String temporalString, ZoneId zone) {
                boolean isTzidEmpty = zone == null;
                boolean isPatternMatch = temporalString.matches(this.getPattern());
                if (!isTzidEmpty && isPatternMatch) {
                    LocalDateTime localDateTime = LocalDateTime.parse(temporalString, LOCAL_DATE_TIME_FORMATTER);
                    return localDateTime.atZone(zone);
                }
                return null;
            }
        };

        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        private DateTimeType(String pattern) {
            this.pattern = pattern;
        }

        public static DateTimeType of(Temporal temporal) {
            return Arrays.stream(DateTimeType.values()).filter(d -> d.is(temporal)).findFirst().get();
        }

        abstract boolean is(Temporal var1);

        public abstract Temporal parse(String var1, ZoneId var2);

        public abstract Temporal from(Temporal var1, ZoneId var2);

        public abstract Temporal from(Temporal var1);
    }

    private static class Triple {
        Temporal start;
        Temporal end;
        String uid;

        public Triple(Temporal start, Temporal end, String uid) {
            this.start = start;
            this.end = end;
            this.uid = uid;
        }
    }
}

