/* The following code was generated by JFlex 1.4.3-fixes on 12/9/13 7:49 AM */

package jodd.lagarto;

import java.nio.CharBuffer;

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3-fixes
 * on 12/9/13 7:49 AM from the specification file
 * <tt>lexer.flex</tt>
 */
abstract class Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 8192;

  /** lexical states */
  public static final int SCRIPT = 8;
  public static final int YYINITIAL = 0;
  public static final int STYLE = 10;
  public static final int ATTR = 4;
  public static final int XML_DECLARATION = 12;
  public static final int XMP = 6;
  public static final int TAG = 2;
  public static final int DOCTYPE = 14;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\10\0\2\23\1\23\1\0\2\23\22\0\1\23\1\2\1\34\4\0"+
    "\1\31\5\0\1\10\1\0\1\32\14\0\1\1\1\33\1\7\1\22"+
    "\1\0\1\21\1\0\1\15\1\13\1\11\1\5\2\0\1\4\2\0"+
    "\1\30\1\25\1\12\1\14\1\20\1\0\1\27\1\26\1\16\3\0"+
    "\1\24\1\17\1\0\1\3\1\0\1\6\3\0\1\21\1\0\1\15"+
    "\1\13\1\11\1\5\2\0\1\4\2\0\1\30\1\25\1\12\1\14"+
    "\1\20\1\0\1\27\1\26\1\16\3\0\1\24\1\17\uff86\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\6\0\1\2\1\3\1\1\1\4\1\5"+
    "\2\1\1\6\1\7\1\10\1\6\1\7\1\11\1\12"+
    "\7\7\1\13\1\7\1\0\1\14\3\1\1\15\1\0"+
    "\1\16\13\0\1\6\3\0\1\17\2\1\10\0\2\1"+
    "\12\0\1\1\1\20\12\0\1\21\1\22\2\0\1\23"+
    "\4\0\1\24\11\0\1\25\1\26\6\0\1\27\2\0"+
    "\1\26\2\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\35\0\72\0\127\0\164\0\221\0\256\0\313"+
    "\0\350\0\u0105\0\u0122\0\u013f\0\u015c\0\u0179\0\u0196\0\u01b3"+
    "\0\u013f\0\u013f\0\u01d0\0\u01ed\0\u013f\0\u013f\0\u020a\0\u0227"+
    "\0\u0244\0\u0261\0\u027e\0\u029b\0\u02b8\0\u013f\0\u02d5\0\u02f2"+
    "\0\u013f\0\u030f\0\u032c\0\u0349\0\u013f\0\u01ed\0\u013f\0\u020a"+
    "\0\u0227\0\u0244\0\u0366\0\u0261\0\u027e\0\u0383\0\u029b\0\u02b8"+
    "\0\u03a0\0\u02d5\0\u013f\0\u03bd\0\u03da\0\u03f7\0\u0122\0\u0414"+
    "\0\u0431\0\u044e\0\u046b\0\u0488\0\u04a5\0\u04c2\0\u04df\0\u04fc"+
    "\0\u0519\0\u0536\0\u0553\0\u0570\0\u058d\0\u05aa\0\u05c7\0\u05e4"+
    "\0\u0601\0\u061e\0\u063b\0\u0658\0\u0675\0\u0692\0\u0122\0\u06af"+
    "\0\u06cc\0\u06e9\0\u0706\0\u0723\0\u0740\0\u075d\0\u077a\0\u0797"+
    "\0\u07b4\0\u0122\0\u013f\0\u07d1\0\u07ee\0\u013f\0\u080b\0\u0828"+
    "\0\u0845\0\u0862\0\u013f\0\u087f\0\u089c\0\u08b9\0\u08d6\0\u08f3"+
    "\0\u0910\0\u092d\0\u094a\0\u0967\0\u013f\0\u013f\0\u0984\0\u09a1"+
    "\0\u09be\0\u09db\0\u09f8\0\u0a15\0\u013f\0\u0a32\0\u0a4f\0\u063b"+
    "\0\u0a6c\0\u0a89";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int ZZ_TRANS [] = {
    8, 9, 8, 8, 8, 8, 8, 8, 8, 8, 
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
    8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 
    10, 10, 10, 10, 10, 11, 11, 10, 10, 10, 
    10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 
    10, 14, 10, 10, 11, 11, 11, 11, 15, 15, 
    15, 15, 15, 15, 16, 17, 15, 15, 15, 15, 
    15, 15, 15, 15, 15, 15, 18, 12, 15, 15, 
    15, 15, 15, 19, 20, 21, 22, 23, 24, 23, 
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 
    23, 23, 23, 23, 23, 23, 25, 26, 25, 25, 
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
    25, 25, 25, 25, 25, 27, 28, 27, 27, 27, 
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 
    27, 27, 27, 27, 16, 16, 16, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
    16, 16, 16, 15, 15, 15, 15, 15, 15, 16, 
    29, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
    15, 15, 12, 15, 15, 15, 15, 15, 16, 16, 
    16, 30, 8, -1, 8, 8, 8, 8, 8, 8, 
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
    8, -1, -1, 31, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 
    10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 
    10, 10, 10, 10, 10, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 12, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 
    10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 
    10, 10, 10, 10, 10, -1, -1, 10, 33, 10, 
    10, 10, -1, -1, -1, -1, 10, 10, 10, 10, 
    10, 10, -1, -1, 10, 10, 10, 10, 10, 34, 
    35, 10, 10, 10, -1, -1, 10, 10, 10, 10, 
    10, -1, -1, -1, -1, 15, 15, 15, 15, 15, 
    15, -1, -1, 15, 15, 15, 15, 15, 15, 15, 
    15, 15, 15, 15, -1, 15, 15, 15, 15, 15, 
    15, -1, -1, 15, 15, 15, 15, 15, 15, 15, 
    -1, 36, 15, 15, 15, 15, 15, 15, 15, 15, 
    15, 15, 15, -1, 15, 15, 15, 15, 15, 15, 
    -1, -1, 15, 37, 37, 37, 37, 37, 37, 37, 
    37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 
    37, 37, 37, 37, 37, 37, 37, 37, 38, 37, 
    37, 37, 39, 39, 39, 39, 39, 39, 39, 39, 
    39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 
    39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 
    38, 40, 41, 40, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 42, 40, 40, 43, 
    44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 44, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 45, 43, 43, 46, 47, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 47, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 48, 46, 46, 49, 49, 49, 49, 49, 
    49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 
    49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 
    49, 49, 49, 50, -1, -1, -1, 51, -1, -1, 
    -1, -1, 52, -1, -1, 53, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, 
    -1, 10, 10, 10, 10, 10, 10, 10, 10, 54, 
    10, -1, -1, 10, 10, 10, 10, 10, -1, -1, 
    -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
    -1, -1, 10, 10, 10, 55, 10, -1, -1, -1, 
    -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 
    10, 10, 10, 10, 10, 10, 56, 10, 10, -1, 
    -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 
    40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
    57, 40, 40, 40, 40, 40, 40, 40, 40, 43, 
    44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 58, 43, 43, 43, 43, 43, 43, 46, 47, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    59, 46, 46, 46, 46, 46, 46, -1, -1, -1, 
    -1, 60, -1, -1, -1, -1, 61, -1, -1, -1, 
    62, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 63, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 64, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 10, 10, 10, 10, 65, 10, 
    -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 
    10, 10, -1, -1, 10, 10, 10, 10, 10, -1, 
    -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, 
    -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
    10, -1, -1, 10, 10, 10, 10, 66, -1, -1, 
    -1, -1, 40, 41, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 67, 40, 40, 40, 40, 40, 40, 
    40, 43, 44, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 68, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 69, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, -1, 
    -1, -1, -1, -1, 70, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 71, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 72, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 63, 73, 63, 63, 
    63, 63, 63, 74, 75, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 76, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, 
    -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 
    77, 10, -1, -1, 10, 10, 10, 10, 10, -1, 
    -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, 
    -1, 10, 78, 10, 10, 10, 10, 10, 10, 10, 
    10, -1, -1, 10, 10, 10, 10, 10, -1, -1, 
    -1, -1, 40, 41, 40, 40, 40, 40, 40, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 79, 40, 
    40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 
    40, 43, 44, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 80, 43, 43, 43, 43, 43, 
    46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 81, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 70, 
    70, 70, 70, 70, 70, 82, 70, 70, 70, 70, 
    70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 
    70, 70, 70, 70, 70, 70, 70, 70, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 83, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 84, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 63, 73, 85, 63, 
    63, 63, 63, 74, 75, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 74, 74, 74, 74, 74, 
    74, 74, 74, 86, 74, 74, 74, 74, 74, 74, 
    74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 
    74, 74, 74, 74, 63, 73, 63, 63, 63, 63, 
    63, 74, 87, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 88, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 
    10, 10, 10, 10, 10, 10, 89, 10, 10, 10, 
    -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, 
    -1, 79, 79, 79, 79, 79, 79, 79, 90, 79, 
    79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 
    79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 
    43, 44, 43, 43, 91, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 46, 
    47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 92, 46, 46, 46, 46, -1, -1, 
    -1, -1, -1, -1, -1, 93, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    95, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 63, 73, 63, 96, 63, 
    63, 63, 74, 75, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 74, 74, 74, 74, 74, 74, 
    74, 74, 97, 74, 74, 74, 74, 74, 74, 74, 
    74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 
    74, 74, 74, 63, 73, 63, 63, 63, 63, 63, 
    98, 87, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 99, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 43, 44, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 100, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    46, 47, 46, 46, 46, 46, 46, 46, 46, 79, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 
    46, 46, 46, 46, 46, 46, 46, 46, 46, -1, 
    -1, -1, -1, -1, 101, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 102, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, 63, 73, 63, 
    63, 63, 63, 63, 74, 75, 103, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 74, 74, 74, 74, 
    74, 74, 74, 98, 97, 74, 74, 74, 74, 74, 
    74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 
    74, 74, 74, 74, 74, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 104, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, 43, 44, 43, 43, 43, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 79, 43, 
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
    43, 43, 43, -1, -1, -1, -1, -1, -1, 105, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 106, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 63, 73, 63, 63, 63, 63, 63, 74, 75, 
    63, 107, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, 109, 110, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, 106, 106, 
    106, 106, 106, 106, 111, 106, 106, 106, 106, 106, 
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 
    106, 106, 106, 106, 106, 106, 106, 63, 73, 63, 
    63, 63, 63, 63, 74, 75, 63, 63, 112, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, -1, -1, -1, -1, 
    -1, -1, -1, -1, 113, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, 106, 106, 106, 106, 106, 
    106, 114, 106, 106, 106, 106, 106, 106, 106, 106, 
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 
    106, 106, 106, 106, 63, 73, 63, 63, 115, 63, 
    63, 74, 75, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, -1, -1, -1, -1, -1, -1, -1, 
    109, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, -1, 106, 106, 106, 106, 106, 106, 114, 116, 
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 
    106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 
    106, 63, 73, 63, 63, 63, 117, 63, 74, 75, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 73, 63, 63, 63, 63, 118, 74, 75, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    73, 63, 63, 63, 63, 63, 119, 120, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 73, 
    63, 63, 63, 63, 63, 74, 121, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 73, 63, 
    63, 63, 63, 63, 109, 87, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 
    63, 63, 63, 63, 63, 63
  };

  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\1\6\0\3\1\1\11\4\1\2\11\2\1"+
    "\2\11\7\1\1\11\1\1\1\0\1\11\3\1\1\11"+
    "\1\0\1\11\13\0\1\11\3\0\3\1\10\0\2\1"+
    "\12\0\2\1\12\0\1\1\1\11\2\0\1\11\4\0"+
    "\1\11\11\0\2\11\6\0\1\11\2\0\1\1\2\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[122];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private char[] zzChars;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	// position methods
	public int position() { return yychar; }
	public int length()   { return yylength(); }
	public int line()     { return -1; /*yyline;*/ }   	// for debugging
	public int column()   { return -1; /*yycolumn;*/ } 	// for debugging

	// state methods
	void stateReset() 	{ yybegin(YYINITIAL); }
	void stateTag()		{ yybegin(TAG); }
	void stateAttr()		{ yybegin(ATTR); }
	void stateXmp() 		{ yybegin(XMP); }
	void stateScript()   { yybegin(SCRIPT); }
	void stateStyle()    { yybegin(STYLE); }
	void stateDoctype()  { yybegin(DOCTYPE); }

	// fast methods
	public final CharSequence xxtext() {
		return CharBuffer.wrap(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
	}
	public final String yytext(int startIndex) {
		startIndex += zzStartRead;
		return new String(zzBuffer, startIndex, zzMarkedPos - startIndex);
	}
	public final String yytext(int startIndex, int endIndexOffset) {
		startIndex += zzStartRead;
		return new String(zzBuffer, startIndex, zzMarkedPos - endIndexOffset - startIndex);
	}

	int nextTagState;
	int getNextTagState() {
		return nextTagState;
	}

	boolean parseSpecialTagsAsCdata = true;
	public void setParseSpecialTagsAsCdata(boolean parseSpecialTagsAsCdata) {
		this.parseSpecialTagsAsCdata = parseSpecialTagsAsCdata;
	}

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 138) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Creates a new scanner.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Lexer(char[] input) {
    this.zzChars = input;
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   */
  private boolean zzRefill() {
    if (zzBuffer == null) {
        zzBuffer = zzChars;
        zzEndRead += zzChars.length;
        return false;
    }
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 8: 
          { yybegin(nextTagState); return Token.GT;
          }
        case 24: break;
        case 23: 
          { return Token.CDATA;
          }
        case 25: break;
        case 13: 
          { stateReset(); return Token.XML_GT;
          }
        case 26: break;
        case 4: 
          { yypushback(1); stateAttr(); return Token.WHITESPACE;
          }
        case 27: break;
        case 16: 
          { if (parseSpecialTagsAsCdata) nextTagState = STYLE; stateAttr(); return Token.WORD;
          }
        case 28: break;
        case 14: 
          { return Token.QUOTE;
          }
        case 29: break;
        case 17: 
          { if (parseSpecialTagsAsCdata) nextTagState = SCRIPT; stateAttr(); return Token.WORD;
          }
        case 30: break;
        case 6: 
          { return Token.WORD;
          }
        case 31: break;
        case 9: 
          { return Token.SLASH;
          }
        case 32: break;
        case 12: 
          { nextTagState = YYINITIAL; stateTag(); return Token.XML_LT;
          }
        case 33: break;
        case 18: 
          { stateReset(); return Token.TEXT;
          }
        case 34: break;
        case 10: 
          { return Token.EQUALS;
          }
        case 35: break;
        case 5: 
          { return Token.WHITESPACE;
          }
        case 36: break;
        case 15: 
          { if (parseSpecialTagsAsCdata) nextTagState = XMP; stateAttr(); return Token.WORD;
          }
        case 37: break;
        case 2: 
          { return Token.TEXT;
          }
        case 38: break;
        case 22: 
          { return Token.CONDITIONAL_COMMENT_END;
          }
        case 39: break;
        case 21: 
          { stateDoctype(); return Token.DOCTYPE;
          }
        case 40: break;
        case 3: 
          { nextTagState = YYINITIAL; stateTag(); return Token.LT;
          }
        case 41: break;
        case 11: 
          { stateReset(); return Token.GT;
          }
        case 42: break;
        case 7: 
          { throw new LagartoException("Illegal character ["+ yytext() + ']', yystate(), line(), column());
          }
        case 43: break;
        case 19: 
          { return Token.CONDITIONAL_COMMENT_START;
          }
        case 44: break;
        case 20: 
          { return Token.COMMENT;
          }
        case 45: break;
        case 1: 
          { stateAttr(); return Token.WORD;
          }
        case 46: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {
                return Token.EOF;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
