/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jodd.lagarto.LagartoParserContext;
import jodd.lagarto.dom.LagartoNodeHtmlRenderer;
import jodd.lagarto.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends Node {
    protected long elapsedTime;
    protected final boolean lowercase;
    protected final boolean collectErrors;
    protected final LagartoNodeHtmlRenderer renderer;
    protected List<String> errors;
    protected LagartoParserContext parserContext;

    public Document() {
        this(true, false, new LagartoNodeHtmlRenderer(), null);
    }

    public Document(boolean lowercase, boolean collectErrors, LagartoNodeHtmlRenderer renderer, LagartoParserContext parserContext) {
        super(null, Node.NodeType.DOCUMENT, null);
        this.lowercase = lowercase;
        this.renderer = renderer;
        this.collectErrors = collectErrors;
        this.elapsedTime = System.currentTimeMillis();
        this.parserContext = parserContext;
    }

    @Override
    public Document clone() {
        Document document = this.cloneTo(new Document(this.lowercase, this.collectErrors, this.renderer, this.parserContext));
        document.elapsedTime = this.elapsedTime;
        return document;
    }

    protected void end() {
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
    }

    @Override
    public void toHtml(Appendable appendable) throws IOException {
        super.toInnerHtml(appendable);
    }

    public void addError(String message) {
        if (this.collectErrors) {
            if (this.errors == null) {
                this.errors = new ArrayList<String>();
            }
            this.errors.add(message);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public boolean isLowercase() {
        return this.lowercase;
    }

    public boolean isCollectErrors() {
        return this.collectErrors;
    }

    public LagartoNodeHtmlRenderer getRenderer() {
        return this.renderer;
    }

    public int getCurrentOffset() {
        if (this.parserContext == null) {
            return -1;
        }
        return this.parserContext.getOffset();
    }
}

