/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import jodd.core.JoddCore;
import jodd.io.findfile.ClassFinder;
import jodd.io.findfile.ClassScanner;
import jodd.props.PropertiesToProps;
import jodd.props.Props;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropsUtil {
    public static void loadFromClasspath(final Props p, String ... patterns) {
        ClassScanner scanner = new ClassScanner(){

            protected void onEntry(ClassFinder.EntryData entryData) throws IOException {
                String encoding = JoddCore.encoding;
                if (StringUtil.endsWithIgnoreCase((String)entryData.getName(), (String)".properties")) {
                    encoding = "ISO-8859-1";
                }
                p.load(entryData.openInputStream(), encoding);
            }
        };
        scanner.setIncludeResources(true);
        scanner.setIgnoreException(true);
        scanner.setExcludeAllEntries(true);
        scanner.setIncludedEntries(patterns);
        scanner.scanDefaultClasspath();
    }

    public static Props createFromClasspath(String ... patterns) {
        Props p = new Props();
        PropsUtil.loadFromClasspath(p, patterns);
        return p;
    }

    public static void convert(Writer writer, Properties properties) throws IOException {
        Map<String, Properties> emptyProfiles = Collections.emptyMap();
        PropsUtil.convert(writer, properties, emptyProfiles);
    }

    public static void convert(Writer writer, Properties properties, Map<String, Properties> profiles) throws IOException {
        PropertiesToProps toProps = new PropertiesToProps();
        toProps.convertToWriter(writer, properties, profiles);
    }
}

