/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.history;

import javax.management.MalformedObjectNameException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.service.history.HistoryKey;
import org.jolokia.service.history.HistoryLimit;
import org.jolokia.service.history.HistoryMBean;
import org.jolokia.service.history.HistoryStore;
import org.json.simple.JSONObject;

public class History
implements HistoryMBean {
    private HistoryStore store;

    public History(HistoryStore pStore) {
        this.store = pStore;
    }

    public void updateAndAdd(JolokiaRequest pJmxReq, JSONObject pJson) {
        this.store.updateAndAdd(pJmxReq, pJson);
    }

    public void setHistoryEntriesForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        this.setHistoryLimitForAttribute(pMBean, pAttribute, pPath, pTarget, pMaxEntries, 0L);
    }

    public void setHistoryLimitForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries, long pMaxDuration) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pAttribute, pPath, pTarget);
        this.store.configure(key, this.limitOrNull(pMaxEntries, pMaxDuration));
    }

    public void setHistoryEntriesForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries) throws MalformedObjectNameException {
        this.setHistoryLimitForOperation(pMBean, pOperation, pTarget, pMaxEntries, 0L);
    }

    public void setHistoryLimitForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries, long pMaxDuration) throws MalformedObjectNameException {
        HistoryKey key = new HistoryKey(pMBean, pOperation, pTarget);
        this.store.configure(key, this.limitOrNull(pMaxEntries, pMaxDuration));
    }

    public void resetHistoryEntries() {
        this.store.reset();
    }

    public int getHistoryMaxEntries() {
        return this.store.getGlobalMaxEntries();
    }

    public void setHistoryMaxEntries(int pLimit) {
        this.store.setGlobalMaxEntries(pLimit);
    }

    public int getHistorySize() {
        return this.store.getSize();
    }

    private HistoryLimit limitOrNull(int pMaxEntries, long pMaxDuration) {
        return pMaxEntries != 0 || pMaxDuration != 0L ? new HistoryLimit(pMaxEntries, pMaxDuration) : null;
    }
}

