/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.history;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.service.history.History;
import org.jolokia.service.history.HistoryStore;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryMBeanRequestInterceptor
extends AbstractJolokiaService<RequestInterceptor>
implements RequestInterceptor {
    private ObjectName historyObjectName;

    public HistoryMBeanRequestInterceptor(int pOrderId) {
        super(RequestInterceptor.class, pOrderId);
    }

    public void init(JolokiaContext pCtx) {
        if (this.getJolokiaContext() == null) {
            super.init(pCtx);
            int maxEntries = this.getMaxEntries(pCtx);
            HistoryStore historyStore = new HistoryStore(maxEntries);
            History history = new History(historyStore);
            this.historyObjectName = this.registerJolokiaMBean("jolokia:type=Config", history);
        }
    }

    public void destroy() throws Exception {
        if (this.getJolokiaContext() != null) {
            this.unregisterJolokiaMBean(this.historyObjectName);
        }
        super.destroy();
    }

    public void intercept(JolokiaRequest pJmxReq, JSONObject pJson) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            if (this.historyObjectName != null) {
                mBeanServer.invoke(this.historyObjectName, "updateAndAdd", new Object[]{pJmxReq, pJson}, new String[]{JolokiaRequest.class.getName(), JSONObject.class.getName()});
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanException e) {
            throw new IllegalStateException("Internal: Cannot update History store", e);
        }
        catch (ReflectionException e) {
            throw new IllegalStateException("Internal: Cannot call History MBean via reflection", e);
        }
    }

    private int getMaxEntries(JolokiaContext pCtx) {
        int maxEntries;
        try {
            maxEntries = Integer.parseInt(pCtx.getConfig(ConfigKey.HISTORY_MAX_ENTRIES));
        }
        catch (NumberFormatException exp) {
            maxEntries = Integer.parseInt(ConfigKey.HISTORY_MAX_ENTRIES.getDefaultValue());
        }
        return maxEntries;
    }
}

