/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jsr160;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.AbstractRequestHandler;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.core.util.jmx.SingleMBeanServerAccess;
import org.jolokia.service.jmx.api.CommandHandler;
import org.jolokia.service.jmx.api.CommandHandlerManager;
import org.jolokia.service.jsr160.ProxyTargetConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr160RequestHandler
extends AbstractRequestHandler {
    private CommandHandlerManager commandHandlerManager;

    public Jsr160RequestHandler(int pOrder) {
        super("proxy", pOrder);
    }

    public void init(JolokiaContext pContext) {
        this.commandHandlerManager = new CommandHandlerManager(pContext, this.getRealm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends JolokiaRequest> Object handleRequest(R pJmxReq, Object pPreviousResult) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException, NotChangedException, EmptyResponseException {
        CommandHandler handler = this.commandHandlerManager.getCommandHandler(pJmxReq.getType());
        JMXConnector connector = null;
        try {
            connector = this.createConnector(pJmxReq);
            connector.connect();
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            if (handler.handleAllServersAtOnce(pJmxReq)) {
                SingleMBeanServerAccess manager = new SingleMBeanServerAccess(connection);
                Object object = handler.handleAllServerRequest((MBeanServerAccess)manager, pJmxReq, pPreviousResult);
                return object;
            }
            Object object = handler.handleSingleServerRequest(connection, pJmxReq);
            return object;
        }
        finally {
            this.releaseConnector(connector);
        }
    }

    private JMXConnector createConnector(JolokiaRequest pJmxReq) throws IOException {
        ProxyTargetConfig targetConfig = new ProxyTargetConfig((Map)pJmxReq.getOption("target"));
        String urlS = targetConfig.getUrl();
        JMXServiceURL url = new JMXServiceURL(urlS);
        Map<String, Object> env = this.prepareEnv(targetConfig.getEnv());
        return JMXConnectorFactory.newJMXConnector(url, env);
    }

    private void releaseConnector(JMXConnector pConnector) throws IOException {
        if (pConnector != null) {
            pConnector.close();
        }
    }

    protected Map<String, Object> prepareEnv(Map<String, String> pTargetConfig) {
        if (pTargetConfig == null || pTargetConfig.size() == 0) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(pTargetConfig);
        String user = (String)ret.remove("user");
        String password = (String)ret.remove("password");
        if (user != null && password != null) {
            ret.put("java.naming.security.principal", user);
            ret.put("java.naming.security.credentials", password);
            ret.put("jmx.remote.credentials", new String[]{user, password});
        }
        return ret;
    }

    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        return pJolokiaRequest.getOption("target") != null;
    }

    public String getRealm() {
        return "proxy";
    }

    public Object getRuntimeInfo() {
        return null;
    }

    public void destroy() throws JMException {
        this.commandHandlerManager.destroy();
    }
}

