/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.io.ByteArrayOutputStream;
import org.jruby.compiler.Compilable;
import org.jruby.compiler.JITCompiler;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

class FullBuildTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FullBuildTask.class);
    private final JITCompiler jitCompiler;
    private final Compilable<InterpreterContext> method;

    FullBuildTask(JITCompiler jitCompiler, Compilable<InterpreterContext> method2) {
        this.jitCompiler = jitCompiler;
        this.method = method2;
    }

    @Override
    public void run() {
        block5: {
            try {
                IRScope hardScope = this.method.getIRScope().getNearestTopLocalVariableScope();
                if (hardScope != this.method.getIRScope()) {
                    hardScope.prepareFullBuild();
                }
                this.method.completeBuild(this.method.getIRScope().prepareFullBuild());
                if (IRRuntimeHelpers.shouldPrintIR(this.jitCompiler.runtime)) {
                    ByteArrayOutputStream baos = IRDumper.printIR(this.method.getIRScope(), true, true);
                    LOG.info("Printing full IR for " + this.method.getIRScope().getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
                }
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.method, this.method.getName(), "done building", new Object[0]);
                }
            }
            catch (Throwable t) {
                if (!this.jitCompiler.config.isJitLogging() || !this.jitCompiler.config.isJitLoggingVerbose()) break block5;
                t.printStackTrace();
            }
        }
    }
}

