/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BSwitchInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildBackrefInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadBlockImplicitClosureInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBackrefFrameInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopBlockFrameInstr;
import org.jruby.ir.instructions.PopMethodFrameInstr;
import org.jruby.ir.instructions.PrepareBlockArgsInstr;
import org.jruby.ir.instructions.PrepareFixedBlockArgsInstr;
import org.jruby.ir.instructions.PrepareNoBlockArgsInstr;
import org.jruby.ir.instructions.PrepareSingleBlockArgInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushBackrefFrameInstr;
import org.jruby.ir.instructions.PushBlockBindingInstr;
import org.jruby.ir.instructions.PushBlockFrameInstr;
import org.jruby.ir.instructions.PushMethodBindingInstr;
import org.jruby.ir.instructions.PushMethodFrameInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordsInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RestoreBindingVisibilityInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ReturnOrRethrowSavedExcInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SaveBindingVisibilityInstr;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.UpdateBlockExecutionStateInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.boxing.AluInstr;
import org.jruby.ir.instructions.boxing.BoxBooleanInstr;
import org.jruby.ir.instructions.boxing.BoxFixnumInstr;
import org.jruby.ir.instructions.boxing.BoxFloatInstr;
import org.jruby.ir.instructions.boxing.UnboxBooleanInstr;
import org.jruby.ir.instructions.boxing.UnboxFixnumInstr;
import org.jruby.ir.instructions.boxing.UnboxFloatInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.BuiltinClass;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.Scope;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.BytecodeMode;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.indy.CallTraceSite;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.DynamicScopeGenerator;
import org.jruby.util.ByteList;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.IntHashMap;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class JVMVisitor
extends IRVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JVMVisitor.class);
    public static final String DYNAMIC_SCOPE = "$dynamicScope";
    private static final boolean DEBUG = false;
    public static final String BLOCK_ARG_NAME = "blockArg";
    public static final String SELF_BLOCK_NAME = "selfBlock";
    public static final String SUPER_NAME_NAME = "superName";
    private static final Signature METHOD_SIGNATURE_BASE = Signature.returning(IRubyObject.class).appendArgs(new String[]{"context", "scope", "self", "blockArg", "class", "superName"}, new Class[]{ThreadContext.class, StaticScope.class, IRubyObject.class, Block.class, RubyModule.class, String.class});
    private static final Signature METHOD_SIGNATURE_VARARGS = METHOD_SIGNATURE_BASE.insertArg("blockArg", "args", IRubyObject[].class);
    public static final Signature CLOSURE_SIGNATURE = Signature.returning(IRubyObject.class).appendArgs(new String[]{"context", "selfBlock", "scope", "self", "args", "blockArg"}, new Class[]{ThreadContext.class, Block.class, StaticScope.class, IRubyObject.class, IRubyObject[].class, Block.class});
    private static final Signature RUN_SIGNATURE = Signature.returning(IRubyObject.class).appendArg("runtime", Ruby.class);
    private static final int MAX_TABLE_SWITCH_SIZE = 33;
    private final BytecodeMode bytecodeMode;
    private final JVM jvm;
    private final Ruby runtime;
    private int methodIndex;
    private final Map<IRClosure, Handle> closuresMap = new HashMap<IRClosure, Handle>();
    final Map<String, StaticScope> staticScopeMap = new HashMap<String, StaticScope>();
    final Map<StaticScope, String> scopeFieldMap = new HashMap<StaticScope, String>();
    final Map<String, String> staticScopeDescriptorMap = new HashMap<String, String>();
    private String file;
    private Instr nextInstr;
    private boolean omitStoreLoad;

    JVMVisitor(Ruby runtime2, BytecodeMode bytecodeMode) {
        this.bytecodeMode = bytecodeMode;
        this.jvm = new JVM();
        this.methodIndex = 0;
        this.runtime = runtime2;
    }

    public static JVMVisitor newForJIT(Ruby runtime2) {
        return new JVMVisitor(runtime2, (java.lang.Boolean)Options.COMPILE_INVOKEDYNAMIC.load() != false ? BytecodeMode.INDY : BytecodeMode.MIXED);
    }

    public static JVMVisitor newForAOT(Ruby runtime2) {
        return new JVMVisitor(runtime2, BytecodeMode.AOT);
    }

    public BytecodeMode getBytecodeMode() {
        return this.bytecodeMode;
    }

    public Class compile(IRScope scope, ClassDefiningClassLoader jrubyClassLoader) {
        this.file = scope.getFile();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        return this.defineFromBytecode(scope, this.compileToBytecode(scope, context), jrubyClassLoader);
    }

    public byte[] compileToBytecode(IRScope scope, JVMVisitorMethodContext context) {
        this.file = scope.getFile();
        this.codegenScope(scope, context);
        return this.code();
    }

    public Class defineFromBytecode(IRScope scope, byte[] code, ClassDefiningClassLoader jrubyClassLoader) {
        return this.defineFromBytecode(scope, code, jrubyClassLoader, true);
    }

    public Class defineScriptFromBytecode(IRScope scope, byte[] code, ClassDefiningClassLoader jrubyClassLoader) {
        return this.defineFromBytecode(scope, code, jrubyClassLoader, (java.lang.Boolean)Options.COMPILE_CACHE_CLASSES.load() == false);
    }

    public Class defineFromBytecode(IRScope scope, byte[] code, ClassDefiningClassLoader jrubyClassLoader, boolean setScopes) {
        this.file = scope.getFile();
        Class<?> result2 = jrubyClassLoader.defineClass(CodegenUtils.c(JVM.scriptToClass(this.file)), code);
        if (setScopes) {
            for (Map.Entry<String, StaticScope> entry : this.staticScopeMap.entrySet()) {
                try {
                    result2.getField(entry.getKey()).set(null, entry.getValue());
                }
                catch (Exception e) {
                    throw new NotCompilableException(e);
                }
            }
        }
        return result2;
    }

    public byte[] code() {
        return this.jvm.toByteCode();
    }

    protected void codegenScope(IRScope scope, JVMVisitorMethodContext context) {
        if (scope instanceof IRScriptBody) {
            this.emitScriptBody((IRScriptBody)scope);
        } else if (scope instanceof IRMethod) {
            this.emitMethodJIT((IRMethod)scope, context);
        } else if (scope instanceof IRClosure) {
            this.emitBlockJIT((IRClosure)scope, context);
        } else if (scope instanceof IRModuleBody) {
            this.emitModuleBodyJIT((IRModuleBody)scope);
        } else {
            throw new NotCompilableException("don't know how to JIT: " + scope);
        }
    }

    protected void emitScope(IRScope scope, String name2, Signature signature, boolean specificArity, boolean print2) {
        BasicBlock[] bbs = scope.prepareForCompilation();
        FullInterpreterContext fullIC = scope.getFullInterpreterContext();
        if (print2 && IRRuntimeHelpers.shouldPrintIR(this.runtime)) {
            ByteArrayOutputStream baos = IRDumper.printIR(scope, true);
            LOG.info("Printing JIT IR for " + scope.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
        }
        Map<BasicBlock, Label> exceptionTable = scope.buildJVMExceptionTable(fullIC);
        String scopeField = name2 + "_StaticScope";
        StaticScope staticScope = this.registerScopeField(scope, scopeField);
        this.emitClosures(scope, print2);
        this.jvm.pushmethod(name2, scope, scopeField, signature, specificArity);
        if (fullIC.needsBinding() || !fullIC.hasExplicitCallProtocol()) {
            this.jvm.methodData().local(DYNAMIC_SCOPE, Type.getType(DynamicScope.class));
        }
        if (!fullIC.hasExplicitCallProtocol()) {
            this.jvmMethod().loadContext();
            this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod((String)"org.jruby.runtime.DynamicScope getCurrentScope()"));
            this.jvmStoreLocal(DYNAMIC_SCOPE);
        } else if (scope instanceof IRClosure) {
            this.jvmAdapter().aconst_null();
            this.jvmStoreLocal(DYNAMIC_SCOPE);
        }
        IRBytecodeAdapter m = this.jvmMethod();
        Label currentRescue = null;
        Label currentRegionStart = null;
        Label currentBlockStart = null;
        HashMap<Label, org.objectweb.asm.Label> rescueEndForStart = new HashMap<Label, org.objectweb.asm.Label>();
        HashMap<Label, org.objectweb.asm.Label> syntheticEndForStart = new HashMap<Label, org.objectweb.asm.Label>();
        for (BasicBlock bb : bbs) {
            currentBlockStart = bb.getLabel();
            Label rescueLabel = exceptionTable.get(bb);
            if (rescueLabel == currentRescue) continue;
            if (currentRescue != null) {
                rescueEndForStart.put(currentRegionStart, this.jvm.methodData().getLabel(bb.getLabel()));
            }
            if (rescueLabel != null) {
                currentRescue = rescueLabel;
                currentRegionStart = bb.getLabel();
                continue;
            }
            currentRescue = null;
            currentRegionStart = null;
        }
        if (currentRegionStart != null) {
            org.objectweb.asm.Label syntheticEnd = new org.objectweb.asm.Label();
            rescueEndForStart.put(currentRegionStart, syntheticEnd);
            syntheticEndForStart.put(currentBlockStart, syntheticEnd);
        }
        for (BasicBlock bb : bbs) {
            org.objectweb.asm.Label syntheticEnd;
            org.objectweb.asm.Label end2;
            org.objectweb.asm.Label start2 = this.jvm.methodData().getLabel(bb.getLabel());
            Label rescueLabel = exceptionTable.get(bb);
            m.mark(start2);
            if (rescueLabel != null && (end2 = (org.objectweb.asm.Label)rescueEndForStart.get(bb.getLabel())) != null) {
                org.objectweb.asm.Label rescue = this.jvm.methodData().getLabel(rescueLabel);
                this.jvmAdapter().trycatch(start2, end2, rescue, CodegenUtils.p(Throwable.class));
            }
            m.adapter.nop();
            List<Instr> instrs = bb.getInstrs();
            int length2 = instrs.size();
            Instr previousScopeNextInstr = null;
            if (this.nextInstr != null) {
                previousScopeNextInstr = this.nextInstr;
            }
            if (length2 > 0) {
                Instr currentInstr = instrs.get(0);
                for (int i2 = 1; i2 < length2; ++i2) {
                    this.nextInstr = instrs.get(i2);
                    this.visit(currentInstr);
                    currentInstr = this.nextInstr;
                }
                this.nextInstr = null;
                this.visit(currentInstr);
            }
            if (previousScopeNextInstr != null) {
                this.nextInstr = previousScopeNextInstr;
            }
            if ((syntheticEnd = (org.objectweb.asm.Label)syntheticEndForStart.get(bb.getLabel())) == null) continue;
            m.mark(syntheticEnd);
        }
        this.jvm.popmethod();
    }

    private StaticScope registerScopeField(IRScope scope, String scopeField) {
        StaticScope staticScope = scope.getStaticScope();
        String staticScopeDescriptor = Helpers.describeScope(staticScope);
        if (this.staticScopeMap.get(scopeField) == null) {
            this.staticScopeMap.put(scopeField, staticScope);
            this.scopeFieldMap.put(staticScope, scopeField);
            this.staticScopeDescriptorMap.put(scopeField, staticScopeDescriptor);
            this.jvm.cls().visitField(73, scopeField, CodegenUtils.ci(StaticScope.class), null, null).visitEnd();
        }
        return staticScope;
    }

    protected void emitVarargsMethodWrapper(IRScope scope, String variableName, String specificName, Signature variableSignature, Signature specificSignature) {
        String scopeField = specificName + "_StaticScope";
        this.jvm.pushmethod(variableName, scope, scopeField, variableSignature, false);
        IRBytecodeAdapter m = this.jvmMethod();
        this.jvmMethod().updateLineNumber(scope.getLine());
        org.jruby.runtime.Signature scopeSig = scope.getStaticScope().getSignature();
        this.checkArity(scopeSig.required(), scopeSig.opt(), scopeSig.hasRest(), scopeSig.keyRest());
        m.loadContext();
        m.loadStaticScope();
        m.loadSelf();
        if (scopeSig.required() > 0) {
            for (int i2 = 0; i2 < scopeSig.required(); ++i2) {
                m.loadArgs();
                this.jvmAdapter().pushInt(i2);
                this.jvmAdapter().aaload();
            }
        }
        m.loadBlock();
        m.loadFrameClass();
        m.loadFrameName();
        Method specificMethod = new Method(specificName, Type.getType((Class)specificSignature.type().returnType()), IRRuntimeHelpers.typesFromSignature(specificSignature));
        this.jvmAdapter().invokestatic(m.getClassData().clsName, specificName, specificMethod.getDescriptor());
        this.jvmAdapter().areturn();
        this.jvm.popmethod();
    }

    protected static final Signature signatureFor(IRScope method2, boolean aritySplit) {
        if (aritySplit) {
            StaticScope argScope = method2.getStaticScope();
            if (argScope.isArgumentScope() && argScope.getSignature().isFixed() && !argScope.getSignature().hasKwargs()) {
                String[] args2 = new String[argScope.getSignature().required()];
                Class[] types = new Class[args2.length];
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    args2[i2] = "arg" + i2;
                    types[i2] = IRubyObject.class;
                }
                return METHOD_SIGNATURE_BASE.insertArgs(BLOCK_ARG_NAME, args2, types);
            }
            return null;
        }
        return METHOD_SIGNATURE_BASE.insertArgs(BLOCK_ARG_NAME, new String[]{"args"}, new Class[]{IRubyObject[].class});
    }

    protected void emitScriptBody(IRScriptBody script) {
        String scopeName = JavaNameMangler.encodeScopeForBacktrace(script);
        String scopeField = scopeName + "_StaticScope";
        String clsName = JVM.scriptToClass(script.getFile());
        Signature signature = JVMVisitor.signatureFor(script, false);
        this.jvm.pushscript(this, clsName, script.getFile());
        this.defineRunMethod(script, scopeName, scopeField, clsName, signature);
        this.emitScope(script, scopeName, signature, false, true);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    private void defineRunMethod(IRScriptBody script, String scopeName, String scopeField, String clsName, Signature signature) {
        SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(this.jvm.cls(), 9, "run", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, java.lang.Boolean.TYPE), null, null);
        method2.start();
        method2.aload(1);
        method2.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        method2.astore(4);
        this.registerScopeField(script, scopeField);
        method2.getstatic(clsName, scopeField, CodegenUtils.ci(StaticScope.class));
        method2.astore(5);
        method2.aload(5);
        org.objectweb.asm.Label after = new org.objectweb.asm.Label();
        method2.ifnonnull(after);
        method2.ldc(this.staticScopeDescriptorMap.get(scopeField));
        method2.aconst_null();
        method2.invokestatic(CodegenUtils.p(Helpers.class), "restoreScope", CodegenUtils.sig(StaticScope.class, String.class, StaticScope.class));
        method2.astore(5);
        method2.aload(5);
        method2.aload(0);
        method2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        method2.invokevirtual(CodegenUtils.p(Ruby.class), "getObject", CodegenUtils.sig(RubyClass.class, new Class[0]));
        method2.invokevirtual(CodegenUtils.p(StaticScope.class), "setModule", CodegenUtils.sig(Void.TYPE, RubyModule.class));
        method2.aload(5);
        method2.aload(2);
        method2.invokevirtual(CodegenUtils.p(StaticScope.class), "setFile", CodegenUtils.sig(Void.TYPE, String.class));
        method2.iload(3);
        org.objectweb.asm.Label nowrap = new org.objectweb.asm.Label();
        method2.iffalse(nowrap);
        method2.aload(0);
        method2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        method2.aload(1);
        method2.aload(5);
        method2.invokevirtual(CodegenUtils.p(Ruby.class), "setupWrappedToplevel", CodegenUtils.sig(StaticScope.class, IRubyObject.class, StaticScope.class));
        method2.astore(5);
        method2.aload(5);
        method2.aload(2);
        method2.invokevirtual(CodegenUtils.p(StaticScope.class), "setFile", CodegenUtils.sig(Void.TYPE, String.class));
        method2.label(nowrap);
        method2.aload(5);
        method2.putstatic(clsName, scopeField, CodegenUtils.ci(StaticScope.class));
        method2.label(after);
        method2.aload(0);
        method2.aload(5);
        method2.aload(1);
        method2.aconst_null();
        method2.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        method2.aload(4);
        method2.aconst_null();
        method2.invokestatic(clsName, scopeName, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()));
        method2.areturn();
        method2.end();
    }

    protected void emitMethod(IRMethod method2, JVMVisitorMethodContext context) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method2) + '$' + this.methodIndex++;
        this.emitWithSignatures(method2, context, name2);
    }

    protected void emitMethodJIT(IRMethod method2, JVMVisitorMethodContext context) {
        String clsName = JVM.scriptToClass(method2.getFile());
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method2) + '$' + this.methodIndex++;
        this.jvm.pushscript(this, clsName, method2.getFile());
        this.emitWithSignatures(method2, context, name2);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    protected void emitBlockJIT(IRClosure closure, JVMVisitorMethodContext context) {
        String clsName = JVM.scriptToClass(closure.getFile());
        String name2 = JavaNameMangler.encodeScopeForBacktrace(closure) + '$' + this.methodIndex++;
        this.jvm.pushscript(this, clsName, closure.getFile());
        this.emitScope(closure, name2, CLOSURE_SIGNATURE, false, true);
        context.setBaseName(name2);
        context.setVariableName(name2);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    private void emitWithSignatures(IRMethod method2, JVMVisitorMethodContext context, String name2) {
        context.setBaseName(name2);
        Signature specificSig = JVMVisitor.signatureFor(method2, true);
        if (specificSig == null) {
            context.setVariableName(name2);
            Signature signature = JVMVisitor.signatureFor(method2, false);
            this.emitScope(method2, name2, signature, false, true);
            context.addNativeSignature(-1, signature.type());
        } else {
            String specificName = name2;
            context.setSpecificName(specificName);
            this.emitScope(method2, specificName, specificSig, true, true);
            context.addNativeSignature(method2.getStaticScope().getSignature().required(), specificSig.type());
            String variableName = name2 + "$__VARARGS__";
            context.setVariableName(variableName);
            this.emitVarargsMethodWrapper(method2, variableName, specificName, METHOD_SIGNATURE_VARARGS, specificSig);
            context.addNativeSignature(-1, METHOD_SIGNATURE_VARARGS.type());
        }
    }

    protected Handle emitModuleBodyJIT(IRModuleBody method2) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method2) + '$' + this.methodIndex++;
        String clsName = JVM.scriptToClass(method2.getFile());
        this.jvm.pushscript(this, clsName, method2.getFile());
        Signature signature = JVMVisitor.signatureFor(method2, false);
        this.emitScope(method2, name2, signature, false, true);
        Handle handle = new Handle(6, this.jvm.classData().clsName, name2, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()), false);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
        return handle;
    }

    private void emitClosures(IRScope s2, boolean print2) {
        for (IRClosure c : s2.getClosures()) {
            this.emitClosure(c, print2);
        }
    }

    protected Handle emitClosure(IRClosure closure, boolean print2) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(closure) + '$' + this.methodIndex++;
        this.emitScope(closure, name2, CLOSURE_SIGNATURE, false, print2);
        Handle handle = new Handle(6, this.jvm.classData().clsName, name2, CodegenUtils.sig((Class)CLOSURE_SIGNATURE.type().returnType(), CLOSURE_SIGNATURE.type().parameterArray()), false);
        this.closuresMap.put(closure, handle);
        return handle;
    }

    protected Handle emitModuleBody(IRModuleBody method2) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method2) + '$' + this.methodIndex++;
        Signature signature = JVMVisitor.signatureFor(method2, false);
        this.emitScope(method2, name2, signature, false, true);
        return new Handle(6, this.jvm.classData().clsName, name2, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()), false);
    }

    @Override
    public void visit(Instr instr) {
        instr.visit(this);
    }

    @Override
    public void visit(Operand operand) {
        operand.visit(this);
    }

    private int getJVMLocalVarIndex(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    return this.jvm.methodData().local(variable, JVM.DOUBLE_TYPE);
                }
                case FIXNUM: {
                    return this.jvm.methodData().local(variable, JVM.LONG_TYPE);
                }
                case BOOLEAN: {
                    return this.jvm.methodData().local(variable, JVM.BOOLEAN_TYPE);
                }
            }
            return this.jvm.methodData().local(variable);
        }
        return this.jvm.methodData().local(variable);
    }

    private int getJVMLocalVarIndex(String specialVar) {
        return this.jvm.methodData().local(specialVar);
    }

    private org.objectweb.asm.Label getJVMLabel(Label label2) {
        return this.jvm.methodData().getLabel(label2);
    }

    private void jvmStoreLocal(Variable variable) {
        if (variable instanceof LocalVariable) {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            this.jvmAdapter().swap();
            this.genSetValue((LocalVariable)variable);
        } else if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().istore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void jvmStoreLocal(Runnable source2, Variable variable) {
        if (variable instanceof LocalVariable) {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            source2.run();
            this.genSetValue((LocalVariable)variable);
        } else if (variable instanceof TemporaryLocalVariable) {
            source2.run();
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().istore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            source2.run();
            this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void genSetValue(LocalVariable localvariable) {
        int depth = localvariable.getScopeDepth();
        int location = localvariable.getLocation();
        String baseName = CodegenUtils.p(DynamicScope.class);
        if (depth == 0) {
            if (location < DynamicScopeGenerator.SPECIALIZED_SETS.size()) {
                this.jvmAdapter().invokevirtual(baseName, DynamicScopeGenerator.SPECIALIZED_SETS.get(location), CodegenUtils.sig(Void.TYPE, IRubyObject.class));
            } else {
                this.jvmAdapter().pushInt(location);
                this.jvmAdapter().invokevirtual(baseName, "setValueDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE));
            }
        } else {
            this.jvmAdapter().pushInt(location);
            this.jvmAdapter().pushInt(depth);
            this.jvmAdapter().invokevirtual(baseName, "setValueVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE, Integer.TYPE));
        }
    }

    private void jvmStoreLocal(String specialVar) {
        this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(specialVar));
    }

    private void jvmLoadLocal(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().iload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void jvmLoadLocal(String specialVar) {
        this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(specialVar));
    }

    @Override
    public void AliasInstr(AliasInstr aliasInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        m.loadContext();
        m.loadSelf();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.visit(aliasInstr.getNewName());
        this.visit(aliasInstr.getOldName());
        m.invokeIRHelper("defineAlias", CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject.class, DynamicScope.class, IRubyObject.class, IRubyObject.class));
    }

    @Override
    public void ArrayDerefInstr(ArrayDerefInstr arrayderefinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelf();
        this.visit(arrayderefinstr.getReceiver());
        this.visit(arrayderefinstr.getKey());
        this.jvmMethod().getInvocationCompiler().invokeArrayDeref(this.file, this.jvm.methodData().scopeField, arrayderefinstr);
        this.jvmStoreLocal(arrayderefinstr.getResult());
    }

    @Override
    public void AsStringInstr(AsStringInstr asstring) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelf();
        this.visit(asstring.getReceiver());
        this.jvmMethod().getInvocationCompiler().asString(asstring, this.jvm.methodData().scopeField, this.file);
        this.jvmStoreLocal(asstring.getResult());
    }

    @Override
    public void AttrAssignInstr(AttrAssignInstr attrAssignInstr) {
        this.compileCallCommon(this.jvmMethod(), attrAssignInstr);
    }

    @Override
    public void BFalseInstr(BFalseInstr bFalseInstr) {
        Operand arg1 = bFalseInstr.getArg1();
        this.visit(arg1);
        if (arg1 instanceof TemporaryBooleanVariable || arg1 instanceof UnboxedBoolean) {
            this.jvmMethod().getBranchCompiler().bfalse(this.getJVMLabel(bFalseInstr.getJumpTarget()));
        } else {
            this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(java.lang.Boolean.TYPE, new Class[0]));
            this.jvmMethod().getBranchCompiler().bfalse(this.getJVMLabel(bFalseInstr.getJumpTarget()));
        }
    }

    @Override
    public void BlockGivenInstr(BlockGivenInstr blockGivenInstr) {
        this.jvmMethod().loadContext();
        this.visit(blockGivenInstr.getBlockArg());
        this.jvmMethod().invokeIRHelper("isBlockGiven", CodegenUtils.sig(RubyBoolean.class, ThreadContext.class, Object.class));
        this.jvmStoreLocal(blockGivenInstr.getResult());
    }

    private void loadFloatArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            double val;
            if (arg2 instanceof Float) {
                val = ((Float)arg2).value;
            } else if (arg2 instanceof Fixnum) {
                val = ((Fixnum)arg2).value;
            } else {
                throw new NotCompilableException("Non-float/fixnum in loadFloatArg!" + arg2);
            }
            this.jvmAdapter().ldc(val);
        }
    }

    private void loadFixnumArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            long val;
            if (arg2 instanceof Float) {
                val = (long)((Float)arg2).value;
            } else if (arg2 instanceof Fixnum) {
                val = ((Fixnum)arg2).value;
            } else {
                throw new NotCompilableException("Non-float/fixnum in loadFixnumArg!" + arg2);
            }
            this.jvmAdapter().ldc(val);
        }
    }

    private void loadBooleanArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            if (!(arg2 instanceof UnboxedBoolean)) {
                throw new NotCompilableException("Non-float/fixnum in loadFixnumArg!" + arg2);
            }
            boolean val = ((UnboxedBoolean)arg2).isTrue();
            this.jvmAdapter().ldc(val);
        }
    }

    @Override
    public void BoxFloatInstr(BoxFloatInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadFloatArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newFloat", CodegenUtils.sig(RubyFloat.class, Double.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BoxFixnumInstr(BoxFixnumInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadFixnumArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BoxBooleanInstr(BoxBooleanInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadBooleanArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newBoolean", CodegenUtils.sig(RubyBoolean.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxFloatInstr(UnboxFloatInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxFloat", CodegenUtils.sig(Double.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxFixnumInstr(UnboxFixnumInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxFixnum", CodegenUtils.sig(Long.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxBooleanInstr(UnboxBooleanInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxBoolean", CodegenUtils.sig(java.lang.Boolean.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void AluInstr(AluInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        this.visit(instr.getArg1());
        this.visit(instr.getArg2());
        switch (instr.getOperation()) {
            case FADD: {
                a.dadd();
                break;
            }
            case FSUB: {
                a.dsub();
                break;
            }
            case FMUL: {
                a.dmul();
                break;
            }
            case FDIV: {
                a.ddiv();
                break;
            }
            case FLT: {
                m.invokeIRHelper("flt", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case FGT: {
                m.invokeIRHelper("fgt", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case FEQ: {
                m.invokeIRHelper("feq", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case IADD: {
                a.ladd();
                break;
            }
            case ISUB: {
                a.lsub();
                break;
            }
            case IMUL: {
                a.lmul();
                break;
            }
            case IDIV: {
                a.ldiv();
                break;
            }
            case ILT: {
                m.invokeIRHelper("ilt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            case IGT: {
                m.invokeIRHelper("igt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            case IOR: {
                a.lor();
                break;
            }
            case IAND: {
                a.land();
                break;
            }
            case IXOR: {
                a.lxor();
                break;
            }
            case ISHL: {
                a.lshl();
                break;
            }
            case ISHR: {
                a.lshr();
                break;
            }
            case IEQ: {
                m.invokeIRHelper("ilt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            default: {
                throw new NotCompilableException("UNHANDLED!");
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BNEInstr(BNEInstr bneinstr) {
        this.jvmMethod().loadContext();
        this.visit(bneinstr.getArg1());
        this.visit(bneinstr.getArg2());
        this.jvmMethod().invokeHelper("BNE", java.lang.Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvmAdapter().iftrue(this.getJVMLabel(bneinstr.getJumpTarget()));
    }

    @Override
    public void BNilInstr(BNilInstr bnilinstr) {
        this.visit(bnilinstr.getArg1());
        this.jvmMethod().getBranchCompiler().branchIfNil(this.getJVMLabel(bnilinstr.getJumpTarget()));
    }

    @Override
    public void BreakInstr(BreakInstr breakInstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.visit(breakInstr.getReturnValue());
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "initiateBreak", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, IRubyObject.class, Block.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void BSwitchInstr(BSwitchInstr bswitchinstr) {
        int low;
        this.visit(bswitchinstr.getCaseOperand());
        this.jvmAdapter().dup();
        Class expectedClass = bswitchinstr.getExpectedClass();
        this.jvmAdapter().instance_of(CodegenUtils.p(expectedClass));
        org.objectweb.asm.Label rubyCaseLabel = this.getJVMLabel(bswitchinstr.getRubyCaseLabel());
        org.objectweb.asm.Label notMatchingType = new org.objectweb.asm.Label();
        this.jvmAdapter().iffalse(notMatchingType);
        this.jvmAdapter().checkcast(CodegenUtils.p(expectedClass));
        if (expectedClass == RubyFixnum.class) {
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyFixnum.class), "getIntValue", CodegenUtils.sig(Integer.TYPE, new Class[0]));
        } else if (expectedClass == RubySymbol.class) {
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubySymbol.class), "getId", CodegenUtils.sig(Integer.TYPE, new Class[0]));
        }
        Label[] targets = bswitchinstr.getTargets();
        org.objectweb.asm.Label[] jvmTargets = new org.objectweb.asm.Label[targets.length];
        for (int i2 = 0; i2 < targets.length; ++i2) {
            jvmTargets[i2] = this.getJVMLabel(targets[i2]);
        }
        org.objectweb.asm.Label defaultTarget = this.getJVMLabel(bswitchinstr.getElseTarget());
        int[] jumps = bswitchinstr.getJumps();
        int high = jumps[jumps.length - 1];
        int span = high - (low = jumps[0]) + 1;
        if (span == jumps.length) {
            this.jvmAdapter().tableswitch(low, high, defaultTarget, jvmTargets);
        } else if (span <= 33) {
            org.objectweb.asm.Label[] realTargets = jvmTargets;
            jvmTargets = new org.objectweb.asm.Label[span];
            jvmTargets[0] = realTargets[0];
            int p2 = jumps[0] + 1;
            int t = 1;
            for (int i3 = 1; i3 < jumps.length; ++i3) {
                int cj = jumps[i3];
                if (cj == p2) {
                    jvmTargets[t++] = realTargets[i3];
                    p2 = cj + 1;
                    continue;
                }
                while (cj > p2++) {
                    jvmTargets[t++] = defaultTarget;
                }
                jvmTargets[t++] = realTargets[i3];
            }
            this.jvmAdapter().tableswitch(low, high, defaultTarget, jvmTargets);
        } else {
            this.jvmAdapter().lookupswitch(defaultTarget, bswitchinstr.getJumps(), jvmTargets);
        }
        this.jvmAdapter().label(notMatchingType);
        this.jvmAdapter().pop();
        this.jvmAdapter().label(rubyCaseLabel);
    }

    @Override
    public void BTrueInstr(BTrueInstr btrueinstr) {
        Operand arg1 = btrueinstr.getArg1();
        if (this.omitStoreLoad) {
            this.omitStoreLoad = false;
        } else {
            this.visit(arg1);
        }
        if (arg1 instanceof TemporaryBooleanVariable || arg1 instanceof UnboxedBoolean) {
            this.jvmMethod().getBranchCompiler().btrue(this.getJVMLabel(btrueinstr.getJumpTarget()));
        } else {
            this.jvmMethod().getBranchCompiler().branchIfTruthy(this.getJVMLabel(btrueinstr.getJumpTarget()));
        }
    }

    @Override
    public void BUndefInstr(BUndefInstr bundefinstr) {
        this.visit(bundefinstr.getArg1());
        this.jvmMethod().getValueCompiler().pushUndefined();
        this.jvmAdapter().if_acmpeq(this.getJVMLabel(bundefinstr.getJumpTarget()));
    }

    @Override
    public void BuildBackrefInstr(BuildBackrefInstr instr) {
        this.jvmMethod().loadContext();
        switch (instr.type) {
            case '&': {
                this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "last_match", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                break;
            }
            case '`': {
                this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "match_pre", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                break;
            }
            case '\'': {
                this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "match_post", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                break;
            }
            case '+': {
                this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "match_last", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                break;
            }
            default: {
                assert (false) : "backref with invalid type";
                break;
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildCompoundArrayInstr(BuildCompoundArrayInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getAppendingArg());
        this.visit(instr.getAppendedArg());
        if (instr.isArgsPush()) {
            this.jvmAdapter().ldc(instr.usesKeywordRest());
            this.jvmMethod().invokeHelper("argsPush", RubyArray.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, java.lang.Boolean.TYPE);
        } else {
            this.jvmMethod().invokeHelper("argsCat", RubyArray.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildCompoundStringInstr(BuildCompoundStringInstr compoundstring) {
        Operand[] pieces = compoundstring.getPieces();
        this.jvmMethod().getValueCompiler().pushBufferString(compoundstring.getEncoding(), compoundstring.getInitialSize());
        for (Operand p2 : pieces) {
            StringLiteral str;
            if (p2 instanceof FrozenString) {
                str = (FrozenString)p2;
                this.jvmMethod().getValueCompiler().pushFrozenString(((FrozenString)str).getByteList(), ((FrozenString)str).getCodeRange(), ((FrozenString)str).getFile(), ((FrozenString)str).getLine());
                this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "cat19", CodegenUtils.sig(RubyString.class, RubyString.class));
                continue;
            }
            if (p2 instanceof StringLiteral) {
                str = (StringLiteral)((Object)p2);
                this.jvmMethod().getValueCompiler().pushByteList(str.getByteList());
                this.jvmAdapter().pushInt(str.getCodeRange());
                this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "cat", CodegenUtils.sig(RubyString.class, ByteList.class, Integer.TYPE));
                continue;
            }
            this.visit(p2);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "appendAsDynamicString", CodegenUtils.sig(RubyString.class, IRubyObject.class));
        }
        if (compoundstring.isFrozen()) {
            if (this.runtime.getInstanceConfig().isDebuggingFrozenStringLiteral()) {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc(compoundstring.getFile());
                this.jvmAdapter().ldc(compoundstring.getLine());
                this.jvmMethod().invokeIRHelper("freezeLiteralString", CodegenUtils.sig(RubyString.class, RubyString.class, ThreadContext.class, String.class, Integer.TYPE));
            } else {
                this.jvmMethod().invokeIRHelper("freezeLiteralString", CodegenUtils.sig(RubyString.class, RubyString.class));
            }
        }
        this.jvmStoreLocal(compoundstring.getResult());
    }

    @Override
    public void BuildDynRegExpInstr(BuildDynRegExpInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        if (instr.getOptions().isOnce() && instr.getRegexp() != null) {
            this.visit(new Regexp(instr.getRegexp().source().convertToString().getByteList(), instr.getOptions()));
            this.jvmStoreLocal(instr.getResult());
            return;
        }
        RegexpOptions options2 = instr.getOptions();
        Operand[] operands = instr.getPieces();
        Runnable r = () -> {
            m.loadContext();
            for (int i2 = 0; i2 < operands.length; ++i2) {
                Operand operand = operands[i2];
                this.visit(operand);
                this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
            }
        };
        m.getDynamicValueCompiler().pushDRegexp(r, options2, operands.length);
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildRangeInstr(BuildRangeInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getBegin());
        this.visit(instr.getEnd());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRange.class), instr.isExclusive() ? "newExclusiveRange" : "newInclusiveRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildSplatInstr(BuildSplatInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getArray());
        String splatMethod = instr.getDup() ? "splatArrayDup" : "splatArray";
        this.jvmMethod().invokeIRHelper(splatMethod, CodegenUtils.sig(RubyArray.class, ThreadContext.class, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void CallInstr(CallInstr callInstr) {
        if (callInstr instanceof OneFixnumArgNoBlockCallInstr) {
            this.oneFixnumArgNoBlockCallInstr((OneFixnumArgNoBlockCallInstr)callInstr);
            return;
        }
        if (callInstr instanceof OneFloatArgNoBlockCallInstr) {
            this.oneFloatArgNoBlockCallInstr((OneFloatArgNoBlockCallInstr)callInstr);
            return;
        }
        this.compileCallCommon(this.jvmMethod(), callInstr);
    }

    private void compileCallCommon(IRBytecodeAdapter m, CallBase call2) {
        boolean functional = call2.getCallType() == CallType.FUNCTIONAL || call2.getCallType() == CallType.VARIABLE;
        Operand[] args2 = call2.getCallArgs();
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        m.loadContext();
        if (!functional) {
            m.loadSelf();
        }
        this.visit(call2.getReceiver());
        int arity2 = args2.length;
        if (args2.length == 1 && args2[0] instanceof Splat) {
            this.visit(args2[0]);
            m.adapter.invokevirtual(CodegenUtils.p(RubyArray.class), "toJavaArray", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            arity2 = -1;
        } else {
            if (CallBase.containsArgSplat(args2)) {
                throw new NotCompilableException("splat in non-initial argument for normal call is unsupported in JIT");
            }
            for (Operand operand : args2) {
                this.visit(operand);
            }
        }
        if (blockPassType.given()) {
            m.loadContext();
            if (call2.isPotentiallyRefined()) {
                m.loadStaticScope();
            }
            this.visit(call2.getClosureArg());
            if (call2.isPotentiallyRefined()) {
                m.invokeIRHelper("getRefinedBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, StaticScope.class, Object.class));
            } else {
                m.invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
            }
        }
        switch (call2.getCallType()) {
            case FUNCTIONAL: 
            case VARIABLE: {
                m.getInvocationCompiler().invokeSelf(this.file, this.jvm.methodData().scopeField, call2, arity2);
                break;
            }
            case NORMAL: {
                m.getInvocationCompiler().invokeOther(this.file, this.jvm.methodData().scopeField, call2, arity2);
            }
        }
        Variable result2 = call2.getResult();
        if (result2 != null) {
            if (!this.omitStoreLoad) {
                this.jvmStoreLocal(result2);
            }
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void CheckArgsArrayArityInstr(CheckArgsArrayArityInstr checkargsarrayarityinstr) {
        int required = checkargsarrayarityinstr.required;
        int opt = checkargsarrayarityinstr.opt;
        boolean rest = checkargsarrayarityinstr.rest;
        if (required == 0 && opt == 0 && rest) {
            return;
        }
        this.jvmMethod().getBranchCompiler().checkArgsArity(() -> this.visit(checkargsarrayarityinstr.getArgsArray()), required, opt, rest);
    }

    @Override
    public void CheckArityInstr(CheckArityInstr checkarityinstr) {
        if (this.jvm.methodData().specificArity < 0) {
            this.checkArity(checkarityinstr.getKeywords(), checkarityinstr.required, checkarityinstr.opt, checkarityinstr.rest, checkarityinstr.restKey);
        }
    }

    private void checkArity(int required, int opt, boolean rest, int restKey) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmMethod().loadArgs();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().getBranchCompiler().checkAritySpecificArgs(required, opt, rest, restKey);
    }

    private void checkArity(Operand keywords, int required, int opt, boolean rest, int restKey) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmMethod().loadArgs();
        this.visit(keywords);
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().getBranchCompiler().checkArity(required, opt, rest, restKey);
    }

    @Override
    public void CheckForLJEInstr(CheckForLJEInstr checkForljeinstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmAdapter().ldc(checkForljeinstr.isDefinedWithinMethod());
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "checkForLJE", CodegenUtils.sig(Void.TYPE, ThreadContext.class, DynamicScope.class, java.lang.Boolean.TYPE, Block.class));
    }

    @Override
    public void ClassSuperInstr(ClassSuperInstr classsuperinstr) {
        String name2 = classsuperinstr.getId();
        Operand[] args2 = classsuperinstr.getCallArgs();
        Operand definingModule = classsuperinstr.getDefiningModule();
        boolean[] splatMap = classsuperinstr.splatMap();
        Operand closure = classsuperinstr.getClosureArg(NullBlock.INSTANCE);
        this.superCommon(name2, classsuperinstr, args2, definingModule, splatMap, closure);
    }

    @Override
    public void CopyInstr(CopyInstr copyinstr) {
        Operand src = copyinstr.getSource();
        Variable res = copyinstr.getResult();
        this.storeHeapOrStack(src, res);
    }

    private void storeHeapOrStack(final Operand value2, final Variable res) {
        this.jvmStoreLocal(new Runnable(){

            @Override
            public void run() {
                if (res instanceof TemporaryFloatVariable) {
                    JVMVisitor.this.loadFloatArg(value2);
                } else if (res instanceof TemporaryFixnumVariable) {
                    JVMVisitor.this.loadFixnumArg(value2);
                } else {
                    JVMVisitor.this.visit(value2);
                }
            }
        }, res);
    }

    @Override
    public void DefineClassInstr(DefineClassInstr defineclassinstr) {
        IRClassBody newIRClassBody = defineclassinstr.getNewIRClassBody();
        this.jvmMethod().loadContext();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(newIRClassBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().ldc(newIRClassBody.getId());
        this.jvmAdapter().ldc(newIRClassBody.getLine());
        this.jvmMethod().getStaticScope(handle.getName() + "_StaticScope");
        this.visit(defineclassinstr.getContainer());
        this.visit(defineclassinstr.getSuperClass());
        this.jvmAdapter().ldc(newIRClassBody.maybeUsingRefinements());
        this.jvmMethod().invokeIRHelper("newCompiledClassBody", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, String.class, Integer.TYPE, StaticScope.class, Object.class, Object.class, java.lang.Boolean.TYPE));
        this.jvmMethod().invokeIRHelper("invokeModuleBody", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicMethod.class));
        this.jvmStoreLocal(defineclassinstr.getResult());
    }

    @Override
    public void DefineClassMethodInstr(DefineClassMethodInstr defineclassmethodinstr) {
        IRMethod method2 = defineclassmethodinstr.getMethod();
        this.jvmMethod().loadContext();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        this.emitMethod(method2, context);
        String defSignature = this.pushHandlesForDef(context.getVariableName(), context.getSpecificName(), context.getNativeSignaturesExceptVariable(), METHOD_SIGNATURE_VARARGS.type(), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, String.class, Integer.TYPE, StaticScope.class, String.class, IRubyObject.class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, String.class, Integer.TYPE, StaticScope.class, String.class, IRubyObject.class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE));
        this.jvmAdapter().ldc(method2.getId());
        this.jvmAdapter().ldc(method2.getLine());
        this.jvmMethod().getStaticScope(context.getBaseName() + "_StaticScope");
        this.jvmAdapter().ldc(ArgumentDescriptor.encode(method2.getArgumentDescriptors()));
        this.visit(defineclassmethodinstr.getContainer());
        this.jvmAdapter().ldc(method2.maybeUsingRefinements());
        this.jvmAdapter().ldc(method2.receivesKeywordArgs());
        this.jvmAdapter().ldc(method2.getFullInterpreterContext().getFlags().contains((Object)IRFlags.REQUIRES_CLASS));
        this.jvmMethod().adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "defCompiledClassMethod", defSignature);
    }

    @Override
    public void DefineInstanceMethodInstr(DefineInstanceMethodInstr defineinstancemethodinstr) {
        IRMethod method2 = defineinstancemethodinstr.getMethod();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        this.emitMethod(method2, context);
        MethodType variable = context.getNativeSignature(-1);
        assert (variable != null);
        String defSignature = this.pushHandlesForDef(context.getVariableName(), context.getSpecificName(), context.getNativeSignaturesExceptVariable(), variable, CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, String.class, Integer.TYPE, StaticScope.class, String.class, DynamicScope.class, IRubyObject.class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, String.class, Integer.TYPE, StaticScope.class, String.class, DynamicScope.class, IRubyObject.class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE));
        a.ldc(method2.getId());
        a.ldc(method2.getLine());
        this.jvmMethod().getStaticScope(context.getBaseName() + "_StaticScope");
        this.jvmAdapter().ldc(ArgumentDescriptor.encode(method2.getArgumentDescriptors()));
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelf();
        this.jvmAdapter().ldc(method2.maybeUsingRefinements());
        this.jvmAdapter().ldc(method2.receivesKeywordArgs());
        this.jvmAdapter().ldc(method2.getFullInterpreterContext().getFlags().contains((Object)IRFlags.REQUIRES_CLASS));
        a.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "defCompiledInstanceMethod", defSignature);
    }

    private String pushHandlesForDef(String variableName, String specificName, IntHashMap<MethodType> signaturesExceptVariable, MethodType variable, String variableOnly, String variableAndSpecific) {
        String defSignature;
        block1: {
            block0: {
                this.jvmMethod().pushHandle(new Handle(6, this.jvm.classData().clsName, variableName, CodegenUtils.sig((Class)variable.returnType(), variable.parameterArray()), false));
                if (signaturesExceptVariable.size() != 0) break block0;
                defSignature = variableOnly;
                break block1;
            }
            defSignature = variableAndSpecific;
            Iterator<IntHashMap.Entry<MethodType>> iterator = signaturesExceptVariable.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            IntHashMap.Entry<MethodType> entry = iterator.next();
            this.jvmMethod().pushHandle(new Handle(6, this.jvm.classData().clsName, specificName, CodegenUtils.sig((Class)entry.getValue().returnType(), entry.getValue().parameterArray()), false));
            this.jvmAdapter().pushInt(entry.getKey());
        }
        return defSignature;
    }

    @Override
    public void DefineMetaClassInstr(DefineMetaClassInstr definemetaclassinstr) {
        IRModuleBody metaClassBody = definemetaclassinstr.getMetaClassBody();
        Handle bodyHandle = this.emitModuleBody(metaClassBody);
        String scopeField = bodyHandle.getName() + "_StaticScope";
        String clsName = this.jvm.classData().clsName;
        Handle scopeHandle = new Handle(2, clsName, scopeField, CodegenUtils.ci(StaticScope.class), false);
        Handle setScopeHandle = new Handle(4, clsName, scopeField, CodegenUtils.ci(StaticScope.class), false);
        this.jvmMethod().loadContext();
        this.visit(definemetaclassinstr.getObject());
        this.jvmAdapter().ldc(this.staticScopeDescriptorMap.get(scopeField));
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().invokedynamic("openMetaClass", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, String.class, StaticScope.class), Bootstrap.OPEN_META_CLASS, bodyHandle, scopeHandle, setScopeHandle, metaClassBody.getLine(), metaClassBody.getFullInterpreterContext().isDynamicScopeEliminated() ? 1 : 0, metaClassBody.maybeUsingRefinements() ? 1 : 0);
        this.jvmStoreLocal(definemetaclassinstr.getResult());
    }

    @Override
    public void DefineModuleInstr(DefineModuleInstr definemoduleinstr) {
        IRModuleBody newIRModuleBody = definemoduleinstr.getNewIRModuleBody();
        this.jvmMethod().loadContext();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(newIRModuleBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().ldc(newIRModuleBody.getId());
        this.jvmAdapter().ldc(newIRModuleBody.getLine());
        this.jvmMethod().getStaticScope(handle.getName() + "_StaticScope");
        this.visit(definemoduleinstr.getContainer());
        this.jvmAdapter().ldc(newIRModuleBody.maybeUsingRefinements());
        this.jvmMethod().invokeIRHelper("newCompiledModuleBody", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, String.class, Integer.TYPE, StaticScope.class, Object.class, java.lang.Boolean.TYPE));
        this.jvmMethod().invokeIRHelper("invokeModuleBody", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicMethod.class));
        this.jvmStoreLocal(definemoduleinstr.getResult());
    }

    private boolean canOmitStoreLoad(EQQInstr eqq2, Instr nextInstr) {
        assert (nextInstr != null) : "Somehow EQQ is the last instr in the scope...";
        return nextInstr instanceof BTrueInstr && eqq2.getResult().equals(((BTrueInstr)nextInstr).getArg1());
    }

    @Override
    public void EQQInstr(EQQInstr eqqinstr) {
        this.omitStoreLoad = this.canOmitStoreLoad(eqqinstr, this.nextInstr);
        if (!eqqinstr.isSplattedValue() && !(eqqinstr.getArg1() instanceof UndefinedValue)) {
            this.compileCallCommon(this.jvmMethod(), eqqinstr);
        } else {
            this.jvmMethod().loadContext();
            this.visit(eqqinstr.getReceiver());
            this.visit(eqqinstr.getArg1());
            this.jvmMethod().getInvocationCompiler().invokeEQQ(eqqinstr);
            if (!this.omitStoreLoad) {
                this.jvmStoreLocal(eqqinstr.getResult());
            }
        }
    }

    @Override
    public void ExceptionRegionEndMarkerInstr(ExceptionRegionEndMarkerInstr exceptionregionendmarkerinstr) {
        throw new NotCompilableException("Marker instructions shouldn't reach compiler: " + exceptionregionendmarkerinstr);
    }

    @Override
    public void ExceptionRegionStartMarkerInstr(ExceptionRegionStartMarkerInstr exceptionregionstartmarkerinstr) {
        throw new NotCompilableException("Marker instructions shouldn't reach compiler: " + exceptionregionstartmarkerinstr);
    }

    @Override
    public void GetClassVarContainerModuleInstr(GetClassVarContainerModuleInstr getclassvarcontainermoduleinstr) {
        this.jvmMethod().loadContext();
        this.visit(getclassvarcontainermoduleinstr.getStartingScope());
        if (getclassvarcontainermoduleinstr.getObject() != null) {
            this.visit(getclassvarcontainermoduleinstr.getObject());
        } else {
            this.jvmAdapter().aconst_null();
        }
        this.jvmMethod().invokeIRHelper("getModuleFromScope", CodegenUtils.sig(RubyModule.class, ThreadContext.class, StaticScope.class, IRubyObject.class));
        this.jvmStoreLocal(getclassvarcontainermoduleinstr.getResult());
    }

    @Override
    public void GetClassVariableInstr(GetClassVariableInstr getclassvariableinstr) {
        this.jvmMethod().loadContext();
        this.visit(getclassvariableinstr.getSource());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
        this.jvmAdapter().ldc(getclassvariableinstr.getId());
        this.jvmMethod().invokeIRHelper("getClassVariable", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyModule.class, String.class));
        this.jvmStoreLocal(getclassvariableinstr.getResult());
    }

    @Override
    public void GetFieldInstr(GetFieldInstr getfieldinstr) {
        Operand source2 = getfieldinstr.getSource();
        if (!source2.canCopyPropagate()) {
            throw new NotCompilableException("non-propagatable target for PutField: " + source2);
        }
        this.jvmMethod().getInstanceVariableCompiler().getField(() -> this.visit(source2), getfieldinstr.getId());
        this.jvmStoreLocal(getfieldinstr.getResult());
    }

    @Override
    public void GetGlobalVariableInstr(GetGlobalVariableInstr getglobalvariableinstr) {
        this.jvmMethod().getGlobalVariableCompiler().getGlobalVariable(getglobalvariableinstr.getTarget().getId(), this.file);
        this.jvmStoreLocal(getglobalvariableinstr.getResult());
    }

    @Override
    public void GVarAliasInstr(GVarAliasInstr gvaraliasinstr) {
        this.jvmMethod().getValueCompiler().pushRuntime();
        this.visit(gvaraliasinstr.getNewName());
        this.visit(gvaraliasinstr.getOldName());
        this.jvmMethod().invokeIRHelper("aliasGlobalVariable", CodegenUtils.sig(Void.TYPE, Ruby.class, Object.class, Object.class));
    }

    @Override
    public void InheritanceSearchConstInstr(InheritanceSearchConstInstr inheritancesearchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(inheritancesearchconstinstr.getCurrentModule());
        this.jvmMethod().getConstantCompiler().inheritanceSearchConst(inheritancesearchconstinstr.getId(), inheritancesearchconstinstr.getName().getBytes());
        this.jvmStoreLocal(inheritancesearchconstinstr.getResult());
    }

    @Override
    public void InstanceSuperInstr(InstanceSuperInstr instancesuperinstr) {
        String name2 = instancesuperinstr.getId();
        Operand[] args2 = instancesuperinstr.getCallArgs();
        Operand definingModule = instancesuperinstr.getDefiningModule();
        boolean[] splatMap = instancesuperinstr.splatMap();
        Operand closure = instancesuperinstr.getClosureArg(NullBlock.INSTANCE);
        this.superCommon(name2, instancesuperinstr, args2, definingModule, splatMap, closure);
    }

    private void superCommon(String name2, CallInstr instr, Operand[] args2, Operand definingModule, boolean[] splatMap, Operand closure) {
        IRBytecodeAdapter m = this.jvmMethod();
        Operation operation = instr.getOperation();
        m.loadContext();
        m.loadSelf();
        m.loadSelf();
        if (definingModule == UndefinedValue.UNDEFINED) {
            this.jvmAdapter().aconst_null();
        } else {
            this.visit(definingModule);
        }
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyClass.class));
        for (int i2 = 0; i2 < args2.length; ++i2) {
            Operand operand = args2[i2];
            this.visit(operand);
        }
        boolean hasClosure = closure != NullBlock.INSTANCE;
        boolean literalClosure = closure instanceof WrappedIRClosure;
        if (hasClosure) {
            m.loadContext();
            if (instr.isPotentiallyRefined()) {
                m.loadStaticScope();
            }
            this.visit(closure);
            if (instr.isPotentiallyRefined()) {
                m.invokeIRHelper("getRefinedBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, StaticScope.class, Object.class));
            } else {
                m.invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
            }
        }
        switch (operation) {
            case INSTANCE_SUPER: {
                m.getInvocationCompiler().invokeInstanceSuper(this.file, name2, args2.length, hasClosure, literalClosure, splatMap, instr.getFlags());
                break;
            }
            case CLASS_SUPER: {
                m.getInvocationCompiler().invokeClassSuper(this.file, name2, args2.length, hasClosure, literalClosure, splatMap, instr.getFlags());
                break;
            }
            case UNRESOLVED_SUPER: {
                m.getInvocationCompiler().invokeUnresolvedSuper(this.file, name2, args2.length, hasClosure, literalClosure, splatMap, instr.getFlags());
                break;
            }
            case ZSUPER: {
                m.getInvocationCompiler().invokeZSuper(this.file, name2, args2.length, hasClosure, splatMap, instr.getFlags());
                break;
            }
            default: {
                throw new NotCompilableException("unknown super type " + (Object)((Object)operation) + " in " + instr);
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void JumpInstr(JumpInstr jumpinstr) {
        this.jvmMethod().goTo(this.getJVMLabel(jumpinstr.getJumpTarget()));
    }

    @Override
    public void LabelInstr(LabelInstr labelinstr) {
    }

    @Override
    public void LexicalSearchConstInstr(LexicalSearchConstInstr lexicalsearchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(lexicalsearchconstinstr.getDefiningScope());
        this.jvmMethod().getConstantCompiler().lexicalSearchConst(lexicalsearchconstinstr.getId(), lexicalsearchconstinstr.getName().getBytes());
        this.jvmStoreLocal(lexicalsearchconstinstr.getResult());
    }

    @Override
    public void LineNumberInstr(LineNumberInstr linenumberinstr) {
        this.jvmMethod().updateLineNumber(linenumberinstr.getLineNumber());
        if (linenumberinstr.coverage) {
            this.jvmMethod().loadContext();
            this.jvmAdapter().invokedynamic("coverLine", CodegenUtils.sig(Void.TYPE, ThreadContext.class), Bootstrap.coverLineHandle(), this.jvm.methodData().scope.getFile(), linenumberinstr.getLineNumber(), linenumberinstr.oneshot ? 1 : 0);
        }
    }

    @Override
    public void LoadLocalVarInstr(LoadLocalVarInstr loadlocalvarinstr) {
        this.LocalVariable(loadlocalvarinstr.getLocalVar());
        this.jvmStoreLocal(loadlocalvarinstr.getResult());
    }

    @Override
    public void LoadImplicitClosure(LoadImplicitClosureInstr loadimplicitclosureinstr) {
        this.jvmMethod().loadBlock();
        this.jvmStoreLocal(loadimplicitclosureinstr.getResult());
    }

    @Override
    public void LoadFrameClosure(LoadFrameClosureInstr loadframeclosureinstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameBlock", CodegenUtils.sig(Block.class, new Class[0]));
        this.jvmStoreLocal(loadframeclosureinstr.getResult());
    }

    @Override
    public void LoadBlockImplicitClosure(LoadBlockImplicitClosureInstr loadblockimplicitclosureinstr) {
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().invokeHelper("getImplicitBlockFromBlockBinding", Block.class, Block.class);
        this.jvmStoreLocal(loadblockimplicitclosureinstr.getResult());
    }

    @Override
    public void MatchInstr(MatchInstr matchInstr) {
        this.compileCallCommon(this.jvmMethod(), matchInstr);
    }

    @Override
    public void ModuleVersionGuardInstr(ModuleVersionGuardInstr moduleversionguardinstr) {
    }

    @Override
    public void NopInstr(NopInstr nopinstr) {
    }

    @Override
    public void NoResultCallInstr(NoResultCallInstr noResultCallInstr) {
        this.compileCallCommon(this.jvmMethod(), noResultCallInstr);
    }

    public void oneFixnumArgNoBlockCallInstr(OneFixnumArgNoBlockCallInstr oneFixnumArgNoBlockCallInstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        long fixnum = oneFixnumArgNoBlockCallInstr.getFixnumArg();
        Operand receiver2 = oneFixnumArgNoBlockCallInstr.getReceiver();
        Variable result2 = oneFixnumArgNoBlockCallInstr.getResult();
        boolean functional = oneFixnumArgNoBlockCallInstr.getCallType() == CallType.FUNCTIONAL || oneFixnumArgNoBlockCallInstr.getCallType() == CallType.VARIABLE;
        m.loadContext();
        if (!functional) {
            m.loadSelf();
        }
        this.visit(receiver2);
        m.getInvocationCompiler().invokeOtherOneFixnum(this.file, oneFixnumArgNoBlockCallInstr, fixnum);
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    public void oneFloatArgNoBlockCallInstr(OneFloatArgNoBlockCallInstr oneFloatArgNoBlockCallInstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        double flote = oneFloatArgNoBlockCallInstr.getFloatArg();
        Operand receiver2 = oneFloatArgNoBlockCallInstr.getReceiver();
        Variable result2 = oneFloatArgNoBlockCallInstr.getResult();
        boolean functional = oneFloatArgNoBlockCallInstr.getCallType() == CallType.FUNCTIONAL || oneFloatArgNoBlockCallInstr.getCallType() == CallType.VARIABLE;
        m.loadContext();
        if (!functional) {
            m.loadSelf();
        }
        this.visit(receiver2);
        m.getInvocationCompiler().invokeOtherOneFloat(this.file, oneFloatArgNoBlockCallInstr, flote);
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void OptArgMultipleAsgnInstr(OptArgMultipleAsgnInstr optargmultipleasgninstr) {
        this.visit(optargmultipleasgninstr.getArray());
        this.jvmAdapter().ldc(optargmultipleasgninstr.getMinArgsLength());
        this.jvmAdapter().ldc(optargmultipleasgninstr.getIndex());
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "extractOptionalArgument", CodegenUtils.sig(IRubyObject.class, RubyArray.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(optargmultipleasgninstr.getResult());
    }

    @Override
    public void PopBindingInstr(PopBindingInstr popbindinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod((String)"void popScope()"));
    }

    @Override
    public void PopBlockFrameInstr(PopBlockFrameInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getFrame());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "postYieldNoScope", CodegenUtils.sig(Void.TYPE, Frame.class));
    }

    @Override
    public void PopMethodFrameInstr(PopMethodFrameInstr popframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod((String)"void postMethodFrameOnly()"));
    }

    @Override
    public void PopBackrefFrameInstr(PopBackrefFrameInstr popframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod((String)"void postBackrefMethod()"));
    }

    @Override
    public void PrepareBlockArgsInstr(PrepareBlockArgsInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().ldc(((IRClosure)this.jvm.methodData().scope).receivesKeywordArgs());
        this.jvmAdapter().ldc(((IRClosure)this.jvm.methodData().scope).isRuby2Keywords());
        this.jvmMethod().invokeIRHelper("prepareBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void PrepareFixedBlockArgsInstr(PrepareFixedBlockArgsInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmMethod().invokeIRHelper("prepareFixedBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void PrepareSingleBlockArgInstr(PrepareSingleBlockArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmMethod().invokeIRHelper("prepareSingleBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void PrepareNoBlockArgsInstr(PrepareNoBlockArgsInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmMethod().invokeIRHelper("prepareNoBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void ProcessModuleBodyInstr(ProcessModuleBodyInstr processmodulebodyinstr) {
        this.jvmMethod().loadContext();
        this.visit(processmodulebodyinstr.getModuleBody());
        this.visit(processmodulebodyinstr.getBlock());
        this.jvmMethod().invokeIRHelper("invokeModuleBody", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicMethod.class, Block.class));
        this.jvmStoreLocal(processmodulebodyinstr.getResult());
    }

    @Override
    public void PushBlockBindingInstr(PushBlockBindingInstr instr) {
        boolean pushNewDynScope;
        IRScope scope = this.jvm.methodData().scope;
        FullInterpreterContext fullIC = scope.getExecutionContext();
        boolean reuseParentDynScope = fullIC.reuseParentDynScope();
        boolean bl = pushNewDynScope = !fullIC.isDynamicScopeEliminated() && !reuseParentDynScope;
        if (pushNewDynScope) {
            if (reuseParentDynScope) {
                throw new NotCompilableException("BUG: both create new scope and reuse parent scope specified");
            }
            this.jvmMethod().loadContext();
            this.jvmMethod().loadSelfBlock();
            this.jvmMethod().invokeIRHelper("pushBlockDynamicScopeNew", CodegenUtils.sig(DynamicScope.class, ThreadContext.class, Block.class));
        } else if (reuseParentDynScope) {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadSelfBlock();
            this.jvmMethod().invokeIRHelper("pushBlockDynamicScopeReuse", CodegenUtils.sig(DynamicScope.class, ThreadContext.class, Block.class));
        } else {
            this.jvmAdapter().aconst_null();
        }
        this.jvmStoreLocal(DYNAMIC_SCOPE);
    }

    @Override
    public void PushBlockFrameInstr(PushBlockFrameInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "preYieldNoScope", CodegenUtils.sig(Frame.class, Block.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void PushMethodBindingInstr(PushMethodBindingInstr pushbindinginstr) {
        IRScope scope = this.jvm.methodData().scope;
        if (scope.isScriptScope() && scope.getRootLexicalScope() != null) {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadStaticScope();
            this.jvmMethod().invokeIRHelper("prepareScriptScope", CodegenUtils.sig(DynamicScope.class, ThreadContext.class, StaticScope.class));
            this.jvmStoreLocal(DYNAMIC_SCOPE);
            return;
        }
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "pushNewScope", CodegenUtils.sig(DynamicScope.class, StaticScope.class));
        this.jvmStoreLocal(DYNAMIC_SCOPE);
    }

    @Override
    public void RaiseRequiredKeywordArgumentErrorInstr(RaiseRequiredKeywordArgumentError instr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().ldc(instr.getId());
        this.jvmMethod().invokeIRHelper("newRequiredKeywordArgumentError", CodegenUtils.sig(RaiseException.class, ThreadContext.class, String.class));
        this.jvmAdapter().athrow();
    }

    @Override
    public void PushMethodFrameInstr(PushMethodFrameInstr pushframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadFrameClass();
        this.jvmMethod().loadFrameName();
        this.jvmMethod().loadSelf();
        this.jvmAdapter().getstatic(CodegenUtils.p(Visibility.class), pushframeinstr.getVisibility().name(), CodegenUtils.ci(Visibility.class));
        this.jvmMethod().loadBlock();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "preMethodFrameOnly", CodegenUtils.sig(Void.TYPE, RubyModule.class, String.class, IRubyObject.class, Visibility.class, Block.class));
    }

    @Override
    public void PushBackrefFrameInstr(PushBackrefFrameInstr pushframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod((String)"void preBackrefMethod()"));
    }

    @Override
    public void PutClassVariableInstr(PutClassVariableInstr putclassvariableinstr) {
        if (putclassvariableinstr.getValue() instanceof CurrentScope) {
            this.visit(putclassvariableinstr.getTarget());
            this.visit(putclassvariableinstr.getValue());
            this.jvmAdapter().pop2();
            return;
        }
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelf();
        this.visit(putclassvariableinstr.getTarget());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
        this.jvmAdapter().ldc(putclassvariableinstr.getId());
        this.visit(putclassvariableinstr.getValue());
        this.jvmMethod().invokeIRHelper("putClassVariable", CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    }

    @Override
    public void PutConstInstr(PutConstInstr putconstinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        m.loadContext();
        m.loadSelf();
        this.visit(putconstinstr.getTarget());
        m.adapter.checkcast(CodegenUtils.p(RubyModule.class));
        m.adapter.ldc(putconstinstr.getId());
        this.visit(putconstinstr.getValue());
        m.invokeIRHelper("putConst", CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    }

    @Override
    public void PutFieldInstr(PutFieldInstr putfieldinstr) {
        Operand target = putfieldinstr.getTarget();
        if (!target.canCopyPropagate()) {
            throw new NotCompilableException("non-propagatable target for PutField: " + target);
        }
        this.jvmMethod().getInstanceVariableCompiler().putField(() -> this.visit(target), () -> this.visit(putfieldinstr.getValue()), putfieldinstr.getId());
    }

    @Override
    public void PutGlobalVarInstr(PutGlobalVarInstr putglobalvarinstr) {
        this.visit(putglobalvarinstr.getValue());
        this.jvmMethod().getGlobalVariableCompiler().setGlobalVariable(putglobalvarinstr.getTarget().getId(), this.file);
    }

    @Override
    public void ReifyClosureInstr(ReifyClosureInstr reifyclosureinstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal("$blockArg");
        this.jvmMethod().invokeIRHelper("newProc", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Block.class));
        this.jvmStoreLocal(reifyclosureinstr.getResult());
    }

    @Override
    public void ReceiveRubyExceptionInstr(ReceiveRubyExceptionInstr receiveexceptioninstr) {
        this.jvmStoreLocal(receiveexceptioninstr.getResult());
    }

    @Override
    public void ReceiveJRubyExceptionInstr(ReceiveJRubyExceptionInstr receiveexceptioninstr) {
        this.jvmStoreLocal(receiveexceptioninstr.getResult());
    }

    @Override
    public void ReceiveKeywordsInstr(ReceiveKeywordsInstr instr) {
        int argsLength = this.jvm.methodData().specificArity;
        if (argsLength >= 0) {
            if (argsLength > 0) {
                this.jvmMethod().loadContext();
                this.jvmMethod().loadStaticScope();
                this.jvmAdapter().aload(3 + argsLength - 1);
                this.jvmMethod().invokeIRHelper("receiveSpecificArityKeywords", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, StaticScope.class, IRubyObject.class));
                this.jvmAdapter().astore(3 + argsLength - 1);
            } else {
                this.jvmMethod().loadContext();
                this.jvmMethod().invokeIRHelper("resetCallInfo", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            }
            this.jvmMethod().invokeIRHelper("undefined", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        } else {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadStaticScope();
            this.jvmMethod().loadArgs();
            this.jvmAdapter().ldc(instr.hasRestArg());
            this.jvmAdapter().ldc(instr.acceptsKeywords());
            this.jvmMethod().invokeIRHelper("receiveKeywords", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, StaticScope.class, IRubyObject[].class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE));
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveKeywordArgInstr(ReceiveKeywordArgInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getKeywords());
        this.jvmAdapter().ldc(instr.getId());
        this.jvmMethod().invokeIRHelper("receiveKeywordArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveKeywordRestArgInstr(ReceiveKeywordRestArgInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getKeywords());
        this.jvmMethod().invokeIRHelper("receiveKeywordRestArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveOptArgInstr(ReceiveOptArgInstr instr) {
        this.jvmMethod().loadArgs();
        this.visit(instr.getKeywords());
        this.jvmAdapter().pushInt(instr.requiredArgs);
        this.jvmAdapter().pushInt(instr.preArgs);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmMethod().invokeIRHelper("receiveOptArg", CodegenUtils.sig(IRubyObject.class, IRubyObject[].class, IRubyObject.class, Integer.TYPE, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceivePreReqdArgInstr(ReceivePreReqdArgInstr instr) {
        if (this.jvm.methodData().specificArity >= 0 && instr.getArgIndex() < this.jvm.methodData().specificArity) {
            this.jvmAdapter().aload(this.jvm.methodData().signature.argOffset("arg" + instr.getArgIndex()));
        } else {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadArgs();
            this.jvmAdapter().pushInt(instr.getArgIndex());
            this.jvmMethod().invokeIRHelper("getPreArgSafe", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE));
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceivePostReqdArgInstr(ReceivePostReqdArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.visit(instr.getKeywords());
        this.jvmAdapter().pushInt(instr.preReqdArgsCount);
        this.jvmAdapter().pushInt(instr.optArgsCount);
        this.jvmAdapter().pushBoolean(instr.restArg);
        this.jvmAdapter().pushInt(instr.postReqdArgsCount);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmMethod().invokeIRHelper("receivePostReqdArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, IRubyObject.class, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveRestArgInstr(ReceiveRestArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.visit(instr.getKeywords());
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmMethod().invokeIRHelper("receiveRestArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, IRubyObject.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveSelfInstr(ReceiveSelfInstr receiveselfinstr) {
    }

    @Override
    public void RecordEndBlockInstr(RecordEndBlockInstr recordEndBlockInstr) {
        this.jvmMethod().loadContext();
        this.visit(recordEndBlockInstr.getEndBlockClosure());
        this.jvmMethod().invokeIRHelper("pushExitBlock", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Object.class));
    }

    @Override
    public void ReqdArgMultipleAsgnInstr(ReqdArgMultipleAsgnInstr reqdargmultipleasgninstr) {
        this.jvmMethod().loadContext();
        this.visit(reqdargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getPreArgsCount());
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getIndex());
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getPostArgsCount());
        this.jvmMethod().invokeIRHelper("irReqdArgMultipleAsgn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(reqdargmultipleasgninstr.getResult());
    }

    @Override
    public void RescueEQQInstr(RescueEQQInstr rescueeqqinstr) {
        this.jvmMethod().loadContext();
        this.visit(rescueeqqinstr.getArg1());
        this.visit(rescueeqqinstr.getArg2());
        this.jvmMethod().invokeIRHelper("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Object.class));
        this.jvmStoreLocal(rescueeqqinstr.getResult());
    }

    @Override
    public void RestArgMultipleAsgnInstr(RestArgMultipleAsgnInstr restargmultipleasgninstr) {
        this.jvmMethod().loadContext();
        this.visit(restargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().pushInt(restargmultipleasgninstr.getPreArgsCount());
        this.jvmAdapter().pushInt(restargmultipleasgninstr.getPostArgsCount());
        this.jvmAdapter().invokestatic(CodegenUtils.p(Helpers.class), "viewArgsArray", CodegenUtils.sig(RubyArray.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(restargmultipleasgninstr.getResult());
    }

    @Override
    public void RestoreBindingVisibilityInstr(RestoreBindingVisibilityInstr instr) {
        this.jvmMethod().loadSelfBlock();
        this.visit(instr.getVisibility());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Block.class), "setVisibility", CodegenUtils.sig(Void.TYPE, Visibility.class));
    }

    @Override
    public void ReturnOrRethrowSavedExcInstr(ReturnOrRethrowSavedExcInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getReturnValue());
        this.jvmMethod().invokeIRHelper("returnOrRethrowSavedException", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void RuntimeHelperCall(RuntimeHelperCall runtimehelpercall) {
        switch (runtimehelpercall.getHelperMethod()) {
            case HANDLE_PROPAGATED_BREAK: {
                this.jvmMethod().loadContext();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handlePropagatedBreak", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, Object.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HANDLE_NONLOCAL_RETURN: {
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handleNonlocalReturn", CodegenUtils.sig(IRubyObject.class, DynamicScope.class, Object.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HANDLE_BREAK_AND_RETURNS_IN_LAMBDA: {
                this.jvmMethod().loadContext();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadSelfBlock();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handleBreakAndReturnsInLambdas", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, Object.class, Block.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_BACKREF: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedBackref", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CALL: {
                this.jvmMethod().loadContext();
                this.jvmMethod().loadSelf();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedCall", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CONSTANT_OR_METHOD: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.visit(runtimehelpercall.getArgs()[1]);
                this.visit(runtimehelpercall.getArgs()[2]);
                this.visit(runtimehelpercall.getArgs()[3]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedConstantOrMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyString.class, IRubyObject.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_NTH_REF: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc((int)((Fixnum)runtimehelpercall.getArgs()[0]).getValue());
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedNthRef", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_GLOBAL: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[0])).getString());
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedGlobal", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_INSTANCE_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedInstanceVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CLASS_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedClassVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyModule.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_SUPER: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadFrameName();
                this.jvmMethod().loadFrameClass();
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedSuper", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_METHOD: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.jvmAdapter().ldc(((Boolean)runtimehelpercall.getArgs()[2]).isTrue());
                this.visit(runtimehelpercall.getArgs()[3]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, java.lang.Boolean.TYPE, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case MERGE_KWARGS: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().ldc(runtimehelpercall.getArgs()[2] == this.runtime.getIRManager().getTrue());
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "mergeKeywordArguments", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, java.lang.Boolean.TYPE));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HASH_CHECK: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "hashCheck", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_HASH_EMPTY: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isHashEmpty", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            default: {
                throw new NotCompilableException("Unknown IR runtime helper method: " + (Object)((Object)runtimehelpercall.getHelperMethod()) + "; INSTR: " + this);
            }
        }
    }

    @Override
    public void SaveBindingVisibilityInstr(SaveBindingVisibilityInstr instr) {
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Block.class), "getVisibility", CodegenUtils.sig(Visibility.class, new Class[0]));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ToggleBacktraceInstr(ToggleBacktraceInstr instr) {
        this.jvmMethod().loadContext();
        if (instr.requiresBacktrace()) {
            this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "exceptionBacktraceOn", CodegenUtils.sig(Void.TYPE, new Class[0]));
        } else {
            this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "exceptionBacktraceOff", CodegenUtils.sig(Void.TYPE, new Class[0]));
        }
    }

    @Override
    public void NonlocalReturnInstr(NonlocalReturnInstr returninstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelfBlock();
        this.visit(returninstr.getReturnValue());
        this.jvmMethod().invokeIRHelper("initiateNonLocalReturn", CodegenUtils.sig(IRubyObject.class, DynamicScope.class, Block.class, IRubyObject.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void ReturnInstr(ReturnInstr returninstr) {
        this.visit(returninstr.getReturnValue());
        this.jvmMethod().returnValue();
    }

    @Override
    public void SearchConstInstr(SearchConstInstr searchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(searchconstinstr.getStartingScope());
        this.jvmMethod().getConstantCompiler().searchConst(searchconstinstr.getId(), searchconstinstr.getName().getBytes(), searchconstinstr.isNoPrivateConsts());
        this.jvmStoreLocal(searchconstinstr.getResult());
    }

    @Override
    public void SearchModuleForConstInstr(SearchModuleForConstInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getCurrentModule());
        this.jvmMethod().getConstantCompiler().searchModuleForConst(instr.getId(), instr.getName().getBytes(), instr.isNoPrivateConsts(), instr.callConstMissing());
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void SetCapturedVarInstr(SetCapturedVarInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getMatch2Result());
        this.jvmAdapter().ldc(instr.getId());
        this.jvmMethod().invokeIRHelper("setCapturedVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void StoreLocalVarInstr(StoreLocalVarInstr storelocalvarinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        int depth = storelocalvarinstr.getLocalVar().getScopeDepth();
        int location = storelocalvarinstr.getLocalVar().getLocation();
        Operand storeValue = storelocalvarinstr.getValue();
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class));
                        return;
                    }
                    case 1: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class));
                        return;
                    }
                    case 2: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class));
                        return;
                    }
                    case 3: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class));
                        return;
                    }
                }
                storeValue.visit(this);
                m.adapter.pushInt(location);
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE));
                return;
            }
        }
        m.adapter.pushInt(location);
        storeValue.visit(this);
        m.adapter.pushInt(depth);
        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueVoid", CodegenUtils.sig(Void.TYPE, Integer.TYPE, IRubyObject.class, Integer.TYPE));
    }

    @Override
    public void ThreadPollInstr(ThreadPollInstr threadpollinstr) {
        this.jvmMethod().getCheckpointCompiler().checkpoint();
    }

    @Override
    public void ThrowExceptionInstr(ThrowExceptionInstr throwexceptioninstr) {
        this.visit(throwexceptioninstr.getException());
        this.jvmAdapter().athrow();
    }

    @Override
    public void ToAryInstr(ToAryInstr toaryinstr) {
        this.jvmMethod().loadContext();
        this.visit(toaryinstr.getArray());
        this.jvmMethod().invokeIRHelper("irToAry", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        this.jvmStoreLocal(toaryinstr.getResult());
    }

    @Override
    public void TraceInstr(TraceInstr traceInstr) {
        this.jvmMethod().loadContext();
        String name2 = traceInstr.getName();
        if (name2 == null) {
            name2 = "null";
        }
        switch (traceInstr.getEvent()) {
            case CALL: 
            case RETURN: 
            case CLASS: 
            case END: 
            case LINE: {
                this.jvmMethod().loadFrameClass();
                this.jvmAdapter().invokedynamic(traceInstr.getEvent().getName(), CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject.class), CallTraceSite.BOOTSTRAP, name2, traceInstr.getFilename(), traceInstr.getLinenumber());
                break;
            }
            case B_CALL: 
            case B_RETURN: {
                this.jvmMethod().loadSelfBlock();
                this.jvmAdapter().invokedynamic(traceInstr.getEvent().getName(), CodegenUtils.sig(Void.TYPE, ThreadContext.class, Block.class), CallTraceSite.BOOTSTRAP, name2, traceInstr.getFilename(), traceInstr.getLinenumber());
                break;
            }
            default: {
                throw new NotCompilableException("unknown trace event in JIT: " + (Object)((Object)traceInstr.getEvent()));
            }
        }
    }

    @Override
    public void UndefMethodInstr(UndefMethodInstr undefmethodinstr) {
        this.jvmMethod().loadContext();
        this.visit(undefmethodinstr.getMethodName());
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelf();
        this.jvmMethod().invokeIRHelper("undefMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class, DynamicScope.class, IRubyObject.class));
        this.jvmStoreLocal(undefmethodinstr.getResult());
    }

    @Override
    public void UnresolvedSuperInstr(UnresolvedSuperInstr unresolvedsuperinstr) {
        String name2 = unresolvedsuperinstr.getId();
        Operand[] args2 = unresolvedsuperinstr.getCallArgs();
        UndefinedValue definingModule = UndefinedValue.UNDEFINED;
        boolean[] splatMap = unresolvedsuperinstr.splatMap();
        Operand closure = unresolvedsuperinstr.getClosureArg(NullBlock.INSTANCE);
        this.superCommon(name2, unresolvedsuperinstr, args2, definingModule, splatMap, closure);
    }

    @Override
    public void UpdateBlockExecutionStateInstr(UpdateBlockExecutionStateInstr instr) {
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadSelf();
        this.jvmMethod().invokeIRHelper("updateBlockState", CodegenUtils.sig(IRubyObject.class, Block.class, IRubyObject.class));
        this.jvmMethod().storeSelf();
    }

    private void setupCallInfo(int flags2) {
        this.jvmMethod().getInvocationCompiler().setCallInfo(flags2);
    }

    @Override
    public void YieldInstr(YieldInstr yieldinstr) {
        this.jvmMethod().loadContext();
        this.visit(yieldinstr.getBlockArg());
        if (yieldinstr.getYieldArg() == UndefinedValue.UNDEFINED) {
            this.setupCallInfo(yieldinstr.getFlags());
            this.jvmMethod().getYieldCompiler().yieldSpecific();
        } else {
            Operand yieldOp = yieldinstr.getYieldArg();
            if (yieldinstr.isUnwrapArray() && yieldOp instanceof Array && ((Array)yieldOp).size() > 1) {
                Array yieldValues = (Array)yieldOp;
                for (Operand yieldValue : yieldValues) {
                    this.visit(yieldValue);
                }
                this.setupCallInfo(yieldinstr.getFlags());
                this.jvmMethod().getYieldCompiler().yieldValues(yieldValues.size());
            } else {
                this.visit(yieldinstr.getYieldArg());
                this.setupCallInfo(yieldinstr.getFlags());
                this.jvmMethod().getYieldCompiler().yield(yieldinstr.isUnwrapArray());
            }
        }
        this.jvmStoreLocal(yieldinstr.getResult());
    }

    @Override
    public void ZSuperInstr(ZSuperInstr zsuperinstr) {
        String name2 = zsuperinstr.getId();
        Operand[] args2 = zsuperinstr.getCallArgs();
        UndefinedValue definingModule = UndefinedValue.UNDEFINED;
        boolean[] splatMap = zsuperinstr.splatMap();
        Operand closure = zsuperinstr.getClosureArg(NullBlock.INSTANCE);
        this.superCommon(name2, zsuperinstr, args2, definingModule, splatMap, closure);
    }

    @Override
    public void GetErrorInfoInstr(GetErrorInfoInstr geterrorinfoinstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getErrorInfo", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.jvmStoreLocal(geterrorinfoinstr.getResult());
    }

    @Override
    public void RestoreErrorInfoInstr(RestoreErrorInfoInstr restoreerrorinfoinstr) {
        this.jvmMethod().loadContext();
        this.visit(restoreerrorinfoinstr.getArg());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        this.jvmAdapter().pop();
    }

    @Override
    public void BuildLambdaInstr(BuildLambdaInstr buildlambdainstr) {
        this.jvmMethod().loadContext();
        this.visit(buildlambdainstr.getLambdaBody());
        this.jvmMethod().invokeIRHelper("newLambdaProc", CodegenUtils.sig(RubyProc.class, ThreadContext.class, Block.class));
        this.jvmStoreLocal(buildlambdainstr.getResult());
    }

    @Override
    public void GetEncodingInstr(GetEncodingInstr getencodinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().getValueCompiler().pushRubyEncoding(getencodinginstr.getEncoding());
        this.jvmStoreLocal(getencodinginstr.getResult());
    }

    @Override
    public void Array(Array array2) {
        this.jvmMethod().loadContext();
        for (Operand operand : array2.getElts()) {
            this.visit(operand);
        }
        this.jvmMethod().getDynamicValueCompiler().array(array2.getElts().length);
    }

    @Override
    public void Bignum(Bignum bignum) {
        this.jvmMethod().getValueCompiler().pushBignum(bignum.value);
    }

    @Override
    public void Boolean(Boolean booleanliteral) {
        this.jvmMethod().getValueCompiler().pushBoolean(booleanliteral.isTrue());
    }

    @Override
    public void UnboxedBoolean(UnboxedBoolean bool2) {
        this.jvmAdapter().ldc(bool2.isTrue());
    }

    @Override
    public void ClosureLocalVariable(ClosureLocalVariable closurelocalvariable) {
        this.LocalVariable(closurelocalvariable);
    }

    @Override
    public void Complex(Complex complex) {
        this.jvmMethod().loadContext();
        this.visit(complex.getNumber());
        this.jvmMethod().invokeIRHelper("newComplexRaw", CodegenUtils.sig(RubyComplex.class, ThreadContext.class, IRubyObject.class));
    }

    @Override
    public void CurrentScope(CurrentScope currentscope) {
        this.jvmMethod().loadStaticScope();
    }

    @Override
    public void DynamicSymbol(DynamicSymbol dynamicsymbol) {
        this.jvmMethod().loadContext();
        this.visit(dynamicsymbol.getSymbolName());
        this.jvmMethod().invokeIRHelper("newDSymbol", CodegenUtils.sig(RubySymbol.class, ThreadContext.class, IRubyObject.class));
    }

    @Override
    public void Filename(Filename filename2) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmMethod().invokeIRHelper("getFileNameStringFromScope", CodegenUtils.sig(RubyString.class, ThreadContext.class, StaticScope.class));
    }

    @Override
    public void Fixnum(Fixnum fixnum) {
        this.jvmMethod().getValueCompiler().pushFixnum(fixnum.getValue());
    }

    @Override
    public void FrozenString(FrozenString frozen) {
        this.jvmMethod().getValueCompiler().pushFrozenString(frozen.getByteList(), frozen.getCodeRange(), frozen.getFile(), frozen.getLine());
    }

    @Override
    public void UnboxedFixnum(UnboxedFixnum fixnum) {
        this.jvmAdapter().ldc(fixnum.getValue());
    }

    @Override
    public void Float(Float flote) {
        this.jvmMethod().getValueCompiler().pushFloat(flote.getValue());
    }

    @Override
    public void UnboxedFloat(UnboxedFloat flote) {
        this.jvmAdapter().ldc(flote.getValue());
    }

    @Override
    public void Hash(Hash hash2) {
        boolean kwargs = hash2.isKeywordRest();
        List<KeyValuePair<Operand, Operand>> pairs = hash2.getPairs();
        Iterator<KeyValuePair<Operand, Operand>> iter = pairs.iterator();
        this.jvmMethod().loadContext();
        if (kwargs) {
            this.jvmMethod().loadContext();
            this.visit(pairs.get(0).getValue());
            this.jvmMethod().invokeIRHelper("keywordRestOnHash", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
            this.jvmAdapter().checkcast(CodegenUtils.p(RubyHash.class));
            iter.next();
        }
        while (iter.hasNext()) {
            KeyValuePair<Operand, Operand> pair = iter.next();
            this.visit(pair.getKey());
            this.visit(pair.getValue());
        }
        if (kwargs) {
            this.jvmMethod().getArgumentsCompiler().kwargsHash(pairs.size() - 1);
        } else {
            this.jvmMethod().getDynamicValueCompiler().hash(pairs.size());
        }
    }

    @Override
    public void LocalVariable(LocalVariable localvariable) {
        IRBytecodeAdapter m = this.jvmMethod();
        int depth = localvariable.getScopeDepth();
        int location = localvariable.getLocation();
        if (this.jvm.methodData().scope instanceof IRMethod) {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            m.getLocalVariableCompiler().getHeapLocal(depth, location);
        } else {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            m.getLocalVariableCompiler().getHeapLocalOrNil(depth, location);
        }
    }

    @Override
    public void Nil(Nil nil) {
        this.jvmMethod().getValueCompiler().pushNil();
    }

    @Override
    public void NthRef(NthRef nthref) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().pushInt(nthref.matchNumber);
        this.jvmMethod().invokeIRHelper("nthMatch", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE));
    }

    @Override
    public void NullBlock(NullBlock nullblock) {
        this.jvmAdapter().getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
    }

    @Override
    public void BuiltinClass(BuiltinClass builtinClass) {
        switch (builtinClass.getType()) {
            case ARRAY: {
                this.jvmMethod().getValueCompiler().pushArrayClass();
                return;
            }
            case HASH: {
                this.jvmMethod().getValueCompiler().pushHashClass();
                return;
            }
            case OBJECT: {
                this.jvmMethod().getValueCompiler().pushObjectClass();
                return;
            }
        }
        throw new RuntimeException("BuiltinClass has unknown type");
    }

    @Override
    public void Rational(Rational rational) {
        this.jvmMethod().loadContext();
        this.visit(rational.getNumerator());
        this.visit(rational.getDenominator());
        this.jvmMethod().invokeIRHelper("newRationalCanonicalize", CodegenUtils.sig(RubyRational.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
    }

    @Override
    public void Range(Range range) {
        this.jvmMethod().getValueCompiler().pushRange(() -> this.visit(range.getBegin()), () -> this.visit(range.getEnd()), range.isExclusive());
    }

    @Override
    public void Regexp(Regexp regexp2) {
        this.jvmMethod().getValueCompiler().pushRegexp(regexp2.getSource(), regexp2.options.toEmbeddedOptions());
    }

    @Override
    public void Scope(Scope scope) {
        this.jvmMethod().loadStaticScope();
    }

    @Override
    public void ScopeModule(ScopeModule scopemodule) {
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().pushInt(scopemodule.getScopeModuleDepth());
        this.jvmAdapter().invokestatic(CodegenUtils.p(Helpers.class), "getNthScopeModule", CodegenUtils.sig(RubyModule.class, StaticScope.class, Integer.TYPE));
    }

    @Override
    public void Self(Self self2) {
        this.jvmMethod().loadSelf();
    }

    @Override
    public void Splat(Splat splat) {
        this.visit(splat.getArray());
    }

    @Override
    public void StandardError(StandardError standarderror) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeIRHelper("getStandardError", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void MutableString(MutableString mutablestring) {
        this.jvmMethod().getValueCompiler().pushString(mutablestring.getByteList(), mutablestring.getCodeRange());
    }

    @Override
    public void SValue(SValue svalue) {
        this.jvmMethod().loadContext();
        this.visit(svalue.getArray());
        this.jvmMethod().invokeIRHelper("svalue", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class));
    }

    @Override
    public void Symbol(Symbol symbol) {
        this.jvmMethod().getValueCompiler().pushSymbol(symbol.getBytes());
    }

    @Override
    public void SymbolProc(SymbolProc symbolproc) {
        this.jvmMethod().getValueCompiler().pushSymbolProc(symbolproc.getName().getBytes());
    }

    @Override
    public void TemporaryVariable(TemporaryVariable temporaryvariable) {
        this.jvmLoadLocal(temporaryvariable);
    }

    @Override
    public void TemporaryLocalVariable(TemporaryLocalVariable temporarylocalvariable) {
        this.jvmLoadLocal(temporarylocalvariable);
    }

    @Override
    public void TemporaryFloatVariable(TemporaryFloatVariable temporaryfloatvariable) {
        this.jvmLoadLocal(temporaryfloatvariable);
    }

    @Override
    public void TemporaryFixnumVariable(TemporaryFixnumVariable temporaryfixnumvariable) {
        this.jvmLoadLocal(temporaryfixnumvariable);
    }

    @Override
    public void TemporaryBooleanVariable(TemporaryBooleanVariable temporarybooleanvariable) {
        this.jvmLoadLocal(temporarybooleanvariable);
    }

    @Override
    public void UndefinedValue(UndefinedValue undefinedvalue) {
        this.jvmMethod().getValueCompiler().pushUndefined();
    }

    @Override
    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
        throw new NotCompilableException(this.getClass().getSimpleName() + " should never be directly executed!");
    }

    @Override
    public void WrappedIRClosure(WrappedIRClosure wrappedirclosure) {
        IRClosure closure = wrappedirclosure.getClosure();
        this.jvmMethod().loadContext();
        this.visit(closure.getSelf());
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().getBlockCompiler().prepareBlock(closure, this.scopeFieldMap.get(closure.getStaticScope().getEnclosingScope()), this.closuresMap.get(closure), closure.getFile(), closure.getLine(), ArgumentDescriptor.encode(closure.getArgumentDescriptors()), closure.getSignature());
    }

    private SkinnyMethodAdapter jvmAdapter() {
        return this.jvmMethod().adapter;
    }

    private IRBytecodeAdapter jvmMethod() {
        return this.jvm.method();
    }
}

