/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import jnr.constants.platform.AddressFamily;
import jnr.unixsocket.UnixSocketAddress;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.ext.socket.SocketUtilsIPV6;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Sockaddr {
    private static final int SOCKADDR_UN_PATH = 108;
    private static final int SOCKADDR_UN_SIZE = 110;

    public static InetAddress addressFromString(Ruby runtime2, String s2) {
        try {
            byte[] bs = ByteList.plain(s2);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw Sockaddr.sockerr(runtime2, "strtoaddr: " + e.toString());
        }
    }

    public static String stringFromAddress(Ruby runtime2, InetAddress as) {
        try {
            return new String(ByteList.plain(as.getAddress()));
        }
        catch (Exception e) {
            throw Sockaddr.sockerr(runtime2, "addrtostr: " + e.toString());
        }
    }

    public static InetSocketAddress addressFromArg(ThreadContext context, IRubyObject arg2) {
        InetSocketAddress iaddr;
        if (arg2 instanceof Addrinfo) {
            Addrinfo addrinfo = (Addrinfo)arg2;
            if (!addrinfo.ip_p(context).isTrue()) {
                throw context.runtime.newTypeError("not an INET or INET6 address: " + addrinfo);
            }
            iaddr = new InetSocketAddress(addrinfo.getInetAddress(), addrinfo.getPort());
        } else {
            iaddr = Sockaddr.addressFromSockaddr_in(context, arg2);
        }
        return iaddr;
    }

    public static InetSocketAddress addressFromSockaddr_in(ThreadContext context, IRubyObject arg2) {
        ByteList val = arg2.convertToString().getByteList();
        return Sockaddr.addressFromSockaddr_in(context, val);
    }

    public static InetSocketAddress addressFromSockaddr_in(ThreadContext context, ByteList val) {
        RubyArray sockaddr = Sockaddr.unpack_sockaddr_in(context, val);
        IRubyObject addr2 = sockaddr.pop(context);
        IRubyObject _port = sockaddr.pop(context);
        int port = SocketUtils.portToInt(_port);
        return new InetSocketAddress(addr2.convertToString().toString(), port);
    }

    public static SocketAddress addressFromSockaddr(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        ByteList val = arg2.convertToString().getByteList();
        AddressFamily af = Sockaddr.getAddressFamilyFromSockaddr(runtime2, val);
        switch (af) {
            case AF_UNIX: {
                return Sockaddr.addressFromSockaddr_un(context, val);
            }
            case AF_INET: 
            case AF_INET6: {
                return Sockaddr.addressFromSockaddr_in(context, val);
            }
        }
        throw runtime2.newArgumentError("can't resolve socket address of wrong type");
    }

    public static UnixSocketAddress addressFromSockaddr_un(ThreadContext context, IRubyObject arg2) {
        ByteList val = arg2.convertToString().getByteList();
        return Sockaddr.addressFromSockaddr_un(context, val);
    }

    public static UnixSocketAddress addressFromSockaddr_un(ThreadContext context, ByteList bl) {
        RubyString pathStr = Sockaddr.pathFromSockaddr_un(context, bl.bytes());
        return new UnixSocketAddress(new File(pathStr.toString()));
    }

    public static IRubyObject packSockaddrFromAddress(ThreadContext context, InetSocketAddress sock) {
        if (sock == null) {
            return Sockaddr.pack_sockaddr_in(context, 0, "");
        }
        return Sockaddr.pack_sockaddr_in(context, sock);
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject port, IRubyObject host) {
        int portNum = !port.isNil() ? (port instanceof RubyString ? Integer.parseInt(port.convertToString().toString()) : RubyNumeric.fix2int(port)) : 0;
        String hostStr = host.isNil() ? null : host.convertToString().toString();
        return Sockaddr.pack_sockaddr_in(context, portNum, hostStr);
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, int port, String host) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            try {
                if (host != null && host.length() == 0) {
                    Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET, ds);
                    Sockaddr.writeSockaddrPort(ds, port);
                    ds.writeInt(0);
                } else {
                    InetAddress[] addrs = InetAddress.getAllByName(host);
                    byte[] addr2 = addrs[0].getAddress();
                    if (addr2.length == 4) {
                        Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET, ds);
                    } else {
                        Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET6, ds);
                    }
                    Sockaddr.writeSockaddrPort(ds, port);
                    ds.write(addr2, 0, addr2.length);
                }
            }
            catch (UnknownHostException e) {
                throw Sockaddr.sockerr(context.runtime, "getaddrinfo: No address associated with nodename");
            }
            Sockaddr.writeSockaddrFooter(ds);
        }
        catch (IOException e) {
            throw Sockaddr.sockerr(context.runtime, "pack_sockaddr_in: internal error");
        }
        return context.runtime.newString(new ByteList(bufS.toByteArray(), false));
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, InetSocketAddress sock) {
        ByteArrayOutputStream bufS = new ByteArrayOutputStream();
        try {
            DataOutputStream ds = new DataOutputStream(bufS);
            InetAddress inet = sock.getAddress();
            if (inet instanceof Inet4Address) {
                Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET, ds);
            } else {
                Sockaddr.writeSockaddrHeader(AddressFamily.AF_INET6, ds);
            }
            Sockaddr.writeSockaddrPort(ds, sock);
            String host = sock.getAddress().getHostAddress();
            if ("".equals(host)) {
                ds.writeInt(0);
            } else {
                byte[] addr2 = sock.getAddress().getAddress();
                ds.write(addr2, 0, addr2.length);
            }
            Sockaddr.writeSockaddrFooter(ds);
        }
        catch (IOException e) {
            throw Sockaddr.sockerr(context.runtime, "pack_sockaddr_in: internal error");
        }
        return context.runtime.newString(new ByteList(bufS.toByteArray(), false));
    }

    public static RubyArray unpack_sockaddr_in(ThreadContext context, IRubyObject addr2) {
        Ruby runtime2 = context.runtime;
        if (addr2 instanceof Addrinfo) {
            Addrinfo addrinfo = (Addrinfo)addr2;
            if (((RubyBoolean)addrinfo.ip_p(context)).isFalse()) {
                throw runtime2.newArgumentError("not an AF_INET/AF_INET6 sockaddr");
            }
            return RubyArray.newArray(runtime2, addrinfo.ip_port(context), addrinfo.ip_address(context));
        }
        ByteList val = addr2.convertToString().getByteList();
        return Sockaddr.unpack_sockaddr_in(context, val);
    }

    public static RubyArray unpack_sockaddr_in(ThreadContext context, ByteList val) {
        RubyString ip2;
        Ruby runtime2 = context.runtime;
        AddressFamily af = Sockaddr.getAddressFamilyFromSockaddr(runtime2, val);
        if (af != AddressFamily.AF_INET && af != AddressFamily.AF_INET6) {
            throw runtime2.newArgumentError("not an AF_INET/AF_INET6 sockaddr");
        }
        int port = ((val.get(2) & 0xFF) << 8) + (val.get(3) & 0xFF);
        StringBuilder formatAddr = new StringBuilder();
        if (af == AddressFamily.AF_INET) {
            formatAddr.append(val.get(4) & 0xFF).append('.').append(val.get(5) & 0xFF).append('.').append(val.get(6) & 0xFF).append('.').append(val.get(7) & 0xFF);
            ip2 = RubyString.newString(runtime2, formatAddr);
        } else {
            for (int i2 = 4; i2 <= 19; ++i2) {
                if (i2 != 4 && i2 % 2 == 0) {
                    formatAddr.append(':');
                }
                formatAddr.append(Integer.toHexString(val.get(i2) & 0xFF | 0x100).substring(1));
            }
            ip2 = RubyString.newString(runtime2, SocketUtilsIPV6.getIPV6Address(formatAddr.toString()));
        }
        return RubyArray.newArray(runtime2, runtime2.newFixnum(port), ip2);
    }

    public static IRubyObject pack_sockaddr_un(ThreadContext context, String unixpath) {
        Ruby runtime2 = context.runtime;
        ByteBuffer buf = ByteBuffer.allocate(110);
        byte[] path2 = unixpath.getBytes();
        if (path2.length > 108) {
            String errorMsg = "too long unix socket path (%d bytes given but %d bytes max)";
            String formattedErrorMsg = String.format(errorMsg, path2.length, 108);
            throw runtime2.newArgumentError(formattedErrorMsg);
        }
        int afamily2 = AddressFamily.AF_UNIX.intValue();
        int high = (afamily2 & 0xFF00) >> 8;
        int low = afamily2 & 0xFF;
        buf.put((byte)high);
        buf.put((byte)low);
        buf.put(path2);
        return RubyString.newString(runtime2, buf.array());
    }

    public static IRubyObject unpack_sockaddr_un(ThreadContext context, IRubyObject addr2) {
        Ruby runtime2 = context.runtime;
        if (addr2 instanceof Addrinfo) {
            Addrinfo addrinfo = (Addrinfo)addr2;
            if (((RubyBoolean)addrinfo.unix_p(context)).isFalse()) {
                throw runtime2.newArgumentError("not an AF_UNIX sockaddr");
            }
            return addrinfo.unix_path(context);
        }
        ByteList val = addr2.convertToString().getByteList();
        AddressFamily af = Sockaddr.getAddressFamilyFromSockaddr(runtime2, val);
        if (af != AddressFamily.AF_UNIX) {
            throw runtime2.newArgumentError("not an AF_UNIX sockaddr");
        }
        return Sockaddr.pathFromSockaddr_un(context, val.bytes());
    }

    public static void writeSockaddrHeader(AddressFamily family2, DataOutputStream ds) throws IOException {
        int value2 = family2.intValue();
        int high = (value2 & 0xFF00) >> 8;
        int low = value2 & 0xFF;
        ds.write((byte)high);
        ds.write((byte)low);
    }

    public static void writeSockaddrFooter(DataOutputStream ds) throws IOException {
        ds.writeInt(0);
        ds.writeInt(0);
    }

    public static void writeSockaddrPort(DataOutputStream ds, InetSocketAddress sockaddr) throws IOException {
        Sockaddr.writeSockaddrPort(ds, sockaddr.getPort());
    }

    public static void writeSockaddrPort(DataOutputStream ds, int port) throws IOException {
        ds.write(port >> 8);
        ds.write(port);
    }

    public static AddressFamily getAddressFamilyFromSockaddr(Ruby runtime2, ByteList val) {
        if (val.length() < 2) {
            throw runtime2.newArgumentError("too short sockaddr");
        }
        int high = val.get(0) & 0xFF;
        int low = val.get(1) & 0xFF;
        return AddressFamily.valueOf((long)((high << 8) + low));
    }

    private static RuntimeException sockerr(Ruby runtime2, String msg) {
        return RaiseException.from(runtime2, runtime2.getClass("SocketError"), msg);
    }

    public static SocketAddress sockaddrFromBytes(Ruby runtime2, byte[] val) throws IOException {
        AddressFamily afamily2 = AddressFamily.valueOf((long)Sockaddr.uint16(val[0], val[1]));
        if (afamily2 == null || afamily2 == AddressFamily.__UNKNOWN_CONSTANT__) {
            throw runtime2.newArgumentError("can't resolve socket address of wrong type");
        }
        switch (afamily2) {
            case AF_INET: {
                int port = Sockaddr.uint16(val[2], val[3]);
                Inet4Address inet4Address = (Inet4Address)InetAddress.getByAddress(Helpers.subseq(val, 4, 4));
                return new InetSocketAddress(inet4Address, port);
            }
            case AF_INET6: {
                int port = Sockaddr.uint16(val[2], val[3]);
                Inet6Address inet6Address = (Inet6Address)InetAddress.getByAddress(Helpers.subseq(val, 4, 16));
                return new InetSocketAddress(inet6Address, port);
            }
            case AF_UNIX: {
                String path2 = new String(val, 2, val.length - 2);
                return new UnixSocketAddress(new File(path2));
            }
        }
        throw runtime2.newArgumentError("can't resolve socket address of wrong type");
    }

    private static int uint16(byte high, byte low) {
        return ((high & 0xFF) << 8) + (low & 0xFF);
    }

    private static RubyString pathFromSockaddr_un(ThreadContext context, byte[] raw) {
        int end2;
        for (end2 = 2; end2 < raw.length && raw[end2] != 0; ++end2) {
        }
        return RubyString.newString(context.runtime, raw, 2, end2 - 2);
    }
}

