/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.ant;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jsonschema2pojo.AllFileFilter;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.InclusionLevel;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.jsonschema2pojo.NoopAnnotator;
import org.jsonschema2pojo.RuleLogger;
import org.jsonschema2pojo.SourceSortOrder;
import org.jsonschema2pojo.SourceType;
import org.jsonschema2pojo.URLProtocol;
import org.jsonschema2pojo.ant.AntRuleLogger;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.URLUtil;

public class Jsonschema2PojoTask
extends Task
implements GenerationConfig {
    private boolean generateBuilders;
    private boolean includeTypeInfo = false;
    private boolean useInnerClassBuilders = false;
    private boolean includeConstructorPropertiesAnnotation = false;
    private boolean includeConstructors = false;
    private boolean usePrimitives;
    private String source;
    private File targetDirectory;
    private String targetPackage;
    private boolean skip;
    private char[] propertyWordDelimiters = new char[]{'-', ' ', '_'};
    private boolean useLongIntegers;
    private boolean useBigIntegers = false;
    private boolean useDoubleNumbers = true;
    private boolean useBigDecimals = false;
    private boolean includeHashcodeAndEquals = true;
    private boolean includeToString = true;
    private String[] toStringExcludes = new String[0];
    private AnnotationStyle annotationStyle = AnnotationStyle.JACKSON;
    private boolean useTitleAsClassname = false;
    private InclusionLevel inclusionLevel = InclusionLevel.NON_NULL;
    private Class<? extends Annotator> customAnnotator = NoopAnnotator.class;
    private Class<? extends RuleFactory> customRuleFactory = RuleFactory.class;
    private boolean includeJsr303Annotations = false;
    private boolean includeJsr305Annotations = false;
    private boolean useOptionalForGetters;
    private SourceType sourceType = SourceType.JSONSCHEMA;
    private Path classpath;
    private boolean removeOldOutput = false;
    private String outputEncoding = "UTF-8";
    private boolean useJodaDates = false;
    private boolean useJodaLocalDates = false;
    private boolean useJodaLocalTimes = false;
    private boolean parcelable = false;
    private boolean serializable = false;
    private boolean initializeCollections = true;
    private String classNamePrefix = "";
    private String classNameSuffix = "";
    private String[] fileExtensions = new String[0];
    private boolean constructorsRequiredPropertiesOnly = false;
    boolean includeRequiredPropertiesConstructor = false;
    boolean includeAllPropertiesConstructor = true;
    boolean includeCopyConstructor = false;
    private boolean includeAdditionalProperties = true;
    private boolean includeGetters = true;
    private boolean includeSetters = true;
    private String targetVersion = "1.6";
    private boolean includeDynamicAccessors = false;
    private boolean includeDynamicGetters = false;
    private boolean includeDynamicSetters = false;
    private boolean includeDynamicBuilders = false;
    private String dateTimeType;
    private String timeType;
    private String dateType;
    private boolean formatDateTimes = false;
    private boolean formatDates = false;
    private boolean formatTimes = false;
    private String customDatePattern;
    private String customTimePattern;
    private String customDateTimePattern;
    private String refFragmentPathDelimiters = "#/.";
    private SourceSortOrder sourceSortOrder = SourceSortOrder.OS;
    private Map<String, String> formatTypeMapping = new HashMap<String, String>();
    private boolean includeGeneratedAnnotation = true;

    public void execute() throws BuildException {
        File sourceFile;
        URL sourceURL;
        if (this.skip) {
            return;
        }
        if (this.source == null) {
            this.log("source attribute is required but was not set");
            return;
        }
        try {
            sourceURL = URLUtil.parseURL((String)this.source);
        }
        catch (IllegalArgumentException e) {
            this.log(String.format("Invalid schema source provided: %s", this.source));
            return;
        }
        if (URLUtil.parseProtocol((String)sourceURL.toString()) == URLProtocol.FILE && !(sourceFile = new File(sourceURL.getFile())).exists()) {
            this.log(sourceFile.getAbsolutePath() + " cannot be found");
            return;
        }
        if (this.targetDirectory == null) {
            this.log("targetDirectory attribute is required but was not set");
            return;
        }
        ClassLoader extendedClassloader = this.buildExtendedClassloader();
        Thread.currentThread().setContextClassLoader(extendedClassloader);
        AntRuleLogger ruleLogger = new AntRuleLogger(this);
        try {
            Jsonschema2Pojo.generate((GenerationConfig)this, (RuleLogger)ruleLogger);
        }
        catch (IOException e) {
            throw new BuildException("Error generating classes from JSON Schema file(s) " + this.source, (Throwable)e);
        }
    }

    private ClassLoader buildExtendedClassloader() {
        final ArrayList<URL> classpathUrls = new ArrayList<URL>();
        for (String pathElement : this.getClasspath().list()) {
            try {
                classpathUrls.add(new File(pathElement).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new BuildException("Unable to use classpath entry as it could not be understood as a valid URL: " + pathElement, (Throwable)e);
            }
        }
        final ClassLoader parentClassloader = Thread.currentThread().getContextClassLoader();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), parentClassloader);
            }
        });
    }

    public void setIncludeConstructors(boolean includeConstructors) {
        this.includeConstructors = includeConstructors;
    }

    public void setConstructorsRequiredPropertiesOnly(boolean constructorsRequiredPropertiesOnly) {
        this.constructorsRequiredPropertiesOnly = constructorsRequiredPropertiesOnly;
    }

    public void setIncludeRequiredPropertiesConstructor(boolean includeRequiredPropertiesConstructor) {
        this.includeRequiredPropertiesConstructor = includeRequiredPropertiesConstructor;
    }

    public void setIncludeAllPropertiesConstructor(boolean includeAllPropertiesConstructor) {
        this.includeAllPropertiesConstructor = includeAllPropertiesConstructor;
    }

    public void setIncludeCopyConstructor(boolean includeCopyConstructor) {
        this.includeCopyConstructor = includeCopyConstructor;
    }

    public void setGenerateBuilders(boolean generateBuilders) {
        this.generateBuilders = generateBuilders;
    }

    public void setIncludeTypeInfo(boolean includeTypeInfo) {
        this.includeTypeInfo = includeTypeInfo;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public void setUseLongIntegers(boolean useLongIntegers) {
        this.useLongIntegers = useLongIntegers;
    }

    public void setUseBigIntegers(boolean useBigIntegers) {
        this.useBigIntegers = useBigIntegers;
    }

    public void setUseDoubleNumbers(boolean useDoubleNumbers) {
        this.useDoubleNumbers = useDoubleNumbers;
    }

    public void setUseBigDecimals(boolean useBigDecimals) {
        this.useBigDecimals = useBigDecimals;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPropertyWordDelimiters(String propertyWordDelimiters) {
        this.propertyWordDelimiters = StringUtils.defaultString((String)propertyWordDelimiters).toCharArray();
    }

    public void setIncludeHashcodeAndEquals(boolean includeHashcodeAndEquals) {
        this.includeHashcodeAndEquals = includeHashcodeAndEquals;
    }

    public void setIncludeToString(boolean includeToString) {
        this.includeToString = includeToString;
    }

    public void setAnnotationStyle(AnnotationStyle annotationStyle) {
        this.annotationStyle = annotationStyle;
    }

    public void setUseTitleAsClassname(boolean useTitleAsClassname) {
        this.useTitleAsClassname = useTitleAsClassname;
    }

    public void setInclusionLevel(InclusionLevel inclusionLevel) {
        this.inclusionLevel = inclusionLevel;
    }

    public void setCustomAnnotator(String customAnnotator) {
        if (StringUtils.isNotBlank((CharSequence)customAnnotator)) {
            try {
                this.customAnnotator = Class.forName(customAnnotator);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.customAnnotator = NoopAnnotator.class;
        }
    }

    public void setCustomRuleFactory(String customRuleFactory) {
        if (StringUtils.isNotBlank((CharSequence)customRuleFactory)) {
            try {
                this.customRuleFactory = Class.forName(customRuleFactory);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.customRuleFactory = RuleFactory.class;
        }
    }

    public void setIncludeJsr303Annotations(boolean includeJsr303Annotations) {
        this.includeJsr303Annotations = includeJsr303Annotations;
    }

    public void setIncludeJsr305Annotations(boolean includeJsr305Annotations) {
        this.includeJsr305Annotations = includeJsr305Annotations;
    }

    public void setUseOptionalForGetters(boolean useOptionalForGetters) {
        this.useOptionalForGetters = useOptionalForGetters;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setIncludeConstructorPropertiesAnnotation(boolean includeConstructorPropertiesAnnotation) {
        this.includeConstructorPropertiesAnnotation = includeConstructorPropertiesAnnotation;
    }

    public void setUseJodaDates(boolean useJodaDates) {
        this.useJodaDates = useJodaDates;
    }

    public void setUseJodaLocalDates(boolean useJodaLocalDates) {
        this.useJodaLocalDates = useJodaLocalDates;
    }

    public void setUseJodaLocalTimes(boolean useJodaLocalTimes) {
        this.useJodaLocalTimes = useJodaLocalTimes;
    }

    public void setUseCommonsLang3(boolean useCommonsLang3) {
        super.log("useCommonsLang3 is deprecated. Please remove it from your config.", 1);
    }

    public void setParcelable(boolean parcelable) {
        this.parcelable = parcelable;
    }

    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public void setInitializeCollections(boolean initializeCollections) {
        this.initializeCollections = initializeCollections;
    }

    public void setClassNamePrefix(String classNamePrefix) {
        this.classNamePrefix = classNamePrefix;
    }

    public void setClassNameSuffix(String classNameSuffix) {
        this.classNameSuffix = classNameSuffix;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void setIncludeAdditionalProperties(boolean includeAdditionalProperties) {
        this.includeAdditionalProperties = includeAdditionalProperties;
    }

    public void setIncludeGetters(boolean includeGetters) {
        this.includeGetters = includeGetters;
    }

    public void setIncludeSetters(boolean includeSetters) {
        this.includeSetters = includeSetters;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public void setIncludeDynamicAccessors(boolean includeDynamicAccessors) {
        this.includeDynamicAccessors = includeDynamicAccessors;
    }

    public void setIncludeDynamicGetters(boolean includeDynamicGetters) {
        this.includeDynamicGetters = includeDynamicGetters;
    }

    public void setIncludeDynamicSetters(boolean includeDynamicSetters) {
        this.includeDynamicSetters = includeDynamicSetters;
    }

    public void setIncludeDynamicBuilders(boolean includeDynamicBuilders) {
        this.includeDynamicBuilders = includeDynamicBuilders;
    }

    public void setFormatDateTime(boolean formatDateTimes) {
        this.formatDateTimes = formatDateTimes;
    }

    public void setFormatTimes(boolean formatTimes) {
        this.formatTimes = formatTimes;
    }

    public void setFormatDates(boolean formatDates) {
        this.formatDates = formatDates;
    }

    public void setCustomDatePattern(String customDatePattern) {
        this.customDatePattern = customDatePattern;
    }

    public void setCustomTimePattern(String customTimePattern) {
        this.customTimePattern = customTimePattern;
    }

    public void setCustomDateTimePattern(String customDateTimePattern) {
        this.customDateTimePattern = customDateTimePattern;
    }

    public void setRefFragmentPathDelimiters(String refFragmentPathDelimiters) {
        this.refFragmentPathDelimiters = refFragmentPathDelimiters;
    }

    public void setSourceSortOrder(SourceSortOrder sourceSortOrder) {
        this.sourceSortOrder = sourceSortOrder;
    }

    public void setUseInnerClassBuilders(boolean useInnerClassBuilders) {
        this.useInnerClassBuilders = useInnerClassBuilders;
    }

    public void setFormatTypeMapping(Map<String, String> formatTypeMapping) {
        this.formatTypeMapping = formatTypeMapping;
    }

    public void setFormatTypeMapping(String[] formatTypeMapping) {
        this.formatTypeMapping = Arrays.stream(formatTypeMapping).collect(Collectors.toMap(m -> m.split(":")[0], m -> m.split(":")[1]));
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public boolean isIncludeTypeInfo() {
        return this.includeTypeInfo;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public Iterator<URL> getSource() {
        return Collections.singleton(URLUtil.parseURL((String)this.source)).iterator();
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public char[] getPropertyWordDelimiters() {
        return (char[])this.propertyWordDelimiters.clone();
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isUseLongIntegers() {
        return this.useLongIntegers;
    }

    public boolean isUseDoubleNumbers() {
        return this.useDoubleNumbers;
    }

    public boolean isIncludeHashcodeAndEquals() {
        return this.includeHashcodeAndEquals;
    }

    public boolean isIncludeToString() {
        return this.includeToString;
    }

    public String[] getToStringExcludes() {
        return this.toStringExcludes;
    }

    public AnnotationStyle getAnnotationStyle() {
        return this.annotationStyle;
    }

    public boolean isUseTitleAsClassname() {
        return this.useTitleAsClassname;
    }

    public InclusionLevel getInclusionLevel() {
        return this.inclusionLevel;
    }

    public Class<? extends Annotator> getCustomAnnotator() {
        return this.customAnnotator;
    }

    public Class<? extends RuleFactory> getCustomRuleFactory() {
        return this.customRuleFactory;
    }

    public boolean isIncludeJsr303Annotations() {
        return this.includeJsr303Annotations;
    }

    public boolean isIncludeJsr305Annotations() {
        return this.includeJsr305Annotations;
    }

    public boolean isUseOptionalForGetters() {
        return this.useOptionalForGetters;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        this.createClasspath().setRefid(classpathRef);
    }

    public Path getClasspath() {
        return this.classpath == null ? new Path(this.getProject()) : this.classpath;
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isUseJodaDates() {
        return this.useJodaDates;
    }

    public boolean isUseJodaLocalDates() {
        return this.useJodaLocalDates;
    }

    public boolean isUseJodaLocalTimes() {
        return this.useJodaLocalTimes;
    }

    public boolean isParcelable() {
        return this.parcelable;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public FileFilter getFileFilter() {
        return new AllFileFilter();
    }

    public boolean isInitializeCollections() {
        return this.initializeCollections;
    }

    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public String getClassNameSuffix() {
        return this.classNameSuffix;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public boolean isIncludeConstructors() {
        return this.includeConstructors;
    }

    public boolean isConstructorsRequiredPropertiesOnly() {
        return this.constructorsRequiredPropertiesOnly;
    }

    public boolean isIncludeRequiredPropertiesConstructor() {
        return this.includeRequiredPropertiesConstructor;
    }

    public boolean isIncludeAllPropertiesConstructor() {
        return this.includeAllPropertiesConstructor;
    }

    public boolean isIncludeCopyConstructor() {
        return this.includeCopyConstructor;
    }

    public boolean isIncludeAdditionalProperties() {
        return this.includeAdditionalProperties;
    }

    public boolean isIncludeGetters() {
        return this.includeGetters;
    }

    public boolean isIncludeSetters() {
        return this.includeSetters;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isIncludeDynamicAccessors() {
        return this.includeDynamicAccessors;
    }

    public boolean isIncludeDynamicGetters() {
        return this.includeDynamicGetters;
    }

    public boolean isIncludeDynamicSetters() {
        return this.includeDynamicSetters;
    }

    public boolean isIncludeDynamicBuilders() {
        return this.includeDynamicBuilders;
    }

    public String getDateTimeType() {
        return this.dateTimeType;
    }

    public String getDateType() {
        return this.dateType;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public boolean isUseBigIntegers() {
        return this.useBigIntegers;
    }

    public boolean isUseBigDecimals() {
        return this.useBigDecimals;
    }

    public boolean isFormatDateTimes() {
        return this.formatDateTimes;
    }

    public boolean isFormatDates() {
        return this.formatDates;
    }

    public boolean isFormatTimes() {
        return this.formatTimes;
    }

    public String getCustomDatePattern() {
        return this.customDatePattern;
    }

    public String getCustomTimePattern() {
        return this.customTimePattern;
    }

    public String getCustomDateTimePattern() {
        return this.customDateTimePattern;
    }

    public String getRefFragmentPathDelimiters() {
        return this.refFragmentPathDelimiters;
    }

    public SourceSortOrder getSourceSortOrder() {
        return this.sourceSortOrder;
    }

    public Map<String, String> getFormatTypeMapping() {
        return this.formatTypeMapping;
    }

    public boolean isUseInnerClassBuilders() {
        return this.useInnerClassBuilders;
    }

    public boolean isIncludeConstructorPropertiesAnnotation() {
        return this.includeConstructorPropertiesAnnotation;
    }

    public boolean isIncludeGeneratedAnnotation() {
        return this.includeGeneratedAnnotation;
    }
}

