/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.addcheck;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.addcheck.AddCheckStatement;
import liquibase.ext.ora.check.CheckAttribute;
import liquibase.ext.ora.dropcheck.DropCheckChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="addCheck", description="Add Check", priority=201)
public class AddCheckChange
extends CheckAttribute {
    @Override
    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        AddCheckStatement statement = new AddCheckStatement(schemaName, this.getTableName(), this.getConstraintName(), this.getCondition());
        statement.setTablespace(this.getTablespace());
        statement.setDisable(this.getDisable());
        statement.setDeferrable(this.getDeferrable());
        statement.setInitiallyDeferred(this.getInitiallyDeferred());
        statement.setRely(this.getRely());
        statement.setValidate(this.getValidate());
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Constraint check " + this.getConstraintName() + " has been added to " + this.getTableName();
    }

    protected Change[] createInverses() {
        if (this.getConstraintName() == null) {
            return null;
        }
        DropCheckChange inverse = new DropCheckChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }
}

