/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mockserver.initialize.ExpectationInitializer;
import org.mockserver.maven.InstanceHolder;

public abstract class MockServerAbstractMojo
extends AbstractMojo {
    @Parameter(property="mockserver.serverPort", defaultValue="-1")
    protected int serverPort = -1;
    @Parameter(property="mockserver.serverSecurePort", defaultValue="-1")
    protected int serverSecurePort = -1;
    @Parameter(property="mockserver.proxyPort", defaultValue="-1")
    protected int proxyPort = -1;
    @Parameter(property="mockserver.proxySecurePort", defaultValue="-1")
    protected int proxySecurePort = -1;
    @Parameter(property="mockserver.timeout")
    protected int timeout;
    @Parameter(property="mockserver.logLevel", defaultValue="INFO")
    protected String logLevel;
    @Parameter(property="mockserver.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="mockserver.pipeLogToConsole", defaultValue="false")
    protected boolean pipeLogToConsole;
    @Parameter(property="mockserver.initializationClass")
    protected String initializationClass;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    protected List<String> compileClasspath;
    @Parameter(property="project.testClasspathElements", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(property="pluginDescriptor.plugin.dependencies", required=true, readonly=true)
    protected List<Dependency> dependencies;
    @Parameter(property="pluginDescriptor.artifacts", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @VisibleForTesting
    protected static InstanceHolder embeddedJettyHolder;

    protected InstanceHolder getEmbeddedJettyHolder() {
        if (embeddedJettyHolder == null) {
            embeddedJettyHolder = new InstanceHolder();
        }
        return embeddedJettyHolder;
    }

    protected ExpectationInitializer createInitializer() {
        try {
            Constructor<?> initializerClassConstructor;
            Object expectationInitializer;
            ClassLoader contextClassLoader = this.setupClasspath();
            if (contextClassLoader != null && StringUtils.isNotEmpty((CharSequence)this.initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(this.initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                return (ExpectationInitializer)expectationInitializer;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private ClassLoader setupClasspath() throws MalformedURLException {
        if (this.compileClasspath != null) {
            int i;
            URL[] urls = new URL[this.compileClasspath.size() + this.testClasspath.size()];
            for (i = 0; i < this.compileClasspath.size(); ++i) {
                urls[i] = new File(this.compileClasspath.get(i)).toURI().toURL();
            }
            for (i = this.compileClasspath.size(); i < this.compileClasspath.size() + this.testClasspath.size(); ++i) {
                urls[i] = new File(this.testClasspath.get(i - this.compileClasspath.size())).toURI().toURL();
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return contextClassLoader;
        }
        return null;
    }

    protected void logPluginClasspath() {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Artifact artifact : this.pluginArtifacts) {
                sb.append(artifact.getFile());
            }
            this.getLog().debug((CharSequence)("Plugin classpath:\n" + sb.toString()));
        }
    }
}

