/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.mockserver.logging.Logging;
import org.mockserver.maven.MockServerAbstractMojo;
import org.mockserver.maven.SettableFuture;

@Mojo(name="run", requiresProject=false, threadSafe=false)
public class MockServerRunAndWaitMojo
extends MockServerAbstractMojo {
    public void execute() throws MojoExecutionException {
        Logging.overrideLogLevel((String)this.logLevel);
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
        } else {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("mockserver:runAndWait about to start MockServer on: " + (this.serverPort != -1 ? " serverPort " + this.serverPort : "") + (this.serverSecurePort != -1 ? " serverSecurePort " + this.serverSecurePort : "") + (this.proxyPort != -1 ? " proxyPort " + this.proxyPort : "") + (this.proxySecurePort != -1 ? " proxySecurePort " + this.proxySecurePort : "")));
            }
            try {
                if (this.timeout > 0) {
                    this.getEmbeddedJettyHolder().start(this.serverPort, this.serverSecurePort, this.proxyPort, this.proxySecurePort, this.createInitializer());
                    try {
                        this.newSettableFuture().get(this.timeout, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException te) {}
                } else {
                    this.getEmbeddedJettyHolder().start(this.serverPort, this.serverSecurePort, this.proxyPort, this.proxySecurePort, this.createInitializer());
                    this.newSettableFuture().get();
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Exception while running MockServer", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    SettableFuture<Object> newSettableFuture() {
        return SettableFuture.create();
    }
}

