/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.mockserver.cli.Main;
import org.mockserver.configuration.SystemProperties;
import org.mockserver.maven.InstanceHolder;
import org.mockserver.maven.MockServerAbstractMojo;

@Mojo(name="runForked", requiresProject=false, threadSafe=false)
public class MockServerRunForkedMojo
extends MockServerAbstractMojo {
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ArtifactResolver artifactResolver;

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
        } else {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("mockserver:runForked about to start MockServer on: " + (this.serverPort != -1 ? " serverPort " + this.serverPort : "") + (this.serverSecurePort != -1 ? " serverSecurePort " + this.serverSecurePort : "") + (this.proxyPort != -1 ? " proxyPort " + this.proxyPort : "") + (this.proxySecurePort != -1 ? " proxySecurePort " + this.proxySecurePort : "")));
            }
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(this.getJavaBin()));
            arguments.add("-Dfile.encoding=UTF-8");
            arguments.add("-Dmockserver.logLevel=" + this.logLevel);
            arguments.add("-cp");
            String classPath = this.resolveJarWithDependenciesPath();
            if (this.dependencies != null && !this.dependencies.isEmpty()) {
                for (Dependency dependency : this.dependencies) {
                    classPath = classPath + System.getProperty("path.separator");
                    classPath = classPath + this.resolvePluginDependencyJarPath(dependency);
                }
            }
            arguments.add(classPath);
            arguments.add(Main.class.getName());
            if (this.serverPort != -1) {
                arguments.add("-serverPort");
                arguments.add("" + this.serverPort);
                SystemProperties.mockServerHttpPort((int)this.serverPort);
            }
            if (this.serverSecurePort != -1) {
                arguments.add("-serverSecurePort");
                arguments.add("" + this.serverSecurePort);
            }
            if (this.proxyPort != -1) {
                arguments.add("-proxyPort");
                arguments.add("" + this.proxyPort);
                SystemProperties.proxyHttpPort((int)this.proxyPort);
            }
            if (this.proxySecurePort != -1) {
                arguments.add("-proxySecurePort");
                arguments.add("" + this.proxySecurePort);
            }
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)StringUtils.rightPad((String)"", (int)72, (String)"-"));
            this.getLog().info((CharSequence)("Running MockServer: " + Joiner.on((String)" ").join(arguments)));
            this.getLog().info((CharSequence)StringUtils.rightPad((String)"", (int)72, (String)"-"));
            this.getLog().info((CharSequence)" ");
            ProcessBuilder processBuilder = this.newProcessBuilder(arguments);
            if (this.pipeLogToConsole) {
                processBuilder.redirectErrorStream(true);
            }
            try {
                processBuilder.start();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Exception while starting MockServer", (Throwable)e);
            }
            try {
                TimeUnit.SECONDS.sleep(this.timeout == 0 ? 2 : this.timeout);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Exception while waiting for mock server JVM to start", e);
            }
            InstanceHolder.runInitializationClass(this.serverPort, this.createInitializer());
        }
    }

    @VisibleForTesting
    ProcessBuilder newProcessBuilder(List<String> arguments) {
        return new ProcessBuilder(arguments);
    }

    @VisibleForTesting
    String getJavaBin() {
        String javaBinary = "java";
        File javaHomeDirectory = new File(System.getProperty("java.home"));
        for (String javaExecutable : new String[]{"java", "java.exe"}) {
            File javaExeLocation = new File(javaHomeDirectory, MockServerRunForkedMojo.fileSeparators("bin/" + javaExecutable));
            if (!javaExeLocation.exists() || !javaExeLocation.isFile()) continue;
            javaBinary = javaExeLocation.getAbsolutePath();
            break;
        }
        return javaBinary;
    }

    @VisibleForTesting
    String resolvePluginDependencyJarPath(Dependency dependency) {
        Artifact dependencyArtifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        this.artifactResolver.resolve(new ArtifactResolutionRequest().setArtifact(dependencyArtifact));
        return dependencyArtifact.getFile().getAbsolutePath();
    }

    @VisibleForTesting
    String resolveJarWithDependenciesPath() {
        Artifact jarWithDependencies = this.repositorySystem.createArtifactWithClassifier("org.mock-server", "mockserver-netty", this.getVersion(), "jar", "jar-with-dependencies");
        this.artifactResolver.resolve(new ArtifactResolutionRequest().setArtifact(jarWithDependencies));
        return jarWithDependencies.getFile().getAbsolutePath();
    }

    @VisibleForTesting
    String getVersion() {
        String version = "3.6.1";
        try {
            Properties p = new Properties();
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/org.mock-server/mockserver-maven-plugin/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "3.6.1");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLog().info((CharSequence)("Using org.mock-server:mockserver-netty:" + version + ":jar-with-dependencies"));
        return version;
    }
}

