/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.proxy.error.Logging;
import org.slf4j.Logger;

public class ProxyRelayHandler<T extends HttpMessage>
extends SimpleChannelInboundHandler<T> {
    private final Logger logger;
    private volatile Channel channel;

    public ProxyRelayHandler(Channel channel, Logger logger) {
        super(false);
        this.channel = channel;
        this.logger = logger;
    }

    public static void closeOnFlush(Channel ch) {
        if (ch != null && ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(final ChannelHandlerContext ctx, T msg) {
        this.channel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    ProxyRelayHandler.this.logger.error("Exception while returning writing", future.cause());
                    future.channel().close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ProxyRelayHandler.closeOnFlush(this.channel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!Logging.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by proxy relay handler -> closing pipeline " + ctx.channel(), cause);
        }
        ProxyRelayHandler.closeOnFlush(ctx.channel());
    }
}

