/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.model.BinaryBodyDTO;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.ParameterBodyDTO;
import org.mockserver.client.serialization.model.StringBodyDTO;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.StringBody;

public class ObjectMapperFactory {
    public static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        Module gameServerModule = new Module();
        objectMapper.registerModule(gameServerModule);
        return objectMapper;
    }

    private static class StringBodySerializer
    extends StdSerializer<StringBody> {
        protected StringBodySerializer() {
            super(StringBody.class);
        }

        @Override
        public void serialize(StringBody stringBody, JsonGenerator json, SerializerProvider provider) throws IOException {
            if (stringBody.getType() == Body.Type.STRING) {
                json.writeString(stringBody.getValue());
            } else {
                json.writeStartObject();
                json.writeStringField("type", stringBody.getType().name());
                json.writeStringField("value", stringBody.getValue());
                json.writeEndObject();
            }
        }
    }

    private static class StringBodyDTOSerializer
    extends StdSerializer<StringBodyDTO> {
        protected StringBodyDTOSerializer() {
            super(StringBodyDTO.class);
        }

        @Override
        public void serialize(StringBodyDTO stringBodyDTO, JsonGenerator json, SerializerProvider provider) throws IOException {
            if (stringBodyDTO.getType() == Body.Type.STRING) {
                json.writeString(stringBodyDTO.getValue());
            } else {
                json.writeStartObject();
                json.writeStringField("type", stringBodyDTO.getType().name());
                json.writeStringField("value", stringBodyDTO.getValue());
                json.writeEndObject();
            }
        }
    }

    private static class BodyDTODeserializer
    extends StdDeserializer<BodyDTO> {
        protected BodyDTODeserializer() {
            super(BodyDTO.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BodyDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonToken currentToken = jsonParser.getCurrentToken();
            if (currentToken == JsonToken.START_OBJECT) {
                jsonParser.nextToken();
                if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME || !jsonParser.getText().equals("type")) return null;
                jsonParser.nextToken();
                if (jsonParser.getCurrentToken() != JsonToken.VALUE_STRING) return null;
                Body.Type type = Body.Type.valueOf(jsonParser.getText());
                jsonParser.nextToken();
                switch (type) {
                    case STRING: 
                    case REGEX: 
                    case JSON: 
                    case XPATH: {
                        if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME || !jsonParser.getText().equals("value")) return null;
                        jsonParser.nextToken();
                        if (jsonParser.getCurrentToken() != JsonToken.VALUE_STRING) return null;
                        String value = jsonParser.getText();
                        jsonParser.nextToken();
                        if (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) return null;
                        return new StringBodyDTO(new StringBody(value, type));
                    }
                    case BINARY: {
                        if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME || !jsonParser.getText().equals("value")) return null;
                        jsonParser.nextToken();
                        if (jsonParser.getCurrentToken() != JsonToken.VALUE_STRING) return null;
                        String value = jsonParser.getText();
                        jsonParser.nextToken();
                        if (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) return null;
                        return new BinaryBodyDTO(new BinaryBody(Base64Converter.base64StringToBytes(value)));
                    }
                    case PARAMETERS: {
                        if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME || !jsonParser.getText().equals("parameters")) return null;
                        jsonParser.nextToken();
                        if (!jsonParser.isExpectedStartArrayToken()) return null;
                        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                        boolean inObject = false;
                        while (inObject || jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                            JsonToken token = jsonParser.nextToken();
                            switch (token) {
                                case START_OBJECT: {
                                    inObject = true;
                                    break;
                                }
                                case END_OBJECT: {
                                    inObject = false;
                                    break;
                                }
                                case FIELD_NAME: {
                                    if (!jsonParser.getText().equals("name") || jsonParser.nextToken() != JsonToken.VALUE_STRING) break;
                                    String name = jsonParser.getText();
                                    jsonParser.nextToken();
                                    if (jsonParser.nextToken() != JsonToken.START_ARRAY) break;
                                    ArrayList<String> values = new ArrayList<String>();
                                    while (jsonParser.nextToken() != null && jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                                        if (jsonParser.getCurrentToken() != JsonToken.VALUE_STRING) continue;
                                        values.add(jsonParser.getText());
                                    }
                                    parameters.add(new Parameter(name, (List<String>)values));
                                }
                            }
                        }
                        jsonParser.nextToken();
                        if (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) return null;
                        return new ParameterBodyDTO(new ParameterBody(parameters));
                    }
                }
                return null;
            } else {
                if (currentToken != JsonToken.VALUE_STRING) return null;
                return new StringBodyDTO(new StringBody(jsonParser.getText(), Body.Type.STRING));
            }
        }
    }

    private static class Module
    extends SimpleModule {
        public Module() {
            this.addDeserializer(BodyDTO.class, new BodyDTODeserializer());
            this.addSerializer(StringBodyDTO.class, new StringBodyDTOSerializer());
            this.addSerializer(StringBody.class, new StringBodySerializer());
        }
    }
}

