/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.mockserver.model.Cookie;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientToMockServerResponseMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpResponse mapApacheHttpClientResponseToMockServerResponse(CloseableHttpResponse clientResponse, boolean binaryBody) throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        this.setStatusCode(httpResponse, clientResponse);
        this.setHeaders(httpResponse, clientResponse);
        this.setCookies(httpResponse);
        if (binaryBody) {
            if (clientResponse.getEntity() != null) {
                this.setBody(httpResponse, EntityUtils.toByteArray(clientResponse.getEntity()));
            }
        } else if (clientResponse.getEntity() != null) {
            this.setBody(httpResponse, EntityUtils.toString(clientResponse.getEntity(), Charsets.UTF_8));
        }
        return httpResponse;
    }

    private void setStatusCode(HttpResponse httpResponse, CloseableHttpResponse clientResponse) {
        if (clientResponse.getStatusLine() != null) {
            httpResponse.withStatusCode(clientResponse.getStatusLine().getStatusCode());
        }
    }

    private void setHeaders(HttpResponse httpResponse, CloseableHttpResponse clientResponse) {
        HashMap<String, org.mockserver.model.Header> mappedHeaders = new HashMap<String, org.mockserver.model.Header>();
        for (Header header : clientResponse.getAllHeaders()) {
            if (mappedHeaders.containsKey(header.getName())) {
                ((org.mockserver.model.Header)mappedHeaders.get(header.getName())).addValue(header.getValue());
                continue;
            }
            mappedHeaders.put(header.getName(), new org.mockserver.model.Header(header.getName(), header.getValue()));
        }
        ArrayList<org.mockserver.model.Header> headers = new ArrayList<org.mockserver.model.Header>(mappedHeaders.values());
        List<String> headersToRemove = Arrays.asList("Content-Encoding", "Content-Length", "Transfer-Encoding");
        for (org.mockserver.model.Header header : new ArrayList(headers)) {
            if (!headersToRemove.contains(header.getName())) continue;
            headers.remove(header);
        }
        httpResponse.withHeaders(headers);
    }

    private void setCookies(HttpResponse httpResponse) {
        HashMap<String, Cookie> mappedCookies = new HashMap<String, Cookie>();
        for (org.mockserver.model.Header header : httpResponse.getHeaders()) {
            if (!header.getName().equals("Cookie") && !header.getName().equals("Set-Cookie")) continue;
            for (String cookieHeader : header.getValues()) {
                try {
                    for (HttpCookie httpCookie : HttpCookie.parse(cookieHeader)) {
                        if (mappedCookies.containsKey(httpCookie.getName())) {
                            ((Cookie)mappedCookies.get(httpCookie.getName())).addValue(httpCookie.getValue());
                            continue;
                        }
                        mappedCookies.put(httpCookie.getName(), new Cookie(httpCookie.getName(), httpCookie.getValue()));
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.logger.warn("Exception while parsing cookie header [" + cookieHeader + "]", iae);
                }
            }
        }
        httpResponse.withCookies(new ArrayList<Cookie>(mappedCookies.values()));
    }

    private void setBody(HttpResponse httpResponse, String content) {
        httpResponse.withBody(content);
    }

    private void setBody(HttpResponse httpResponse, byte[] content) {
        httpResponse.withBody(content);
    }
}

