/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.TimeUnit;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.mockserver.MockServerInitializer;
import org.mockserver.proxy.filters.LogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private final LogFilter logFilter = new LogFilter();
    private SettableFuture<String> hasStarted;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public Thread start(final Integer port, final Integer securePort) {
        if (port == null && securePort == null) {
            throw new IllegalStateException("You must specify a port or a secure port");
        }
        this.hasStarted = SettableFuture.create();
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        Thread mockServerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Channel httpChannel = null;
                    MockServer.this.logger.info("MockServer starting up" + (port != null ? " serverPort " + port : "") + (securePort != null ? " secureServerPort " + securePort : ""));
                    if (port != null) {
                        httpChannel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_BACKLOG, 1024)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).group(MockServer.this.bossGroup, MockServer.this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new MockServerInitializer(new MockServerHandler(MockServer.this.mockServerMatcher, MockServer.this.logFilter, MockServer.this, false))).bind(port).sync().channel();
                    }
                    Channel httpsChannel = null;
                    if (securePort != null) {
                        httpsChannel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_BACKLOG, 1024)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).group(MockServer.this.bossGroup, MockServer.this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new MockServerInitializer(new MockServerHandler(MockServer.this.mockServerMatcher, MockServer.this.logFilter, MockServer.this, true))).bind(securePort).sync().channel();
                    }
                    MockServer.this.hasStarted.set("STARTED");
                    if (httpChannel != null) {
                        httpChannel.closeFuture().sync();
                    }
                    if (httpsChannel != null) {
                        httpsChannel.closeFuture().sync();
                    }
                }
                catch (InterruptedException ie) {
                    MockServer.this.logger.error("MockServer receive InterruptedException", ie);
                }
                finally {
                    MockServer.this.bossGroup.shutdownGracefully();
                    MockServer.this.workerGroup.shutdownGracefully();
                }
            }
        });
        mockServerThread.start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            this.logger.debug("Exception while waiting for proxy to complete starting up", e);
        }
        return mockServerThread;
    }

    public void stop() {
        try {
            this.workerGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
            this.bossGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
        }
        catch (Exception ie) {
            this.logger.trace("Exception while waiting for MockServer to stop", ie);
        }
    }

    public boolean isRunning() {
        if (this.hasStarted.isDone()) {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return !this.bossGroup.isShuttingDown() && !this.workerGroup.isShuttingDown();
        }
        return false;
    }
}

