/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.interceptor;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.proxy.interceptor.Interceptor;
import org.slf4j.Logger;

public class RequestInterceptor
implements Interceptor {
    private final InetSocketAddress remoteSocketAddress;
    private final Decoder httpRequestDecoder = new Decoder();
    private final Encoder httpRequestEncoder = new Encoder();

    public RequestInterceptor(InetSocketAddress remoteSocketAddress) {
        this.remoteSocketAddress = remoteSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf intercept(ChannelHandlerContext ctx, ByteBuf channelBuffer, Logger logger) throws Exception {
        ByteBuf channelBufferCopy = Unpooled.copiedBuffer(channelBuffer);
        logger.debug("INTERCEPTING - REQUEST: " + channelBuffer.toString(Charsets.UTF_8));
        try {
            ArrayList<ByteBuf> allRequestRawChunks = new ArrayList<ByteBuf>();
            ArrayList<Object> requestHttpFormattedChunks = new ArrayList<Object>();
            this.httpRequestDecoder.callDecode(ctx, channelBufferCopy, requestHttpFormattedChunks);
            for (Object e : requestHttpFormattedChunks) {
                if (e instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)e;
                    httpRequest.headers().remove("Accept-Encoding");
                    if (this.remoteSocketAddress != null) {
                        httpRequest.headers().set("Host", (Object)(this.remoteSocketAddress.getHostName() + ":" + this.remoteSocketAddress.getPort()));
                    }
                    httpRequest.headers().set("Connection", (Object)"close");
                }
                logger.debug("HTTP-FORMATTED -REQUEST- " + e.getClass().getSimpleName() + " -- " + e);
                if (e instanceof LastHttpContent) continue;
                ArrayList<Object> requestRawChunks = new ArrayList<Object>();
                this.httpRequestEncoder.encode(ctx, e, (List<Object>)requestRawChunks);
                for (Object e2 : requestRawChunks) {
                    if (!(e2 instanceof ByteBuf)) continue;
                    allRequestRawChunks.add((ByteBuf)e2);
                }
            }
            ByteBuf byteBuf = Unpooled.copiedBuffer(allRequestRawChunks.toArray(new ByteBuf[allRequestRawChunks.size()]));
            return byteBuf;
        }
        finally {
            channelBufferCopy.release();
        }
    }

    private class Decoder
    extends HttpRequestDecoder {
        private Decoder() {
        }

        @Override
        public void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            super.callDecode(ctx, in, out);
        }
    }

    private class Encoder
    extends HttpRequestEncoder {
        private Encoder() {
        }

        @Override
        public void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            super.encode(ctx, msg, out);
        }
    }
}

