/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.configuration.SystemProperties;
import org.mockserver.mockserver.MockServer;

public class MockServerBuilder {
    private Integer port;
    private Integer securePort;

    public MockServerBuilder withHTTPPort(Integer port) {
        if (port != null && port != -1) {
            SystemProperties.mockServerHttpPort((int)port);
            this.port = port;
        } else {
            this.port = null;
        }
        return this;
    }

    public MockServerBuilder withHTTPSPort(Integer securePort) {
        this.securePort = securePort != null && securePort != -1 ? securePort : null;
        return this;
    }

    public MockServer build() {
        MockServer mockServer = this.newMockServer();
        mockServer.start(this.port, this.securePort);
        return mockServer;
    }

    public Thread buildAndReturnThread() {
        return this.newMockServer().start(this.port, this.securePort);
    }

    @VisibleForTesting
    MockServer newMockServer() {
        return new MockServer();
    }
}

