/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.configuration.SystemProperties;
import org.mockserver.proxy.http.HttpProxy;

public class HttpProxyBuilder {
    private Integer port;
    private Integer securePort;
    private Integer socksPort;
    private Integer directLocalPort;
    private Integer directLocalSecurePort;
    private String directRemoteHost;
    private Integer directRemotePort;

    public HttpProxyBuilder withHTTPPort(Integer port) {
        if (port != null && port != -1) {
            SystemProperties.proxyHttpPort((int)port);
            this.port = port;
        } else {
            this.port = null;
        }
        return this;
    }

    public HttpProxyBuilder withHTTPSPort(Integer securePort) {
        this.securePort = securePort != null && securePort != -1 ? securePort : null;
        return this;
    }

    public HttpProxyBuilder withSOCKSPort(Integer socksPort) {
        this.socksPort = socksPort != null && socksPort != -1 ? socksPort : null;
        return this;
    }

    public HttpProxyBuilder withDirect(Integer fromPort, String toHost, Integer toPort) {
        if (fromPort != null && fromPort != -1) {
            this.directLocalPort = fromPort;
            this.directRemoteHost = toHost;
            this.directRemotePort = toPort;
        } else {
            this.directLocalPort = null;
        }
        return this;
    }

    public HttpProxyBuilder withDirectSSL(Integer fromSecurePort, String toHost, Integer toPort) {
        if (fromSecurePort != null && fromSecurePort != -1) {
            this.directLocalSecurePort = fromSecurePort;
            this.directRemoteHost = toHost;
            this.directRemotePort = toPort;
        } else {
            this.directLocalSecurePort = null;
        }
        return this;
    }

    public HttpProxy build() {
        HttpProxy httpProxy = this.newHttpProxy();
        httpProxy.start(this.port, this.securePort, this.socksPort, this.directLocalPort, this.directLocalSecurePort, this.directRemoteHost, this.directRemotePort);
        return httpProxy;
    }

    public Thread buildAndReturnThread() {
        return this.newHttpProxy().start(this.port, this.securePort, this.socksPort, this.directLocalPort, this.directLocalSecurePort, this.directRemoteHost, this.directRemotePort);
    }

    @VisibleForTesting
    HttpProxy newHttpProxy() {
        return new HttpProxy();
    }
}

