/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class LoggingHandler
extends ChannelDuplexHandler {
    private static final String NEWLINE;
    private static final String[] BYTE2HEX;
    private static final String[] HEXPADDING;
    private static final String[] BYTEPADDING;
    private static final char[] BYTE2CHAR;
    protected final Logger logger;

    public LoggingHandler() {
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public LoggingHandler(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public LoggingHandler(Logger logger) {
        this.logger = logger;
    }

    protected String format(ChannelHandlerContext ctx, String message) {
        String chStr = ctx.channel().toString();
        return chStr + ' ' + message;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace(this.format(ctx, "REGISTERED"));
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace(this.format(ctx, "UNREGISTERED"));
        super.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace(this.format(ctx, "ACTIVE"));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace(this.format(ctx, "INACTIVE"));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.trace(this.format(ctx, "EXCEPTION: " + cause), cause);
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            this.logger.trace(this.format(ctx, "SslHandshakeCompletionEvent: "), ((SslHandshakeCompletionEvent)evt).cause());
        } else if (evt instanceof Exception) {
            this.logger.trace(this.format(ctx, "Exception: "), (Throwable)((Exception)evt));
        } else {
            this.logger.trace(this.format(ctx, "USER_EVENT: " + evt));
        }
        super.userEventTriggered(ctx, evt);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.logger.trace(this.format(ctx, "BIND(" + localAddress + ')'));
        super.bind(ctx, localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.logger.trace(this.format(ctx, "CONNECT(" + remoteAddress + ", " + localAddress + ')'));
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.logger.trace(this.format(ctx, "DISCONNECT()"));
        super.disconnect(ctx, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.logger.trace(this.format(ctx, "CLOSE()"));
        super.close(ctx, promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.logger.trace(this.format(ctx, "DEREGISTER()"));
        super.deregister(ctx, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.logMessage(ctx, "RECEIVED", msg);
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.logMessage(ctx, "WRITE", msg);
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.logger.trace(this.format(ctx, "FLUSH"));
        ctx.flush();
    }

    private void logMessage(ChannelHandlerContext ctx, String eventName, Object msg) {
        this.logger.trace(this.format(ctx, this.formatMessage(eventName, msg)));
    }

    private String formatMessage(String eventName, Object msg) {
        if (msg instanceof ByteBuf) {
            return this.formatByteBuf(eventName, (ByteBuf)msg);
        }
        if (msg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(eventName, (ByteBufHolder)msg);
        }
        return this.formatNonByteBuf(eventName, msg);
    }

    private String formatByteBuf(String eventName, ByteBuf buf) {
        int i;
        int length = buf.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder dump = new StringBuilder(rows * 80 + eventName.length() + 16);
        dump.append(eventName).append('(').append(length).append('B').append(')').append(NEWLINE).append("         +-------------------------------------------------+").append(NEWLINE).append("         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |").append(NEWLINE).append("+--------+-------------------------------------------------+----------------+");
        int startIndex = buf.readerIndex();
        int endIndex = buf.writerIndex();
        for (i = startIndex; i < endIndex; ++i) {
            int relIdx = i - startIndex;
            int relIdxMod16 = relIdx & 0xF;
            if (relIdxMod16 == 0) {
                dump.append(NEWLINE);
                dump.append(Long.toHexString((long)relIdx & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
            dump.append(BYTE2HEX[buf.getUnsignedByte(i)]);
            if (relIdxMod16 != 15) continue;
            dump.append(" |");
            if (i > 15 && buf.readableBytes() > i) {
                dump.append(buf.toString(i - 15, 16, Charsets.UTF_8).replaceAll("" + System.getProperty("line.separator"), "/").replaceAll("\r", "/"));
            } else {
                for (int j = i - 15; j <= i; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
            }
            dump.append('|');
        }
        if ((i - startIndex & 0xF) != 0) {
            int remainder = length & 0xF;
            dump.append(HEXPADDING[remainder]);
            dump.append(" |");
            for (int j = i - remainder; j < i; ++j) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
            }
            dump.append(BYTEPADDING[remainder]);
            dump.append('|');
        }
        dump.append(NEWLINE).append("+--------+-------------------------------------------------+----------------+");
        return dump.toString();
    }

    private String formatNonByteBuf(String eventName, Object msg) {
        return eventName + ": " + msg;
    }

    private String formatByteBufHolder(String eventName, ByteBufHolder msg) {
        return this.formatByteBuf(eventName, msg.content());
    }

    static {
        int j;
        StringBuilder buf;
        int padding;
        int i;
        NEWLINE = String.format("%n", new Object[0]);
        BYTE2HEX = new String[256];
        HEXPADDING = new String[16];
        BYTEPADDING = new String[16];
        BYTE2CHAR = new char[256];
        for (i = 0; i < 10; ++i) {
            LoggingHandler.BYTE2HEX[i] = " 0" + i;
        }
        while (i < 16) {
            LoggingHandler.BYTE2HEX[i] = " 0" + (char)(97 + i - 10);
            ++i;
        }
        while (i < BYTE2HEX.length) {
            LoggingHandler.BYTE2HEX[i] = " " + Integer.toHexString(i);
            ++i;
        }
        for (i = 0; i < HEXPADDING.length; ++i) {
            padding = HEXPADDING.length - i;
            buf = new StringBuilder(padding * 3);
            for (j = 0; j < padding; ++j) {
                buf.append("   ");
            }
            LoggingHandler.HEXPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTEPADDING.length; ++i) {
            padding = BYTEPADDING.length - i;
            buf = new StringBuilder(padding);
            for (j = 0; j < padding; ++j) {
                buf.append(' ');
            }
            LoggingHandler.BYTEPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTE2CHAR.length; ++i) {
            LoggingHandler.BYTE2CHAR[i] = i <= 31 || i >= 127 ? 46 : (char)i;
        }
    }
}

