/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.mockserver.filters.LogFilter;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer {
    public static final AttributeKey<LogFilter> LOG_FILTER = AttributeKey.valueOf((String)"SERVER_LOG_FILTER");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private final LogFilter logFilter = new LogFilter();
    private final SettableFuture<Integer> hasStarted;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private Channel channel;

    public MockServer(final Integer port) {
        if (port == null) {
            throw new IllegalArgumentException("You must specify a port");
        }
        this.hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MockServer.this.channel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(MockServer.this.bossGroup, MockServer.this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childHandler((ChannelHandler)new MockServerInitializer(MockServer.this.mockServerMatcher, MockServer.this)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childAttr(LOG_FILTER, (Object)MockServer.this.logFilter).bind(port.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                MockServer.this.hasStarted.set((Object)((InetSocketAddress)future.channel().localAddress()).getPort());
                            } else {
                                MockServer.this.hasStarted.setException(future.cause());
                            }
                        }
                    }).channel();
                    MockServer.this.logger.info("MockServer started on port: {}", MockServer.this.hasStarted.get());
                    MockServer.this.channel.closeFuture().syncUninterruptibly();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while starting MockServer", e.getCause());
                }
                finally {
                    MockServer.this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                    MockServer.this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                }
            }
        }).start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            this.logger.error("Exception while waiting for MockServer to complete starting up", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            this.channel.close();
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (Exception ie) {
            this.logger.trace("Exception while stopping MockServer", (Throwable)ie);
        }
    }

    public boolean isRunning() {
        if (this.hasStarted.isDone()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.trace("Exception while waiting for the proxy to confirm running status", (Throwable)e);
            }
            return !this.bossGroup.isShuttingDown() && !this.workerGroup.isShuttingDown();
        }
        return false;
    }

    public Integer getPort() {
        try {
            return (Integer)this.hasStarted.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while starting MockServer", e);
        }
    }
}

