/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ClientConfiguration;
import org.mockserver.configuration.Configuration;
import org.mockserver.lifecycle.ExpectationsListener;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.netty.MockServer;
import org.slf4j.event.Level;

public class ClientAndServer
extends MockServerClient {
    private final Configuration configuration;
    private final MockServer mockServer;

    public static ClientAndServer startClientAndServer(List<Integer> ports) {
        return ClientAndServer.startClientAndServer(ports.toArray(new Integer[0]));
    }

    public static ClientAndServer startClientAndServer(Configuration configuration, List<Integer> ports) {
        return ClientAndServer.startClientAndServer(configuration, ports.toArray(new Integer[0]));
    }

    public static ClientAndServer startClientAndServer(Integer ... port) {
        return ClientAndServer.startClientAndServer(Configuration.configuration(), port);
    }

    public static ClientAndServer startClientAndServer(Configuration configuration, Integer ... port) {
        return new ClientAndServer(configuration, port);
    }

    public static ClientAndServer startClientAndServer(String remoteHost, Integer remotePort, Integer ... port) {
        return ClientAndServer.startClientAndServer(Configuration.configuration(), remoteHost, remotePort, port);
    }

    public static ClientAndServer startClientAndServer(Configuration configuration, String remoteHost, Integer remotePort, Integer ... port) {
        return new ClientAndServer(configuration, remoteHost, remotePort, port);
    }

    public ClientAndServer(Integer ... ports) {
        this(Configuration.configuration(), ports);
    }

    public ClientAndServer(Configuration configuration, Integer ... ports) {
        super(ClientConfiguration.clientConfiguration((Configuration)configuration), new CompletableFuture());
        this.configuration = configuration;
        this.mockServer = new MockServer(configuration, ports);
        this.completePortFutureAndOpenUI();
    }

    public ClientAndServer(String remoteHost, Integer remotePort, Integer ... ports) {
        this(Configuration.configuration(), remoteHost, remotePort, ports);
    }

    public ClientAndServer(Configuration configuration, String remoteHost, Integer remotePort, Integer ... ports) {
        super(ClientConfiguration.clientConfiguration((Configuration)configuration), new CompletableFuture());
        this.configuration = configuration;
        this.mockServer = new MockServer(configuration, remotePort, remoteHost, ports);
        this.completePortFutureAndOpenUI();
    }

    private void completePortFutureAndOpenUI() {
        if (MockServerLogger.isEnabled((Level)Level.DEBUG) && this.configuration.launchUIForLogLevelDebug().booleanValue()) {
            this.portFuture.whenComplete((integer, throwable) -> this.openUI());
        }
        this.portFuture.complete(this.mockServer.getLocalPort());
    }

    public ClientAndServer openUI() {
        super.openUI();
        return this;
    }

    public ClientAndServer openUI(TimeUnit timeUnit, long pause) {
        super.openUI(timeUnit, pause);
        return this;
    }

    public boolean isRunning() {
        return this.mockServer.isRunning();
    }

    public boolean hasStarted() {
        return this.mockServer.isRunning();
    }

    public CompletableFuture stopAsync() {
        return this.mockServer.stopAsync().thenComposeAsync(s -> this.stop(true));
    }

    public void stop() {
        this.mockServer.stop();
        super.stop();
    }

    public Integer getPort() {
        return this.mockServer.getLocalPort();
    }

    public Integer getLocalPort() {
        return this.mockServer.getLocalPort();
    }

    public List<Integer> getLocalPorts() {
        return this.mockServer.getLocalPorts();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.mockServer.getRemoteAddress();
    }

    public ClientAndServer registerListener(ExpectationsListener expectationsListener) {
        this.mockServer.registerListener(expectationsListener);
        return this;
    }
}

