/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.socks;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5Message;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.netty.proxy.socks.Socks5ConnectHandler;
import org.mockserver.netty.proxy.socks.SocksProxyHandler;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class Socks5ProxyHandler
extends SocksProxyHandler<Socks5Message> {
    public Socks5ProxyHandler(Configuration configuration, MockServerLogger mockServerLogger, LifeCycle server) {
        super(configuration, mockServerLogger, server);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Socks5Message socksRequest) {
        if (socksRequest instanceof Socks5InitialRequest) {
            this.handleInitialRequest(ctx, (Socks5InitialRequest)socksRequest);
        } else if (socksRequest instanceof Socks5PasswordAuthRequest) {
            this.handlePasswordAuthRequest(ctx, (Socks5PasswordAuthRequest)socksRequest);
        } else if (socksRequest instanceof Socks5CommandRequest) {
            this.handleCommandRequest(ctx, (Socks5CommandRequest)socksRequest);
        } else {
            ctx.close();
        }
    }

    private void handleInitialRequest(ChannelHandlerContext ctx, Socks5InitialRequest initialRequest) {
        Socks5CommandRequestDecoder nextRequestDecoder;
        Socks5AuthMethod requiredAuthMethod;
        String username = this.configuration.proxyAuthenticationUsername();
        String password = this.configuration.proxyAuthenticationPassword();
        if (initialRequest.authMethods().contains(Socks5AuthMethod.NO_AUTH)) {
            requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
            nextRequestDecoder = new Socks5CommandRequestDecoder();
        } else if (initialRequest.authMethods().contains(Socks5AuthMethod.PASSWORD)) {
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                requiredAuthMethod = Socks5AuthMethod.PASSWORD;
                nextRequestDecoder = new Socks5PasswordAuthRequestDecoder();
            } else {
                requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
                nextRequestDecoder = new Socks5CommandRequestDecoder();
            }
        } else {
            requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
            nextRequestDecoder = new Socks5CommandRequestDecoder();
        }
        this.answerInitialRequest(ctx, initialRequest, requiredAuthMethod, (ChannelHandler)nextRequestDecoder);
    }

    private void answerInitialRequest(ChannelHandlerContext ctx, Socks5InitialRequest initialRequest, Socks5AuthMethod requiredAuthMethod, ChannelHandler nextRequestDecoder) {
        ctx.writeAndFlush((Object)initialRequest.authMethods().stream().filter(authMethod -> authMethod.equals((Object)requiredAuthMethod)).findFirst().map(authMethod -> {
            if (PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
                ctx.pipeline().addAfter(SslHandler.class.getName(), null, nextRequestDecoder);
            } else {
                ctx.pipeline().addFirst(new ChannelHandler[]{nextRequestDecoder});
            }
            return new DefaultSocks5InitialResponse(requiredAuthMethod);
        }).orElse(new DefaultSocks5InitialResponse(Socks5AuthMethod.UNACCEPTED)));
        ctx.pipeline().remove(Socks5InitialRequestDecoder.class);
    }

    private void handlePasswordAuthRequest(ChannelHandlerContext ctx, Socks5PasswordAuthRequest passwordAuthRequest) {
        String username = this.configuration.proxyAuthenticationUsername();
        String password = this.configuration.proxyAuthenticationPassword();
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) && username.equals(passwordAuthRequest.username()) && password.equals(passwordAuthRequest.password())) {
            ctx.pipeline().replace(Socks5PasswordAuthRequestDecoder.class, null, (ChannelHandler)new Socks5CommandRequestDecoder());
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS)).awaitUninterruptibly();
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.AUTHENTICATION_FAILED).setLogLevel(Level.INFO).setMessageFormat("proxy authentication failed so returning SOCKS FAILURE response"));
        }
    }

    private void handleCommandRequest(ChannelHandlerContext ctx, Socks5CommandRequest commandRequest) {
        if (commandRequest.type().equals((Object)Socks5CommandType.CONNECT)) {
            this.forwardConnection(ctx, (ChannelHandler)new Socks5ConnectHandler(this.configuration, this.mockServerLogger, this.server, commandRequest.dstAddr(), commandRequest.dstPort()), commandRequest.dstAddr(), commandRequest.dstPort());
            ctx.fireChannelRead((Object)commandRequest);
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.COMMAND_UNSUPPORTED, Socks5AddressType.DOMAIN, "", 0)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

