/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.unification;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.codec.MockServerHttpServerCodec;
import org.mockserver.codec.PreserveHeadersNettyRemoves;
import org.mockserver.configuration.Configuration;
import org.mockserver.dashboard.DashboardWebSocketHandler;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.MockServerHttpResponseToFullHttpResponse;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Protocol;
import org.mockserver.netty.HttpRequestHandler;
import org.mockserver.netty.proxy.BinaryRequestProxyingHandler;
import org.mockserver.netty.proxy.socks.Socks4ProxyHandler;
import org.mockserver.netty.proxy.socks.Socks5ProxyHandler;
import org.mockserver.netty.proxy.socks.SocksDetector;
import org.mockserver.netty.unification.HttpContentLengthRemover;
import org.mockserver.netty.unification.PortBinding;
import org.mockserver.netty.websocketregistry.CallbackWebSocketServerHandler;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.socket.tls.SniHandler;
import org.slf4j.event.Level;

public class PortUnificationHandler
extends ReplayingDecoder<Void> {
    private static final AttributeKey<Boolean> TLS_ENABLED_UPSTREAM = AttributeKey.valueOf((String)"TLS_ENABLED_UPSTREAM");
    private static final AttributeKey<Boolean> TLS_ENABLED_DOWNSTREAM = AttributeKey.valueOf((String)"TLS_ENABLED_DOWNSTREAM");
    private static final AttributeKey<NettySslContextFactory> NETTY_SSL_CONTEXT_FACTORY = AttributeKey.valueOf((String)"NETTY_SSL_CONTEXT_FACTORY");
    private static final AttributeKey<Boolean> HTTP_ENABLED = AttributeKey.valueOf((String)"HTTP_ENABLED");
    private static final AttributeKey<Boolean> HTTP2_ENABLED = AttributeKey.valueOf((String)"HTTP2_ENABLED");
    private static final Map<PortBinding, Set<String>> localAddressesCache = new ConcurrentHashMap<PortBinding, Set<String>>();
    protected final MockServerLogger mockServerLogger;
    private final LoggingHandler loggingHandler = new LoggingHandler(PortUnificationHandler.class.getName() + "-first");
    private final HttpContentLengthRemover httpContentLengthRemover = new HttpContentLengthRemover();
    private final PreserveHeadersNettyRemoves preserveHeadersNettyRemoves = new PreserveHeadersNettyRemoves();
    private final Configuration configuration;
    private final LifeCycle server;
    private final HttpState httpState;
    private final HttpActionHandler actionHandler;
    private final NettySslContextFactory nettySslContextFactory;
    private final MockServerHttpResponseToFullHttpResponse mockServerHttpResponseToFullHttpResponse;

    public PortUnificationHandler(Configuration configuration, LifeCycle server, HttpState httpState, HttpActionHandler actionHandler, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.server = server;
        this.mockServerLogger = httpState.getMockServerLogger();
        this.httpState = httpState;
        this.actionHandler = actionHandler;
        this.nettySslContextFactory = nettySslContextFactory;
        this.mockServerHttpResponseToFullHttpResponse = new MockServerHttpResponseToFullHttpResponse(this.mockServerLogger);
    }

    public static NettySslContextFactory nettySslContextFactory(Channel channel) {
        if (channel.attr(NETTY_SSL_CONTEXT_FACTORY).get() != null) {
            return (NettySslContextFactory)channel.attr(NETTY_SSL_CONTEXT_FACTORY).get();
        }
        throw new RuntimeException("NettySslContextFactory not yet initialised for channel " + channel);
    }

    public static void enableSslUpstreamAndDownstream(Channel channel) {
        channel.attr(TLS_ENABLED_UPSTREAM).set((Object)Boolean.TRUE);
        channel.attr(TLS_ENABLED_DOWNSTREAM).set((Object)Boolean.TRUE);
    }

    public static boolean isSslEnabledUpstream(Channel channel) {
        if (channel.attr(TLS_ENABLED_UPSTREAM).get() != null) {
            return (Boolean)channel.attr(TLS_ENABLED_UPSTREAM).get();
        }
        return false;
    }

    public static void enableSslDownstream(Channel channel) {
        channel.attr(TLS_ENABLED_DOWNSTREAM).set((Object)Boolean.TRUE);
    }

    public static void disableSslDownstream(Channel channel) {
        channel.attr(TLS_ENABLED_DOWNSTREAM).set((Object)Boolean.FALSE);
    }

    public static boolean isSslEnabledDownstream(Channel channel) {
        if (channel.attr(TLS_ENABLED_DOWNSTREAM).get() != null) {
            return (Boolean)channel.attr(TLS_ENABLED_DOWNSTREAM).get();
        }
        return false;
    }

    public static void httpEnabled(Channel channel) {
        channel.attr(HTTP_ENABLED).set((Object)Boolean.TRUE);
    }

    public static boolean isHttpEnabled(Channel channel) {
        if (channel.attr(HTTP_ENABLED).get() != null) {
            return (Boolean)channel.attr(HTTP_ENABLED).get();
        }
        return false;
    }

    public static void http2Enabled(Channel channel) {
        channel.attr(HTTP2_ENABLED).set((Object)Boolean.TRUE);
    }

    public static boolean isHttp2Enabled(Channel channel) {
        if (channel.attr(HTTP2_ENABLED).get() != null) {
            return (Boolean)channel.attr(HTTP2_ENABLED).get();
        }
        return false;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        ctx.channel().attr(NETTY_SSL_CONTEXT_FACTORY).set((Object)this.nettySslContextFactory);
        if (SocksDetector.isSocks4(msg, this.actualReadableBytes())) {
            this.logStage(ctx, "adding SOCKS4 decoders");
            this.enableSocks4(ctx, msg);
        } else if (SocksDetector.isSocks5(msg, this.actualReadableBytes())) {
            this.logStage(ctx, "adding SOCKS5 decoders");
            this.enableSocks5(ctx, msg);
        } else if (this.isTls(msg)) {
            this.logStage(ctx, "adding TLS decoders");
            this.enableTls(ctx, msg);
        } else if (Protocol.HTTP_2.equals((Object)SniHandler.getALPNProtocol((MockServerLogger)this.mockServerLogger, (ChannelHandlerContext)ctx))) {
            this.logStage(ctx, "adding HTTP2 decoders");
            this.switchToHttp2(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.logStage(ctx, "adding HTTP decoders");
            this.switchToHttp(ctx, msg);
        } else if (this.isProxyConnected(msg)) {
            this.logStage(ctx, "setting proxy connected");
            this.switchToProxyConnected(ctx, msg);
        } else if (this.configuration.assumeAllRequestsAreHttp().booleanValue()) {
            this.logStage(ctx, "adding HTTP decoders");
            this.switchToHttp(ctx, msg);
        } else {
            this.logStage(ctx, "adding binary decoder");
            this.switchToBinaryRequestProxying(ctx, msg);
        }
        if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
            this.loggingHandler.addLoggingHandler(ctx);
        }
    }

    private void logStage(ChannelHandlerContext ctx, String message) {
        if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat(message + " for channel:{}pipeline:{}").setArguments(new Object[]{ctx.channel().toString(), ctx.pipeline().names()}));
        }
    }

    private void enableSocks4(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, (ReplayingDecoder<?>)new Socks4ServerDecoder(), new ChannelHandler[]{new Socks4ProxyHandler(this.configuration, this.mockServerLogger, this.server), Socks4ServerEncoder.INSTANCE});
    }

    private void enableSocks5(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, (ReplayingDecoder<?>)new Socks5InitialRequestDecoder(), new ChannelHandler[]{new Socks5ProxyHandler(this.configuration, this.mockServerLogger, this.server), Socks5ServerEncoder.DEFAULT});
    }

    private void enableSocks(ChannelHandlerContext ctx, ByteBuf msg, ReplayingDecoder<?> socksInitialRequestDecoder, ChannelHandler ... channelHandlers) {
        ChannelPipeline pipeline = ctx.pipeline();
        for (ChannelHandler channelHandler : channelHandlers) {
            if (PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
                pipeline.addAfter("SslHandler#0", null, channelHandler);
                continue;
            }
            pipeline.addFirst(new ChannelHandler[]{channelHandler});
        }
        pipeline.addFirst(new ChannelHandler[]{socksInitialRequestDecoder});
        HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
        ctx.pipeline().fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isTls(ByteBuf buf) {
        return SslHandler.isEncrypted((ByteBuf)buf);
    }

    private void enableTls(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new ChannelHandler[]{new SniHandler(this.configuration, this.nettySslContextFactory)});
        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
        ctx.pipeline().fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isHttp(ByteBuf msg) {
        String method = msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII);
        return method.startsWith("GET ") || method.startsWith("POST ") || method.startsWith("PUT ") || method.startsWith("HEAD ") || method.startsWith("OPTIONS ") || method.startsWith("PATCH ") || method.startsWith("DELETE ") || method.startsWith("TRACE ") || method.startsWith("CONNECT ");
    }

    private void switchToHttp2(ChannelHandlerContext ctx, ByteBuf msg) {
        if (!PortUnificationHandler.isHttp2Enabled(ctx.channel())) {
            PortUnificationHandler.http2Enabled(ctx.channel());
            ChannelPipeline pipeline = ctx.pipeline();
            DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
            HttpToHttp2ConnectionHandlerBuilder http2ConnectionHandlerBuilder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(Integer.MAX_VALUE).propagateSettings(true).validateHttpHeaders(false).build()));
            if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
                http2ConnectionHandlerBuilder.frameLogger(new Http2FrameLogger(LogLevel.TRACE, PortUnificationHandler.class.getName()));
            }
            this.addLastIfNotPresent(pipeline, (ChannelHandler)http2ConnectionHandlerBuilder.connection((Http2Connection)connection).build());
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new CallbackWebSocketServerHandler(this.httpState));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new DashboardWebSocketHandler(this.httpState, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), false));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new MockServerHttpServerCodec(this.configuration, this.mockServerLogger, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), SniHandler.retrieveClientCertificates((MockServerLogger)this.mockServerLogger, (ChannelHandlerContext)ctx), ctx.channel().localAddress()));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpRequestHandler(this.configuration, this.server, this.httpState, this.actionHandler));
            pipeline.remove((ChannelHandler)this);
            ctx.channel().attr(HttpRequestHandler.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
            ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
        }
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        if (!PortUnificationHandler.isHttpEnabled(ctx.channel())) {
            PortUnificationHandler.httpEnabled(ctx.channel());
            ChannelPipeline pipeline = ctx.pipeline();
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpServerCodec(this.configuration.maxInitialLineLength().intValue(), this.configuration.maxHeaderSize().intValue(), this.configuration.maxChunkSize().intValue()));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)this.preserveHeadersNettyRemoves);
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentDecompressor());
            this.addLastIfNotPresent(pipeline, (ChannelHandler)this.httpContentLengthRemover);
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
            if (this.configuration.tlsMutualAuthenticationRequired().booleanValue() && !PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
                HttpResponse httpResponse = HttpResponse.response().withStatusCode(Integer.valueOf(426)).withHeader("Upgrade", new String[]{"TLS/1.2, HTTP/1.1"}).withHeader("Connection", new String[]{"Upgrade"});
                if (MockServerLogger.isEnabled((Level)Level.INFO)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("no tls for connection:{}returning response:{}").setArguments(new Object[]{ctx.channel().localAddress(), httpResponse}));
                }
                ctx.channel().writeAndFlush(this.mockServerHttpResponseToFullHttpResponse.mapMockServerResponseToNettyResponse(httpResponse).get(0)).addListener(future -> future.channel().disconnect().awaitUninterruptibly());
            } else {
                this.addLastIfNotPresent(pipeline, (ChannelHandler)new CallbackWebSocketServerHandler(this.httpState));
                this.addLastIfNotPresent(pipeline, (ChannelHandler)new DashboardWebSocketHandler(this.httpState, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), false));
                this.addLastIfNotPresent(pipeline, (ChannelHandler)new MockServerHttpServerCodec(this.configuration, this.mockServerLogger, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), SniHandler.retrieveClientCertificates((MockServerLogger)this.mockServerLogger, (ChannelHandlerContext)ctx), ctx.channel().localAddress()));
                this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpRequestHandler(this.configuration, this.server, this.httpState, this.actionHandler));
                pipeline.remove((ChannelHandler)this);
                ctx.channel().attr(HttpRequestHandler.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
                ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
            }
        }
    }

    private boolean isProxyConnected(ByteBuf msg) {
        return msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII).startsWith("PROXIED_");
    }

    private void switchToProxyConnected(ChannelHandlerContext ctx, ByteBuf msg) {
        String message = this.readMessage(msg);
        if (message.startsWith("PROXIED_SECURE_")) {
            String[] hostParts = StringUtils.substringAfter((String)message, (String)"PROXIED_SECURE_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 443;
            PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
            HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
            HttpActionHandler.setRemoteAddress((ChannelHandlerContext)ctx, (InetSocketAddress)new InetSocketAddress(hostParts[0], port));
        } else if (message.startsWith("PROXIED_")) {
            String[] hostParts = StringUtils.substringAfter((String)message, (String)"PROXIED_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 80;
            HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
            HttpActionHandler.setRemoteAddress((ChannelHandlerContext)ctx, (InetSocketAddress)new InetSocketAddress(hostParts[0], port));
        }
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])("PROXIED_RESPONSE_" + message).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
    }

    private String readMessage(ByteBuf msg) {
        byte[] bytes = new byte[this.actualReadableBytes()];
        msg.readBytes(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private void switchToBinaryRequestProxying(ChannelHandlerContext ctx, ByteBuf msg) {
        this.addLastIfNotPresent(ctx.pipeline(), (ChannelHandler)new BinaryRequestProxyingHandler(this.configuration, this.httpState.getMockServerLogger(), this.httpState.getScheduler(), this.actionHandler.getHttpClient()));
        ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        String portExtension;
        InetSocketAddress inetSocketAddress;
        PortBinding cacheKey;
        SocketAddress localAddress = ctx.channel().localAddress();
        Set<String> localAddresses = null;
        if (localAddress instanceof InetSocketAddress && (localAddresses = localAddressesCache.get((Object)(cacheKey = new PortBinding(inetSocketAddress = (InetSocketAddress)localAddress, portExtension = this.calculatePortExtension(inetSocketAddress, PortUnificationHandler.isSslEnabledUpstream(ctx.channel())))))) == null) {
            localAddresses = this.calculateLocalAddresses(inetSocketAddress, portExtension);
            localAddressesCache.put(cacheKey, localAddresses);
        }
        return localAddresses == null ? Collections.emptySet() : localAddresses;
    }

    private String calculatePortExtension(InetSocketAddress inetSocketAddress, boolean sslEnabledUpstream) {
        String portExtension = inetSocketAddress.getPort() == 443 && sslEnabledUpstream || inetSocketAddress.getPort() == 80 && !sslEnabledUpstream ? "" : ":" + inetSocketAddress.getPort();
        return portExtension;
    }

    private Set<String> calculateLocalAddresses(InetSocketAddress localAddress, String portExtension) {
        InetAddress socketAddress = localAddress.getAddress();
        HashSet<String> localAddresses = new HashSet<String>();
        localAddresses.add(socketAddress.getHostAddress() + portExtension);
        localAddresses.add(socketAddress.getCanonicalHostName() + portExtension);
        localAddresses.add(socketAddress.getHostName() + portExtension);
        localAddresses.add("localhost" + portExtension);
        localAddresses.add("127.0.0.1" + portExtension);
        return Collections.unmodifiableSet(localAddresses);
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(new ChannelHandler[]{channelHandler});
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        if (ExceptionHandling.connectionClosedException((Throwable)throwable)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by port unification handler -> closing pipeline " + ctx.channel()).setThrowable(throwable));
        } else if (ExceptionHandling.sslHandshakeException((Throwable)throwable)) {
            if (throwable.getMessage().contains("certificate_unknown") || throwable.getMessage().toLowerCase().contains("unknown_ca")) {
                if (MockServerLogger.isEnabled((Level)Level.WARN) && this.mockServerLogger != null) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("TLS handshake failure:" + Character.NEW_LINE + Character.NEW_LINE + " Client does not trust MockServer Certificate Authority for:{}See http://mock-server.com/mock_server/HTTPS_TLS.html to enable the client to trust MocksServer Certificate Authority." + Character.NEW_LINE).setArguments(new Object[]{ctx.channel()}).setThrowable(throwable));
                }
            } else if (!throwable.getMessage().contains("close_notify during handshake")) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("TLS handshake failure while a client attempted to connect to " + ctx.channel()).setThrowable(throwable));
            }
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

